/*  JSSlideShow.js */
/*  This Javascript program is included by SRC= attribute of SCRIPT */
/* entry generated by the ImgIdxEditor. It is used to control the   */
/* Automatic slide show.  It requires that the including HTML file  */
/* define: */
/*  1) an array named "images" that contains the paths the images   */
/*     to be shown.                                                 */
/*  2) a main IMG tag with NAME=ssFrame          */
/*  3) a FORM tag with NAME=GetStrForm           */
/*  4) an INPUT TYPE=HIDDEN with NAME=FndStr     */
/*  5) an IMG for pause() with NAME=Pause        */

/*  Define global variables: */
 var ix  = 0       /* nextImage increments by 1 before displaying */
 var nbrimgs = images.length
 var maxIx = nbrimgs - 1
 var dur = 5  			// define in .HTML file??? 
 
 var pauseFlag = "off"        // ="on" if paused
 var intervalID = -1
 var Browser = "x"            // Set to "NS" if NetScape 
 var anImage = new Image()
 var newNSWin1 = null
 var newNSWin2 = null

 anImage.src = images[0]      // start reading first image
 

/* Start the interval timer to show the slides: */
 function startShow() {
    if (document.images) {  /* Test if browser is capable */
      if (navigator.appName == "Netscape") { Browser = "NS" }   
      if (pauseFlag == "off") {  /* Start automatic if not paused */
        intervalID = setInterval("nextImage()", dur * 1000)
      }
    } else alert("Don't have image capability")
 }
/* Bump index (ix) and show that image.  Wrap around at end */ 
 function nextImage() { 
   ix++
   if (ix > maxIx) {  /* Wrap around */
     ix = 0
   }
   if (document.ssFrame.complete) {
     showImage()
   }
   if (ix < maxIx) anImage.src=images[ix+1]   // read next image 
 }
 // Show current image at ix and set status/title to filename minus ext 
 function showImage() {
   if (Browser == "NS") {
     // Toggle between using newNSWIn1 and newNSWin2:
     if(newNSWin1 != null) {
       bldNSWin(newNSWin2) 
       if(newNSWin1 != null && !newNSWin1.closed) newNSWin1.close();
       newNSWin1 = null
     }
     else {
       bldNSWin(newNSWin1)
       if(newNSWin2 != null && !newNSWin2.closed) newNSWin2.close();
       newNSWin2 = null
     }    
   }
   else {  // IE can reuse same frame
     document.ssFrame.src=images[ix]
   }
   var iy = images[ix].lastIndexOf('/') + 1
   status=images[ix].substring(iy,images[ix].length-4) 
   if (Browser != "NS") { 
     document.title=images[ix].substring(iy,images[ix].length-4)
   }
 }
 // This function toggles between Pause and Started
 function pause(win) {
   if (pauseFlag == "off") {
     pauseFlag = "on"
     win.document.Pause.src="RSSLib/GreenCircle.jpg"  // change display
     clearInterval(intervalID)   /* Stop show */
   }
   else {  // must be ON -> start
     pauseFlag = "off"
     win.document.Pause.src="RSSLib/RedCircle.jpg"  // change display
     startShow()   /* restart show */ 
   }
 }

 function start() {  // not used
    if (pauseFlag == "on") {  /* Start if we're stopped */
       pauseFlag = "off"
       startShow()   /* restart */ 
    }
 }
 function slower() {
   if (dur < 60) {
     dur++
   } 
 }
 function faster() {
     if (dur > 2) {
       dur--
     }
 }
 function next() {
    nextImage()
 }
 function last() {
    ix = ix - 2      /* -2 because nextImage increments by 1 */
    if (ix < -1) {    /* Wrap around */
      ix = maxIx - 1 
    }
    nextImage()
 }
 function ShowStats() {
   var tix = ix + 1
   anImage.src = images[ix]
   alert("Showing " +tix+ " of " +nbrimgs+ " images.\n"
             + "Delay is " +dur+ ". Pause is "+pauseFlag+ "\n"
             + "Image: " + anImage.width + " by " + anImage.height)
              
 } 
//------------------------------------------------------------------
//  Following for FIND function:
// Initialize global variables:
 var newWindow
 var FindStr = ""
 var lastFindStr = "??"

/* Create window to enter string in: */
/*  Break script tags to stop browser from using them */
 function GetFindStr() {
   if (pauseFlag == "off") {
     alert("Must Pause to do Find")
     return
   } 
   newWindow = window.open('', 'newWin', 'width=300,height=110')
   newWindow.document.write("<HTML><HEAD><TITLE>Find String</TITLE><SC"
     + "RIPT LANGUAGE=JAVASCRIPT>\n function rtnStr(txtFld) {\n "
     + " var theStr = txtFld.value;\n"
     + "opener.setFindStr(theStr);}\n"
     +  "</SC" + "RIPT></HEAD><BODY BGCOLOR=WHITE" 
     + " onUnLoad=\"JAVASCRIPT:rtnStr(inptFrm.inptFld),window.close()\">"
     + "<H5>Enter string to find in image name:</H5>"
     + "<FORM NAME=\"inptFrm\"><INPUT TYPE=TEXT NAME=\"inptFld\" " 
     + "onBlur=\"JAVASCRIPT:rtnStr(this),window.close()\" SIZE=30>"
     + "</FORM></BODY></HTML>")
   newWindow.document.close()
  
   FindStr = ""                       // clear
   if (Browser != "NS")   // doesn't work for Netscape-> no properties ???
     newWindow.inptFrm.inptFld.focus() //  How to get focus into "inptFld" ????
   setTimeout("checkFindStr()",3000)  // wait 3 seconds first time
  }  // end  GetFindStr()

 // Check if user has closed New window and if string was returned
 // ?? How can I detect string returned and do the close myself?? 
 function checkFindStr() {
   if (newWindow != null && newWindow.closed) { 
     var Str = FindStr
     if (Str != "") {
       lastFindStr = Str                   // save
       for (i = ix+1; i < maxIx; i++) {  // Search the image table
         if (images[i].indexOf(Str) >=  0) {
           ix = i - 1   // set ptr -1 
           nextImage()  // show it
           return
         }
       }
       for (i = 0; i < ix; i++) {  // Continue search from beginning
         if (images[i].indexOf(Str) >=  0) {
           ix = i - 1   // set ptr -1 
           nextImage()  // show it
           return
         }
       } 
       window.status = "No match found for " + Str
     }
     else {
      window.status="No Find String returned" + FindStr + ":" + lastFindStr
     } 
   }   
   else {  // wait some more for user
     setTimeout("checkFindStr()", 1000)      // now check every sec   
   }
 } 

// Called by newWindow (above) to return string to Find
function setFindStr(theStr) {
  FindStr = theStr
}

//-----------------------------------------------------------------------
// A special function for Netscape to allow for images of different sizes
function bldNSWin(newNSWin) {
  var iy = images[ix].lastIndexOf('/') + 1
  var title = images[ix].substring(iy,images[ix].length-4)
  anImage.src = images[ix]    // get this image's width and height
  var w = anImage.width       
  var h = anImage.height
  if (pauseFlag == "on") pflagicon = "RSSLib/GreenCircle.jpg"
  else pflagicon = "RSSLib/RedCircle.jpg"

  // Now build the new window to show the next image in
 
  newNSWin = window.open("", "NSWin", config="scrollbars=yes,resizable=yes")
  newNSWin.document.write("<HTML><HEAD><TITLE>" + title + "</TITLE></HEAD>")
  newNSWin.document.write('<BODY BGColor=gray><IMG SRC="' + images[ix]
                + '" Name="ssNSFrame" BORDER=0 width='+w+'height='+h+'>\n')
  // Keep following in sync with JSSlideShowPart2.js
  newNSWin.document.write('<CENTER><TABLE BORDER=0 CELLSPACING=8 VSPACE=0>');
  newNSWin.document.write('<TR><TD COLSPAN=2>\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.faster()>');
  newNSWin.document.write('  <IMG SRC="RSSLib/GoFaster.gif" ALT="Show Faster" BORDER=0></A>\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.slower()>');
  newNSWin.document.write('<IMG SRC="RSSLib/GoSlower.gif" ALT="Show Slower" BORDER=0></A>\n');
  newNSWin.document.write('</TD><TD>\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.pause(this)>');
  newNSWin.document.write('  <IMG SRC="' + pflagicon + '" Name="Pause" Border=0 ALT="Pause/Continue"></A>\n');
  newNSWin.document.write('</TD><TD COLSPAN=2>\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.last()');
  newNSWin.document.write('  onmouseover="document.Prev.src=\'RSSLib/Prev_dis.gif\'"\n');
  newNSWin.document.write('  onmouseout="document.Prev.src=\'RSSLib/Prev.gif\'">\n');
  newNSWin.document.write('  <IMG SRC="RSSLib/Prev.gif" NAME="Prev" Border=0\n');
  newNSWin.document.write('   ALT="View Last image"></A>&nbsp\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.next()');
  newNSWin.document.write('  onmouseover="document.Next.src=\'RSSLib/Next_dis.gif\'"\n');
  newNSWin.document.write('  onmouseout="document.Next.src=\'RSSLib/Next.gif\'">\n');
  newNSWin.document.write('<IMG SRC="RSSLib/Next.gif" NAME="Next" Border=0\n');
  newNSWin.document.write('  ALT="View Next image"></A>');
  newNSWin.document.write('</TD><TD>\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.GetFindStr()>\n');
  newNSWin.document.write('  <IMG SRC="RSSLib/magGlass.gif" ALT="Find a slide" Border=0></A>\n');
  newNSWin.document.write('</TD><TD>\n');
  newNSWin.document.write('<A HREF=JAVASCRIPT:opener.ShowStats()>');
  newNSWin.document.write('  <IMG SRC="RSSLib/questionMark.gif" ALT="Show Status" BORDER=0></A>\n');
  newNSWin.document.write('</TD></TR></TABLE></CENTER></BODY></HTML>\n');
  newNSWin.document.close()
}  // end bldNSWin()
