/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.DocumentViewer;

import NormsTools.DocumentViewer.DocElemBGColor;
import NormsTools.DocumentViewer.DocElemCenter;
import NormsTools.DocumentViewer.DocElemColor;
import NormsTools.DocumentViewer.DocElemDebug;
import NormsTools.DocumentViewer.DocElemEndCenter;
import NormsTools.DocumentViewer.DocElemFont;
import NormsTools.DocumentViewer.DocElemHLString;
import NormsTools.DocumentViewer.DocElemHorizLine;
import NormsTools.DocumentViewer.DocElemNOBR;
import NormsTools.DocumentViewer.DocElemNewLine;
import NormsTools.DocumentViewer.DocElemRegisterLoc;
import NormsTools.DocumentViewer.DocElemSetInset;
import NormsTools.DocumentViewer.DocElemString;
import NormsTools.DocumentViewer.Document;
import NormsTools.DocumentViewer.DocumentElement;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.ShowMsgBox;
import NormsTools.StackX;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public final class HTMLParser {
    private boolean debug = false;
    private final String DebugON = "DEBUGON";
    private final String DebugOFF = "DEBUGOFF";
    StreamTokenizer st;
    Vector de = new Vector();
    Document doc;
    private String pushedTkn = null;
    final String LEFT_BKT = "<";
    final String RIGHT_BKT = ">";
    final String StartEndTAG = "/";
    final String EOF = "<EOF>";
    final String CMTStart = "!";
    final String CMTEnd = "-->";
    final int CMTStartC = 33;
    final String DblDash = "--";
    final String Amper = "&";
    final String AmpVarEnd = ";";
    final String StartHEX = "#";
    final String SkipTag = "X-";
    Color currBGColor = Color.white;
    Color currColor = Color.black;
    Color linkColor = new Color(0, 0, 255);
    Font currFont = new Font("TimesRoman", 0, 14);
    final int H1Size = 13;
    final int H2Size = 9;
    final int H3Size = 5;
    final int H4Size = 2;
    final int H5Size = -1;
    final int H6Size = -2;
    static final int NoList = 0;
    static final int OLtype = 1;
    static final int ULtype = 2;
    static final String ULIdx = "\u00b0 ";
    static final String ULIdx2 = "\u00b7 ";
    static final String OLSfx = "). ";
    int currOLIdx = 0;
    int currListType = 0;
    StackX saveFont = new StackX();
    StackX saveColor = new StackX();
    StackX saveListType = new StackX();
    StackX saveOLIdx = new StackX();
    private boolean returnSpaces = false;
    final int elemIdxCCT = 0;
    final int parserIdxCCT = 1;
    final int cctIdxCCT = 2;
    final int entrySizeCCT = 3;
    final String LinkToCCT = "<LINKTOCCT>";
    final String ExitCCT = "<EXITCCT";
    Object[] currCCT = null;
    Stack saveCCT = new Stack();
    InputStreamReader fileRdr;
    ParseA parseA = new ParseA();
    ParseB parseB = new ParseB();
    ParseI parseI = new ParseI();
    ParseFONT parseFONT = new ParseFONT();
    ParseCENTER parseCENTER = new ParseCENTER();
    ParseHEAD parseHEAD = new ParseHEAD();
    ParseBODY parseBODY = new ParseBODY();
    ParseTITLE parseTITLE = new ParseTITLE();
    ParseMETA parseMETA = new ParseMETA();
    ParseBR parseBR = new ParseBR();
    ParseP parseP = new ParseP();
    ParseHR parseHR = new ParseHR();
    ParseOL parseOL = new ParseOL();
    ParseUL parseUL = new ParseUL();
    ParseLI parseLI = new ParseLI();
    ParseLI parseLIX = new ParseLI("X");
    ParseHTML parseHTML = new ParseHTML();
    ParsePRE parsePRE = new ParsePRE();
    ParseDIV parseDIV = new ParseDIV();
    ParseTT parseTT = new ParseTT();
    ParseNOBR parseNOBR = new ParseNOBR();
    ParseEATTAG parseEatTag = new ParseEATTAG();
    Object[] CharsHiLite_CCT;
    Object[] UL_CCT;
    Object[] OL_CCT;
    Object[] LI_CCT;
    Object[] A_CCT;
    Object[] HEAD_CCT;
    Object[] BODY_CCT;
    Object[] HTML_CCT;
    final int B_TAG = 1;
    final String[] amperNms;
    final String[][] amperVals;
    private boolean isAmpVarGT;
    private String lastCharGNT;
    private String thisCharGNT;
    private String HEX_CHARS;
    private static /* synthetic */ Class class$NormsTools$DocumentViewer$HTMLParser;

    public Document parseHTMLFile(String string) throws InvalidHTMLException, Exception {
        block18: {
            Object object;
            block19: {
                if (this.debug) {
                    System.out.println("parseHTMLFile() trying to read " + string);
                }
                try {
                    this.fileRdr = new FileReader(string);
                    this.st = new StreamTokenizer(this.fileRdr);
                }
                catch (Exception exception) {
                    System.err.println("parseHTMLFile() ex trying to read " + string + "\n" + exception);
                }
                if (this.st == null) {
                    try {
                        object = (class$NormsTools$DocumentViewer$HTMLParser != null ? class$NormsTools$DocumentViewer$HTMLParser : (class$NormsTools$DocumentViewer$HTMLParser = HTMLParser.class$("NormsTools.DocumentViewer.HTMLParser"))).getResource("/" + string);
                        if (this.debug) {
                            System.out.println("Reading " + string + " from " + object);
                        }
                        if (object != null) {
                            this.fileRdr = new InputStreamReader(((URL)object).openStream());
                            this.st = new StreamTokenizer(this.fileRdr);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("error trying to get " + string);
                    }
                    if (this.st == null) {
                        new ShowMsgBox("Error reading file", "Unable to read file: " + string, new Frame(), true);
                        throw new Exception("parseHTMLFile() unable to read file: " + string);
                    }
                }
                this.doc = new Document();
                this.doc.setFileName(string);
                this.de = new Vector();
                this.de.addElement(new DocElemFont(this.currFont));
                this.st.resetSyntax();
                this.st.whitespaceChars(0, 32);
                this.st.wordChars(97, 122);
                this.st.wordChars(65, 90);
                this.st.wordChars(47, 47);
                this.st.wordChars(39, 39);
                this.st.wordChars(48, 57);
                this.st.wordChars(46, 46);
                this.st.wordChars(45, 45);
                this.st.wordChars(35, 35);
                this.st.quoteChar(34);
                this.st.ordinaryChar(32);
                this.st.eolIsSignificant(true);
                block4: while (true) {
                    object = this.getToken();
                    if (this.debug) {
                        System.out.println("Mainlp: Got token: " + (String)object);
                    }
                    if (((String)object).equals("<EOF>")) break block18;
                    if (!((String)object).equals("<")) break block19;
                    object = this.getToken();
                    if (!((String)object).equalsIgnoreCase("HTML")) break;
                    this.getCkForRBkt();
                    this.currCCT = this.HTML_CCT;
                    while (true) {
                        if (((String)(object = this.getToken())).equals("<")) {
                            object = this.getToken();
                            if (((String)object).startsWith("X-")) {
                                this.eatTag((String)object);
                                continue;
                            }
                            if (((String)object).equals("DEBUGON")) {
                                this.debug = true;
                                this.de.addElement(new DocElemDebug(true));
                                this.eatTag((String)object);
                                continue;
                            }
                            if (((String)object).equals("DEBUGOFF")) {
                                this.debug = false;
                                this.de.addElement(new DocElemDebug(false));
                                this.eatTag((String)object);
                                continue;
                            }
                            if (this.parseEngine((String)object, this.currCCT)) continue;
                            System.out.println("Mainlp: false from parseEng at " + this.st.lineno() + ", tkn=" + (String)object + ", cct=" + this.currCCT + " 1stEnt=" + (String)this.currCCT[0]);
                            if (((String)object).equals("/HTML")) {
                                this.getCkForRBkt();
                                break block18;
                            }
                            System.err.println("mainlp(): ignoring '" + (String)object + "' at line " + this.st.lineno());
                            this.eatThruEndTag((String)object);
                            continue;
                        }
                        if (((String)object).equals("<EOF>")) continue block4;
                        String string2 = this.getAString((String)object, "<");
                        if (this.debug) {
                            System.out.println("mainlp adding str '" + string2 + "' at " + this.st.lineno());
                        }
                        this.de.addElement(new DocElemString(string2));
                    }
                    break;
                }
                throw new InvalidHTMLException("Mainlp: expected 'HTML', got '" + (String)object + "'");
            }
            throw new InvalidHTMLException("Mainlp: expected '<', got '" + (String)object + "'");
        }
        this.de.addElement(new DocElemNewLine());
        this.doc.des = new DocumentElement[this.de.size()];
        this.de.copyInto(this.doc.des);
        return this.doc;
    }

    private String getNextT() {
        this.lastCharGNT = this.thisCharGNT;
        block9: while (true) {
            try {
                this.st.nextToken();
            }
            catch (IOException iOException) {
                System.err.println(">*>*>*>StreamTokenizer error " + iOException);
                this.thisCharGNT = "";
                return "";
            }
            switch (this.st.ttype) {
                case -2: {
                    System.out.println("TT_NUMBER " + this.st.nval);
                    Double d = new Double(this.st.nval);
                    this.thisCharGNT = "" + d.intValue();
                    return this.thisCharGNT;
                }
                case -3: {
                    this.thisCharGNT = this.st.sval;
                    return this.thisCharGNT;
                }
                case -1: {
                    this.thisCharGNT = "<EOF>";
                    return "<EOF>";
                }
                case 34: {
                    this.thisCharGNT = this.st.sval;
                    return this.thisCharGNT;
                }
                case 10: 
                case 32: {
                    this.thisCharGNT = " ";
                    if (this.returnSpaces && !this.lastCharGNT.equals(" ")) {
                        return " ";
                    }
                    this.lastCharGNT = " ";
                    continue block9;
                }
            }
            break;
        }
        this.thisCharGNT = new String(new byte[]{(byte)this.st.ttype});
        return this.thisCharGNT;
    }

    private boolean parseEngine(String string, Object[] objectArray) throws InvalidHTMLException {
        boolean bl = false;
        if (this.debug || bl) {
            System.out.println("parseEng: tok=" + string);
        }
        int n = 0;
        while (n < objectArray.length) {
            if (((String)objectArray[n]).equalsIgnoreCase(string) || string.equalsIgnoreCase("/" + (String)objectArray[n])) {
                if (this.debug || bl) {
                    System.out.println("parseEng found " + string + " in " + objectArray + "  i=" + n);
                }
                ((ParseTAG)objectArray[n + 1]).parseTag(string);
                if (objectArray[n + 2] != null) {
                    if (objectArray[n + 2] instanceof String && ((String)objectArray[n + 2]).equals("<EXITCCT")) {
                        this.currCCT = (Object[])this.saveCCT.pop();
                        if (this.debug || bl) {
                            System.out.println("parsEng ExitCCT: " + this.currCCT);
                        }
                    } else if (!string.startsWith("/") && !((String)objectArray[n]).equalsIgnoreCase("/" + string)) {
                        this.saveCCT.push(this.currCCT);
                        this.currCCT = (Object[])objectArray[n + 2];
                        if (this.debug || bl) {
                            System.out.println("parsEng set new CCT: " + this.currCCT);
                        }
                    } else {
                        this.currCCT = (Object[])this.saveCCT.pop();
                        if (this.debug || bl) {
                            System.out.println("parsEng restored CCT: " + this.currCCT);
                        }
                    }
                }
                return true;
            }
            n += 3;
        }
        if (this.debug || bl) {
            System.out.println("parseEngine didn't find " + string + " in " + objectArray);
        }
        return false;
    }

    String getToken() {
        String string;
        this.isAmpVarGT = false;
        if (this.pushedTkn != null) {
            string = this.pushedTkn;
            this.pushedTkn = null;
            if (!string.equals("&")) {
                return string;
            }
        } else {
            string = this.getNextT();
        }
        while (string.equals("<")) {
            string = this.getNextT();
            if (string.equals("!")) {
                this.eatComment();
                string = this.getNextT();
                continue;
            }
            this.st.pushBack();
            return "<";
        }
        if (string.equals("&") && this.returnSpaces) {
            String string2 = this.getNextT();
            String string3 = this.getNextT();
            if (!string3.equals(";")) {
                if (this.debug) {
                    System.out.println("getToken pushing1 '" + string2 + "' " + string3);
                }
                this.st.pushBack();
                this.pushToken(string2);
                return string;
            }
            int n = 0;
            int n2 = string2.length() - 2;
            if (n2 < this.amperNms.length && (n = this.amperNms[n2].indexOf(";" + string2.toLowerCase())) >= 0) {
                this.isAmpVarGT = true;
                return this.amperVals[n2][n / (n2 + 2)];
            }
            if (string2.startsWith("#") && string2.length() < 5) {
                long l = this.HexStringToDec(string2.substring(1));
                String string4 = new String(new byte[]{(byte)l});
                return string4;
            }
            if (string2.equals("DEBUGON")) {
                this.debug = true;
                this.de.addElement(new DocElemDebug(true));
                return "";
            }
            if (string2.equals("DEBUGOFF")) {
                this.debug = false;
                this.de.addElement(new DocElemDebug(false));
                return "";
            }
            System.out.println("getToken pushing2 '" + string2 + "'");
            this.st.pushBack();
            this.pushToken(string2);
            return string;
        }
        if (this.debug) {
            System.out.println("getToken() returning '" + string + "' at " + this.st.lineno());
        }
        return string;
    }

    private void pushToken(String string) {
        if (this.pushedTkn != null) {
            System.err.println("pushToken() overlayed " + this.pushedTkn + " with " + string + " at " + this.st.lineno());
        }
        this.pushedTkn = string;
    }

    String getAttributeValue(String string) throws InvalidHTMLException {
        String string2 = this.getToken();
        if (!string2.equals("=")) {
            throw new InvalidHTMLException("Invalid keyword " + string + ", fnd:" + string2);
        }
        String string3 = this.getAString("", " >");
        return string3;
    }

    String getAString(String string, String string2) {
        String string3;
        StringBuffer stringBuffer;
        block4: {
            this.returnSpaces = true;
            if (string.equals("&")) {
                this.pushToken("&");
                string = this.getToken();
            }
            stringBuffer = new StringBuffer();
            if (this.lastCharGNT.equals(" ")) {
                stringBuffer.append(" ");
            }
            string3 = "";
            while (true) {
                stringBuffer.append(string);
                string = this.getToken();
                if (string.length() < 1) continue;
                if (string.equals("<EOF>")) break block4;
                int n = string2.indexOf(string.substring(0, 1));
                if (n >= 0 & !this.isAmpVarGT) break;
            }
            this.pushToken(string);
        }
        string3 = stringBuffer.toString();
        if (this.debug) {
            System.out.println("getAString() terminates '" + string3 + "' with " + string + " at " + this.st.lineno());
        }
        this.returnSpaces = false;
        return string3;
    }

    public HTMLParser() {
        Object[] objectArray = new Object[12];
        objectArray[0] = "B";
        objectArray[1] = this.parseB;
        objectArray[3] = "I";
        objectArray[4] = this.parseI;
        objectArray[6] = "TT";
        objectArray[7] = this.parseTT;
        objectArray[9] = "FONT";
        objectArray[10] = this.parseFONT;
        this.CharsHiLite_CCT = objectArray;
        Object[] objectArray2 = new Object[6];
        objectArray2[0] = "LI";
        objectArray2[1] = this.parseLI;
        objectArray2[3] = "/UL";
        objectArray2[4] = this.parseUL;
        objectArray2[5] = "<EXITCCT";
        this.UL_CCT = objectArray2;
        Object[] objectArray3 = new Object[6];
        objectArray3[0] = "LI";
        objectArray3[1] = this.parseLI;
        objectArray3[3] = "/OL";
        objectArray3[4] = this.parseOL;
        objectArray3[5] = "<EXITCCT";
        this.OL_CCT = objectArray3;
        Object[] objectArray4 = new Object[54];
        objectArray4[0] = "B";
        objectArray4[1] = this.parseB;
        objectArray4[3] = "I";
        objectArray4[4] = this.parseI;
        objectArray4[6] = "TT";
        objectArray4[7] = this.parseTT;
        objectArray4[9] = "A";
        objectArray4[10] = this.parseA;
        objectArray4[12] = "P";
        objectArray4[13] = this.parseP;
        objectArray4[15] = "BR";
        objectArray4[16] = this.parseBR;
        objectArray4[18] = "H1";
        objectArray4[19] = new ParseH1();
        objectArray4[21] = "H2";
        objectArray4[22] = new ParseH2();
        objectArray4[24] = "H3";
        objectArray4[25] = new ParseH3();
        objectArray4[27] = "H4";
        objectArray4[28] = new ParseH4();
        objectArray4[30] = "H5";
        objectArray4[31] = new ParseH5();
        objectArray4[33] = "H6";
        objectArray4[34] = new ParseH6();
        objectArray4[36] = "FONT";
        objectArray4[37] = this.parseFONT;
        objectArray4[39] = "NOBR";
        objectArray4[40] = this.parseNOBR;
        objectArray4[42] = "OL";
        objectArray4[43] = this.parseOL;
        objectArray4[44] = this.OL_CCT;
        objectArray4[45] = "UL";
        objectArray4[46] = this.parseUL;
        objectArray4[47] = this.UL_CCT;
        objectArray4[48] = "/LI";
        objectArray4[49] = this.parseLI;
        objectArray4[50] = "<EXITCCT";
        objectArray4[51] = "LI";
        objectArray4[52] = this.parseLIX;
        this.LI_CCT = objectArray4;
        Object[] objectArray5 = new Object[15];
        objectArray5[0] = "B";
        objectArray5[1] = this.parseB;
        objectArray5[3] = "I";
        objectArray5[4] = this.parseI;
        objectArray5[6] = "TT";
        objectArray5[7] = this.parseTT;
        objectArray5[9] = "FONT";
        objectArray5[10] = this.parseFONT;
        objectArray5[12] = "/A";
        objectArray5[13] = this.parseA;
        objectArray5[14] = "<EXITCCT";
        this.A_CCT = objectArray5;
        Object[] objectArray6 = new Object[12];
        objectArray6[0] = "TITLE";
        objectArray6[1] = this.parseTITLE;
        objectArray6[3] = "META";
        objectArray6[4] = this.parseMETA;
        objectArray6[6] = "SCRIPT";
        objectArray6[7] = this.parseEatTag;
        objectArray6[9] = "/HEAD";
        objectArray6[10] = this.parseHEAD;
        objectArray6[11] = "<EXITCCT";
        this.HEAD_CCT = objectArray6;
        Object[] objectArray7 = new Object[78];
        objectArray7[0] = "B";
        objectArray7[1] = this.parseB;
        objectArray7[3] = "I";
        objectArray7[4] = this.parseI;
        objectArray7[6] = "BR";
        objectArray7[7] = this.parseBR;
        objectArray7[9] = "P";
        objectArray7[10] = this.parseP;
        objectArray7[12] = "HR";
        objectArray7[13] = this.parseHR;
        objectArray7[15] = "TT";
        objectArray7[16] = this.parseTT;
        objectArray7[18] = "OL";
        objectArray7[19] = this.parseOL;
        objectArray7[20] = this.OL_CCT;
        objectArray7[21] = "UL";
        objectArray7[22] = this.parseUL;
        objectArray7[23] = this.UL_CCT;
        objectArray7[24] = "FONT";
        objectArray7[25] = this.parseFONT;
        objectArray7[27] = "NOBR";
        objectArray7[28] = this.parseNOBR;
        objectArray7[30] = "CENTER";
        objectArray7[31] = this.parseCENTER;
        objectArray7[33] = "H1";
        objectArray7[34] = new ParseH1();
        objectArray7[36] = "H2";
        objectArray7[37] = new ParseH2();
        objectArray7[39] = "H3";
        objectArray7[40] = new ParseH3();
        objectArray7[42] = "H4";
        objectArray7[43] = new ParseH4();
        objectArray7[45] = "H5";
        objectArray7[46] = new ParseH5();
        objectArray7[48] = "H6";
        objectArray7[49] = new ParseH6();
        objectArray7[51] = "A";
        objectArray7[52] = this.parseA;
        objectArray7[53] = this.A_CCT;
        objectArray7[54] = "APPLET";
        objectArray7[55] = this.parseEatTag;
        objectArray7[57] = "DL";
        objectArray7[58] = this.parseEatTag;
        objectArray7[60] = "SCRIPT";
        objectArray7[61] = this.parseEatTag;
        objectArray7[63] = "TABLE";
        objectArray7[64] = this.parseEatTag;
        objectArray7[66] = "FORM";
        objectArray7[67] = this.parseEatTag;
        objectArray7[69] = "PRE";
        objectArray7[70] = this.parsePRE;
        objectArray7[72] = "OBJECT";
        objectArray7[73] = this.parseEatTag;
        objectArray7[75] = "/BODY";
        objectArray7[76] = this.parseBODY;
        objectArray7[77] = "<EXITCCT";
        this.BODY_CCT = objectArray7;
        Object[] objectArray8 = new Object[9];
        objectArray8[0] = "HEAD";
        objectArray8[1] = this.parseHEAD;
        objectArray8[2] = this.HEAD_CCT;
        objectArray8[3] = "BODY";
        objectArray8[4] = this.parseBODY;
        objectArray8[5] = this.BODY_CCT;
        objectArray8[6] = "/HTML";
        objectArray8[7] = this.parseHTML;
        this.HTML_CCT = objectArray8;
        this.B_TAG = 1;
        this.amperNms = new String[]{";lt;gt;", ";amp;", ";copy;nbsp;quot;"};
        this.amperVals = new String[][]{{"<", ">"}, {"&"}, {"\u00a9", " ", "\""}};
        this.isAmpVarGT = false;
        this.lastCharGNT = "";
        this.thisCharGNT = "";
        this.HEX_CHARS = "0123456789ABCDEF";
        this.UL_CCT[2] = this.LI_CCT;
        this.OL_CCT[2] = this.LI_CCT;
    }

    Color getColor(String string) {
        if (string.length() == 7 & string.startsWith("#")) {
            int n = (int)this.HexStringToDec(string.substring(1, 3));
            int n2 = (int)this.HexStringToDec(string.substring(3, 5));
            int n3 = (int)this.HexStringToDec(string.substring(5));
            return new Color(n, n2, n3);
        }
        System.err.println("getColor() invalid color value: " + string);
        return Color.white;
    }

    void eatTag(String string) {
        while (!string.equals(">")) {
            string = this.getNextT();
            if (string.equals("<EOF>")) break;
        }
    }

    private void eatComment() {
        String string;
        if (this.debug) {
            System.out.println("Eating a comment at " + this.st.lineno());
        }
        if (!(string = this.getNextT()).startsWith("--")) {
            System.out.println("EatCmt  pushback '" + string + "'");
            this.st.pushBack();
            return;
        }
        do {
            if (!(string = this.getNextT()).equals("<EOF>")) continue;
            return;
        } while (!(string.equals("--") || string.endsWith("--") ? (string = this.getNextT()).equals(">") : string.endsWith("-->")));
    }

    String getCkValue(String string) throws InvalidHTMLException {
        String string2 = this.getToken();
        if (!string2.equals("=")) {
            throw new InvalidHTMLException("Invalid keyword " + string + ", fnd:" + string2);
        }
        String string3 = this.getAString("", ">");
        this.getToken();
        return string3;
    }

    public static void main(String[] stringArray) {
        String string = "TestParser.html";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        HTMLParser hTMLParser = new HTMLParser();
        try {
            Document document = hTMLParser.parseHTMLFile(string);
            ShowDocument showDocument = new ShowDocument(document);
            showDocument.setExitOnClose(true);
        }
        catch (Exception exception) {
            System.err.println("main() got " + exception + " at " + hTMLParser.st.lineno());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    void eatThruEndTag(String string) {
        if (this.debug) {
            System.out.println("Eating tag " + string);
        }
        String string2 = this.getToken();
        String string3 = "/" + string;
        while (!string2.equals(">")) {
            string2 = this.getToken();
            if (!string2.equals("<EOF>")) continue;
            return;
        }
        while (true) {
            if (string2.equals("<") && (string2 = this.getToken()).equalsIgnoreCase(string3)) {
                string2 = this.getToken();
                return;
            }
            if (string2.equals("<EOF>")) {
                return;
            }
            string2 = this.getToken();
        }
    }

    private static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    void getCkForRBkt() throws InvalidHTMLException {
        String string = this.getNextT();
        if (string.equals(">")) {
            return;
        }
        throw new InvalidHTMLException("Missing >");
    }

    private long HexStringToDec(String string) {
        long l = 0L;
        int n = 0;
        while (n < string.length()) {
            int n2 = this.HEX_CHARS.indexOf(string.substring(n, n + 1).toUpperCase());
            if (n2 >= 0) {
                l = l * 16L + (long)n2;
            } else {
                System.err.println("Invalid hex string '" + string + "' at " + this.st.lineno());
            }
            ++n;
        }
        return l;
    }

    void showLocation(String string) {
        System.out.println("showLocation() " + string + " At line: " + this.st.lineno() + "  currCCT= " + this.currCCT + ", 1stEnt=" + (String)this.currCCT[0]);
    }

    class InvalidHTMLException
    extends Exception {
        public InvalidHTMLException(String string) {
            super("\n  " + string + " at line:" + HTMLParser.this.st.lineno());
            HTMLParser.this.getClass();
        }
    }

    class ParseTAG {
        int type;

        void parseTag(String string) throws InvalidHTMLException {
        }

        ParseTAG() {
            HTMLParser.this.getClass();
        }

        int getType() {
            return this.type;
        }
    }

    class ParseA
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.saveColor.push(HTMLParser.this.currColor);
                HTMLParser.this.currColor = HTMLParser.this.linkColor;
                HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.linkColor));
                String string2 = HTMLParser.this.getToken();
                if (string2.equalsIgnoreCase("HREF")) {
                    String string3 = HTMLParser.this.getCkValue(string2);
                    String string4 = HTMLParser.this.getAString("", "<").trim();
                    HTMLParser.this.de.addElement(new DocElemHLString(string4, string3));
                } else if (string2.equalsIgnoreCase("NAME")) {
                    String string5 = HTMLParser.this.getCkValue(string2);
                    HTMLParser.this.de.addElement(new DocElemRegisterLoc(string5));
                } else {
                    HTMLParser.this.eatTag(string);
                }
            } else {
                HTMLParser.this.currColor = HTMLParser.this.saveColor.popColor();
                HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseA() {
            HTMLParser.this.getClass();
            this.type = 9;
        }
    }

    class ParseB
    extends ParseTAG {
        int nest;

        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                ++this.nest;
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize());
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                this.nest += -1;
                if (this.nest < 0) {
                    throw new InvalidHTMLException("</B> nest error");
                }
                HTMLParser.this.currFont = HTMLParser.this.saveFont.popFont();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }

        ParseB() {
            HTMLParser.this.getClass();
            this.nest = 0;
            this.type = HTMLParser.this.B_TAG;
        }
    }

    class ParseI
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 2, HTMLParser.this.currFont.getSize());
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = HTMLParser.this.saveFont.popFont();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }

        ParseI() {
            HTMLParser.this.getClass();
            this.type = 2;
        }
    }

    class ParseFONT
    extends ParseTAG {
        boolean popColor;

        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                String string2;
                Color color = HTMLParser.this.currColor;
                int n = HTMLParser.this.currFont.getSize();
                int n2 = HTMLParser.this.currFont.getStyle();
                String string3 = HTMLParser.this.currFont.getName();
                while (true) {
                    String string4;
                    if ((string2 = HTMLParser.this.getToken()).equalsIgnoreCase("COLOR")) {
                        string4 = HTMLParser.this.getAttributeValue(string2);
                        color = HTMLParser.this.getColor(string4);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("SIZE")) {
                        string4 = HTMLParser.this.getAttributeValue(string2);
                        int n3 = 0;
                        if (string4.startsWith("+")) {
                            n3 = Integer.parseInt(string4.substring(1));
                        } else if (string4.startsWith("-")) {
                            n3 = Integer.parseInt(string4);
                        } else {
                            n = Integer.parseInt(string4);
                        }
                        n += n3;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("FACE")) {
                        string3 = string4 = HTMLParser.this.getAttributeValue(string2);
                        continue;
                    }
                    if (string2.equalsIgnoreCase("STYLE")) {
                        string4 = HTMLParser.this.getAttributeValue(string2);
                        System.out.println("Font style=" + string4 + " NOT IMPLIMENTED");
                        continue;
                    }
                    if (!string2.equals(" ")) break;
                }
                HTMLParser.this.eatTag(string2);
                if (color != HTMLParser.this.currColor) {
                    this.popColor = true;
                    HTMLParser.this.saveColor.push(HTMLParser.this.currColor);
                    HTMLParser.this.currColor = color;
                    HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
                }
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(string3, n2, n);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                if (this.popColor) {
                    this.popColor = false;
                    HTMLParser.this.currColor = HTMLParser.this.saveColor.popColor();
                    HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
                }
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = HTMLParser.this.saveFont.popFont();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }

        ParseFONT() {
            HTMLParser.this.getClass();
            this.popColor = false;
            this.type = 3;
        }
    }

    class ParseCENTER
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemCenter());
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemEndCenter());
            }
        }

        ParseCENTER() {
            HTMLParser.this.getClass();
            this.type = 4;
        }
    }

    class ParseHEAD
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseHEAD() {
            HTMLParser.this.getClass();
            this.type = 12;
        }
    }

    class ParseBODY
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                String string2 = HTMLParser.this.getToken();
                while (!string2.equals(HTMLParser.this.RIGHT_BKT)) {
                    if (string2.equalsIgnoreCase("BGCOLOR") && (string2 = HTMLParser.this.getToken()).equals("=")) {
                        string2 = HTMLParser.this.getToken();
                        HTMLParser.this.currBGColor = HTMLParser.this.getColor(string2);
                        HTMLParser.this.de.addElement(new DocElemBGColor(HTMLParser.this.currBGColor));
                    }
                    string2 = HTMLParser.this.getToken();
                }
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseBODY() {
            HTMLParser.this.getClass();
            this.type = 11;
        }
    }

    class ParseTITLE
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                String string2;
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.doc.title = string2 = HTMLParser.this.getAString("", "<");
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseTITLE() {
            HTMLParser.this.getClass();
            this.type = 10;
        }
    }

    class ParseMETA
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.eatTag("");
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseMETA() {
            HTMLParser.this.getClass();
            this.type = 13;
        }
    }

    class ParseBR
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseBR() {
            HTMLParser.this.getClass();
            this.type = 14;
        }
    }

    class ParseP
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseP() {
            HTMLParser.this.getClass();
            this.type = 15;
        }
    }

    class ParseHR
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                String string2 = HTMLParser.this.getToken();
                int n = 1;
                if (string2.equalsIgnoreCase("SIZE")) {
                    String string3 = HTMLParser.this.getCkValue(string2);
                    n = Integer.parseInt(string3);
                } else {
                    HTMLParser.this.eatTag(string2);
                }
                HTMLParser.this.de.addElement(new DocElemColor(Color.gray));
                HTMLParser.this.de.addElement(new DocElemHorizLine(n));
                HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseHR() {
            HTMLParser.this.getClass();
            this.type = 16;
        }
    }

    class ParseOL
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.de.addElement(new DocElemSetInset(2));
                HTMLParser.this.de.addElement(new DocElemNewLine());
                if (HTMLParser.this.currListType != 0) {
                    HTMLParser.this.saveListType.push(HTMLParser.this.currListType);
                    HTMLParser.this.saveOLIdx.push(HTMLParser.this.currOLIdx);
                }
                HTMLParser.this.currOLIdx = 1;
                HTMLParser.this.currListType = 1;
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemSetInset(-2));
                if (!HTMLParser.this.saveListType.isEmpty()) {
                    HTMLParser.this.currListType = HTMLParser.this.saveListType.popInt();
                    HTMLParser.this.currOLIdx = HTMLParser.this.saveOLIdx.popInt();
                }
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseOL() {
            HTMLParser.this.getClass();
            this.type = 17;
        }
    }

    class ParseUL
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.de.addElement(new DocElemSetInset(2));
                HTMLParser.this.de.addElement(new DocElemNewLine());
                if (HTMLParser.this.currListType != 0) {
                    HTMLParser.this.saveListType.push(HTMLParser.this.currListType);
                    HTMLParser.this.saveOLIdx.push(HTMLParser.this.currOLIdx);
                }
                HTMLParser.this.currListType = 2;
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemSetInset(-2));
                if (!HTMLParser.this.saveListType.isEmpty()) {
                    HTMLParser.this.currListType = HTMLParser.this.saveListType.popInt();
                    HTMLParser.this.currOLIdx = HTMLParser.this.saveOLIdx.popInt();
                }
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseUL() {
            HTMLParser.this.getClass();
            this.type = 18;
        }
    }

    class ParseLI
    extends ParseTAG {
        boolean doEndTag;

        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                if (this.doEndTag) {
                    HTMLParser.this.de.addElement(new DocElemNewLine());
                    HTMLParser.this.showLocation("<LI> ends <LI>");
                }
                String string2 = HTMLParser.ULIdx;
                if (HTMLParser.this.currListType == 1) {
                    string2 = HTMLParser.this.currOLIdx++ + HTMLParser.OLSfx;
                }
                HTMLParser.this.de.addElement(new DocElemString(string2));
                HTMLParser.this.de.addElement(new DocElemSetInset(4));
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemSetInset(-4));
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.getCkForRBkt();
                if (this.doEndTag) {
                    System.err.println("Got /LI for parseLIX??");
                }
            }
        }

        ParseLI() {
            HTMLParser.this.getClass();
            this.doEndTag = false;
            this.type = 19;
        }

        ParseLI(String string) {
            HTMLParser.this.getClass();
            this.doEndTag = false;
            this.type = 19;
            this.doEndTag = true;
        }
    }

    class ParseHTML
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseHTML() {
            HTMLParser.this.getClass();
            this.type = 20;
        }
    }

    class ParsePRE
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                String string2 = this.readLine();
                while (string2 != null && !string2.trim().equalsIgnoreCase("</PRE>")) {
                    if (string2.length() > 0) {
                        HTMLParser.this.de.addElement(new DocElemString(string2));
                    }
                    HTMLParser.this.de.addElement(new DocElemNewLine());
                    string2 = this.readLine();
                }
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParsePRE() {
            HTMLParser.this.getClass();
            this.type = 22;
        }

        private String readLine() {
            StringBuffer stringBuffer = new StringBuffer(100);
            while (true) {
                try {
                    int n = HTMLParser.this.fileRdr.read();
                    if (n == 10) break;
                    if (n == 13) continue;
                    stringBuffer.append((char)n);
                }
                catch (IOException iOException) {
                    System.err.println("Error reading <PRE> text");
                }
            }
            return stringBuffer.toString();
        }
    }

    class ParseDIV
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.eatThruEndTag(string);
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseDIV() {
            HTMLParser.this.getClass();
            this.type = 21;
        }
    }

    class ParseTT
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font("Monospaced", HTMLParser.this.currFont.getStyle(), HTMLParser.this.currFont.getSize());
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }

        ParseTT() {
            HTMLParser.this.getClass();
            this.type = 23;
        }
    }

    class ParseNOBR
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.de.addElement(new DocElemNOBR(true));
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemNOBR(false));
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseNOBR() {
            HTMLParser.this.getClass();
            this.type = 25;
        }
    }

    class ParseEATTAG
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            System.out.println("Eating tag: " + string + " at line " + HTMLParser.this.st.lineno());
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.eatThruEndTag(string);
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }

        ParseEATTAG() {
            HTMLParser.this.getClass();
            this.type = -1;
        }
    }

    class ParseH1
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + HTMLParser.this.H1Size);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }

        ParseH1() {
            HTMLParser.this.getClass();
            this.type = 5;
        }
    }

    class ParseH2
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + HTMLParser.this.H2Size);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }

        ParseH2() {
            HTMLParser.this.getClass();
            this.type = 6;
        }
    }

    class ParseH3
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + HTMLParser.this.H3Size);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }

        ParseH3() {
            HTMLParser.this.getClass();
            this.type = 7;
        }
    }

    class ParseH4
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + HTMLParser.this.H4Size);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }

        ParseH4() {
            HTMLParser.this.getClass();
            this.type = 8;
        }
    }

    class ParseH5
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font("Monospaced", 1, HTMLParser.this.currFont.getSize() + HTMLParser.this.H5Size);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }

        ParseH5() {
            HTMLParser.this.getClass();
            this.type = 25;
        }
    }

    class ParseH6
    extends ParseTAG {
        void parseTag(String string) throws InvalidHTMLException {
            if (!string.startsWith(HTMLParser.this.StartEndTAG)) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font("Monospaced", 2, HTMLParser.this.currFont.getSize() + HTMLParser.this.H6Size);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }

        ParseH6() {
            HTMLParser.this.getClass();
            this.type = 8;
        }
    }
}

