/*
 * Decompiled with CFR 0.152.
 */
package SlideShow;

import NormsTools.ChoiceOfYesOrNo;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.DroppedFileHandlerN;
import NormsTools.ErrDialog;
import NormsTools.FindOurHome;
import NormsTools.GetInput;
import NormsTools.GetIntInput;
import NormsTools.NormsDropTarget;
import NormsTools.OrderingList;
import NormsTools.SaveStdOutput;
import NormsTools.ShowListBox;
import NormsTools.ShowMsgBox;
import NormsTools.Sorter;
import SlideShow.CopyFilesTo;
import SlideShow.ImageData;
import SlideShow.ImageIndexFile;
import SlideShow.SSImageCanvas;
import SlideShow.WaitingForImage;
import SlideShow.WriteAppletHTML;
import SlideShow.WriteJavaScript;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public final class ImgIdxEditor
extends Frame
implements ActionListener,
TextListener,
ItemListener,
Runnable,
WaitingForImage,
DroppedFileHandlerN {
    public static boolean Testing;
    static final String TheTitle = "Image Index Editor for the Radder Slide Show - 13 Jan 2002";
    final String helpFN = "ImgIdxEditor.html";
    final String DRIVE_NM = "CD Photo1";
    final int LENLastModDate = 13;
    final String DOTSEP = ".";
    final String INVALIDFNCHAR = ";:'\"()[]{}#*&*-+= !~`";
    public static final String LandscapeIMAGE = "L";
    public static final String PortraitIMAGE = "P";
    public static final String ExcellentIMAGE = "E";
    public static final String GoodIMAGE = "G";
    public static final String PoorIMAGE = "P";
    final String propFN = "ImgIdxEditor.ini";
    String propFolder = "";
    String propFilePath = "";
    final String JPGFolderPN = "jpgFolder";
    final String HomeFolderPN = "homeFolder";
    final String LastRSSFilePN = "lastRSSFile";
    final String LastSSCopiedPN = "lastSSCopied";
    final String LastHTMLWrittenPN = "lastHTMLWritten";
    final String ImageFolderPN = "imageFolder";
    final String JavaScriptRefPN = "javascriptRef";
    final String AddGotoPN = "addGoto";
    final String HndrdPercentPN = "hndrdPercent";
    final String BGImagePN = "backgroundImg";
    private Properties ourProps = new Properties();
    boolean propsChanged = false;
    private String jpgFolder = "";
    String homeFolder = "";
    private String lastHTMLWritten = "";
    private String lastSSCopied = "";
    private String imageFolder = "jpg";
    String idxFnParm = "";
    String suffix = ".jpg";
    String idxDirParm = "";
    boolean fromDirectory;
    String driveLetter = "";
    SSImageCanvas showImg;
    ImageIndexFile iiFile;
    Frame fullFrame;
    ScrollPane scrollPane = new ScrollPane();
    int initWidth = 800;
    int adjHeight = 10;
    int initHeight = 600 - this.adjHeight;
    final Color BGCOLOR = new Color(0, 128, 208);
    MenuBar mbar;
    MenuItem fullScreenMI = new MenuItem("Full Screen");
    MenuItem showXXXMI = new MenuItem("Show All");
    MenuItem sttsMI = new MenuItem("Status");
    MenuItem autoPauseMI;
    MenuItem FasterMI = new MenuItem("Faster");
    MenuItem SlowerMI = new MenuItem("Slower");
    MenuItem chgDelayMI = new MenuItem("Change delay...");
    MenuItem listMI = new MenuItem("Select from list...");
    MenuItem findInFN = new MenuItem("Find in Filename...");
    MenuItem findInDesc = new MenuItem("Find in Description...");
    MenuItem nrScale = new MenuItem("Reduce");
    final String SetTestTXT = "Set test mode";
    final String ClearTestTXT = "Clear test mode";
    MenuItem setTestMI = new MenuItem("Set test mode");
    private MenuItem createFldrsMI = new MenuItem("Create SlideShow folders...");
    private MenuItem openIdxMI = new MenuItem("Open Index file...");
    private MenuItem openSSMI = new MenuItem("Open Slide Show...");
    private MenuItem openMI = new MenuItem("Get single image...");
    private MenuItem getAllImgMI = new MenuItem("Get All Images...");
    private MenuItem saveMI = new MenuItem("Save");
    private MenuItem saveAsMI = new MenuItem("Save As...");
    private MenuItem wrtApltHtmlMI = new MenuItem("Write HTML with Applet...");
    private MenuItem wrtJSHtmlMI = new MenuItem("Write HTML with JavaScript...");
    private MenuItem viewHTMLMI = new MenuItem("View home page");
    private MenuItem copyToMI = new MenuItem("Copy SlideShow to ...");
    private MenuItem exitMI = new MenuItem("Exit");
    private MenuItem enterDataMI = new MenuItem("Edit mode");
    private MenuItem orderMI = new MenuItem("Order images...");
    private MenuItem removeMI = new MenuItem("Remove image");
    private MenuItem addPreCommentMI = new MenuItem("Add Pre comment...");
    private MenuItem addPostCommentMI = new MenuItem("Add Post comment...");
    Menu optionsM = new Menu("Options");
    CheckboxMenuItem backgroundImgMI = new CheckboxMenuItem("Image as background");
    CheckboxMenuItem hndrdPercentMI = new CheckboxMenuItem("<IMG WIDTH & HEIGHT =100%", true);
    CheckboxMenuItem javascriptMI = new CheckboxMenuItem("Add Javascript reference");
    CheckboxMenuItem addGotoMI = new CheckboxMenuItem("Add goto Start");
    CheckboxMenuItem structuredModeMI = new CheckboxMenuItem("Structured mode");
    MenuItem setHomeMI = new MenuItem("Set home folder...");
    final String autoShowNm = "Start automatic Show";
    final String pauseShowNm = "Pause the show";
    MenuItem zllScale;
    MenuItem zlrScale;
    MenuItem zcScale;
    MenuItem zulScale;
    MenuItem zurScale;
    MenuItem aboutMI = new MenuItem("About Image Index Editor");
    MenuItem helpMI = new MenuItem("Help Topics");
    Panel aPanel = new Panel();
    Panel bPanel = new Panel();
    TextField imageFnTF = new TextField(50);
    TextField descTF = new TextField(50);
    TextField newNameTF = new TextField(30);
    CheckboxGroup orientationCBG = new CheckboxGroup();
    Checkbox landscapeCB = new Checkbox("Landscape", this.orientationCBG, true);
    Checkbox portraitCB = new Checkbox("Portrait", this.orientationCBG, false);
    CheckboxGroup qualityCBG = new CheckboxGroup();
    Checkbox excellentQCB = new Checkbox("Excellent", this.qualityCBG, false);
    Checkbox goodQCB = new Checkbox("Good", this.qualityCBG, true);
    Checkbox poorQCB = new Checkbox("Poor", this.qualityCBG, false);
    Button addImgBtn = new Button("Add new Image");
    Button updtImgDataBtn = new Button("Update data");
    Button nextImg = new Button("Next");
    Button lastImg = new Button("Last");
    Button renameImgBtn = new Button("Rename Image file");
    Label statusMsg = new Label("", 0);
    boolean autoDisplay = false;
    boolean fullScreen = false;
    boolean showALL = true;
    boolean arrowPressed = false;
    boolean usingJView = false;
    boolean tfChanged = false;
    boolean loggingStdOut = false;
    boolean java2 = false;
    boolean waitingOnLoad = false;
    ImageData[] saveImages;
    int autoDspTime = 8;
    final int AutoDspTimeMAX = 60;
    final int AutoDspTimeMIN = 3;
    int nbrID = 0;
    int maxID = 999;
    final int tableCushion = 50;
    int curID = -99;
    int selIdx = -1;
    int readAheadCnt = 3;
    String lastDir = "";
    String currDir = "*";
    String[] files;
    FilenameFilter filter;
    FilenameFilter dirFilter;
    String[] workFolders = new String[]{"ThumbNails", "RSSLib"};
    DateFormat dateFormatter = DateFormat.getDateTimeInstance(3, 3);
    NormsDropTarget nDT;
    private Vector imgVec;
    private String savedTitle = "Title not set";
    private String savedFN = "";
    Frame listF;
    List aList;
    int selItem = -1;
    Button show = null;
    private MenuItem svMenuItem;

    private void parseArgs(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            Object object;
            if (stringArray[n].equals("-e")) {
                if (++n >= stringArray.length) {
                    ImgIdxEditor.usage(1);
                }
                this.suffix = stringArray[n];
            } else if (stringArray[n].equals("-i")) {
                if (++n >= stringArray.length) {
                    ImgIdxEditor.usage(2);
                }
                object = new File(stringArray[n]);
                this.idxFnParm = ((File)object).getName();
                this.idxDirParm = ((File)object).getParent() + File.separator;
                System.out.println("-i " + this.idxDirParm + "<>" + this.idxFnParm + "<");
            } else if (stringArray[n].equals("-j")) {
                if (++n >= stringArray.length) {
                    ImgIdxEditor.usage(4);
                }
            } else if (stringArray[n].equals("-dl")) {
                if (++n >= stringArray.length) {
                    ImgIdxEditor.usage(4);
                }
                this.driveLetter = stringArray[n];
            } else if (stringArray[n].equals("-iniLoc")) {
                if (++n >= stringArray.length) {
                    ImgIdxEditor.usage(4);
                }
                this.propFolder = stringArray[n];
                if (!this.propFolder.endsWith(File.separator)) {
                    this.propFolder = this.propFolder + File.separator;
                }
            } else if (stringArray[n].equals("-ucd")) {
                object = System.getProperty("user.dir");
                this.driveLetter = ((String)object).substring(0, 1);
            } else if (stringArray[n].equals("-fd")) {
                this.fromDirectory = true;
            } else if (stringArray[n].equals("-JV")) {
                this.usingJView = true;
            } else if (stringArray[n].equals("?") || stringArray[n].equals("/?")) {
                ImgIdxEditor.usage(0);
            } else if (stringArray[n].equals("-t")) {
                this.setTesting(true);
            } else {
                if (Testing) {
                    System.out.println("stand alone arg: " + stringArray[n]);
                }
                if (!this.idxDirParm.equals("")) {
                    System.err.println(n + " " + this.idxDirParm + " " + stringArray[n]);
                    ImgIdxEditor.usage(3);
                } else {
                    if (!stringArray[n].endsWith(File.separator)) {
                        int n2 = n;
                        stringArray[n2] = stringArray[n2] + File.separator;
                    }
                    this.idxDirParm = stringArray[n];
                    this.lastDir = stringArray[n];
                }
            }
            ++n;
        }
    }

    private static void usage(int n) {
        System.out.println(n + " Usage: JAVA SlideShow.ImgIdxEditor [RSSdirectory] " + "[-e exten] [-i RSSfilename] [-fd] [-dl drvltr] [-ucd] [-JV]" + "[-iniLoc ini-folder]");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {}
        System.exit(n);
    }

    private int getID(String string) {
        int n = 1;
        while (n <= this.nbrID) {
            if (this.saveImages[n].getIDFN().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void createSSFolders() {
        if (this.homeFolder.equals("")) {
            return;
        }
        FileDialog fileDialog = new FileDialog((Frame)this, "Enter new Slide show name and press Save", 1);
        fileDialog.setFile("Enter New SlideShow name here");
        fileDialog.setDirectory(this.homeFolder);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string == null || string.equals("")) {
            return;
        }
        String string2 = fileDialog.getDirectory();
        if (Testing) {
            System.out.println("Going to create " + string2 + " <> " + string);
        }
        if (string2.endsWith(string + File.separator)) {
            new ErrDialog(this, "Invalid folder location: " + string2, true);
            return;
        }
        if (string2.indexOf(" ") >= 0 || string.indexOf(" ") >= 0) {
            new ErrDialog(this, "Invalid folder name.\nSpaces not allowed.", true);
            return;
        }
        File file = new File(string2, string);
        if (file.mkdir()) {
            File file2 = new File(file.toString() + File.separator + this.imageFolder);
            if (file2.mkdir()) {
                this.statusMsg.setText("Created folders: " + file.toString() + " and " + file2.toString());
            } else {
                new ErrDialog(this, "Error creating folder: " + file2.toString(), true);
                this.statusMsg.setText("Error creating folder: " + file2.toString());
            }
        } else {
            new ErrDialog(this, "Error creating folder: " + file.toString(), true);
            this.statusMsg.setText("Error creating folder: " + file.toString());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        if (Testing) {
            System.out.println("iSC " + itemEvent);
        }
        if ((object = itemEvent.getSource()) == this.backgroundImgMI) {
            this.hndrdPercentMI.setState(false);
        } else if (object == this.hndrdPercentMI) {
            this.backgroundImgMI.setState(false);
        } else {
            if (object == this.javascriptMI) {
                return;
            }
            if (object == this.addGotoMI) {
                return;
            }
            if (object == this.structuredModeMI) {
                this.openIdxMI.setEnabled(!this.structuredModeMI.getState());
                if (!this.structuredModeMI.getState()) {
                    if (this.java2) {
                        if (this.nDT == null) {
                            if (Testing) {
                                System.out.println("Setting DT " + this.showImg + ", " + this.showImg.getParent());
                            }
                            this.nDT = new NormsDropTarget(this.showImg, this, true);
                        } else {
                            this.nDT.setActive(true);
                        }
                    }
                } else if (this.java2 && this.nDT != null) {
                    this.nDT.setActive(false);
                }
            } else if (object != this.portraitCB && object != this.landscapeCB) {
                System.err.println("iSC unknown ie " + itemEvent);
            }
        }
        this.updtImgDataBtn.setEnabled(true);
    }

    private void setTesting(boolean bl) {
        if (bl) {
            try {
                SaveStdOutput.start("ImgIdxEditor.log");
                this.loggingStdOut = true;
            }
            catch (Exception exception) {
                System.err.println("Error saving StdOutput: " + exception);
            }
        } else if (this.loggingStdOut) {
            SaveStdOutput.stop();
        }
        Testing = bl;
        if (this.iiFile != null) {
            this.iiFile.setTesting(bl);
        }
        if (this.showImg != null) {
            this.showImg.setTesting(bl);
        }
    }

    public static String getVersion() {
        return TheTitle;
    }

    void showList() {
        this.listF = new Frame();
        this.listF.setTitle("Chose next slide to show");
        ((Component)this.listF).setSize(200, 400);
        ((Component)this.listF).setLocation(100, 100);
        ((Component)this.listF).setBackground(Color.lightGray);
        this.listF.setLayout(new BorderLayout());
        this.listF.addWindowListener(new WindowAdapter(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)ImgIdxEditor.this.listF).setVisible(false);
                ImgIdxEditor.this.listF.dispose();
            }
        });
        Panel panel = new Panel();
        int n = Math.min(25, Math.max(10, this.nbrID));
        this.aList = new List(n, false);
        int n2 = 1;
        while (n2 <= this.nbrID) {
            String string = this.saveImages[n2].getIDFN();
            this.aList.add(string);
            ++n2;
        }
        this.aList.addItemListener(new ItemListener(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                ImgIdxEditor.this.selItem = ImgIdxEditor.this.aList.getSelectedIndex();
                if (ImgIdxEditor.this.selItem == -1) {
                    return;
                }
                ++ImgIdxEditor.this.selItem;
                if (Testing) {
                    System.out.println("Selected " + ImgIdxEditor.this.selItem);
                }
                ImgIdxEditor.this.show.setEnabled(true);
            }
        });
        panel.add(this.aList);
        this.listF.add((Component)panel, "Center");
        Panel panel2 = new Panel();
        this.show = new Button("Show");
        this.show.setEnabled(false);
        this.show.addActionListener(new ActionListener(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (ImgIdxEditor.this.selItem == -1) {
                    return;
                }
                ((Component)ImgIdxEditor.this.listF).setVisible(false);
                ImgIdxEditor.this.listF.dispose();
                ImgIdxEditor.this.curID = ImgIdxEditor.this.selItem;
                ImgIdxEditor.this.showImg.startTracking(ImgIdxEditor.this.saveImages[ImgIdxEditor.this.curID].getImage(), ImgIdxEditor.this.saveImages[ImgIdxEditor.this.curID].getIdx());
                ImgIdxEditor.this.gotoThisDisplay(ImgIdxEditor.this.selItem);
            }
        });
        panel2.add(this.show);
        this.listF.add((Component)panel2, "South");
        this.listF.pack();
        ((Component)this.listF).setVisible(true);
    }

    public static void main(String[] stringArray) {
        new ImgIdxEditor(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block85: {
            try {
                String string = actionEvent.getActionCommand();
                Object object = actionEvent.getSource();
                if (object == this.openMI) {
                    this.getSingleImageFile();
                    break block85;
                }
                if (object == this.openSSMI) {
                    this.openSlideShow();
                    break block85;
                }
                if (object == this.openIdxMI) {
                    this.iiFile.openImageIndexFile(null);
                    break block85;
                }
                if (object == this.saveMI) {
                    this.iiFile.flush(false);
                    this.statusMsg.setText(this.nbrID + " image indexes saved to " + this.iiFile.currentIndexFN());
                    break block85;
                }
                if (object == this.saveAsMI) {
                    this.iiFile.saveImageIndexFileAs();
                    break block85;
                }
                if (object == this.wrtApltHtmlMI) {
                    WriteAppletHTML writeAppletHTML = new WriteAppletHTML(this, this.iiFile.getImageIndexDir(), this.iiFile.getImageIndexFn(), Testing);
                    writeAppletHTML.setHndrdPercent(this.hndrdPercentMI.getState());
                    writeAppletHTML.setJavaScriptRef(this.javascriptMI.getState());
                    writeAppletHTML.setAddGoto(this.addGotoMI.getState());
                    writeAppletHTML.setStructuredMode(this.structuredModeMI.getState());
                    String string2 = writeAppletHTML.writeHtmlWithApplet(this.saveImages, this.nbrID, this.iiFile.getPreComments(), this.iiFile.getPostComments(), this.backgroundImgMI.getState());
                    this.statusMsg.setText(string2);
                    this.lastHTMLWritten = writeAppletHTML.getHTMLWritten();
                    this.viewHTMLMI.setEnabled(!this.lastHTMLWritten.equals(""));
                    break block85;
                }
                if (object == this.wrtJSHtmlMI) {
                    WriteJavaScript writeJavaScript = new WriteJavaScript(this, this.iiFile.getImageIndexDir(), this.iiFile.getImageIndexFn(), Testing);
                    String string3 = writeJavaScript.writeHtmlWithJavaScript(this.saveImages, this.nbrID);
                    this.statusMsg.setText(string3);
                    break block85;
                }
                if (object == this.viewHTMLMI) {
                    if (this.lastHTMLWritten != null && !this.lastHTMLWritten.equals("")) {
                        if (Testing) {
                            System.out.println("Starting " + this.lastHTMLWritten);
                        }
                        Runtime.getRuntime().exec("Start " + this.lastHTMLWritten);
                    }
                    break block85;
                }
                if (object == this.copyToMI) {
                    CopyFilesTo copyFilesTo = new CopyFilesTo(this, this.lastDir, Testing);
                    copyFilesTo.setJView(this.usingJView);
                    copyFilesTo.doTheCopy();
                    this.lastSSCopied = copyFilesTo.getTargetDir();
                    this.propsChanged = true;
                    break block85;
                }
                if (object == this.setHomeMI) {
                    FileDialog fileDialog = new FileDialog((Frame)this, "Set home folder. Enter home folder and press Open button.", 0);
                    fileDialog.setFile("Press 'Open' when in home folder.");
                    fileDialog.setDirectory(this.lastDir);
                    fileDialog.show();
                    String string4 = fileDialog.getFile();
                    if (string4 == null || string4.equals("")) {
                        return;
                    }
                    this.homeFolder = fileDialog.getDirectory();
                    if (this.lastDir.equals("") && this.homeFolder != null) {
                        this.lastDir = this.homeFolder;
                    }
                    this.createFldrsMI.setEnabled(true);
                    this.openSSMI.setEnabled(true);
                    this.propsChanged = true;
                    break block85;
                }
                if (object == this.createFldrsMI) {
                    this.createSSFolders();
                    break block85;
                }
                if (object == this.addPreCommentMI) {
                    GetInput getInput = new GetInput("Enter pre comments for these images", this, 8, 80, "Save", this.iiFile.getPreComments());
                    this.iiFile.setPreComments(getInput.getResponse());
                    break block85;
                }
                if (object == this.addPostCommentMI) {
                    GetInput getInput = new GetInput("Enter post comments for these images", this, 8, 80, "Save", this.iiFile.getPostComments());
                    this.iiFile.setPostComments(getInput.getResponse());
                    break block85;
                }
                if (object == this.orderMI) {
                    this.autoDisplay = false;
                    this.orderList();
                    break block85;
                }
                if (object == this.removeMI) {
                    this.removeImageFromList();
                    break block85;
                }
                if (object == this.exitMI) {
                    this.exitProgram();
                    break block85;
                }
                if (object == this.getAllImgMI) {
                    this.getAllImagesInFolder();
                    break block85;
                }
                if (object == this.fullScreenMI) {
                    this.setFullScreen();
                    break block85;
                }
                if (object == this.enterDataMI) {
                    try {
                        this.enterDataMI.setEnabled(false);
                        this.fullScreenMI.setEnabled(true);
                        this.FasterMI.setEnabled(false);
                        this.SlowerMI.setEnabled(false);
                        this.chgDelayMI.setEnabled(false);
                        this.autoDisplay = false;
                        if (this.fullScreen) {
                            this.fullScreen = false;
                            this.autoPauseMI.setEnabled(false);
                            if (this.fullFrame != null) {
                                ((Component)this.fullFrame).setVisible(false);
                            }
                            this.setMenuBar(this.mbar);
                            this.requestFocus();
                            if (this.curID > 0) {
                                this.setDisplay(this.saveImages[this.curID]);
                            }
                            this.scrollPane.add(this.showImg);
                            this.scrollPane.setSize(this.showImg.getMinimumSize());
                            this.add("Center", this.scrollPane);
                            this.pack();
                            ((Component)this).setVisible(true);
                            this.showImg.repaint();
                            this.enableImageEdits(true);
                        }
                        break block85;
                    }
                    catch (Exception exception) {
                        System.err.println("E..D.. " + this.scrollPane + "\n" + this.showImg);
                    }
                    break block85;
                }
                if (string.equals("Show All")) {
                    this.showXXXMI.setLabel("Show Best");
                    this.showALL = false;
                } else if (string.equals("Show Best")) {
                    this.showXXXMI.setLabel("Show All");
                    this.showALL = true;
                } else if (object == this.findInFN) {
                    this.findImage("F");
                } else if (object == this.findInDesc) {
                    this.findImage("D");
                } else if (object == this.listMI) {
                    this.showList();
                } else if (object == this.nextImg) {
                    this.gotoNextDisplay();
                } else if (object == this.lastImg) {
                    this.gotoLastDisplay();
                } else if (object == this.renameImgBtn) {
                    this.renameImageFile();
                } else if (string.equals("Pause the show")) {
                    this.autoPauseMI.setLabel("Start automatic Show");
                    this.autoDisplay = false;
                } else if (string.equals("Start automatic Show")) {
                    if (!this.fullScreen) {
                        this.statusMsg.setText("Must be in Full Screen for Auto show");
                        return;
                    }
                    this.setAutoDisplay();
                } else if (object == this.FasterMI) {
                    this.autoDspTime = this.autoDspTime > 3 ? (this.autoDspTime = this.autoDspTime + -1) : 3;
                } else if (object == this.SlowerMI) {
                    this.autoDspTime = this.autoDspTime < 60 ? (this.autoDspTime = this.autoDspTime + 1) : 60;
                } else if (object == this.chgDelayMI) {
                    GetIntInput getIntInput = new GetIntInput(this, "Change image display times", "Set delay", 3, 60, this.autoDspTime);
                    this.autoDspTime = getIntInput.getValue();
                } else if (object == this.sttsMI) {
                    Frame frame = this;
                    if (this.fullScreen) {
                        frame = this.fullFrame;
                    }
                    Dimension dimension = this.showImg.getMinimumSize();
                    ShowMsgBox showMsgBox = new ShowMsgBox("RSS Status", "Slide no: " + this.curID + " of " + this.nbrID + ".  Delay is  " + this.autoDspTime + " seconds.  " + "Show is: " + (this.autoDisplay ? "Auto" : "manual") + ". WxH:" + dimension.width + "X" + dimension.height, frame, false);
                    showMsgBox = null;
                    frame.requestFocus();
                } else if (string.equals("Set test mode")) {
                    this.setTesting(true);
                    this.setTestMI.setLabel("Clear test mode");
                } else if (string.equals("Clear test mode")) {
                    this.setTesting(false);
                    this.setTestMI.setLabel("Set test mode");
                } else if (string.equals("Reduce")) {
                    this.nrScale.setLabel("Full");
                    this.showImg.setView("R");
                    this.gotoThisDisplay(this.curID);
                } else if (string.equals("Full")) {
                    this.showImg.setView("N");
                    this.setZoomMI(null);
                    this.nrScale.setLabel("Reduce");
                    this.gotoThisDisplay(this.curID);
                } else if (string.equals("Zoom-UL")) {
                    this.setZoomMI(this.zulScale);
                    this.showImg.setView("ZUL");
                    this.gotoThisDisplay(this.curID);
                } else if (string.equals("Zoom-UR")) {
                    this.setZoomMI(this.zurScale);
                    this.showImg.setView("ZUR");
                    this.gotoThisDisplay(this.curID);
                } else if (string.equals("Zoom-C")) {
                    this.setZoomMI(this.zcScale);
                    this.showImg.setView("ZC");
                    this.gotoThisDisplay(this.curID);
                } else if (string.equals("Zoom-LL")) {
                    this.setZoomMI(this.zllScale);
                    this.showImg.setView("ZLL");
                    this.gotoThisDisplay(this.curID);
                } else if (string.equals("Zoom-LR")) {
                    this.setZoomMI(this.zlrScale);
                    this.showImg.setView("ZLR");
                    this.gotoThisDisplay(this.curID);
                } else if (object == this.aboutMI) {
                    long l;
                    String string5 = "";
                    if (FindOurHome.fromJar() && (l = FindOurHome.getBuildDate(this)) > 0L) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("M/dd/yyyy h:mm a");
                        Date date = new Date(l);
                        string5 = "  Build date: " + simpleDateFormat.format(date) + "\n";
                    }
                    new ShowMsgBox("Image Index Editor", "Written by Norm Radder\n" + string5 + "  Email: radder@hotmail.com", this, true);
                } else if (object == this.helpMI) {
                    try {
                        new ShowDocument("ImgIdxEditor.html");
                    }
                    catch (Exception exception) {
                        new ErrDialog((Frame)this, "Error getting help files");
                    }
                } else {
                    System.out.println("a..P.. unknown evt " + actionEvent);
                }
            }
            catch (Exception exception) {
                System.err.println("a..Per.. ex: " + exception + "\n with event: " + actionEvent);
                exception.printStackTrace();
            }
        }
    }

    private void setFullScreen() {
        this.enterDataMI.setEnabled(true);
        this.fullScreenMI.setEnabled(false);
        this.FasterMI.setEnabled(true);
        this.SlowerMI.setEnabled(true);
        this.chgDelayMI.setEnabled(true);
        if (!this.fullScreen) {
            this.fullScreen = true;
            this.autoPauseMI.setEnabled(true);
            ((Component)this).setVisible(false);
            if (this.fullFrame == null) {
                this.fullFrame = new Frame();
            }
            this.fullFrame.add(this.showImg);
            this.fullFrame.addKeyListener(new KeyEventHandler());
            this.fullFrame.setMenuBar(this.mbar);
            if (this.curID > 0) {
                this.fullFrame.setTitle(this.saveImages[this.curID].getTitle());
            } else {
                this.fullFrame.setTitle("Radder Slide Show");
            }
            ((Component)this.fullFrame).setSize(this.initWidth, this.initHeight);
            ((Component)this.fullFrame).setVisible(true);
            this.fullFrame.requestFocus();
            this.fullFrame.addWindowListener(new WindowAdapter(){
                {
                    ImgIdxEditor.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ImgIdxEditor.this.exitProgram();
                }
            });
            this.fullFrame.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (Testing) {
                        System.out.println("Mouse pressed in fullFrame");
                    }
                    ImgIdxEditor.this.fullFrame.requestFocus();
                }
                {
                    ImgIdxEditor.this.getClass();
                }
            });
        }
    }

    private void getAllImages(String string) {
        Object object;
        File file = new File(string);
        if (!file.isDirectory()) {
            new ErrDialog((Frame)this, "Directory not found " + string);
            throw new IllegalArgumentException("getAllImages: no such directory: " + string);
        }
        if (this.filter == null) {
            this.filter = this.makeFilter();
        }
        this.files = file.list(this.filter);
        if (this.files.length < 1) {
            new ErrDialog((Frame)this, "No image files found in " + file);
            throw new IllegalArgumentException("getAllImages: No image files found for: " + file);
        }
        this.jpgFolder = file.getAbsolutePath();
        int n = 0;
        while (n < this.files.length) {
            object = new File(string, this.files[n]);
            this.files[n] = this.padLeadingZeros("" + ((File)object).lastModified(), 13) + this.files[n];
            ++n;
        }
        Sorter.sort(this.files);
        if (Testing) {
            n = 0;
            while (n < this.files.length) {
                System.out.println(this.files[n]);
                ++n;
            }
        }
        this.iiFile.flush(true);
        this.nbrID = this.files.length;
        this.maxID = this.files.length + 50;
        this.saveImages = new ImageData[this.maxID + 1];
        n = 0;
        while (n < this.files.length) {
            object = this.files[n].substring(13);
            if (Testing) {
                System.out.println("img fn=" + (String)object + " from " + this.files[n]);
            }
            this.saveImages[n + 1] = new ImageData(string, (String)object, " ", "VOLSER", GoodIMAGE, LandscapeIMAGE);
            ++n;
        }
        this.iiFile.setCreated(true);
    }

    private void removeImageFromList() {
        if (this.nbrID <= 1) {
            return;
        }
        this.nbrID += -1;
        this.iiFile.setChanged(true);
        this.saveImages[this.curID].flushImage();
        if (this.curID > this.nbrID) {
            this.saveImages[this.curID] = null;
            this.curID = 1;
        } else {
            ImageData[] imageDataArray = new ImageData[this.saveImages.length - 1];
            if (this.curID == 1) {
                System.arraycopy(this.saveImages, 2, imageDataArray, 1, this.nbrID);
            } else {
                System.arraycopy(this.saveImages, 1, imageDataArray, 1, this.curID - 1);
                System.arraycopy(this.saveImages, this.curID + 1, imageDataArray, this.curID, this.nbrID - this.curID + 1);
            }
            this.saveImages = imageDataArray;
        }
        this.showImg.startTracking(this.saveImages[this.curID].getImage(), this.saveImages[this.curID].getIdx());
        this.gotoThisDisplay(this.curID);
    }

    private void findImage(String string) {
        if (this.nbrID > 0) {
            GetInput getInput = new GetInput("Enter string to find", (Frame)this, "Find");
            String string2 = getInput.getResponse().trim();
            getInput = null;
            if (string2 != null && string2 != "") {
                int n;
                boolean bl = false;
                if (this.curID < this.nbrID) {
                    n = this.curID + 1;
                    while (n <= this.nbrID) {
                        if (string.equals("D") && this.saveImages[n].getDesc().indexOf(string2) >= 0 || string.equals("F") && this.saveImages[n].getIDFN().indexOf(string2) >= 0) {
                            this.curID = n;
                            if (Testing) {
                                System.out.println("Found: " + string2 + " at " + n);
                            }
                            this.showImg.startTracking(this.saveImages[n].getImage(), this.saveImages[n].getIdx());
                            this.gotoThisDisplay(n);
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    n = 1;
                    while (n < this.curID) {
                        if (string.equals("D") && this.saveImages[n].getDesc().indexOf(string2) >= 0 || string.equals("F") && this.saveImages[n].getIDFN().indexOf(string2) >= 0) {
                            this.curID = n;
                            if (Testing) {
                                System.out.println("Found: " + string2 + " at " + n);
                            }
                            this.showImg.startTracking(this.saveImages[n].getImage(), this.saveImages[n].getIdx());
                            this.gotoThisDisplay(n);
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (bl) {
                    if (this.fullScreen) {
                        this.fullFrame.requestFocus();
                    } else {
                        this.requestFocus();
                    }
                } else {
                    this.statusMsg.setText(string2 + " not found");
                }
            } else {
                this.statusMsg.setText("Find cancelled by user");
            }
        } else {
            this.statusMsg.setText("No images to search");
        }
    }

    protected void enableImageEdits(boolean bl) {
        this.nextImg.setEnabled(bl);
        this.lastImg.setEnabled(bl);
        this.wrtApltHtmlMI.setEnabled(bl);
        this.wrtJSHtmlMI.setEnabled(bl);
        this.saveMI.setEnabled(bl);
        this.saveAsMI.setEnabled(bl && !this.structuredModeMI.getState());
        this.addPreCommentMI.setEnabled(bl);
        this.addPostCommentMI.setEnabled(bl);
        this.orderMI.setEnabled(bl);
        this.removeMI.setEnabled(bl);
    }

    public void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.newNameTF) {
            this.renameImgBtn.setEnabled(!this.newNameTF.getText().trim().equals(""));
        } else if (object == this.descTF) {
            this.updtImgDataBtn.setEnabled(!this.descTF.getText().trim().equals("") && !this.tfChanged);
            this.tfChanged = false;
        } else {
            System.err.println("Unknown TextEvt " + textEvent);
        }
    }

    private void openProps(boolean bl) {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.propFilePath);
            this.ourProps.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Property file NOT found: " + this.propFilePath + " It will be created on Exit.");
            this.propsChanged = true;
            return;
        }
        catch (Exception exception) {
            System.err.println("Error getting properties " + exception);
        }
        this.jpgFolder = this.ourProps.getProperty("jpgFolder", this.jpgFolder);
        this.homeFolder = this.ourProps.getProperty("homeFolder", this.homeFolder);
        this.iiFile.setLastRSSFile(this.ourProps.getProperty("lastRSSFile", ""));
        this.lastSSCopied = this.ourProps.getProperty("lastSSCopied", this.lastSSCopied);
        this.lastHTMLWritten = this.ourProps.getProperty("lastHTMLWritten", this.lastHTMLWritten);
        this.imageFolder = this.ourProps.getProperty("imageFolder", this.imageFolder);
        this.backgroundImgMI.setState("true".equals(this.ourProps.getProperty("backgroundImg")));
        this.hndrdPercentMI.setState("true".equals(this.ourProps.getProperty("hndrdPercent")));
        this.javascriptMI.setState("true".equals(this.ourProps.getProperty("javascriptRef")));
        this.addGotoMI.setState("true".equals(this.ourProps.getProperty("addGoto")));
        if (bl) {
            // empty if block
        }
        if (Testing) {
            this.ourProps.list(System.out);
        }
    }

    void saveProps() {
        if (!this.propsChanged) {
            return;
        }
        this.propsChanged = false;
        ((Hashtable)this.ourProps).put("jpgFolder", this.jpgFolder);
        ((Hashtable)this.ourProps).put("homeFolder", this.homeFolder);
        ((Hashtable)this.ourProps).put("lastRSSFile", this.iiFile.getLastRSSFile());
        ((Hashtable)this.ourProps).put("lastSSCopied", this.lastSSCopied);
        ((Hashtable)this.ourProps).put("lastHTMLWritten", this.lastHTMLWritten);
        ((Hashtable)this.ourProps).put("imageFolder", this.imageFolder);
        ((Hashtable)this.ourProps).put("javascriptRef", "" + this.javascriptMI.getState());
        ((Hashtable)this.ourProps).put("addGoto", "" + this.addGotoMI.getState());
        ((Hashtable)this.ourProps).put("hndrdPercent", "" + this.hndrdPercentMI.getState());
        ((Hashtable)this.ourProps).put("backgroundImg", "" + this.backgroundImgMI.getState());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propFilePath);
            this.ourProps.save(fileOutputStream, "Image Index Editor");
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error saving props " + exception);
        }
        if (Testing) {
            this.ourProps.list(System.out);
        }
    }

    private void renameImageFile() {
        String string = this.newNameTF.getText().trim();
        String string2 = this.imageFnTF.getText();
        int n = string2.lastIndexOf(".");
        String string3 = string2.substring(n);
        int n2 = string.lastIndexOf(".");
        if (n2 < 0) {
            string = string + string3;
        } else if (!string3.equalsIgnoreCase(string.substring(n2))) {
            new ErrDialog((Frame)this, "Can not change image file extension!");
            return;
        }
        int n3 = 0;
        while (n3 < ";:'\"()[]{}#*&*-+= !~`".length()) {
            if (string.indexOf(";:'\"()[]{}#*&*-+= !~`".charAt(n3)) > -1) {
                new ErrDialog((Frame)this, "Invalid new filename. It must not have this character >" + ";:'\"()[]{}#*&*-+= !~`".charAt(n3) + "<");
                return;
            }
            ++n3;
        }
        File file = new File(this.saveImages[this.curID].getDir() + string);
        if (file.exists()) {
            new ErrDialog((Frame)this, "The New File exists " + file.getAbsolutePath());
            return;
        }
        File file2 = new File(this.saveImages[this.curID].getDir() + string2);
        if (!file2.exists()) {
            new ErrDialog((Frame)this, "The old File was not found " + file2.getAbsolutePath());
            return;
        }
        if (Testing) {
            System.out.println("Renaming " + this.saveImages[this.curID].getDir() + this.saveImages[this.curID].getIDFN() + " to " + this.saveImages[this.curID].getDir() + string);
        }
        if (!file2.renameTo(file)) {
            new ErrDialog((Frame)this, "Error renaming " + this.saveImages[this.curID].getDir() + this.saveImages[this.curID].getIDFN() + " to " + this.saveImages[this.curID].getDir() + string);
            return;
        }
        this.saveImages[this.curID].setFileName(string);
        this.imageFnTF.setText(string);
        this.savedFN = string;
        this.renameImgBtn.setEnabled(false);
        this.iiFile.setChanged(true);
    }

    private void setDisplay(ImageData imageData) {
        this.updtImgDataBtn.setEnabled(false);
        try {
            if (this.fullScreen) {
                this.savedTitle = imageData.getTitle();
            } else {
                this.imageFnTF.setText(imageData.getIDFN());
                this.savedFN = imageData.getIDFN();
                this.lastDir = imageData.getDir();
                if (imageData.getQuality().equals(ExcellentIMAGE)) {
                    this.excellentQCB.setState(true);
                } else if (imageData.getQuality().equals(GoodIMAGE)) {
                    this.goodQCB.setState(true);
                } else {
                    this.poorQCB.setState(true);
                }
                if (imageData.getOrientation().equals(LandscapeIMAGE)) {
                    this.landscapeCB.setState(true);
                } else {
                    this.portraitCB.setState(true);
                }
                this.tfChanged = true;
                this.descTF.setText(imageData.getDesc());
                if (this.curID > 0) {
                    this.statusMsg.setText("Displaying image: " + this.curID);
                }
            }
            this.currDir = imageData.getDir();
        }
        catch (NullPointerException nullPointerException) {
            System.err.println("setDisplay: npe " + imageData + " " + this.curID + " " + this.nbrID);
        }
    }

    protected void gotoThisDisplay(int n) {
        if (this.nbrID < 1) {
            return;
        }
        this.setDisplay(this.saveImages[n]);
        this.showImg.setImage(this.saveImages[n].getImage(), this.saveImages[n].getIdx());
        if (n < this.nbrID) {
            this.showImg.startTracking(this.saveImages[n + 1].getImage(), this.saveImages[n + 1].getIdx());
        }
    }

    void exitProgram() {
        this.iiFile.flush(true);
        this.saveProps();
        if (this.loggingStdOut) {
            SaveStdOutput.stop();
        }
        System.exit(0);
    }

    private void invalidFirstRec(String string) {
        System.err.println("Invalid first record: " + string);
        this.maxID = 450;
    }

    public ImgIdxEditor(String[] stringArray) {
        Object object;
        FontMetrics fontMetrics;
        this.java2 = "1.2".compareTo(System.getProperty("java.version")) < 0;
        System.out.println("Java version: " + System.getProperty("java.version"));
        if (this.propFolder.equals("")) {
            this.propFolder = FindOurHome.getHomeLoc(this, "ImgIdxEditor.class");
        }
        this.parseArgs(stringArray);
        this.propFilePath = this.propFolder + "ImgIdxEditor.ini";
        if (Testing) {
            System.out.println("PropFilePath=" + this.propFilePath + (!FindOurHome.fromJar() ? "" : ", Build date: " + new Date(FindOurHome.getBuildDate(this))));
        }
        this.iiFile = new ImageIndexFile(this, this.idxDirParm, this.idxFnParm);
        this.iiFile.setTesting(Testing);
        this.openProps(true);
        if (this.lastDir.equals("") && this.homeFolder != null) {
            this.lastDir = this.homeFolder;
        }
        if ((fontMetrics = this.getFontMetrics(new Font("monspaced", 1, 12))).toString().indexOf("com.ms.awt.") >= 0) {
            this.usingJView = true;
            System.out.println("NOTE: Setting usingJView flag");
        }
        if (this.fromDirectory && !this.idxDirParm.equals("")) {
            this.getAllImages(this.idxDirParm);
        } else if (!this.idxFnParm.equals("")) {
            object = this.iiFile.readImageIndex(this.idxDirParm + this.idxFnParm);
            System.out.println("readImageIndex msg: " + (String)object);
        }
        if (Testing) {
            System.out.println("Starting GUI layout");
        }
        object = Toolkit.getDefaultToolkit().getScreenSize();
        this.initWidth = ((Dimension)object).width;
        this.initHeight = ((Dimension)object).height - this.adjHeight;
        if (Testing) {
            System.out.println("ScnSz: " + this.initWidth + "X" + this.initHeight);
        }
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(this.BGCOLOR);
        this.setTitle(TheTitle);
        this.addWindowListener(new WindowAdapter(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                ImgIdxEditor.this.exitProgram();
            }
        });
        this.mbar = new MenuBar();
        Menu menu = new Menu("File");
        this.createFldrsMI.addActionListener(this);
        this.createFldrsMI.setEnabled(!this.homeFolder.equals(""));
        menu.add(this.createFldrsMI);
        this.openSSMI.addActionListener(this);
        this.openSSMI.setEnabled(!this.homeFolder.equals(""));
        menu.add(this.openSSMI);
        this.openIdxMI.addActionListener(this);
        this.openIdxMI.setEnabled(this.homeFolder.equals(""));
        menu.add(this.openIdxMI);
        menu.addSeparator();
        this.openMI.addActionListener(this);
        menu.add(this.openMI);
        this.getAllImgMI.addActionListener(this);
        menu.add(this.getAllImgMI);
        menu.addSeparator();
        this.saveMI.addActionListener(this);
        this.saveMI.setEnabled(false);
        menu.add(this.saveMI);
        this.saveAsMI.addActionListener(this);
        this.saveAsMI.setEnabled(false);
        menu.add(this.saveAsMI);
        menu.addSeparator();
        this.wrtApltHtmlMI.addActionListener(this);
        this.wrtApltHtmlMI.setEnabled(false);
        menu.add(this.wrtApltHtmlMI);
        this.wrtJSHtmlMI.addActionListener(this);
        this.wrtJSHtmlMI.setEnabled(false);
        menu.add(this.wrtJSHtmlMI);
        menu.addSeparator();
        this.viewHTMLMI.addActionListener(this);
        this.viewHTMLMI.setEnabled(false);
        menu.add(this.viewHTMLMI);
        this.copyToMI.addActionListener(this);
        menu.add(this.copyToMI);
        menu.addSeparator();
        this.exitMI.addActionListener(this);
        menu.add(this.exitMI);
        this.mbar.add(menu);
        Menu menu2 = new Menu("Edit");
        this.enterDataMI.addActionListener(this);
        this.enterDataMI.setEnabled(false);
        menu2.add(this.enterDataMI);
        this.addPreCommentMI.setEnabled(false);
        this.addPreCommentMI.addActionListener(this);
        menu2.add(this.addPreCommentMI);
        this.addPostCommentMI.setEnabled(false);
        this.addPostCommentMI.addActionListener(this);
        menu2.add(this.addPostCommentMI);
        this.orderMI.addActionListener(this);
        this.orderMI.setEnabled(false);
        menu2.add(this.orderMI);
        menu2.addSeparator();
        this.removeMI.setEnabled(false);
        this.removeMI.addActionListener(this);
        menu2.add(this.removeMI);
        this.mbar.add(menu2);
        Menu menu3 = new Menu("Index");
        this.findInFN.addActionListener(this);
        menu3.add(this.findInFN);
        this.findInDesc.addActionListener(this);
        menu3.add(this.findInDesc);
        this.listMI.addActionListener(this);
        menu3.add(this.listMI);
        this.mbar.add(menu3);
        Menu menu4 = new Menu("Show");
        this.fullScreenMI.addActionListener(this);
        menu4.add(this.fullScreenMI);
        this.showXXXMI.addActionListener(this);
        menu4.add(this.showXXXMI);
        this.autoPauseMI = new MenuItem("Start automatic Show");
        this.autoPauseMI.addActionListener(this);
        this.autoPauseMI.setEnabled(false);
        menu4.add(this.autoPauseMI);
        this.FasterMI.addActionListener(this);
        this.FasterMI.setEnabled(false);
        menu4.add(this.FasterMI);
        this.SlowerMI.addActionListener(this);
        this.SlowerMI.setEnabled(false);
        menu4.add(this.SlowerMI);
        this.chgDelayMI.addActionListener(this);
        this.chgDelayMI.setEnabled(false);
        menu4.add(this.chgDelayMI);
        this.mbar.add(menu4);
        Menu menu5 = new Menu("Scale");
        this.nrScale.addActionListener(this);
        menu5.add(this.nrScale);
        this.zulScale = new MenuItem("Zoom-UL");
        this.zulScale.addActionListener(this);
        menu5.add(this.zulScale);
        this.zurScale = new MenuItem("Zoom-UR");
        this.zurScale.addActionListener(this);
        menu5.add(this.zurScale);
        this.zcScale = new MenuItem("Zoom-C");
        this.zcScale.addActionListener(this);
        menu5.add(this.zcScale);
        this.zllScale = new MenuItem("Zoom-LL");
        this.zllScale.addActionListener(this);
        menu5.add(this.zllScale);
        this.zlrScale = new MenuItem("Zoom-LR");
        this.zlrScale.addActionListener(this);
        menu5.add(this.zlrScale);
        this.mbar.add(menu5);
        this.backgroundImgMI.addItemListener(this);
        this.optionsM.add(this.backgroundImgMI);
        this.hndrdPercentMI.addItemListener(this);
        this.optionsM.add(this.hndrdPercentMI);
        this.optionsM.add(this.javascriptMI);
        this.optionsM.add(this.addGotoMI);
        this.structuredModeMI.addItemListener(this);
        this.structuredModeMI.setState(true);
        this.optionsM.add(this.structuredModeMI);
        this.optionsM.addSeparator();
        this.setHomeMI.addActionListener(this);
        this.optionsM.add(this.setHomeMI);
        this.setTestMI.addActionListener(this);
        if (Testing) {
            this.setTestMI.setLabel("Clear test mode");
        }
        this.optionsM.add(this.setTestMI);
        this.mbar.add(this.optionsM);
        Menu menu6 = new Menu("Help");
        this.sttsMI.addActionListener(this);
        menu6.add(this.sttsMI);
        menu6.add(this.aboutMI);
        this.aboutMI.addActionListener(this);
        menu6.add(this.helpMI);
        this.helpMI.addActionListener(this);
        this.mbar.add(menu6);
        this.setMenuBar(this.mbar);
        this.aPanel.setLayout(new GridLayout(4, 1));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        Label label = new Label("FileName:   ", 0);
        panel.add(label);
        this.imageFnTF.setEditable(false);
        panel.add(this.imageFnTF);
        this.landscapeCB.addItemListener(this);
        panel.add(this.landscapeCB);
        this.portraitCB.addItemListener(this);
        panel.add(this.portraitCB);
        this.aPanel.add(panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        Label label2 = new Label("Description:", 0);
        panel2.add(label2);
        this.descTF.addTextListener(this);
        panel2.add(this.descTF);
        this.excellentQCB.addItemListener(this);
        panel2.add(this.excellentQCB);
        this.goodQCB.addItemListener(this);
        panel2.add(this.goodQCB);
        this.poorQCB.addItemListener(this);
        panel2.add(this.poorQCB);
        this.aPanel.add(panel2);
        this.bPanel.setLayout(new FlowLayout(0));
        this.addImgBtn.addActionListener(new ActionListener(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImgIdxEditor.this.imageFnTF.getText().trim();
                ImgIdxEditor.this.testRename(ImgIdxEditor.this.lastDir, string);
                String string2 = ImgIdxEditor.this.excellentQCB.getState() ? ImgIdxEditor.ExcellentIMAGE : (ImgIdxEditor.this.goodQCB.getState() ? ImgIdxEditor.GoodIMAGE : "P");
                String string3 = ImgIdxEditor.this.landscapeCB.getState() ? ImgIdxEditor.LandscapeIMAGE : "P";
                String string4 = ImgIdxEditor.this.descTF.getText().trim();
                String string5 = ImgIdxEditor.this.DRIVE_NM;
                if (ImgIdxEditor.this.saveImages == null) {
                    ImgIdxEditor.this.saveImages = new ImageData[ImgIdxEditor.this.maxID + 1];
                }
                ImgIdxEditor.this.saveImages[++ImgIdxEditor.this.nbrID] = new ImageData(ImgIdxEditor.this.lastDir, string, string4, string5, string2, string3);
                if (Testing) {
                    System.out.println("Added: " + ImgIdxEditor.this.nbrID);
                }
                ImgIdxEditor.this.statusMsg.setText("Image " + ImgIdxEditor.this.nbrID + " Added");
                ImgIdxEditor.this.iiFile.setChanged(true);
                ImgIdxEditor.this.addImgBtn.setEnabled(false);
                ImgIdxEditor.this.curID = ImgIdxEditor.this.nbrID;
            }
        });
        this.addImgBtn.setEnabled(false);
        this.bPanel.add(this.addImgBtn);
        this.updtImgDataBtn.addActionListener(new ActionListener(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ImgIdxEditor.this.imageFnTF.getText().trim();
                ImgIdxEditor.this.testRename(ImgIdxEditor.this.lastDir, string);
                String string2 = ImgIdxEditor.this.descTF.getText().trim();
                String string3 = ImgIdxEditor.this.excellentQCB.getState() ? ImgIdxEditor.ExcellentIMAGE : (ImgIdxEditor.this.goodQCB.getState() ? ImgIdxEditor.GoodIMAGE : "P");
                String string4 = ImgIdxEditor.this.landscapeCB.getState() ? ImgIdxEditor.LandscapeIMAGE : "P";
                String string5 = ImgIdxEditor.this.DRIVE_NM;
                if (ImgIdxEditor.this.curID > 0) {
                    ImgIdxEditor.this.saveImages[ImgIdxEditor.this.curID].upDate(ImgIdxEditor.this.currDir, string, string2, string5, string3, string4);
                }
                if (Testing) {
                    System.out.println("Updated: " + ImgIdxEditor.this.curID);
                }
                ImgIdxEditor.this.iiFile.setChanged(true);
                ImgIdxEditor.this.updtImgDataBtn.setEnabled(false);
                ImgIdxEditor.this.statusMsg.setText("Image " + ImgIdxEditor.this.curID + " Updated");
            }
        });
        this.updtImgDataBtn.setEnabled(false);
        this.bPanel.add(this.updtImgDataBtn);
        this.nextImg.addActionListener(new ActionListener(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ImgIdxEditor.this.gotoNextDisplay();
            }
        });
        this.bPanel.add(this.nextImg);
        this.lastImg.addActionListener(new ActionListener(){
            {
                ImgIdxEditor.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ImgIdxEditor.this.gotoLastDisplay();
            }
        });
        this.bPanel.add(this.lastImg);
        this.enableImageEdits(false);
        this.bPanel.add(new Label("New name:"));
        this.newNameTF.addTextListener(this);
        this.newNameTF.setEditable(false);
        this.bPanel.add(this.newNameTF);
        this.renameImgBtn.addActionListener(this);
        this.renameImgBtn.setEnabled(false);
        this.bPanel.add(this.renameImgBtn);
        this.aPanel.add(this.bPanel);
        this.aPanel.add(this.statusMsg);
        this.add((Component)this.aPanel, "North");
        ((Component)this).setSize(this.initWidth, this.initHeight);
        if (this.nbrID > 0) {
            this.curID = 1;
            this.showImg = new SSImageCanvas(this.saveImages[this.curID].getImage(), this, this.initWidth, this.initHeight, Testing);
            this.showImg.addKeyListener(new KeyEventHandler());
            this.setFullScreen();
            this.setDisplay(this.saveImages[this.curID]);
            this.enableFinds(true);
            this.showImg.setImage(this.saveImages[this.curID].getImage(), this.saveImages[this.curID].getIdx());
            this.waitingOnLoad = true;
            if (this.curID < this.nbrID) {
                this.showImg.startTracking(this.saveImages[this.curID + 1].getImage(), this.saveImages[this.curID + 1].getIdx());
                this.saveImages[this.curID + 1].setTracked();
                this.setAutoDisplay();
            }
        } else {
            this.showImg = new SSImageCanvas(null, this, this.initWidth, this.initHeight, Testing);
            this.scrollPane.add(this.showImg);
            this.scrollPane.setSize(this.showImg.getMinimumSize());
            Adjustable adjustable = this.scrollPane.getVAdjustable();
            adjustable.addAdjustmentListener(new AdjustmentHandler());
            this.add((Component)this.scrollPane, "Center");
            this.pack();
            ((Component)this).setVisible(true);
            this.addKeyListener(new KeyEventHandler());
            this.showImg.addKeyListener(new KeyEventHandler());
            this.enableFinds(false);
        }
    }

    private void getSingleImageFile() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Select single image file", 0);
        fileDialog.setFile("*.gif;*.jpg");
        fileDialog.setDirectory(this.lastDir);
        fileDialog.show();
        String string = fileDialog.getFile();
        this.lastDir = fileDialog.getDirectory();
        if (string != null) {
            this.updtImgDataBtn.setEnabled(false);
            ImageData imageData = new ImageData(this.lastDir, string, "new", "VOLSER", GoodIMAGE, LandscapeIMAGE);
            this.showImg.setImage(imageData.getImage(), imageData.getIdx());
            this.imageFnTF.setText(string);
            this.savedFN = string;
            this.goodQCB.setState(true);
            this.landscapeCB.setState(true);
            this.descTF.setText("");
            this.savedTitle = string;
            this.addImgBtn.setEnabled(true);
            this.statusMsg.setText("Image loaded. Press Add... to include.");
        } else {
            System.out.println("User entered null image filename");
        }
        this.showImg.repaint();
    }

    public static String getParentDir(String string) {
        int n = string.substring(0, string.length() - 1).lastIndexOf(File.separator) + 1;
        return string.substring(0, n);
    }

    void testRename(String string, String string2) {
        ChoiceOfYesOrNo choiceOfYesOrNo;
        if (!string2.equals(this.savedFN) && (choiceOfYesOrNo = new ChoiceOfYesOrNo((Frame)this, "Do you want to rename\n    " + this.savedFN + "\n to " + string2)).isYes()) {
            File file;
            File file2;
            if (Testing) {
                System.out.println("Renaming " + this.savedFN + " to " + string2);
            }
            if (!(file2 = new File(string, this.savedFN)).renameTo(file = new File(string, string2))) {
                new ErrDialog(this, "Error renaming " + file2.getAbsolutePath() + "\n to " + file.getAbsolutePath(), true);
                System.err.println("Error renaming " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
            } else if (Testing) {
                System.out.println("Renamed " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
            }
        }
    }

    protected void enableFinds(boolean bl) {
        this.findInFN.setEnabled(bl);
        this.findInDesc.setEnabled(bl);
        this.listMI.setEnabled(bl);
    }

    private void orderList() {
        if (this.nbrID < 2) {
            return;
        }
        new OrderingList(this, "Order list of images", this.saveImages, 1, this.nbrID + 1);
    }

    public void imageLoaded(int n) {
        this.waitingOnLoad = false;
        if (Testing) {
            System.out.println("image " + n + " now loaded");
        }
        if (this.fullFrame != null) {
            this.fullFrame.setTitle(this.savedTitle);
        }
    }

    void setZoomMI(MenuItem menuItem) {
        if (this.svMenuItem != null) {
            this.svMenuItem.setEnabled(true);
        }
        if (menuItem != null) {
            menuItem.setEnabled(false);
        }
        this.svMenuItem = menuItem;
        this.nrScale.setLabel("Full");
    }

    private String padLeadingZeros(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        int n2 = 6 - (n - string.length());
        return ("000000" + string).substring(n2);
    }

    private FilenameFilter makeFilter() {
        return new FilenameFilter(){
            {
                ImgIdxEditor.this.getClass();
            }

            public boolean accept(File file, String string) {
                if (Testing) {
                    System.out.println("filter: " + file + " " + string);
                }
                if (new File(file, string).isDirectory()) {
                    return false;
                }
                return string.endsWith(ImgIdxEditor.this.suffix) || string.endsWith(ImgIdxEditor.this.suffix.toUpperCase()) || string.endsWith(ImgIdxEditor.this.suffix.toLowerCase());
            }
        };
    }

    private void getAllImagesInFolder() {
        Object object;
        String string = "";
        String string2 = "";
        while (true) {
            object = new FileDialog((Frame)this, "Get All image files. Enter folder, select any image and press Open.", 0);
            ((FileDialog)object).setFile("*.gif;*.jpg");
            ((FileDialog)object).setDirectory(this.lastDir);
            ((Dialog)object).show();
            String string3 = ((FileDialog)object).getFile();
            if (string3 == null || string3.equals("")) {
                System.out.println("User didn't select an image file");
                return;
            }
            string = ((FileDialog)object).getDirectory();
            string2 = ImgIdxEditor.getLowestFolder(string);
            if (string2.indexOf(" ") <= 0) break;
            System.err.println("Invalid directory name " + string2);
            new ErrDialog((Frame)this, "Directory name must not contain a blank!");
        }
        String string4 = ImgIdxEditor.getParentDir(string);
        this.iiFile.setImageIndexDir(string4);
        this.getAllImages(string);
        object = ImgIdxEditor.getLowestFolder(ImgIdxEditor.getParentDir(string));
        this.iiFile.setImageIndexFn((String)object);
        this.enableFinds(true);
        this.enableRenames(true);
        this.enableImageEdits(true);
        this.curID = 1;
        this.showImg.startTracking(this.saveImages[1].getImage(), this.saveImages[1].getIdx());
        this.gotoThisDisplay(1);
        this.statusMsg.setText(this.nbrID + " images loaded from " + string);
    }

    protected void enableRenames(boolean bl) {
        this.newNameTF.setEditable(bl);
    }

    private void openSlideShow() {
        File file;
        String[] stringArray;
        if (this.dirFilter == null) {
            this.dirFilter = new FilenameFilter(){
                {
                    ImgIdxEditor.this.getClass();
                }

                public boolean accept(File file, String string) {
                    if (new File(file, string).isDirectory()) {
                        int n = 0;
                        while (n < ImgIdxEditor.this.workFolders.length) {
                            if (string.equalsIgnoreCase(ImgIdxEditor.this.workFolders[n])) {
                                return false;
                            }
                            ++n;
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
        if ((stringArray = (file = new File(this.homeFolder)).list(this.dirFilter)).length < 1) {
            new ErrDialog((Frame)this, "No SlideShow folders found in " + file);
            throw new IllegalArgumentException("openSS: No folders found for: " + file);
        }
        Sorter.sort(stringArray);
        ShowListBox showListBox = new ShowListBox("Select Slide Show", stringArray, 10, (Frame)this);
        String string = showListBox.getSelection();
        if (string == null || string.equals("")) {
            return;
        }
        this.iiFile.openImageIndexFile(this.homeFolder + string);
    }

    void gotoNextDisplay() {
        if (this.nbrID < 1) {
            return;
        }
        if (this.curID >= this.nbrID) {
            this.curID = 0;
            this.showImg.startTracking(this.saveImages[1].getImage(), this.saveImages[1].getIdx());
        }
        if (this.curID >= 0 && this.curID < this.nbrID) {
            this.setDisplay(this.saveImages[++this.curID]);
            this.showImg.setImage(this.saveImages[this.curID].getImage(), this.saveImages[this.curID].getIdx());
            this.waitingOnLoad = true;
            if (this.curID < this.nbrID) {
                this.showImg.startTracking(this.saveImages[this.curID + 1].getImage(), this.saveImages[this.curID + 1].getIdx());
            }
            if (this.curID > this.readAheadCnt) {
                this.saveImages[this.curID - this.readAheadCnt].flushImage();
            }
        } else {
            System.err.println("->Next with curID= " + this.curID);
        }
        this.updtImgDataBtn.setEnabled(false);
    }

    public static String getLowestFolder(String string) {
        int n;
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.length() - 1);
        }
        n = (n = string.lastIndexOf(File.separator) + 1) > 1 ? n : string.length();
        return string.substring(n);
    }

    public void run() {
        while (this.autoDisplay) {
            try {
                Thread.sleep(1000 * this.autoDspTime);
            }
            catch (InterruptedException interruptedException) {}
            if (!this.autoDisplay) {
                return;
            }
            if (this.arrowPressed) {
                this.arrowPressed = false;
                continue;
            }
            if (this.waitingOnLoad) continue;
            this.gotoNextDisplay();
        }
    }

    void gotoLastDisplay() {
        if (this.nbrID < 1) {
            return;
        }
        if (this.curID == 1) {
            this.curID = this.nbrID + 1;
        }
        if (this.curID > 1 && this.curID <= this.nbrID + 1) {
            if (Testing) {
                System.out.println("backing up to Last: " + (this.curID - 1));
            }
            this.setDisplay(this.saveImages[this.curID += -1]);
            this.showImg.startTracking(this.saveImages[this.curID].getImage(), this.saveImages[this.curID].getIdx());
            this.showImg.setImage(this.saveImages[this.curID].getImage(), this.saveImages[this.curID].getIdx());
        } else {
            System.err.println("->'Last' with curID= " + this.curID);
        }
        this.updtImgDataBtn.setEnabled(false);
    }

    private void setAutoDisplay() {
        this.autoDisplay = true;
        this.FasterMI.setEnabled(true);
        this.SlowerMI.setEnabled(true);
        this.chgDelayMI.setEnabled(true);
        this.autoPauseMI.setLabel("Pause the show");
        Thread thread = new Thread(this);
        thread.start();
    }

    public void handleDroppedFile(File file) {
        if (this.imgVec == null) {
            this.imgVec = new Vector();
        }
        if (this.filter == null) {
            this.filter = this.makeFilter();
        }
        if (Testing) {
            System.out.println("got file " + file);
        }
        if (file == null) {
            boolean bl = false;
            if (this.saveImages == null) {
                this.maxID = this.imgVec.size() + 50;
                this.saveImages = new ImageData[this.maxID + 1];
                bl = true;
            }
            int n = 0;
            while (n < this.imgVec.size()) {
                file = (File)this.imgVec.elementAt(n);
                String string = file.getParent() + File.separator;
                String string2 = file.getName();
                this.saveImages[++this.nbrID] = new ImageData(string, string2, " ", "VOLSER", GoodIMAGE, LandscapeIMAGE);
                if (Testing) {
                    System.out.println("Added: " + string + string2 + " as " + this.nbrID);
                }
                ++n;
            }
            this.iiFile.setChanged(true);
            if (bl) {
                this.curID = 1;
                this.setDisplay(this.saveImages[1]);
                this.showImg.setImage(this.saveImages[1].getImage(), this.saveImages[1].getIdx());
                this.enableFinds(true);
                this.enableRenames(true);
                this.enableImageEdits(true);
            }
            this.imgVec = null;
            this.statusMsg.setText("Image " + this.nbrID + " added to show.");
        } else if (this.filter.accept(file, file.getName())) {
            this.imgVec.addElement(file);
        }
    }

    class KeyEventHandler
    extends KeyAdapter {
        KeyEventHandler() {
            ImgIdxEditor.this.getClass();
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (Testing) {
                System.out.println("Key typed: " + keyEvent);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (Testing) {
                System.out.println("Key press: " + keyEvent);
            }
            switch (keyEvent.getKeyCode()) {
                case 33: 
                case 38: 
                case 39: {
                    ImgIdxEditor.this.arrowPressed = true;
                    ImgIdxEditor.this.gotoNextDisplay();
                    break;
                }
                case 34: 
                case 37: 
                case 40: {
                    ImgIdxEditor.this.arrowPressed = true;
                    ImgIdxEditor.this.gotoLastDisplay();
                    break;
                }
                default: {
                    if (!Testing) break;
                    System.out.println("unsupported key press: " + keyEvent.getKeyCode());
                }
            }
        }
    }

    class AdjustmentHandler
    implements AdjustmentListener {
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (Testing) {
                System.out.println("Adjustment: " + adjustmentEvent);
            }
            ImgIdxEditor.this.showImg.repaint();
        }

        AdjustmentHandler() {
            ImgIdxEditor.this.getClass();
        }
    }
}

