/*
 * Decompiled with CFR 0.152.
 */
package SlideShow;

import NormsTools.ChoiceOfYesOrNo;
import NormsTools.ErrDialog;
import NormsTools.ShowMsgBox;
import SlideShow.ImageData;
import SlideShow.ImgIdxEditor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;

public class ImageIndexFile {
    static final String IndexFileExt = ".RSS";
    static final String IndexFilenameDFLT = "ImageIndex";
    static final String NBRIMAGES = "nbrimages=";
    static final char NEWLINE = '\n';
    static final char NEWLINE_REP = '\u00a0';
    static final String COMMENT_SEP = " ";
    static final String PostCommentTAG = "<POSTCMT>";
    static final String DOTSEP = ".";
    String dirName;
    String idxFilename;
    String lastRSSFile = "";
    String preComments = "";
    String postComments = "";
    boolean tableChanged = false;
    boolean tableCreated = false;
    boolean Testing = false;
    ImgIdxEditor iie;

    protected void saveImageIndexFileAs() {
        FileDialog fileDialog;
        while (true) {
            fileDialog = new FileDialog((Frame)this.iie, "Save Image Index file", 1);
            if (this.idxFilename.equals(IndexFilenameDFLT + IndexFileExt)) {
                if (this.Testing) {
                    System.out.println("SaveAs IndexDir: " + this.dirName);
                }
                fileDialog.setFile(ImgIdxEditor.getLowestFolder(this.dirName) + IndexFileExt);
            } else {
                fileDialog.setFile(this.idxFilename);
            }
            fileDialog.setDirectory(this.dirName);
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                System.out.println("Save As. User entered Null filename");
                this.iie.statusMsg.setText("Save As cancelled by user");
                return;
            }
            if (string.indexOf(COMMENT_SEP) <= 0) break;
            System.err.println("Invalid file name " + string);
            new ErrDialog((Frame)this.iie, "File name must not contain a blank!");
        }
        this.idxFilename = fileDialog.getFile();
        this.dirName = fileDialog.getDirectory();
        this.tableChanged = true;
        this.flush(false);
        this.iie.statusMsg.setText(this.iie.nbrID + " items saved");
    }

    public void setCreated(boolean bl) {
        this.tableCreated = bl;
    }

    private void invalidFirstRec(String string) {
        System.err.println("Invalid first record: " + string);
        this.iie.maxID = 450;
    }

    public ImageIndexFile(ImgIdxEditor imgIdxEditor, String string, String string2) {
        if (this.Testing) {
            System.out.println("ImageIndexFile: ImgIdxDir:" + string + ",  fn:" + string2);
        }
        this.iie = imgIdxEditor;
        this.dirName = string;
        this.idxFilename = string2;
    }

    public void setImageIndexFn(String string) {
        if (string.endsWith(IndexFileExt)) {
            this.idxFilename = string;
        } else {
            if (string.indexOf(DOTSEP) > 0) {
                throw new IllegalArgumentException("Invalid filename: " + string);
            }
            this.idxFilename = string + IndexFileExt;
        }
    }

    public String getImageIndexFn() {
        return this.idxFilename;
    }

    public void setTesting(boolean bl) {
        this.Testing = bl;
    }

    public String currentIndexFN() {
        return this.dirName + this.idxFilename;
    }

    protected String readImageIndex(String string) {
        Object object;
        int n = 0;
        File file = new File(string);
        if (this.Testing) {
            System.out.println("readImageIndex: reading " + file);
        }
        if (!file.exists()) {
            return "Error: file " + file.toString() + " not found.";
        }
        this.lastRSSFile = file.toString();
        this.iie.propsChanged = true;
        try {
            object = new BufferedReader(new FileReader(file));
            String string2 = ((BufferedReader)object).readLine();
            if (string2.startsWith(NBRIMAGES)) {
                this.preComments = "";
                this.postComments = "";
                int n2 = NBRIMAGES.length();
                int n3 = string2.indexOf(COMMENT_SEP, n2);
                if (n3 < 0) {
                    n3 = string2.length();
                } else {
                    int n4 = string2.indexOf(PostCommentTAG, n3);
                    if (n4 < 0) {
                        this.preComments = string2.substring(n3).replace('\u00a0', '\n');
                    } else if (n4 > 0) {
                        this.preComments = string2.substring(n3, n4).replace('\u00a0', '\n');
                        this.postComments = string2.substring(n4 + PostCommentTAG.length()).replace('\u00a0', '\n');
                    } else if (n4 == 0) {
                        this.postComments = string2.substring(PostCommentTAG.length()).replace('\u00a0', '\n');
                    }
                }
                try {
                    this.iie.maxID = Integer.parseInt(string2.substring(n2, n3)) + this.iie.tableCushion;
                }
                catch (NumberFormatException numberFormatException) {
                    this.invalidFirstRec("Idx record. Bad number: " + string2 + "   at " + n2);
                }
            } else {
                this.invalidFirstRec("Invalid Idx header record: " + string2);
            }
            this.iie.saveImages = new ImageData[this.iie.maxID + 1];
            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                String string3;
                File file2;
                if (string2.length() < 20) {
                    System.err.println("Skipping short record: " + string2);
                    continue;
                }
                this.iie.saveImages[++this.iie.nbrID] = new ImageData(string2);
                if (!this.iie.driveLetter.equals("")) {
                    this.iie.saveImages[this.iie.nbrID].setDriveLetter(this.iie.driveLetter);
                }
                if ((file2 = new File(string3 = this.iie.saveImages[this.iie.nbrID].getDir() + this.iie.saveImages[this.iie.nbrID].getIDFN())).exists()) continue;
                ++n;
                System.err.println("Missing file: " + string3);
            }
            ((BufferedReader)object).close();
            object = null;
        }
        catch (IOException iOException) {
            System.err.println("IOEx reading: " + file);
        }
        catch (Exception exception) {
            System.err.println("rdImgIdx: " + exception + "\n  nbrID=" + this.iie.nbrID + COMMENT_SEP + this.iie.maxID);
        }
        object = this.iie.nbrID + " images loaded with " + n + " errors";
        if (this.Testing) {
            System.out.println("Loaded " + this.iie.nbrID + " imgidx from " + file + " with " + n + " errors");
        }
        return object;
    }

    public void setLastRSSFile(String string) {
        this.lastRSSFile = string;
    }

    public String getLastRSSFile() {
        return this.lastRSSFile;
    }

    public void openImageIndexFile(String string) {
        Object object;
        this.flush(true);
        if (string == null) {
            object = new FileDialog((Frame)this.iie, "Open Image Index file", 0);
            ((FileDialog)object).setFile("*" + IndexFileExt);
            ((FileDialog)object).setDirectory(this.dirName.equals("") ? this.iie.homeFolder : this.dirName);
            ((Dialog)object).show();
            String string2 = ((FileDialog)object).getFile();
            if (string2 == null || string2.equals("")) {
                return;
            }
            this.idxFilename = string2;
            this.dirName = ((FileDialog)object).getDirectory();
        } else {
            if (this.Testing) {
                System.out.println("IIF.openImageIndexFile: " + string);
            }
            this.idxFilename = ImgIdxEditor.getLowestFolder(string) + IndexFileExt;
            this.dirName = string + (string.endsWith(File.separator) ? "" : File.separator);
        }
        string = this.dirName + this.idxFilename;
        if (this.Testing) {
            System.out.println("IIF.openImageIndexFile: path:" + string + "\n     dir:" + this.dirName + ",  fn:" + this.idxFilename);
        }
        if (string != null) {
            this.iie.nbrID = 0;
            object = this.readImageIndex(string);
            new ShowMsgBox("Image index load results:", (String)object, this.iie, false);
            if (this.iie.saveImages == null) {
                return;
            }
            this.tableCreated = false;
            this.iie.enableFinds(true);
            this.iie.enableRenames(true);
            this.iie.enableImageEdits(true);
            this.iie.curID = 1;
            this.iie.showImg.startTracking(this.iie.saveImages[1].getImage(), this.iie.saveImages[1].getIdx());
            this.iie.gotoThisDisplay(1);
        } else {
            System.out.println("User cancelled Open Image Idx");
        }
    }

    public void setPostComments(String string) {
        this.tableChanged = true;
        this.postComments = string;
    }

    public String getPostComments() {
        return this.postComments.replace('\u00a0', '\n');
    }

    public void setImageIndexDir(String string) {
        if (this.Testing) {
            System.out.println("setting ImgIdxDir to " + string);
        }
        this.dirName = string;
    }

    public String getImageIndexDir() {
        return this.dirName;
    }

    public void setPreComments(String string) {
        this.tableChanged = true;
        this.preComments = string;
    }

    public String getPreComments() {
        return this.preComments.replace('\u00a0', '\n');
    }

    public void flush(boolean bl) {
        Object object;
        Serializable serializable;
        if (!this.tableChanged && !this.tableCreated) {
            if (this.Testing) {
                System.out.println("flush() with no changes");
            }
            return;
        }
        if (bl && (this.tableChanged || this.tableCreated) && !((ChoiceOfYesOrNo)(serializable = new ChoiceOfYesOrNo((Frame)this.iie, "Do you want to " + (this.tableChanged ? "save the" : "create an") + " Index file: " + this.idxFilename + "?"))).isYes()) {
            return;
        }
        if (this.Testing) {
            System.out.println("flush(): " + this.iie.nbrID + " to file: " + this.dirName + "<>" + this.idxFilename + "<");
        }
        if (this.dirName != null && this.dirName.equals("")) {
            serializable = new FileDialog((Frame)this.iie, "Save Image Index file as", 1);
            ((FileDialog)serializable).setFile(this.idxFilename);
            ((FileDialog)serializable).setDirectory(this.dirName);
            ((Dialog)serializable).show();
            object = ((FileDialog)serializable).getFile();
            if (object == null || ((String)object).equals("")) {
                System.out.println("User entered null or empty Image Index filename");
                return;
            }
            this.idxFilename = object;
            this.dirName = ((FileDialog)serializable).getDirectory();
        }
        serializable = new File(this.dirName + this.idxFilename);
        this.lastRSSFile = ((File)serializable).toString();
        this.iie.propsChanged = true;
        try {
            object = new PrintWriter(new FileWriter((File)serializable));
            String string = NBRIMAGES + this.iie.nbrID + (!this.preComments.equals("") ? COMMENT_SEP + this.preComments.replace('\n', '\u00a0') : "") + (!this.postComments.equals("") ? PostCommentTAG + this.postComments.replace('\n', '\u00a0') : "");
            ((PrintWriter)object).println(string);
            int n = 1;
            while (n <= this.iie.nbrID) {
                ((PrintWriter)object).println(this.iie.saveImages[n].bldRecord());
                ++n;
            }
            ((PrintWriter)object).close();
        }
        catch (IOException iOException) {
            System.err.println("flush(): Error saving Image Index file to " + this.idxFilename);
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            System.err.println("flush(): ex> " + exception);
        }
        this.tableChanged = false;
        this.tableCreated = false;
    }

    public void setChanged(boolean bl) {
        this.tableChanged = bl;
    }
}

