/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public final class GetIntInput
extends Dialog
implements AdjustmentListener,
ActionListener,
TextListener {
    final boolean debug = false;
    int toFrontCnt = 3;
    boolean done = false;
    Scrollbar theSB;
    TextField theTF = new TextField(" ");
    Button button = new Button("Done");
    private int theValue = -1;
    private int minValue;
    private int maxValue;

    public GetIntInput(Frame parent, String title, String label, int min, int max, int init) {
        super(parent, title, true);
        this.theValue = init;
        this.minValue = min;
        this.maxValue = max;
        this.theSB = new Scrollbar(0, init, 1, this.minValue, this.maxValue + 1);
        this.setLayout(new BorderLayout());
        this.theSB.addAdjustmentListener(this);
        this.theTF.addActionListener(this);
        this.theTF.addTextListener(this);
        double[] rowWeights = new double[]{0.0, 1.0};
        double[] colWeights = new double[]{0.0, 1.0};
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = colWeights;
        Panel p = new Panel(gbl);
        p.setLayout(gbl);
        this.add((Component)this.makeScrollbars(label, this.theSB, this.theTF), "North");
        this.button.addActionListener(this);
        Panel bPanel = new Panel();
        bPanel.add(this.button);
        this.add((Component)bPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                GetIntInput.this.setDone();
            }

            public void windowDeactivated(WindowEvent we) {
                if (!GetIntInput.this.done && GetIntInput.this.toFrontCnt-- > 0) {
                    GetIntInput.this.toFront();
                }
            }
        });
        this.theTF.setText("" + this.theValue);
        this.theSB.setValue(this.theValue);
        this.addNotify();
        Insets ins = this.getInsets();
        ((Component)this).setSize(300, ins.top + ins.bottom + 53);
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((ss.width - this.getBounds().width) / 2, (ss.height - this.getBounds().height) / 2);
        this.show();
    }

    public int getValue() {
        return this.theValue;
    }

    Panel makeScrollbars(String l1, Scrollbar sb1, TextField tf1) {
        double[] rowWeights = new double[]{0.0, 1.0};
        double[] colWeights = new double[]{0.0, 1.0};
        GridBagLayout gbl = new GridBagLayout();
        gbl.columnWeights = colWeights;
        Panel p = new Panel(gbl);
        p.setLayout(gbl);
        this.add(p, gbl, new Label(l1, 1), 0, 0, 0);
        this.add(p, gbl, sb1, 1, 0, 2);
        this.add(p, gbl, tf1, 2, 0, 0);
        return p;
    }

    void add(Panel p, GridBagLayout gbl, Component comp, int x, int y, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.fill = fill;
        gbl.setConstraints(comp, gbc);
        p.add(comp);
    }

    public void textValueChanged(TextEvent te) {
        this.theValue = this.getInt(this.theTF);
        this.theSB.setValue(this.theValue);
    }

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == this.theTF) {
            this.theValue = this.getInt(this.theTF);
            this.theSB.setValue(this.theValue);
        } else if (src == this.button) {
            this.setDone();
        } else {
            System.err.println("Unknown ae " + ae);
        }
    }

    private void setDone() {
        this.done = true;
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private int getInt(TextField tf) {
        String s = tf.getText();
        int xx = -9999;
        try {
            xx = Integer.parseInt(s);
            if (xx <= this.maxValue && xx >= this.minValue) {
                return xx;
            }
            System.err.println("int value out of range: " + xx);
        }
        catch (Exception ex) {
            System.err.println("Invalid int value: " + s);
        }
        tf.setText("" + this.theValue);
        return this.theValue;
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        Object src = evt.getSource();
        if (src != this.theSB) {
            System.err.println("Unknown AdjE " + evt);
            return;
        }
        this.theValue = this.theSB.getValue();
        this.theTF.setText("" + this.theValue);
    }

    private String padZero(String s) {
        if (s.length() > 1) {
            return s;
        }
        return "0" + s;
    }
}

