/*
 * Decompiled with CFR 0.152.
 */
import Acme.JPM.Encoders.GifEncoder;
import NormsTools.BitmapFile;
import NormsTools.ErrDialog;
import NormsTools.FindOurHome;
import NormsTools.IntInputField;
import NormsTools.ShowMsgBox;
import NormsTools.WindowFramer;
import NormsTools.WindowFramerListener;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Properties;

public final class ScreenCapturer
extends Frame
implements ActionListener,
ItemListener,
WindowFramerListener {
    static final String Title = "Screen Capturer - 7 Feb 2002";
    MenuBar mb = new MenuBar();
    Menu fM = new Menu("File");
    MenuItem saveAsFM = new MenuItem("Save As...", new MenuShortcut(83));
    MenuItem exitFM = new MenuItem("Exit");
    Menu oM = new Menu("Options");
    MenuItem setClipOM = new MenuItem("Set Clip...");
    final String HideIW = "Hide view window";
    final String ShowIW = "Show view window";
    MenuItem cntrlViewOM = new MenuItem("Hide view window");
    CheckboxMenuItem useWinFrameOM = new CheckboxMenuItem("Use Window Frame");
    CheckboxMenuItem captInRTOM = new CheckboxMenuItem("Capture in realtime");
    MenuItem snapInOM = new MenuItem("Capture after delay", new MenuShortcut(67));
    MenuItem snapNowOM = new MenuItem("Capture now", new MenuShortcut(88));
    CheckboxMenuItem setColorRedOM = new CheckboxMenuItem("Set border red");
    CheckboxMenuItem setColorBlackOM = new CheckboxMenuItem("Set border black", true);
    CheckboxMenuItem setColorBlueOM = new CheckboxMenuItem("Set border blue");
    CheckboxMenuItem setColorGrayOM = new CheckboxMenuItem("Set border gray");
    CheckboxMenuItem setColorWhiteOM = new CheckboxMenuItem("Set border white");
    final CheckboxMenuItem[] allCBMI = new CheckboxMenuItem[]{this.setColorRedOM, this.setColorBlackOM, this.setColorBlueOM, this.setColorGrayOM, this.setColorWhiteOM};
    final Color[] setColors = new Color[]{Color.red, Color.black, Color.blue, Color.gray, Color.white};
    Menu hM = new Menu("Help");
    MenuItem statusHM = new MenuItem("Status");
    MenuItem aboutHM = new MenuItem("About");
    MenuItem topicsHM = new MenuItem("Topics");
    final String MoveRect = "Move rect with arrows";
    final String ResizeRect = "Resize rect with arrows";
    Label status = new Label("Move rect with arrows");
    Robot rbt;
    Image bImg = null;
    ImageWindow iw;
    WindowFramer winFrame = null;
    Rectangle captRect;
    Rectangle iwBnds;
    IntInputField clipX;
    IntInputField clipY;
    IntInputField clipW;
    IntInputField clipH;
    IntInputField captDelay;
    int snapDelay = 5;
    KeyEventHandler keh;
    Dimension screenSize;
    final int PadBnds = 2;
    final int MinSize;
    final String propFN = "ScreenCapturer.ini";
    final String BMP = ".bmp";
    final String JPG = ".jpg";
    final String JPEG = ".jpeg";
    final String GIF = ".gif";
    String imgFN = "ScreenCapture";
    String lastDir = "";
    private final String LastDir = "lastDir";
    private final String IWBounds = "IWBounds";
    private final String CaptRect = "CaptRect";
    private final String SCLocation = "SCLocation";
    private final String CaptDelay = "CaptDelay";
    private String propFolder = "";
    private String propFilePath = "";
    private Properties ourProps = new Properties();
    boolean propsChanged = false;
    private Point ourLoc = null;
    boolean saving = false;
    Object monitor = new Object();
    boolean testing = false;

    private Point setDefaultLoc() {
        return new Point(0, this.screenSize.height - this.getSize().height);
    }

    void exitProgram() {
        this.iw.dispose();
        this.saveProps();
        Object object = this.monitor;
        synchronized (object) {
            Object var2_2 = null;
        }
        System.exit(0);
    }

    public ScreenCapturer(String[] stringArray) {
        super(Title);
        this.MinSize = 3;
        if (stringArray.length > 0 && stringArray[0].equalsIgnoreCase("-D")) {
            this.testing = true;
        }
        if (this.propFolder.equals("")) {
            this.propFolder = FindOurHome.getHomeLoc(this, "ScreenCapturer.class");
        }
        this.propFilePath = this.propFolder + "ScreenCapturer.ini";
        this.openProps();
        String string = System.getProperty("java.version");
        System.out.println("Java version: " + string);
        if ("1.2".compareTo(string.substring(0, 2)) < 0) {
            new ShowMsgBox("Need newer Java", "You need at least java 1.3 to run this program\n You currently have version: " + string, this, true);
            return;
        }
        try {
            this.rbt = new Robot();
        }
        catch (Exception exception) {
            System.err.println("Error getting Robot. ex " + exception);
            return;
        }
        this.saveAsFM.addActionListener(this);
        this.fM.add(this.saveAsFM);
        this.exitFM.addActionListener(this);
        this.fM.add(this.exitFM);
        this.mb.add(this.fM);
        this.setClipOM.addActionListener(this);
        this.cntrlViewOM.addActionListener(this);
        this.snapInOM.addActionListener(this);
        this.snapNowOM.addActionListener(this);
        this.useWinFrameOM.addItemListener(this);
        this.captInRTOM.addItemListener(this);
        this.captInRTOM.setEnabled(false);
        this.oM.add(this.snapInOM);
        this.oM.add(this.snapNowOM);
        this.oM.add(this.captInRTOM);
        this.oM.addSeparator();
        this.oM.add(this.cntrlViewOM);
        this.oM.add(this.useWinFrameOM);
        this.oM.add(this.setClipOM);
        this.oM.addSeparator();
        this.setColorBlackOM.addItemListener(this);
        this.setColorBlueOM.addItemListener(this);
        this.setColorRedOM.addItemListener(this);
        this.setColorGrayOM.addItemListener(this);
        this.setColorWhiteOM.addItemListener(this);
        this.oM.add(this.setColorBlackOM);
        this.oM.add(this.setColorBlueOM);
        this.oM.add(this.setColorRedOM);
        this.oM.add(this.setColorGrayOM);
        this.oM.add(this.setColorWhiteOM);
        this.mb.add(this.oM);
        this.statusHM.addActionListener(this);
        this.aboutHM.addActionListener(this);
        this.topicsHM.addActionListener(this);
        this.hM.add(this.statusHM);
        this.hM.add(this.topicsHM);
        this.hM.add(this.aboutHM);
        this.mb.add(this.hM);
        this.setMenuBar(this.mb);
        this.addWindowListener(new WindowAdapter(){
            long timeLastEvent;
            {
                ScreenCapturer.this.getClass();
                this.timeLastEvent = 0L;
            }

            public void windowClosing(WindowEvent windowEvent) {
                ScreenCapturer.this.exitProgram();
            }

            public void windowActivated(WindowEvent windowEvent) {
                if (ScreenCapturer.this.testing) {
                    System.out.println("winActivated " + (System.currentTimeMillis() - this.timeLastEvent));
                }
                if (System.currentTimeMillis() - this.timeLastEvent > 100L) {
                    if (ScreenCapturer.this.iw != null) {
                        ScreenCapturer.this.iw.toFront();
                    }
                    ScreenCapturer.this.requestFocus();
                    ScreenCapturer.this.toFront();
                    this.timeLastEvent = System.currentTimeMillis();
                }
            }
        });
        this.add(this.status);
        this.keh = new KeyEventHandler();
        this.addKeyListener(this.keh);
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (this.ourLoc == null) {
            this.ourLoc = this.setDefaultLoc();
        }
        ((Component)this).setLocation(this.ourLoc);
        if (this.captRect == null) {
            this.captRect = this.setDefaultCapt();
        }
        this.pack();
        this.show();
        this.bImg = this.getImage(this.captRect);
        this.iw = new ImageWindow(new Frame());
        if (this.iwBnds == null) {
            this.iwBnds = this.setDefaultBnds();
        }
        ((Component)this.iw).setBounds(this.iwBnds);
        this.iw.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getSource();
        if (checkboxMenuItem == this.useWinFrameOM) {
            if (this.winFrame == null) {
                if (this.useWinFrameOM.getState()) {
                    this.winFrame = new WindowFramer(this);
                    this.winFrame.addWindowFramerListener(this);
                } else {
                    return;
                }
            }
            if (this.useWinFrameOM.getState()) {
                this.removeKeyListener(this.keh);
                this.addKeyListener(this.winFrame.getKeyListener());
                this.captInRTOM.setEnabled(true);
                this.winFrame.setBounds(this.captRect);
                this.winFrame.show();
            } else {
                this.winFrame.setVisible(false);
                this.captInRTOM.setEnabled(false);
                this.removeKeyListener(this.winFrame.getKeyListener());
                this.addKeyListener(this.keh);
            }
            return;
        }
        if (checkboxMenuItem == this.captInRTOM) {
            return;
        }
        int n = -1;
        int n2 = 0;
        while (n2 < this.allCBMI.length) {
            this.allCBMI[n2].setState(false);
            if (this.allCBMI[n2] == checkboxMenuItem) {
                n = n2;
            }
            ++n2;
        }
        checkboxMenuItem.setState(true);
        if (this.iw != null && n >= 0) {
            this.iw.setColor(this.setColors[n]);
        }
        if (this.winFrame != null && n >= 0) {
            this.winFrame.setColor(this.setColors[n]);
        }
    }

    public void windowMoved(Rectangle rectangle) {
        this.captRect = rectangle;
        if (this.captInRTOM.getState()) {
            this.bImg = this.getImage(rectangle);
            this.iwBnds.width = rectangle.width + 2;
            this.iwBnds.height = rectangle.height + 2;
            ((Component)this.iw).setBounds(this.iwBnds);
            this.iw.repaint();
        }
    }

    public static String getVersion() {
        return Title;
    }

    private Rectangle setDefaultCapt() {
        return new Rectangle(0, 0, 300, 120);
    }

    public static void main(String[] stringArray) {
        new ScreenCapturer(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.setClipOM) {
            GetClipRect getClipRect = new GetClipRect(this);
            if (getClipRect.cancelled) {
                return;
            }
            this.captRect.x = this.clipX.getValue();
            this.captRect.y = this.clipY.getValue();
            this.captRect.width = this.clipW.getValue();
            this.captRect.height = this.clipH.getValue();
            this.snapDelay = this.captDelay.getValue();
            this.bImg = this.getImage(this.captRect);
            this.iwBnds.width = this.captRect.width + 2;
            this.iwBnds.height = this.captRect.height + 2;
            ((Component)this.iw).setBounds(this.iwBnds);
            this.iw.repaint();
        } else if (object == this.snapInOM) {
            new Thread(new Runnable(){
                {
                    ScreenCapturer.this.getClass();
                }

                public void run() {
                    try {
                        Thread.sleep(ScreenCapturer.this.snapDelay * 1000);
                    }
                    catch (Exception exception) {}
                    ScreenCapturer.this.bImg = ScreenCapturer.this.getImage(ScreenCapturer.this.captRect);
                    ScreenCapturer.this.requestFocus();
                    ScreenCapturer.this.toFront();
                    if (ScreenCapturer.this.testing) {
                        System.out.println("Got image " + ScreenCapturer.this.bImg.getWidth(ScreenCapturer.this) + "x" + ScreenCapturer.this.bImg.getHeight(ScreenCapturer.this));
                    }
                    ScreenCapturer.this.iw.repaint();
                }
            }).start();
        } else if (object == this.snapNowOM) {
            this.bImg = this.getImage(this.captRect);
            this.requestFocus();
            this.toFront();
            if (this.testing) {
                System.out.println("Got image " + this.bImg.getWidth(this) + "x" + this.bImg.getHeight(this));
            }
            this.iw.repaint();
        } else if (object == this.cntrlViewOM) {
            if (this.cntrlViewOM.getLabel().equals("Show view window")) {
                ((Component)this.iw).setVisible(true);
                this.cntrlViewOM.setLabel("Hide view window");
            } else {
                ((Component)this.iw).setVisible(false);
                this.cntrlViewOM.setLabel("Show view window");
            }
        } else if (object == this.saveAsFM) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Save Image as", 1);
            int n = this.imgFN.indexOf(46);
            String string = this.imgFN + (n < 0 ? ".bmp" : "");
            fileDialog.setFile(string);
            fileDialog.setDirectory(this.lastDir);
            fileDialog.show();
            if (fileDialog.getFile() == null || fileDialog.getFile().trim().equals("")) {
                return;
            }
            this.lastDir = fileDialog.getDirectory();
            this.imgFN = fileDialog.getFile();
            if (!(this.imgFN.endsWith(".jpg") || this.imgFN.endsWith(".jpeg") || this.imgFN.endsWith(".bmp") || this.imgFN.endsWith(".gif"))) {
                new ErrDialog((Frame)this, "Invalid image filename: " + this.imgFN);
                return;
            }
            new WriteImage().start();
        } else if (object == this.statusHM) {
            new ShowMsgBox("Image stats", "x: " + this.captRect.x + ", y: " + this.captRect.y + " width: " + this.bImg.getWidth(this) + " height: " + this.bImg.getHeight(this), this, true);
        } else if (object == this.aboutHM) {
            new ShowMsgBox("Screen Capturer", "Written by Norm Radder\n Email: radder@hotmail.com", this, true);
        } else if (object == this.topicsHM) {
            new ShowMsgBox("Screen Capturer", "The captured image is shown in its own window.\nNote:  This program must have the focus to operate.\nMove or resize the clip rectangle by using the 4 arrows.\nSet Move mode by pressing 'c', Resize mode by Shift and 'c'\nArrow speed is increased by 5 times if Ctrl is pressed.\nImage can be captured now or later by using a Option Menu item.\nImage can be saved as: bmp, jpg or gif", this, true);
        } else if (object == this.exitFM) {
            this.exitProgram();
        } else {
            System.err.println("unkn ae " + actionEvent);
        }
    }

    void setStatus(String string) {
        this.status.setText(string);
        this.status.invalidate();
        this.validate();
    }

    synchronized Image getImage(Rectangle rectangle) {
        long l = System.currentTimeMillis();
        BufferedImage bufferedImage = this.rbt.createScreenCapture(rectangle);
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, -1, -1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return bufferedImage;
        }
        int[] nArray = (int[])pixelGrabber.getPixels();
        if (this.testing) {
            System.out.println("first 5 pixels: " + Integer.toHexString(nArray[0]) + " " + Integer.toHexString(nArray[1]) + " " + Integer.toHexString(nArray[2]) + " " + Integer.toHexString(nArray[3]) + " " + Integer.toHexString(nArray[4]));
        }
        nArray[0] = nArray[3];
        nArray[1] = nArray[3];
        nArray[2] = nArray[3];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(pixelGrabber.getWidth(), pixelGrabber.getHeight(), pixelGrabber.getColorModel(), nArray, 0, pixelGrabber.getWidth()));
        if (this.testing) {
            System.out.println("getImage() used " + (System.currentTimeMillis() - l) + " millisecs");
        }
        return image;
    }

    private Rectangle setDefaultBnds() {
        return new Rectangle(10, this.screenSize.height - this.bImg.getHeight(this) - this.getSize().height - 10, this.bImg.getWidth(this) + 2, this.bImg.getHeight(this) + 2);
    }

    private void openProps() {
        Object object;
        try {
            object = new FileInputStream(this.propFilePath);
            this.ourProps.load((InputStream)object);
            ((FileInputStream)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Property file NOT found: " + this.propFilePath + " It will be created on Exit.");
            this.propsChanged = true;
            return;
        }
        catch (Exception exception) {
            System.err.println("Error getting properties " + exception);
        }
        this.lastDir = this.ourProps.getProperty("lastDir", this.lastDir);
        this.snapDelay = Integer.parseInt(this.ourProps.getProperty("CaptDelay", "" + this.snapDelay));
        try {
            object = new IntProperties(this.ourProps.getProperty("IWBounds"));
            this.iwBnds = new Rectangle(((IntProperties)object).getPropertyAsInt("x"), ((IntProperties)object).getPropertyAsInt("y"), ((IntProperties)object).getPropertyAsInt("width"), ((IntProperties)object).getPropertyAsInt("height"));
            object = new IntProperties(this.ourProps.getProperty("SCLocation"));
            this.ourLoc = new Point(((IntProperties)object).getPropertyAsInt("x"), ((IntProperties)object).getPropertyAsInt("y"));
            object = new IntProperties(this.ourProps.getProperty("CaptRect"));
            this.captRect = new Rectangle(((IntProperties)object).getPropertyAsInt("x"), ((IntProperties)object).getPropertyAsInt("y"), ((IntProperties)object).getPropertyAsInt("width"), ((IntProperties)object).getPropertyAsInt("height"));
        }
        catch (Exception exception) {
            System.err.println("ex " + exception);
        }
    }

    private void saveProps() {
        this.propsChanged = false;
        ((Hashtable)this.ourProps).put("lastDir", this.lastDir);
        ((Hashtable)this.ourProps).put("IWBounds", this.iwBnds.toString());
        ((Hashtable)this.ourProps).put("SCLocation", this.getLocation().toString());
        ((Hashtable)this.ourProps).put("CaptDelay", "" + this.snapDelay);
        ((Hashtable)this.ourProps).put("CaptRect", this.captRect.toString());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propFilePath);
            this.ourProps.store(fileOutputStream, Title);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error saving props " + exception);
        }
        if (this.testing) {
            this.ourProps.list(System.out);
        }
    }

    final class ImageWindow
    extends Window {
        Point mPressed;
        Color borderColor;
        final int BorderX = 1;
        final int BorderY = 1;

        public ImageWindow(Frame frame) {
            super(frame);
            ScreenCapturer.this.getClass();
            this.borderColor = Color.black;
            this.BorderX = 1;
            this.BorderY = 1;
            this.addMouseMotionListener(new MouseMotionListener(){
                boolean resizing;
                boolean resizeRight;

                public void mouseDragged(MouseEvent mouseEvent) {
                    mouseEvent.translatePoint(ScreenCapturer.this.iwBnds.x, ScreenCapturer.this.iwBnds.y);
                    if (ScreenCapturer.this.testing) {
                        System.out.println("dragged to " + mouseEvent.getPoint());
                    }
                    if (ImageWindow.this.mPressed == null) {
                        return;
                    }
                    int n = mouseEvent.getX() - ImageWindow.this.mPressed.x;
                    int n2 = mouseEvent.getY() - ImageWindow.this.mPressed.y;
                    ImageWindow.this.mPressed = mouseEvent.getPoint();
                    if (this.resizing) {
                        int n3 = ScreenCapturer.this.iwBnds.width + n;
                        int n4 = ScreenCapturer.this.iwBnds.height + n2;
                        if (n3 > ScreenCapturer.this.MinSize && this.resizeRight || n4 > ScreenCapturer.this.MinSize && !this.resizeRight) {
                            if (this.resizeRight) {
                                ScreenCapturer.this.iwBnds.width = n3 + ScreenCapturer.this.PadBnds;
                                ScreenCapturer.this.captRect.width = n3;
                            } else {
                                ScreenCapturer.this.iwBnds.height = n4 + ScreenCapturer.this.PadBnds;
                                ScreenCapturer.this.captRect.height = n4;
                            }
                            ScreenCapturer.this.bImg = ScreenCapturer.this.getImage(ScreenCapturer.this.captRect);
                            ((Component)ImageWindow.this).setBounds(ScreenCapturer.this.iwBnds);
                            ImageWindow.this.repaint();
                            return;
                        }
                        System.out.println("Too small image created");
                        return;
                    }
                    if (n != 0 || n2 != 0) {
                        int n5 = ScreenCapturer.this.iwBnds.x + n;
                        int n6 = ScreenCapturer.this.iwBnds.y + n2;
                        if (!(n5 < 0 || n6 < 0 || n5 + ScreenCapturer.this.iwBnds.width > ScreenCapturer.this.screenSize.width && n >= 0 || n6 + ScreenCapturer.this.iwBnds.height > ScreenCapturer.this.screenSize.height && n2 >= 0)) {
                            ScreenCapturer.this.iwBnds.x = n5;
                            ScreenCapturer.this.iwBnds.y = n6;
                            if (ScreenCapturer.this.testing) {
                                System.out.println("   moving to " + ScreenCapturer.this.iwBnds.x + "," + ScreenCapturer.this.iwBnds.y + "   right=" + n + ", up=" + n2);
                            }
                            ((Component)ImageWindow.this).setLocation(ScreenCapturer.this.iwBnds.x, ScreenCapturer.this.iwBnds.y);
                            ImageWindow.this.repaint();
                        } else if (ScreenCapturer.this.testing) {
                            System.out.println("   NOT moving from " + ScreenCapturer.this.iwBnds.x + "," + ScreenCapturer.this.iwBnds.y + " to " + n5 + "," + n6 + "   right=" + n + ", up=" + n2);
                        }
                    } else if (ScreenCapturer.this.testing) {
                        System.out.println("   NO move from " + ScreenCapturer.this.iwBnds.x + "," + ScreenCapturer.this.iwBnds.y + "   right=" + n + ", up=" + n2);
                    }
                }
                {
                    ImageWindow.this.getClass();
                    this.resizing = false;
                    this.resizeRight = false;
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    if (mouseEvent.getX() >= ScreenCapturer.this.iwBnds.width - ScreenCapturer.this.MinSize && mouseEvent.getX() <= ScreenCapturer.this.iwBnds.width) {
                        ImageWindow.this.setCursor(Cursor.getPredefinedCursor(11));
                        this.resizing = true;
                        this.resizeRight = true;
                    } else if (mouseEvent.getY() >= ScreenCapturer.this.iwBnds.height - ScreenCapturer.this.MinSize && mouseEvent.getY() <= ScreenCapturer.this.iwBnds.height) {
                        ImageWindow.this.setCursor(Cursor.getPredefinedCursor(9));
                        this.resizing = true;
                        this.resizeRight = false;
                    } else {
                        ImageWindow.this.setCursor(Cursor.getDefaultCursor());
                        this.resizing = false;
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (ScreenCapturer.this.testing) {
                        System.out.println("mPressed at " + mouseEvent.getPoint() + " <<<<<<<<<<<<<<");
                    }
                    mouseEvent.translatePoint(ScreenCapturer.this.iwBnds.x, ScreenCapturer.this.iwBnds.y);
                    ImageWindow.this.mPressed = mouseEvent.getPoint();
                }
                {
                    ImageWindow.this.getClass();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    ImageWindow.this.mPressed = null;
                    ScreenCapturer.this.requestFocus();
                }
            });
        }

        public void paint(Graphics graphics) {
            graphics.setColor(this.borderColor);
            graphics.drawLine(1, 0, 1 + ScreenCapturer.this.captRect.width, 0);
            graphics.drawLine(0, 1, 0, 1 + ScreenCapturer.this.captRect.height);
            graphics.drawLine(1, 1 + ScreenCapturer.this.captRect.height, 1 + ScreenCapturer.this.captRect.width, 1 + ScreenCapturer.this.captRect.height);
            graphics.drawLine(1 + ScreenCapturer.this.captRect.width, 0, 1 + ScreenCapturer.this.captRect.width, 1 + ScreenCapturer.this.captRect.height);
            if (ScreenCapturer.this.bImg != null) {
                graphics.drawImage(ScreenCapturer.this.bImg, 1, 1, this);
            }
        }

        void setColor(Color color) {
            this.borderColor = color;
            this.repaint();
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    final class KeyEventHandler
    extends KeyAdapter {
        boolean upperLeft;
        boolean ctlIsPressed;
        boolean shiftPressed;
        int incrAmt;

        KeyEventHandler() {
            ScreenCapturer.this.getClass();
            this.upperLeft = true;
            this.ctlIsPressed = false;
            this.shiftPressed = false;
            this.incrAmt = 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void keyPressed(KeyEvent keyEvent) {
            block29: {
                int n;
                block30: {
                    block33: {
                        block32: {
                            block31: {
                                if (ScreenCapturer.this.testing) {
                                    System.out.println("keyPressed " + keyEvent);
                                }
                                if ((n = keyEvent.getKeyCode()) == 67) {
                                    this.upperLeft = !this.shiftPressed;
                                    ScreenCapturer.this.setStatus(this.upperLeft ? ScreenCapturer.this.MoveRect : ScreenCapturer.this.ResizeRect);
                                    return;
                                }
                                if (n == 16) {
                                    this.shiftPressed = true;
                                    return;
                                }
                                if (n == 17) {
                                    this.ctlIsPressed = true;
                                    this.incrAmt = 5;
                                    return;
                                }
                                if (n == 68 && this.ctlIsPressed) {
                                    ScreenCapturer.this.testing = !ScreenCapturer.this.testing;
                                    System.out.println("Debug is " + (ScreenCapturer.this.testing ? "ON" : "OFF"));
                                    return;
                                }
                                if (!this.upperLeft) break block30;
                                if (n != 38) break block31;
                                if (ScreenCapturer.this.captRect.y > this.incrAmt - 1) {
                                    ScreenCapturer.this.captRect.y -= this.incrAmt;
                                    break block29;
                                } else {
                                    Toolkit.getDefaultToolkit().beep();
                                }
                                break block29;
                            }
                            if (n != 40) break block32;
                            if (ScreenCapturer.this.captRect.y < ScreenCapturer.this.screenSize.height - ScreenCapturer.this.captRect.height - this.incrAmt) {
                                ScreenCapturer.this.captRect.y += this.incrAmt;
                                break block29;
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                            break block29;
                        }
                        if (n != 37) break block33;
                        if (ScreenCapturer.this.captRect.x > this.incrAmt - 1) {
                            ScreenCapturer.this.captRect.x -= this.incrAmt;
                            break block29;
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        break block29;
                    }
                    if (n == 39) {
                        if (ScreenCapturer.this.captRect.x < ScreenCapturer.this.screenSize.width - ScreenCapturer.this.captRect.width - this.incrAmt) {
                            ScreenCapturer.this.captRect.x += this.incrAmt;
                            break block29;
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        break block29;
                    } else {
                        if (ScreenCapturer.this.testing) {
                            System.out.println("keyPressed Ignoring " + keyEvent);
                        }
                        return;
                    }
                }
                if (n == 38) {
                    if (ScreenCapturer.this.captRect.height > ScreenCapturer.this.MinSize + this.incrAmt) {
                        ScreenCapturer.this.captRect.height -= this.incrAmt;
                    }
                } else if (n == 40) {
                    if (ScreenCapturer.this.captRect.y + ScreenCapturer.this.captRect.height < ScreenCapturer.this.screenSize.height - ScreenCapturer.this.PadBnds) {
                        ScreenCapturer.this.captRect.height += this.incrAmt;
                    }
                } else if (n == 37) {
                    if (ScreenCapturer.this.captRect.width > ScreenCapturer.this.MinSize + this.incrAmt) {
                        ScreenCapturer.this.captRect.width -= this.incrAmt;
                    }
                } else if (n == 39) {
                    if (ScreenCapturer.this.captRect.x + ScreenCapturer.this.captRect.width < ScreenCapturer.this.screenSize.width - ScreenCapturer.this.PadBnds) {
                        ScreenCapturer.this.captRect.width += this.incrAmt;
                    }
                } else {
                    if (ScreenCapturer.this.testing) {
                        System.out.println("keyPressed Ignoring " + keyEvent);
                    }
                    return;
                }
                ScreenCapturer.this.iwBnds.width = ScreenCapturer.this.captRect.width + ScreenCapturer.this.PadBnds;
                ScreenCapturer.this.iwBnds.height = ScreenCapturer.this.captRect.height + ScreenCapturer.this.PadBnds;
                ((Component)ScreenCapturer.this.iw).setBounds(ScreenCapturer.this.iwBnds);
            }
            ScreenCapturer.this.bImg = ScreenCapturer.this.getImage(ScreenCapturer.this.captRect);
            ScreenCapturer.this.iw.repaint();
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 17) {
                this.ctlIsPressed = false;
                this.incrAmt = 1;
            } else if (n == 16) {
                this.shiftPressed = false;
            }
        }
    }

    final class GetClipRect
    extends Dialog {
        boolean cancelled;

        GetClipRect(Frame frame) {
            super(frame, "Set clip rectangle", true);
            ScreenCapturer.this.getClass();
            this.cancelled = false;
            Panel panel = new Panel(new FlowLayout(0));
            panel.add(new Label("Rectangle:"));
            ScreenCapturer.this.clipX = new IntInputField("x ", 3, ScreenCapturer.this.captRect.x);
            panel.add(ScreenCapturer.this.clipX);
            ScreenCapturer.this.clipX.setMinMax(0, ScreenCapturer.this.screenSize.width);
            ScreenCapturer.this.clipY = new IntInputField("y ", 3, ScreenCapturer.this.captRect.y);
            panel.add(ScreenCapturer.this.clipY);
            ScreenCapturer.this.clipY.setMinMax(0, ScreenCapturer.this.screenSize.height);
            ScreenCapturer.this.clipW = new IntInputField("width ", 3, ScreenCapturer.this.captRect.width);
            panel.add(ScreenCapturer.this.clipW);
            ScreenCapturer.this.clipW.setMinMax(0, ScreenCapturer.this.screenSize.width);
            ScreenCapturer.this.clipH = new IntInputField("height ", 3, ScreenCapturer.this.captRect.height);
            panel.add(ScreenCapturer.this.clipH);
            ScreenCapturer.this.clipH.setMinMax(0, ScreenCapturer.this.screenSize.height);
            ScreenCapturer.this.captDelay = new IntInputField(" Capture delay:", 2, ScreenCapturer.this.snapDelay);
            panel.add(ScreenCapturer.this.captDelay);
            ScreenCapturer.this.captDelay.setMinMax(2, 20);
            this.addWindowListener(new WindowAdapter(){
                {
                    GetClipRect.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    GetClipRect.this.cancelled = true;
                    ((Component)GetClipRect.this).setVisible(false);
                    GetClipRect.this.dispose();
                }
            });
            this.add((Component)panel, "North");
            Button button = new Button("Set new clip rectangle");
            button.addActionListener(new ActionListener(){
                {
                    GetClipRect.this.getClass();
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)GetClipRect.this).setVisible(false);
                    GetClipRect.this.dispose();
                }
            });
            this.add((Component)button, "South");
            this.pack();
            ((Component)this).setLocation(0, ScreenCapturer.this.iwBnds.y - this.getSize().height);
            this.show();
        }
    }

    final class WriteImage
    extends Thread {
        String oldStatus;
        final String FinishedMsg = "Image saved";

        WriteImage() {
            ScreenCapturer.this.getClass();
            this.FinishedMsg = "Image saved";
        }

        public void run() {
            ScreenCapturer.this.saving = true;
            this.oldStatus = ScreenCapturer.this.status.getText();
            ScreenCapturer.this.setStatus("Writing image file: " + ScreenCapturer.this.imgFN);
            Object object = ScreenCapturer.this.monitor;
            synchronized (object) {
                Cursor cursor = ScreenCapturer.this.getCursor();
                Cursor cursor2 = ScreenCapturer.this.iw.getCursor();
                ScreenCapturer.this.setCursor(new Cursor(3));
                ScreenCapturer.this.iw.setCursor(new Cursor(3));
                if (ScreenCapturer.this.imgFN.endsWith(ScreenCapturer.this.BMP)) {
                    BitmapFile bitmapFile = new BitmapFile();
                    bitmapFile.saveBitmap(ScreenCapturer.this.lastDir + ScreenCapturer.this.imgFN, ScreenCapturer.this.bImg, ScreenCapturer.this.bImg.getWidth(ScreenCapturer.this.iw), ScreenCapturer.this.bImg.getHeight(ScreenCapturer.this.iw));
                    if (ScreenCapturer.this.testing) {
                        System.out.println("done saving " + ScreenCapturer.this.imgFN);
                    }
                } else if (ScreenCapturer.this.imgFN.endsWith(ScreenCapturer.this.JPG) || ScreenCapturer.this.imgFN.endsWith(ScreenCapturer.this.JPEG)) {
                    BufferedImage bufferedImage = new BufferedImage(ScreenCapturer.this.bImg.getWidth(ScreenCapturer.this.iw), ScreenCapturer.this.bImg.getHeight(ScreenCapturer.this.iw), 1);
                    Graphics graphics = bufferedImage.getGraphics();
                    graphics.drawImage(ScreenCapturer.this.bImg, 0, 0, ScreenCapturer.this);
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(ScreenCapturer.this.lastDir + ScreenCapturer.this.imgFN);
                        JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                        jPEGImageEncoder.encode(bufferedImage);
                        ((OutputStream)fileOutputStream).close();
                    }
                    catch (Exception exception) {
                        System.err.println("ex writing " + ScreenCapturer.this.lastDir + ScreenCapturer.this.imgFN);
                        new ErrDialog((Frame)ScreenCapturer.this, "Error writing JPG file: " + exception.getMessage());
                        exception.printStackTrace();
                    }
                } else if (ScreenCapturer.this.imgFN.endsWith(ScreenCapturer.this.GIF)) {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(ScreenCapturer.this.lastDir + ScreenCapturer.this.imgFN);
                        GifEncoder gifEncoder = new GifEncoder(ScreenCapturer.this.bImg, (OutputStream)fileOutputStream);
                        gifEncoder.encode();
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {
                        new ErrDialog((Frame)ScreenCapturer.this, "Error writing GIF file: " + exception.getMessage());
                        System.err.println("ex writing " + ScreenCapturer.this.lastDir + ScreenCapturer.this.imgFN);
                        exception.printStackTrace();
                    }
                } else {
                    System.err.println("Invalid filetype:" + ScreenCapturer.this.imgFN);
                }
                ScreenCapturer.this.monitor.notify();
                ScreenCapturer.this.saving = false;
                ScreenCapturer.this.setCursor(cursor);
                ScreenCapturer.this.iw.setCursor(cursor2);
                ScreenCapturer.this.setStatus("Image saved");
                Object var8_13 = null;
            }
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
            if (ScreenCapturer.this.status.getText().equals("Image saved")) {
                ScreenCapturer.this.setStatus(this.oldStatus);
            }
        }
    }

    class IntProperties
    extends Properties {
        Properties theProps;

        IntProperties(String string) throws Exception {
            ScreenCapturer.this.getClass();
            this.theProps = new Properties();
            int n = string.indexOf("[");
            int n2 = string.indexOf("]", n);
            if (n < 0 || n2 < n) {
                throw new Exception("Invalid prop string: " + string);
            }
            string = string.replace(',', '\n');
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.substring(n + 1, n2).getBytes());
            this.theProps.load(byteArrayInputStream);
        }

        int getPropertyAsInt(String string) {
            String string2 = this.theProps.getProperty(string);
            if (string2 == null) {
                return -99;
            }
            return Integer.parseInt(string2);
        }
    }
}

