/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import NormsTools.WindowFramerListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class WindowFramer {
    final int Thickness = 4;
    static final String TOP = "top";
    static final String RIGHT = "right";
    static final String BOTTOM = "bottom";
    static final String LEFT = "left";
    Color borderColor = Color.black;
    WindowSide topWin;
    WindowSide rightWin;
    WindowSide bottomWin;
    WindowSide leftWin;
    WindowSide[] allWins;
    WindowFramerListener wfl = null;
    KeyEventHandler keh;
    Rectangle theBnds = new Rectangle(100, 100, 100, 100);
    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
    boolean testing = false;

    public Point getLocation() {
        return new Point(this.theBnds.x, this.theBnds.y);
    }

    public KeyListener getKeyListener() {
        return this.keh;
    }

    public void requestFocus() {
        this.topWin.requestFocus();
    }

    void exitProgram() {
        if (this.testing) {
            System.out.println("Exiting");
            System.exit(0);
        }
    }

    public WindowFramer(Frame frame) {
        this.topWin = new WindowSide(frame, TOP);
        this.rightWin = new WindowSide(frame, RIGHT);
        this.bottomWin = new WindowSide(frame, BOTTOM);
        this.leftWin = new WindowSide(frame, LEFT);
        this.allWins = new WindowSide[]{this.topWin, this.rightWin, this.bottomWin, this.leftWin};
        this.topWin.setOpposite(this.bottomWin);
        this.rightWin.setOpposite(this.leftWin);
        this.bottomWin.setOpposite(this.topWin);
        this.leftWin.setOpposite(this.rightWin);
        this.setBounds(this.theBnds);
        this.setColor(this.borderColor);
        this.keh = new KeyEventHandler();
        this.addKeyListener(this.keh);
    }

    public void repaint() {
        int n = 0;
        while (n < this.allWins.length) {
            this.allWins[n].repaint();
            ++n;
        }
    }

    public void setColor(Color color) {
        int n = 0;
        while (n < this.allWins.length) {
            ((Component)this.allWins[n]).setBackground(color);
            ++n;
        }
    }

    void setTesting(boolean bl) {
        int n = 0;
        while (n < this.allWins.length) {
            this.allWins[n].setTesting(bl);
            ++n;
        }
    }

    public void setVisible(boolean bl) {
        int n = 0;
        while (n < this.allWins.length) {
            ((Component)this.allWins[n]).setVisible(bl);
            ++n;
        }
    }

    public void toFront() {
        int n = 0;
        while (n < this.allWins.length) {
            this.allWins[n].toFront();
            ++n;
        }
    }

    public void addWindowFramerListener(WindowFramerListener windowFramerListener) {
        this.wfl = windowFramerListener;
    }

    public void addKeyListener(KeyListener keyListener) {
        int n = 0;
        while (n < this.allWins.length) {
            this.allWins[n].addKeyListener(keyListener);
            ++n;
        }
    }

    public void show() {
        this.setVisible(true);
        this.requestFocus();
    }

    public Rectangle getBounds() {
        return this.theBnds;
    }

    public void setBounds(Rectangle rectangle) {
        if (this.testing) {
            System.out.println("WindowFramer.setBounds() to " + rectangle);
        }
        this.theBnds = rectangle;
        this.topWin.setBounds(rectangle.x - 4, rectangle.y - 4, rectangle.width + 8, 4);
        this.rightWin.setBounds(rectangle.x + rectangle.width, rectangle.y, 4, rectangle.height + 8);
        this.bottomWin.setBounds(rectangle.x - 4, rectangle.y + rectangle.height + 4, rectangle.width + 8, 4);
        this.leftWin.setBounds(rectangle.x - 4, rectangle.y - 4, 4, rectangle.height + 8);
        if (this.wfl != null) {
            this.wfl.windowMoved(rectangle);
        }
    }

    public void setLocation(int n, int n2) {
        this.theBnds.x = n;
        this.theBnds.y = n2;
        this.setBounds(this.theBnds);
    }

    final class KeyEventHandler
    extends KeyAdapter {
        boolean upperLeft;
        boolean ctlIsPressed;
        boolean shiftPressed;
        int incrAmt;

        KeyEventHandler() {
            WindowFramer.this.getClass();
            this.upperLeft = true;
            this.ctlIsPressed = false;
            this.shiftPressed = false;
            this.incrAmt = 1;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void keyPressed(KeyEvent keyEvent) {
            block31: {
                int n;
                block32: {
                    block35: {
                        block34: {
                            block33: {
                                if (WindowFramer.this.testing) {
                                    System.out.println("keyPressed " + keyEvent);
                                }
                                if ((n = keyEvent.getKeyCode()) == 67) {
                                    this.upperLeft = !this.shiftPressed;
                                    System.out.println(this.upperLeft ? "Moving" : "Changing size");
                                    return;
                                }
                                if (n == 16) {
                                    this.shiftPressed = true;
                                    return;
                                }
                                if (n == 17) {
                                    this.ctlIsPressed = true;
                                    this.incrAmt = 5;
                                    return;
                                }
                                if (n == 68 && this.ctlIsPressed) {
                                    WindowFramer.this.testing = !WindowFramer.this.testing;
                                    WindowFramer.this.setTesting(WindowFramer.this.testing);
                                    System.out.println("Debug is " + (WindowFramer.this.testing ? "ON" : "OFF"));
                                    return;
                                }
                                if (n == 87 && this.ctlIsPressed) {
                                    System.out.println("Bounds are: " + WindowFramer.this.theBnds);
                                    return;
                                }
                                if (n == 88 && this.ctlIsPressed) {
                                    WindowFramer.this.exitProgram();
                                }
                                if (!this.upperLeft) break block32;
                                if (n != 38) break block33;
                                if (WindowFramer.this.theBnds.y > 0) {
                                    WindowFramer.this.theBnds.y -= this.incrAmt;
                                    break block31;
                                } else {
                                    Toolkit.getDefaultToolkit().beep();
                                }
                                break block31;
                            }
                            if (n != 40) break block34;
                            if (WindowFramer.this.theBnds.y < WindowFramer.this.screenSize.height - WindowFramer.this.theBnds.height) {
                                WindowFramer.this.theBnds.y += this.incrAmt;
                                break block31;
                            } else {
                                Toolkit.getDefaultToolkit().beep();
                            }
                            break block31;
                        }
                        if (n != 37) break block35;
                        if (WindowFramer.this.theBnds.x > 0) {
                            WindowFramer.this.theBnds.x -= this.incrAmt;
                            break block31;
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        break block31;
                    }
                    if (n == 39) {
                        if (WindowFramer.this.theBnds.x < WindowFramer.this.screenSize.width - WindowFramer.this.theBnds.width) {
                            WindowFramer.this.theBnds.x += this.incrAmt;
                            break block31;
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        break block31;
                    } else {
                        if (WindowFramer.this.testing) {
                            System.out.println("keyPressed Ignoring " + keyEvent);
                        }
                        return;
                    }
                }
                if (n == 38) {
                    if (WindowFramer.this.theBnds.height > 0) {
                        WindowFramer.this.theBnds.height -= this.incrAmt;
                    }
                } else if (n == 40) {
                    if (WindowFramer.this.theBnds.y + WindowFramer.this.theBnds.height < WindowFramer.this.screenSize.height) {
                        WindowFramer.this.theBnds.height += this.incrAmt;
                    }
                } else if (n == 37) {
                    if (WindowFramer.this.theBnds.width > 0) {
                        WindowFramer.this.theBnds.width -= this.incrAmt;
                    }
                } else if (n == 39) {
                    if (WindowFramer.this.theBnds.x + WindowFramer.this.theBnds.width < WindowFramer.this.screenSize.width) {
                        WindowFramer.this.theBnds.width += this.incrAmt;
                    }
                } else {
                    if (WindowFramer.this.testing) {
                        System.out.println("keyPressed Ignoring " + keyEvent);
                    }
                    return;
                }
            }
            WindowFramer.this.setBounds(WindowFramer.this.theBnds);
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 17) {
                this.ctlIsPressed = false;
                this.incrAmt = 1;
            } else if (n == 16) {
                this.shiftPressed = false;
            }
        }
    }

    final class WindowSide
    extends Window {
        Point mPressed;
        String ourSide;
        Rectangle ourBnds;
        WindowSide opposSide;
        long dragCnt;
        boolean testing;

        public WindowSide(Frame frame, String string) {
            super(frame);
            WindowFramer.this.getClass();
            this.ourBnds = new Rectangle();
            this.dragCnt = 0L;
            this.testing = WindowFramer.this.testing;
            this.ourSide = string;
            this.testing = WindowFramer.this.testing;
            this.addWindowListener(new WindowAdapter(){
                long timeLastEvent;
                {
                    WindowSide.this.getClass();
                    this.timeLastEvent = 0L;
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (WindowSide.this.testing) {
                        System.out.println("winActivated " + (System.currentTimeMillis() - this.timeLastEvent));
                    }
                    if (System.currentTimeMillis() - this.timeLastEvent > 100L) {
                        WindowSide.this.requestFocus();
                        WindowFramer.this.toFront();
                        this.timeLastEvent = System.currentTimeMillis();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionListener(){
                boolean resizing;
                boolean resizeRight;

                public void mouseDragged(MouseEvent mouseEvent) {
                    if (WindowSide.this.dragCnt++ % 3L != 1L) {
                        return;
                    }
                    if (WindowSide.this.testing) {
                        System.out.println(WindowSide.this.ourSide + " dragged to " + mouseEvent.getPoint() + " at " + mouseEvent.getWhen());
                    }
                    mouseEvent.translatePoint(WindowSide.this.ourBnds.x, WindowSide.this.ourBnds.y);
                    if (WindowSide.this.testing) {
                        System.out.println(WindowSide.this.ourSide + " dragged to " + mouseEvent.getPoint() + " from: " + WindowSide.this.ourBnds.x + "," + WindowSide.this.ourBnds.y + " mPressed=" + WindowSide.this.mPressed);
                    }
                    if (WindowSide.this.mPressed == null) {
                        return;
                    }
                    int n = mouseEvent.getX() - WindowSide.this.mPressed.x;
                    int n2 = mouseEvent.getY() - WindowSide.this.mPressed.y;
                    WindowSide.this.mPressed = mouseEvent.getPoint();
                    if (this.resizing) {
                        if (n2 == 0 && n == 0) {
                            return;
                        }
                        int n3 = WindowFramer.this.theBnds.width + n;
                        int n4 = WindowFramer.this.theBnds.height + n2;
                        if (n3 > 0 && this.resizeRight || n4 > 0 && !this.resizeRight) {
                            if (WindowSide.this.testing) {
                                System.out.println(WindowSide.this.ourSide + " Resizing WxH from " + WindowFramer.this.theBnds.width + "x" + WindowFramer.this.theBnds.height + " to " + n3 + "x" + n4);
                            }
                            if (this.resizeRight) {
                                WindowFramer.this.theBnds.width = n3;
                            } else {
                                WindowFramer.this.theBnds.height = n4;
                            }
                            WindowFramer.this.setBounds(WindowFramer.this.theBnds);
                            return;
                        }
                        System.err.println("Frame is too small");
                        return;
                    }
                    if (n != 0 || n2 != 0) {
                        int n5 = WindowFramer.this.theBnds.x + n;
                        int n6 = WindowFramer.this.theBnds.y + n2;
                        if (!(n5 < 0 || n6 < 0 || n5 + WindowFramer.this.theBnds.width > WindowFramer.this.screenSize.width && n >= 0 || n6 + WindowFramer.this.theBnds.height > WindowFramer.this.screenSize.height && n2 >= 0)) {
                            if (WindowSide.this.testing) {
                                System.out.println(WindowSide.this.ourSide + "    moving to " + n5 + "," + n6 + "   right=" + n + ", up=" + n2);
                            }
                            WindowFramer.this.setLocation(n5, n6);
                            if (WindowSide.this.testing) {
                                System.out.println(" mDragged() - new bnds: " + WindowFramer.this.theBnds);
                            }
                        } else if (WindowSide.this.testing) {
                            System.out.println(WindowSide.this.ourSide + "    NOT moving from " + WindowFramer.this.theBnds.x + "," + WindowFramer.this.theBnds.y + " to " + n5 + "," + n6 + "   right=" + n + ", up=" + n2);
                        }
                    } else {
                        if (WindowSide.this.testing) {
                            System.out.println(WindowSide.this.ourSide + "    NO move from " + WindowSide.this.ourBnds.x + "," + WindowSide.this.ourBnds.y + " loc=" + WindowSide.this.getLocation());
                        }
                        Point point = WindowSide.this.getLocation();
                        n = point.x - WindowSide.this.ourBnds.x;
                        n2 = point.y - WindowSide.this.ourBnds.y;
                        if (n != 0 || n2 != 0) {
                            WindowFramer.this.theBnds.x += n;
                            WindowFramer.this.theBnds.y += n2;
                            WindowFramer.this.setBounds(WindowFramer.this.theBnds);
                        }
                    }
                }
                {
                    WindowSide.this.getClass();
                    this.resizing = false;
                    this.resizeRight = false;
                }

                public void mouseMoved(MouseEvent mouseEvent) {
                    mouseEvent.translatePoint(WindowFramer.this.theBnds.x, WindowFramer.this.theBnds.y);
                    if (WindowSide.this.ourSide.equals(WindowFramer.TOP) || WindowSide.this.ourSide.equals(WindowFramer.LEFT)) {
                        WindowSide.this.setCursor(Cursor.getPredefinedCursor(13));
                        this.resizing = false;
                        this.resizeRight = false;
                    } else if (WindowSide.this.ourSide.equals(WindowFramer.RIGHT)) {
                        WindowSide.this.setCursor(Cursor.getPredefinedCursor(11));
                        this.resizing = true;
                        this.resizeRight = true;
                    } else if (WindowSide.this.ourSide.equals(WindowFramer.BOTTOM)) {
                        WindowSide.this.setCursor(Cursor.getPredefinedCursor(9));
                        this.resizing = true;
                        this.resizeRight = false;
                    } else {
                        WindowSide.this.setCursor(Cursor.getDefaultCursor());
                        this.resizing = false;
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    mouseEvent.translatePoint(WindowSide.this.ourBnds.x, WindowSide.this.ourBnds.y);
                    if (WindowSide.this.testing) {
                        System.out.println(WindowSide.this.ourSide + " mPressed at " + mouseEvent.getPoint() + " <<<<<<<<<<<<<<");
                    }
                    WindowSide.this.mPressed = mouseEvent.getPoint();
                }
                {
                    WindowSide.this.getClass();
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    WindowSide.this.mPressed = null;
                    mouseEvent.translatePoint(WindowSide.this.ourBnds.x, WindowSide.this.ourBnds.y);
                    if (WindowSide.this.testing) {
                        System.out.println(WindowSide.this.ourSide + " mReleased at " + mouseEvent.getPoint() + " <<<<<<<<<<<<<<");
                    }
                }
            });
        }

        public void setOpposite(WindowSide windowSide) {
            this.opposSide = windowSide;
        }

        public void setTesting(boolean bl) {
            this.testing = bl;
        }

        public void setBounds(Rectangle rectangle) {
            if (this.testing) {
                System.out.println(this.ourSide + "  setBounds(R) to: " + rectangle);
            }
            super.setBounds(rectangle);
            this.ourBnds = rectangle;
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.testing) {
                System.out.println(this.ourSide + "  setBounds(i) to: " + n + "," + n2 + "  " + n3 + "x" + n4 + " at " + System.currentTimeMillis());
            }
            super.setBounds(n, n2, n3, n4);
            if (this.ourBnds != null) {
                this.ourBnds.x = n;
                this.ourBnds.y = n2;
                this.ourBnds.width = n3;
                this.ourBnds.height = n4;
            }
        }
    }
}

