/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import NormsTools.ErrDialog;
import NormsTools.MyLabel;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class IntInputField
extends Panel
implements FocusListener {
    MyLabel lbl;
    TextField tf;
    int value;
    int lastPos;
    Frame errF = null;
    int maxValue = 100000;
    int minValue = 0;
    FlowLayout fl = new FlowLayout(0);
    private long timeOfErr = 0L;

    public int getValue() {
        this.checkValue();
        return this.value;
    }

    public void setValue(int n) {
        this.value = n;
        this.tf.setText("" + n);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public IntInputField(String string, int n, int n2) {
        this.fl.setHgap(0);
        this.setLayout(this.fl);
        this.lbl = new MyLabel(string, 0);
        this.add(this.lbl);
        this.tf = new TextField("" + n2, n);
        this.add(this.tf);
        this.tf.addFocusListener(this);
        this.tf.addKeyListener(new KeyAdapter(){
            {
                IntInputField.this.getClass();
            }

            public void keyTyped(KeyEvent keyEvent) {
                char c = keyEvent.getKeyChar();
                if (!('0' <= c && c <= '9' || Character.isISOControl(c))) {
                    keyEvent.consume();
                } else {
                    IntInputField.this.lastPos = IntInputField.this.tf.getCaretPosition();
                }
            }
        });
        this.value = n2;
    }

    public void ckValid() {
        this.checkValue();
    }

    public void setErrFrame(Frame frame) {
        this.errF = frame;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            System.out.println("Temp focus lost!");
            return;
        }
        if (focusEvent.getComponent() == this.tf) {
            if (System.currentTimeMillis() - this.timeOfErr < 50L) {
                this.tf.requestFocus();
                return;
            }
            if (this.tf.getText().trim().equals("")) {
                if (this.errF != null) {
                    new ErrDialog(this.errF, this.lbl.getText() + " missing value ");
                } else {
                    System.err.println(this.lbl.getText() + " missing value ");
                }
                this.tf.requestFocus();
            } else {
                this.checkValue();
            }
        } else {
            System.out.println("unkn focusLost: " + focusEvent);
        }
    }

    private void checkValue() {
        if (this.tf.getText().trim().equals("")) {
            return;
        }
        try {
            int n = Integer.parseInt(this.tf.getText().trim());
            if (n > this.maxValue || n < this.minValue) {
                String string = this.lbl.getText() + " value out of range: (" + this.minValue + ":" + this.maxValue + ")";
                if (this.errF != null) {
                    new ErrDialog(this.errF, string, true);
                    this.timeOfErr = System.currentTimeMillis();
                } else {
                    System.err.println(string);
                }
                this.tf.requestFocus();
            } else {
                this.value = n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.tf.setText("" + this.value);
            this.tf.setCaretPosition(this.lastPos);
        }
    }

    public void setMinMax(int n, int n2) {
        if (n < n2) {
            this.minValue = n;
            this.maxValue = n2;
        } else {
            System.err.println("Invalid min:max values");
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }
}

