/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

public final class BitmapFile
extends Component {
    private static final boolean Testing = false;
    private static final int BITMAPFILEHEADER_SIZE = 14;
    private static final int BITMAPINFOHEADER_SIZE = 40;
    private byte[] bitmapFileHeader = new byte[14];
    private final byte[] bfType = new byte[]{66, 77};
    private int bfSize = 0;
    private int bfReserved1 = 0;
    private int bfReserved2 = 0;
    private int bfOffBits = 54;
    private byte[] bitmapInfoHeader = new byte[40];
    private int biSize = 40;
    private int biWidth = 0;
    private int biHeight = 0;
    private int biPlanes = 1;
    private int biBitCount = 24;
    private int biCompression = 0;
    private int biSizeImage = 196608;
    private int biXPelsPerMeter = 0;
    private int biYPelsPerMeter = 0;
    private int biClrUsed = 0;
    private int biClrImportant = 0;
    private int[] bitmap;
    private FileOutputStream fo;

    private void writeBitmapInfoHeader() {
        try {
            this.fo.write(this.intToDWord(this.biSize));
            this.fo.write(this.intToDWord(this.biWidth));
            this.fo.write(this.intToDWord(this.biHeight));
            this.fo.write(this.intToWord(this.biPlanes));
            this.fo.write(this.intToWord(this.biBitCount));
            this.fo.write(this.intToDWord(this.biCompression));
            this.fo.write(this.intToDWord(this.biSizeImage));
            this.fo.write(this.intToDWord(this.biXPelsPerMeter));
            this.fo.write(this.intToDWord(this.biYPelsPerMeter));
            this.fo.write(this.intToDWord(this.biClrUsed));
            this.fo.write(this.intToDWord(this.biClrImportant));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmap() {
        int n;
        byte[] byArray = new byte[3];
        int n2 = this.biWidth * this.biHeight;
        int n3 = this.biWidth * 3;
        int n4 = n3 % 4 == 0 ? 0 : 4 - n3 % 4;
        int n5 = 1;
        int n6 = 0;
        int n7 = n = n2 - this.biWidth - 1;
        try {
            int n8 = 0;
            while (n8 < n2) {
                int n9 = this.bitmap[n];
                byArray[0] = (byte)(n9 & 0xFF);
                byArray[1] = (byte)(n9 >> 8 & 0xFF);
                byArray[2] = (byte)(n9 >> 16 & 0xFF);
                this.fo.write(byArray);
                if (n5 == this.biWidth) {
                    n6 += n4;
                    int n10 = 1;
                    while (n10 <= n4) {
                        this.fo.write(0);
                        ++n10;
                    }
                    n5 = 1;
                    n7 = n = n7 - this.biWidth;
                } else {
                    ++n5;
                }
                ++n;
                ++n8;
            }
            this.bfSize += n6 - n4;
            this.biSizeImage += n6 - n4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("rowIndex: " + n + ", lastRowIndex:" + n7);
        }
    }

    private byte[] intToWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return byArray;
    }

    private byte[] intToDWord(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    private boolean convertImage(Image image, int n, int n2) {
        this.bitmap = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, this.bitmap, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            return false;
        }
        int n3 = n * 3;
        int n4 = n3 % 4 == 0 ? 0 : (4 - n3 % 4) * n2;
        this.biSizeImage = n * n2 * 3 + n4;
        this.bfSize = this.biSizeImage + 14 + 40;
        this.biWidth = n;
        this.biHeight = n2;
        return true;
    }

    public void saveBitmap(String string, Image image, int n, int n2) {
        try {
            this.fo = new FileOutputStream(string);
            this.save(image, n, n2);
            this.fo.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void save(Image image, int n, int n2) {
        try {
            this.convertImage(image, n, n2);
            this.writeBitmapFileHeader();
            this.writeBitmapInfoHeader();
            this.writeBitmap();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void writeBitmapFileHeader() {
        try {
            this.fo.write(this.bfType);
            this.fo.write(this.intToDWord(this.bfSize));
            this.fo.write(this.intToWord(this.bfReserved1));
            this.fo.write(this.intToWord(this.bfReserved2));
            this.fo.write(this.intToDWord(this.bfOffBits));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Image loadbitmap(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string + string2);
            return BitmapFile.loadbitmap(fileInputStream);
        }
        catch (Exception exception) {
            System.err.println("Caught exception in loadbitmap!");
            exception.printStackTrace();
            return null;
        }
    }

    public static Image loadbitmap(InputStream inputStream) {
        try {
            Image image;
            int n = 14;
            byte[] byArray = new byte[n];
            inputStream.read(byArray, 0, n);
            int n2 = 40;
            byte[] byArray2 = new byte[n2];
            inputStream.read(byArray2, 0, n2);
            int n3 = (byArray[5] & 0xFF) << 24 | (byArray[4] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[2] & 0xFF;
            int n4 = (byArray2[3] & 0xFF) << 24 | (byArray2[2] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[0] & 0xFF;
            int n5 = (byArray2[7] & 0xFF) << 24 | (byArray2[6] & 0xFF) << 16 | (byArray2[5] & 0xFF) << 8 | byArray2[4] & 0xFF;
            int n6 = (byArray2[11] & 0xFF) << 24 | (byArray2[10] & 0xFF) << 16 | (byArray2[9] & 0xFF) << 8 | byArray2[8] & 0xFF;
            int n7 = (byArray2[13] & 0xFF) << 8 | byArray2[12] & 0xFF;
            int n8 = (byArray2[15] & 0xFF) << 8 | byArray2[14] & 0xFF;
            int n9 = byArray2[19] << 24 | byArray2[18] << 16 | byArray2[17] << 8 | byArray2[16];
            int n10 = (byArray2[23] & 0xFF) << 24 | (byArray2[22] & 0xFF) << 16 | (byArray2[21] & 0xFF) << 8 | byArray2[20] & 0xFF;
            int n11 = (byArray2[27] & 0xFF) << 24 | (byArray2[26] & 0xFF) << 16 | (byArray2[25] & 0xFF) << 8 | byArray2[24] & 0xFF;
            int n12 = (byArray2[31] & 0xFF) << 24 | (byArray2[30] & 0xFF) << 16 | (byArray2[29] & 0xFF) << 8 | byArray2[28] & 0xFF;
            int n13 = (byArray2[35] & 0xFF) << 24 | (byArray2[34] & 0xFF) << 16 | (byArray2[33] & 0xFF) << 8 | byArray2[32] & 0xFF;
            int n14 = (byArray2[39] & 0xFF) << 24 | (byArray2[38] & 0xFF) << 16 | (byArray2[37] & 0xFF) << 8 | byArray2[36] & 0xFF;
            if (n8 == 24) {
                int n15 = n10 / n6 - n5 * 3;
                int[] nArray = new int[n6 * n5];
                byte[] byArray3 = new byte[(n5 + n15) * 3 * n6];
                inputStream.read(byArray3, 0, (n5 + n15) * 3 * n6);
                int n16 = 0;
                int n17 = 0;
                while (n17 < n6) {
                    int n18 = 0;
                    while (n18 < n5) {
                        nArray[n5 * (n6 - n17 - 1) + n18] = 0xFF000000 | (byArray3[n16 + 2] & 0xFF) << 16 | (byArray3[n16 + 1] & 0xFF) << 8 | byArray3[n16] & 0xFF;
                        n16 += 3;
                        ++n18;
                    }
                    n16 += n15;
                    ++n17;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n5, n6, nArray, 0, n5));
            } else if (n8 == 8) {
                int n19 = 0;
                n19 = n13 > 0 ? n13 : 1 << n8;
                if (n10 == 0) {
                    n10 = (n5 * n8 + 31 & 0xFFFFFFE0) >> 3;
                    System.out.println("nsizeimage (backup) is" + (n10 *= n6));
                }
                int[] nArray = new int[n19];
                byte[] byArray4 = new byte[n19 * 4];
                inputStream.read(byArray4, 0, n19 * 4);
                int n20 = 0;
                int n21 = 0;
                while (n21 < n19) {
                    nArray[n21] = 0xFF000000 | (byArray4[n20 + 2] & 0xFF) << 16 | (byArray4[n20 + 1] & 0xFF) << 8 | byArray4[n20] & 0xFF;
                    n20 += 4;
                    ++n21;
                }
                n21 = n10 / n6 - n5;
                int[] nArray2 = new int[n5 * n6];
                byte[] byArray5 = new byte[(n5 + n21) * n6];
                inputStream.read(byArray5, 0, (n5 + n21) * n6);
                n20 = 0;
                int n22 = 0;
                while (n22 < n6) {
                    int n23 = 0;
                    while (n23 < n5) {
                        nArray2[n5 * (n6 - n22 - 1) + n23] = nArray[byArray5[n20] & 0xFF];
                        ++n20;
                        ++n23;
                    }
                    n20 += n21;
                    ++n22;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n5, n6, nArray2, 0, n5));
            } else {
                System.err.println("Not a 24-bit or 8-bit Windows Bitmap, aborting...");
                image = null;
            }
            inputStream.close();
            return image;
        }
        catch (Exception exception) {
            System.err.println("Caught exception in loadbitmap!");
            exception.printStackTrace();
            return null;
        }
    }
}

