/** UtilsForJava.java
*  This program is the interface to C functions in a DLL
*  Usage instructions:
*  Generate the  C header file by: JAVAH -jni UtilsForJava
*  Then copy the function prototypes to the C program, add variable names
*  and include the header.
*/

//package NormsTools;


public class UtilsForJava {

    /** Returns true if the window wName is open, otherwise false;
    */
	public native static boolean windowOpen(String wName);

    /** Returns a list of open windows
    */
    public native static String[] openWindows();

    /** Set focus on window wName
    */
    public native static boolean setFocus(String wName);

    /** Press Left mouse button on window wName
    */
    public native static boolean pressLButton(String wName);

    /** Release Left mouse button on window wName
    */
    public native static boolean releaseLButton(String wName);

    /** Post a message to window wName
    */
    public native static boolean postMessage(String wName, String msg);

    /** Returns a help string
    */
	public native static String  getHelp();

    //---------------------------------------
	/** Load the DLL for the above functions
    */
	static {
		System.loadLibrary("UtilsForJava");
	}
}  // end class UtilsForJava

