// This class implements a simple text display that can
// display lines with different colors.

package NormsTools;

import java.awt.*;
import java.util.*;

public class TtyCanvas extends Component {
    // Vector of current lines.
    Vector lines = new Vector();

    // Vector of new lines.
    Vector newLines = new Vector();
 
    synchronized void append(String s, Color c) {
        newLines.addElement(new TtyLine(s, c));
        repaint();
    }

    public void paint(Graphics g) {
        synchronized (this) {
            // Transfer new lines into lines.
            while (newLines.size() > 0) {
                lines.addElement(newLines.elementAt(0));
                newLines.removeElementAt(0);
            }

            // Keep at most the last 50 lines.
            while (lines.size() > 50) {
                lines.removeElementAt(0);
            }
        }

        FontMetrics fm = g.getFontMetrics();
        int margin = fm.getHeight()/2;
        int w = getSize().width;
        int y = getSize().height-fm.getHeight()-margin;
        
        // Paint all the lines bottom up.
        for (int i=lines.size()-1; i>=0; i--) {
            TtyLine tl = (TtyLine)lines.elementAt(i);
            g.setColor(tl.c);
            g.drawString(tl.s, margin, y+fm.getAscent());
            y -= fm.getHeight();
        }
    } // end paint()

    //---------------------------------------------
    // Following for testing. Comment out when done
    public static void main(String[] args) {
        TestFrame tf = new TestFrame();
        TtyCanvas tty = new TtyCanvas();
        tf.add(tty, BorderLayout.CENTER);
        tf.setSize(400, 300);
        tf.show();

        tty.append(" ----A red line ----------------------1", Color.red);
        tty.append("1        Blue line ---", Color.blue);
        tty.append(" ----A red line ----------------------2", Color.red);
        tty.append("2        Blue line ---", Color.blue);
        tty.append(" ----A red line ----------------------3", Color.red);
        tty.append("3        Blue line ---", Color.blue);
        tty.append(" ----A red line ----------------------4", Color.red);
        tty.append("4        Blue line ---", Color.blue);
    } // end main() */

} // end class

//---------------------------------------------------
// Convenient class to hold a string and its color.
class TtyLine {
    String s;
    Color c;
    TtyLine(String s, Color c) {
        this.s = s;
        this.c = c;
    }
}