//TextPaneData.java - holds text to be displayed in a TextPane

package NormsTools;

import java.awt.*;
import java.awt.event.*;


// class that holds text output controls
public class TextPaneData {
    // Define record types:
    final static int   TextRec = 1,        // Record contains text
                       PosRec = 2;         // Record sets position only
    
    int         recType = 0;
    Rectangle   rect;
    Color       bgColor;
    Color       fgColor;
    Font        theFont;
    String      text;

    String      MOText;         // MouseOver text
    Dimension   MOSize;         // size of MOText
    boolean     showingMOText = false;

    // Constructors
    TextPaneData(String text) {
        recType = TextRec;
        this.text = text;
    }
    TextPaneData(String text, Color bgC, Color fgC) {
        recType = TextRec;
        this.text = text;
        bgColor = bgC;
        fgColor = fgC;
    }
    TextPaneData(String text, Color bgC, Color fgC, String mot) {
        recType = TextRec;
        this.text = text;
        bgColor = bgC;
        fgColor = fgC;
        MOText = mot;
    }
    TextPaneData(Point p) {
        recType = PosRec;
        rect = new Rectangle(p);
    } // end Constructor

    // Accessor methods
    public void setBGColor(Color c) {bgColor = c;}
    public void setFGColor(Color c) {fgColor = c;}
    public void setFont(Font f) {theFont = f;}
    public void setMOText(String s) {MOText = s;}
    public void setLocation(Point p) {
        if (rect == null)
            rect = new Rectangle(p);
        else
            rect.setLocation(p);
    }
} // end class TextPaneData

