//TextPane.java - Display text with color and MouseOver message

// ADD:  Code to find largest Font / Ascent for a line to make a common bottom!
// FIX:  Deletion of PUW on mouseExit  

package NormsTools;

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class TextPane extends Component implements MouseMotionListener {
    final static Color DfltBGColor = Color.white;
    final static Color DfltFGColor = Color.black;

    Vector  theText = new Vector();     // Holds text to be displayed
    Point   currPos = new Point(0,0);   // Points to where output to go

    Dimension   ourSize;
    Insets      ins = new Insets(1, 1, 1, 1);
    Frame       parent;
    PopUpWindow puw;

    final static boolean    debug = false; //true;       // for debug output

    // Constructors ----------------------------------------------
    public TextPane(Frame f) {
        addMouseMotionListener(this);
        parent = f;                     // Save????
        // Trap mouseExited to clear PopUpWindow
        addMouseListener(new MouseAdapter() {
            // NOTE: ???? Why do we get mouseExited???? calls when inside?
            public void mouseExited(MouseEvent me) {
                if (debug)
                    System.out.println("mousXtd at " + me.getX() + "," + me.getY()
                        + "  Bnds:" + getBounds() + " " + puw);
                if (puw != null) {
                    // contains() NOT working??? >> puw masks our mouse listeners
                    // Problem with puw and enter/exit
                    if (!puw.tpd.rect.contains(me.getX(), me.getY())) {
                        clearPUW();
                    }else {
                        if (debug)
                            System.out.println(" >" + puw.tpd.rect + " cntns " 
                                                                + me.getPoint());
                    }
                }
            } // end mouseExited()
            public void mouseEntered(MouseEvent me) {
                if (debug)
                    System.out.println("mouseEntd at " + me.getX() + "," + me.getY()
                        + "  Bnds:" + getBounds() + " " + puw);
            } // end mouseEntered()
        }); 
    } // end Constructors

    private boolean containsIt(Rectangle r, Point p) {
        return ((p.x > r.x && p.x < r.x + r.width)
            && (p.y > r.y && p.y < r.y + r.height));
    }

    // Clear current PopUp Window
    private void clearPUW() {
        if (puw != null) {
            puw.tpd.showingMOText = false;   // reset
            puw.dispose();      // get rid of old versions
            puw = null;
        }
    } // end clearPUW()

    //--------------------------------------------------------------------------
    // Set the text. Remove old and add new
    public TextPaneData setText(String text) {
        return setText(text, DfltBGColor, DfltFGColor, null);
    }
    public TextPaneData setText(String text, Color bgC, Color fgC, String mot) {
        clearPUW();                     // Remove leftovers
        theText.removeAllElements();
        return addText(text, bgC, fgC, mot);
    }

    // Add a text data item to the list
    public TextPaneData addText(String text) {
        return addText(text, DfltBGColor, DfltFGColor, null);
    }
    public TextPaneData addText(String text, Color bgC, Color fgC) {
        return addText(text, bgC, fgC, null);
    }
    public TextPaneData addText(String text, Color bgC, Color fgC, String mot) {    
        TextPaneData tp = new TextPaneData(text, bgC, fgC, mot);
        theText.addElement(tp);
        return tp;
    }
    public TextPaneData addText(TextPaneData tp) {
        theText.addElement(tp);
        return tp;
    }

    public void clearText() {
        theText.removeAllElements();
    }

    //------------------------------------------------------------
    // Display the text and compute ourSize
    public void paint(Graphics g) {
//        FontMetrics fm = g.getFontMetrics();
        int maxAscent = g.getFontMetrics().getAscent();
        int maxHeight = g.getFontMetrics().getHeight();

        if (ourSize != null && getBackground() != Color.white) {
            g.setColor(getBackground());
            g.fillRect(0, 0, ourSize.width, ourSize.height);
        }
        // Reset currPos for start of new line
        currPos.setLocation(ins.top, ins.left);

        // ADD CODE to copy/clone theText to prevent collisions?

        // Find maxAscent & maxHeight - to put all text on same base
        for (int i=0; i < theText.size(); i++ ) {
            TextPaneData tp = (TextPaneData)theText.elementAt(i);
            if(tp.theFont == null) {    // Make sure its set
                tp.theFont = getFont();
            }
            FontMetrics fm = g.getFontMetrics(tp.theFont);
            if (fm.getAscent() > maxAscent) {
                maxAscent = fm.getAscent();         // save largest
                maxHeight = fm.getHeight();         // ASSUME also biggest??
            }
        } // end finding maxAscent

        // Paint all the text, bit by bit.
        for (int i=0; i < theText.size(); i++) {
            TextPaneData tp = (TextPaneData)theText.elementAt(i);
            // First time, fill in the null fields:
            g.setFont(tp.theFont);
            FontMetrics fm = g.getFontMetrics();
            // Compute y value adjustment for case of different heights
            int yAdj = maxHeight - fm.getHeight();

            if(tp.MOText != null) {
                tp.MOSize = new Dimension(fm.stringWidth(tp.MOText)+6, 
                                                        fm.getAscent()+6);
            }
            if(tp.rect == null) {
                // Define location and size of text's rectangle
                tp.rect = new Rectangle(currPos.x, currPos.y,
                                        fm.stringWidth(tp.text),
                                        fm.getHeight());
                if (debug)
                    System.out.println(tp.MOText + " rect=" + tp.rect);
            }

            if (tp.recType == TextPaneData.PosRec) {
                // If only to position, set new position and move on
                currPos.x = tp.rect.x;
                currPos.y = tp.rect.y;
                continue;               // Done, go to next element
            }

            // Now build the display
            if (tp.bgColor != null) {
                g.setColor(tp.bgColor);
                g.fillRect(currPos.x, currPos.y+yAdj, tp.rect.width, tp.rect.height);
            }
            if (tp.fgColor != null) {
                g.setColor(tp.fgColor);
            }
            // Now put out the text
            g.drawString(tp.text, tp.rect.x, tp.rect.y+maxAscent);

            // Advance currPos.x
            currPos.x += fm.stringWidth(tp.text);
        } // end processing TextPaneData elements

        if (ourSize == null) { 
            ourSize = new Dimension(currPos.x + ins.left + ins.right,
                                    maxHeight + ins.top + ins.bottom);
            if (debug)
                System.out.println("ourSize " + ourSize + ",  Bnds=" + getBounds());
            // NB> setSize() calls invalidate() see stackDump below!!!????
//            setSize(ourSize);
        }
    } // end paint()

    public void update(Graphics g) {
        paint(g);
    }

    public Dimension getMinimumSize() {
        // Need to compute the height and width needed for text!
//        System.out.println("getMinimumSize() " + ourSize);
        if(ourSize == null) {
            addNotify();        // Get our peer so we can get Graphics!
            Graphics g = getGraphics();
            paint(g);                   // Go display and compute ourSize
        }
        return ourSize;
    }
    public Dimension getPreferredSize() {
//        System.out.println("getPreferredSize() " + ourSize);
        return getMinimumSize();
    }

    // This one NOT called!
    public boolean contains(Point p) {
        System.out.println("Contains Point=" + p);
        return super.contains(p);
    }
    // This is the ONE!
    public boolean containsXXXX(int x, int y) {
        System.out.println("Contains x=" + x + ", y=" + y 
                        + "? " + super.contains(x,y));
        return super.contains(x, y);  // <<<<<<  RECODE ????
    }

    public void invalidate() {
        ourSize = null;                 // Clear
        super.invalidate();
    }
/* from stackDump in invalidate()
Invalidate
java.lang.Exception: Stack trace
	at java.lang.Thread.dumpStack(Unknown Source)
	at NormsTools.TextPane.invalidate(TextPane.java)
	at java.awt.Component.reshape(Unknown Source)
	at java.awt.Component.setBounds(Unknown Source)
	at java.awt.Component.resize(Unknown Source)
	at java.awt.Component.setSize(Unknown Source)
	at java.awt.Component.resize(Unknown Source)
	at java.awt.Component.setSize(Unknown Source)
	at NormsTools.TextPane.paint(TextPane.java)
	at NormsTools.TextPane.getMinimumSize(TextPane.java)
	at NormsTools.TextPane.getPreferredSize(TextPane.java)
	at java.awt.GridLayout.preferredLayoutSize(Unknown Source)
	at java.awt.Container.preferredSize(Unknown Source)
	at java.awt.Container.getPreferredSize(Unknown Source)
	at java.awt.Window.pack(Unknown Source)
	at NormsTools.TextPane.main(TextPane.java)
java.lang.NullPointerException
	at java.awt.GridLayout.preferredLayoutSize(Unknown Source)
	at java.awt.Container.preferredSize(Unknown Source)
	at java.awt.Container.getPreferredSize(Unknown Source)
	at java.awt.Window.pack(Unknown Source)
	at NormsTools.TextPane.main(TextPane.java)

0 error(s)
*/
    public void setInsets(Insets in) {
        ins = in;
    }
    public Insets getInsets() {
        return ins;
    }

    //--------------------------------------------------------
    // Handle mouse motions:
    // Add PopUp when mouse over rect that has MOText
    public void mouseMoved(MouseEvent me) {
        // Find which block of text it's over by looking at TextPaneData rects
        for(int i = 0; i < theText.size(); i++) {
            TextPaneData tp = (TextPaneData)theText.elementAt(i);
            if (tp.rect != null && tp.MOText != null) {
                if (tp.rect.contains(me.getPoint())) {
                    if (debug && false)
                        System.out.println(">> " + tp.MOText + " me=" + me.getX()
                                        + "," + me.getY());
                    // Don't move with the mouse if currently being shown
                    if (!tp.showingMOText) {
                        if (puw != null && puw.tpd != tp) {
                            clearPUW();     // Clear old one
                        }
                        Rectangle bnds = getBounds();
                        Point pp = parent.getLocation();
                        if (debug)
                            System.out.println(" bnds=" + bnds + ", p.loc=" + pp
                                     + ", me=" + me.getX() + "," + me.getY());
                        puw = new PopUpWindow(parent, tp.MOText, tp);
                        // Position the puw at ????
                        puw.setBounds(pp.x+bnds.x+me.getX(), 
                                      pp.y+bnds.y+me.getY()+20, // +20 avoid masking
                                      tp.MOSize.width, tp.MOSize.height);
                        puw.show();
                        tp.showingMOText = true;        // Remember its being shown
                        return;
                    }else {
                        return;
                    }
                }  // mouse in rect
            }  // has rect defined and MOText
        }  
        // Clear if not needed
//        System.out.println("Clearing puw2 " + puw);
        clearPUW();
    } // end mouseMoved()

    public void mouseDragged(MouseEvent me) {
    }

    //*****************************************************
    // Class to show small message in own window
    private class PopUpWindow extends Window {
        String          msg;
        TextPaneData    tpd;

        // Constructor
        PopUpWindow(Frame f, String text, TextPaneData tpd) {
            super(f);
            setBackground(Color.yellow);
            msg = text;                 // Save
            this.tpd = tpd;             // Save origin of msg
            // Ignore Mouse -> These mouse Listeners MASK those of the TextPane!!!
            addMouseMotionListener(new MouseMotionAdapter() {
                public void mouseMoved() {
                } 
            });
            addMouseListener(new MouseAdapter() {
                public void mouseExited() {
                }
            });
        } // end Constructor
    
        // Show the MouseOver text in our window
        public void paint(Graphics g) {
            FontMetrics fm = g.getFontMetrics();
            g.drawString(msg, (getSize().width-fm.stringWidth(msg))/2,
                        (getSize().height-fm.getHeight())/2 
                          + fm.getAscent());
        } // end paint()
      } // end class PopUpWindow

    //--------------------------------------------------------------------------
	// Following for testing. Comment out when done!
/*	public static void main(String[] args) {
        TestFrame tf = new TestFrame("Testing TextPane");
        tf.setLayout(new GridLayout(2, 1));

        TextPane tp = new TextPane(tf);
        tp.setFont(new Font("Monospaced", Font.PLAIN, 14));
        tp.setBackground(Color.darkGray);  // Border color!
        tp.addText("The first texty", Color.cyan, Color.black, "CYAN TEXT");
        tp.addText(" The next textg", Color.red, Color.black);
        TextPaneData tx = new TextPaneData(" The last textp", Color.green, Color.black);
        tx.setMOText("Mouse Over Green Text");
        tx.setFont(new Font("Monospaced", Font.PLAIN, 20));
        tp.addText(tx);
        tf.add(tp);

        TextPane tp2 = new TextPane(tf);
        TextPaneData tpd = tp2.addText("The first texty", Color.gray, Color.black);
        tpd.setMOText("Mouse Over Gray Text");
        tp2.addText("The next text", Color.yellow, Color.black);
        tp2.addText("The last textp", Color.magenta, Color.black);
        tf.add(tp2);

        tf.pack();
        tf.show();

        tf.list(System.out);            // Show components in this container
	} // end main() */
} // end class TextPane

