//StackX.java - Extend Stack for some primitive types
// and for casting some Common types

package NormsTools;

import java.util.Stack;
import java.awt.*;

public class StackX extends Stack {

	// For booleans
	public void push(boolean b) {
	   push(new Boolean(b));
	}

    public boolean popBoolean() {
        Boolean b = (Boolean)pop();
        return b.booleanValue();
    }
    
    // for bytes
    public void push(byte b) {
        push(new Byte(b));
    }
    public byte popByte() {
        Byte b = (Byte)pop();
        return b.byteValue();
    }

    // for char
    public void push(char c) {
        push(new Character(c));
    }
    public char popChar() {
        Character c = (Character)pop();
        return c.charValue();
    }

    // For ints
    public void push(int i) {
        push(new Integer(i));
    }
    public int popInt() {
        Integer i = (Integer)pop();
        return i.intValue();
    }

    // For String
    public String popString() {
        return (String)pop();
    }
    // For Color
    public Color popColor() {
        return (Color)pop();
    }
    // For FONT
    public Font popFont() {
        return (Font)pop();
    }
}  // end class StackX