// Sorter.java
// added code to setStrength() 5/16/2000

package NormsTools;  // = name of subdirectory containing this file

import java.text.Collator;
import java.text.CollationKey;
import java.util.Locale;
import java.util.Vector;

/** Sort  utility
*/
public class Sorter {
  
  public static interface Comparer {
    /**
     * if (a>b) return >0
     * if (a==b)return 0
     * if (a<b) return <0
    **/
    public int compare(Object a, Object b);
  }
  
  public static interface Comparable {
    
    public int compareTo(Object other);
  }
  
  public static Comparer ascii_comparer = new Comparer() {
    public int compare(Object a, Object b) {
      return ((String)a).compareTo((String)b);        
    }
  };    
  
  public static Comparer comparable_comparer = new Comparer() {
    public int compare(Object a, Object b) {
      return ((Comparable)a).compareTo(b);
    }
  };
  
  public static void sortAscii(String[] a, int from, int to, boolean up) {
    sort(a, null, from, to, up, ascii_comparer);
  }
  
  
  //------------------------------------------------------------------
  /** Sort a Vector of strings into ascending order
  *  @param  Vector of strings
  */
  public static void sort(Vector v) {
    String[] vs = new String[v.size()];
    v.copyInto((Object[])vs);
    sort(vs, 0, vs.length-1, true, false, null);
    // now replace elements in the vector
    for(int i =0; i < v.size(); i++)
        v.setElementAt(vs[i], i);
  }

  /** Sort an array of strings into ascending ording, using the
  * correct collation order for the default locale
  *   @param String array
  */
  public static void sort(String[] a) {
//    System.out.println("Sorting");
    sort(a, 0, a.length-1, true, false, null);
  }

  // sort a portion of an array  
/*  public static void sort(String[] a, int from, int to, boolean up, 
                             boolean ignorecase) {
    sort(a, from, to, ignorecase, null);
  }
*/
  //********************************************************************  
  public static void sort(String[] a, int from, int to,
                          boolean up, boolean ignorecase, 
                          Locale locale) {
    if((a==null) || (a.length < 2)) return;                          
  
    Collator c;
    if(locale==null) c = Collator.getInstance();
    else c = Collator.getInstance(locale);
  
    // Specify whether or not case
    try {
        c.setStrength(Collator.IDENTICAL);      // added 5/16/2000 NCR
    }catch(IllegalArgumentException iae) {
        c.setStrength(Collator.TERTIARY);  // for JVIEW or jdk < 1.1.6
    }
    if (ignorecase) c.setStrength(Collator.SECONDARY);
  
    // Use Collator object
    CollationKey[] b = new CollationKey[a.length];
    for(int i = 0; i < a.length; i++) b[i] = c.getCollationKey(a[i]);
  
    // Now define a Comparer object
    Comparer comp = new Comparer() {
      public int compare(Object a, Object b) {
        return((CollationKey)a).compareTo((CollationKey)b);
      }
    };
  
    // Finally, sort the array
    sort(b, a, from, to, up, comp);
  }   
  
  
  /** Main sort routine:
  */
  public static void sort(Object[] a, Object[] b,
                          int from, int to,
                          boolean up, Comparer c) {
    if ((a==null) || (a.length < 2)) return;
  
    // The basic quicksort
    int i = from, j = to;
    Object center = a[(from + to)/2];
    do {
      if(up) { // ascending sort
        while((i < to) && (c.compare(center, a[i]) > 0)) i++;
        while((j > from) && (c.compare(center, a[j]) < 0)) j--;
      } else { // a descending sort
        // ADD CODE HERE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
      }
      if (i < j) {
        Object tmp = a[i]; a[i] = a[j]; a[j] = tmp;  // swap i & j elements
        if (b != null) {tmp = b[i]; b[i] = b[j]; b[j] = tmp;}
      }
      if (i<=j) { i++; j--;}
    } while(i <= j);
    
    if (from < j) sort(a, b, from, j, up, c);  // recursively sort the rest
    if (i < to) sort(a, b, i, to, up, c);       
  }  // end main sort routine                      
  
} // end class Sorter  
                                   
              
