//ShowOptions.java

package NormsTools;

import java.awt.*;
import java.awt.event.*;

//------------------------------------------------------------------------
/** Define class to display Checkboxes for user to select from. <BR>
* Settings of Checkboxes are saved on entry and restored if Dialog
* window is closed.
*/
public class ShowOptions extends Dialog implements Runnable {
boolean   done = false;           // controls thread keeping toFront

Checkbox[]    cbs;
boolean[]     cbStates;               // Save incoming checkbox states

Button doneB = new Button("Done");

//--- Constructor-------------------------------------
/** Constructor - 
*   @param Checkbox[] - array of checkboxes to be displayed
*   @param String - title for Dialog Window
*/
public ShowOptions(Frame f, Checkbox[] cbsP, String title){
   super(f, title, true);
   this.cbs = cbsP;
   setBackground(new Color(180, 180, 200));

   // Save current states incase of cancel
   cbStates = new boolean[cbs.length];
   for(int i = 0; i < cbs.length; i++)
      cbStates[i] = cbs[i].getState();

   setLayout(new GridLayout(cbs.length+2, 1));
   add(new Label("Select from following options:"));
   // add Checkboxes
   for(int i = 0; i < cbs.length; i++)
      add(cbs[i]);
   Panel p = new Panel();         // for nicer formating
   p.add(doneB);
   add(p);
   doneB.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent ae) {
          exitPgm();
      }
   });

   // Trap window closing event
   addWindowListener(new WindowAdapter() {
      public void windowClosing(WindowEvent we) {
          // restore states of buttons:
          for(int i = 0; i < cbs.length; i++)
             cbs[i].setState(cbStates[i]);
          exitPgm();
      }
   });
   setLocation(300, 150);
   setSize(300, 100);
   pack();
   (new Thread(this)).start();     // start toFront() calls on thread
   show();
} // end Constructor

private void exitPgm() {
  setVisible(false);
  dispose();
  done = true;            // tell thread
}

//---------------------------------------------------------------------------------------------
// Trap checkbox being selected
public void itemStateChanged(ItemEvent ie) { // ????
  System.out.println("itemStateChanged for " + ie);
} // end itemStateChanged()

//-------------------------------------
// Keep the dialog window on top!
public void run() {
  while (true) {  // forever loop
      try {
          if (done)  return;      // exit if done
          toFront();
          Thread.sleep(500);
      }catch(Exception ex){
          ex.printStackTrace();
      }
  }  // end forever loop
}  // end run()

}  // end class ShowOptions
