// ShowMsgBox.java
// Display a message in a Dialog box
// See Class Libraries Vol II page 511 for code to center in window
// 5/29/01 - Use WindowListener to keep on top

// Changes:
//    21Oct01 - Limit toFront() calls

package NormsTools;  // = name of subdirectory containing this file

import java.util.*;
import java.awt.*;
import java.awt.event.*;

final public class ShowMsgBox extends Dialog implements ActionListener { //, Runnable {

  final static boolean    testing = false;     // control debug output
  final int    MAX4LABEL = 50;         // Max String length for Label

  boolean   done = false;               // Controls thread keeping toFront()
  private int  toFrontCnt = 3;          // Only do it this many times
                                        
  int   prfdWidth = -1;                 // User's preferred width

  // Constructors -----------------------------------------------------
  public ShowMsgBox(Frame f, String text) {
    super(f, true);
    finishIt(text);
  }
  public ShowMsgBox(Frame f, String title, String text) {
    super(f, title, true);
    finishIt(text);
  }
  public ShowMsgBox(String title, String text, Frame parent, boolean modal) {
    super(parent, title, modal);
    finishIt(text);
  }
  public ShowMsgBox(String title, String text, Frame parent, boolean modal,
                            int prfdWidth) {
    super(parent, title, modal);
    this.prfdWidth = prfdWidth;         // Save
    finishIt(text);
  }
  // end of Constructors
   
  // Common routine for Constructors
  private void finishIt(String text) {
    Component lbl = null;
    // Use Label if short and no newlines
    if (text.length() < MAX4LABEL && text.indexOf("\n") < 0) {
      lbl = new Label(text);
    }else {
      lbl = new MessageArea(text);  // This one will wrap text
       if (testing) {
           ((MessageArea)lbl).setTesting(testing);
           System.out.println("the MA.size= " + lbl.getSize());
       }
    }
    super.setResizable(true);         // for testing with MessageArea
    add(lbl, BorderLayout.NORTH);

    Panel p = new Panel();
    Button b = new Button("  Ok  ");
    p.add(b);
    b.addActionListener(this);
    b.addKeyListener(new MakeEnterDoAction());  // Catch Enter pressed
    b.requestFocus();                   // Set the default here

    // Trap window closing and get rid of our stuff
    addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent we) {
            done = true;                // tell thread  
            setVisible(false);
            dispose();
        }
        // Keep our window on top
        public void windowDeactivated(WindowEvent we) {
//            System.out.println("Deactivated " + done + " " + toFrontCnt);
            if (!done) {
                if(toFrontCnt-- > 0) {
//                  System.out.println("toFront");
                  toFront();           // No effect when run from main() below???
                }
            }
        }
    });
    add(p, BorderLayout.SOUTH);
    if (prfdWidth > 0)
        lbl.setSize(prfdWidth, 50);        // set if given
//    System.out.println("SMB size before pack = " + getSize());
    pack();
//    System.out.println("SMB size after pack = " + getSize());

    // Center frame
    Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation((ss.width-getBounds().width)/2, 
                (ss.height-getBounds().height)/2);  

//;    Thread t = new Thread(this);
//    t.setDaemon(true);
//    t.start();     // start toFront() calls on thread
    if (testing) {
        System.out.println("Our size= " + getSize());
    }
    show();
  }  // end constructor

  //--------------------------------------------------------------
  // OK button pressed
  public void actionPerformed(ActionEvent ae) {
    if (testing)
        System.out.println("SMB: exiting");
    done = true;                // tell thread  
    setVisible(false);
    dispose();
  }
  // Allow Change toFront count
  public void setToFrontCnt(int cnt) {
   toFrontCnt = cnt;
  }

  // Keep the dialog window on top!
/*  public void run() {
    while (true) {  // forever loop
        try {
            if (done)  return;          // exit if done
            toFront();
            if (testing)
                System.out.println("SMB: toFront()");
            Thread.sleep(300);
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }  // end forever loop
  }  // end run()  */

  //----------------------------------------------------------
  // Following for testing only  Comment out when done
/*  public static void main(String[] args) {
    new ShowMsgBox("Title", "A Message", new Frame(), true);
    Frame f = new Frame("Test ShowMsgBox"); // For different effect???
    f.setSize(200, 50);
    f.show();
    new ShowMsgBox("Title", "A Message that should be longer than one line " 
                            + "and that will cause wrapping", f, true);
    new ShowMsgBox("Title", "A Message that should be longer than one line\n " 
                            + "and that will cause wrapping. Len=300",
                            f, true, 300);
    f.dispose();
    System.exit(0);
  } // end main() */
}  // end class ShowMsgBox

