// ShowListBox.java
/** Display a message in a Dialog box
* See Class Libraries Vol II page 511 for code to center in window

* New features to add:
*  Display Only option - no choices
*  Change size of List to fit strings being displayed???

5/29/01 - Moved toFront() to windowListener vs in thread
*/

package NormsTools;  // = name of subdirectory containing this file

import java.util.*;
import java.awt.List;
import java.awt.*;
import java.awt.event.*;

public class ShowListBox extends Dialog implements ActionListener, ItemListener { 
                                                    //, Runnable {

  boolean   done = false;               // Controls thread that does toFront()


  Button    okB = new Button("  OK  ");
  Button    cancelB = new Button(" Cancel ");
  Button    doneB = new Button("Done");

  String    selectedItem = "";
  List      list;

  Dimension  ourSize;

  boolean readOnly = false;             // To display non-selectable list

  final static boolean  debug = false;      // control debug output

  // Constructors ----------------------------------------------------------
  public ShowListBox(String title, Enumeration en, int sz, Frame parent) {
    super(parent, title, true);
    
    // Get Vector from Enumeration and sort it to String[]
    Vector v = new Vector();
    while(en.hasMoreElements())
        v.addElement(en.nextElement());

    String[] list = new String[v.size()];
    int ix = 0;                         // index to store next smallest item
    while(v.size() > 0) {
        int lwst = 0;                   // reset index to lowest value in v
        for(int i = 1; i < v.size(); i++) {
            if(((String)v.elementAt(lwst)).compareTo((String)v.elementAt(i)) > 0)
                lwst = i;               // Found new lowest
        }
        list[ix++] = (String)v.elementAt(lwst);
        v.removeElementAt(lwst);
    } // end sorting

    buildList(list ,sz);                    // Go to common routine
  }

  public ShowListBox(String title, String[] list, int sz, Frame parent) {
    super(parent, title, true);
    buildList(list, sz);                    // Go to common routine
  }
  public ShowListBox(String title, String[] list, int sz, Frame parent,
                                boolean rdOnly) {
    super(parent, title, !rdOnly);
    readOnly = rdOnly;                  // Save setting
    buildList(list, sz);                    // Go to common routine
  } // end Constructors ---------------------------------------------------

  // Common routine to do the work
  private void buildList(String[] strs, int sz) {
    Label lbl = null;
    if (readOnly) {
    }else { 
        lbl = new Label("Select an item and press OK");
//        MessageArea lbl = new MessageArea("Select item and press OK");

        super.setResizable(true);         // for testing with MessageArea
        add(lbl, BorderLayout.NORTH);
    } 
    // Need a Graphics object to compute the length of longest string
    addNotify();
    Graphics g = getGraphics();
    FontMetrics fm = g.getFontMetrics();
    int longest = 150;                  // Set a default???

    // Now build the list in the center panel
    Panel pC = new Panel();
    list = new List(Math.min(sz, strs.length), false) {
        // Override some methods to control size of list
        public Dimension getMinimumSize() {
            Dimension md = super.getMinimumSize();
            if (debug)
                System.out.println("ms = " + md + "  rSize=" + ourSize);
            if (md.height > ourSize.height) {
                ourSize = new Dimension(ourSize.width, md.height);
            }
            return ourSize;
        }    
        public Dimension getPreferredSize() {
            return getMinimumSize();
        }
    }; // */
    // Copy strings to list
    for(int i=0; i < strs.length; i++) {
        int l = fm.stringWidth(strs[i]);
        if (l > longest)
            longest = l;
        list.add(strs[i]);
    }
    list.addItemListener(this);

    // Make sure list is big enough to see
    int h = list.getSize().height;
    if (strs.length < 3) {
        h = 40;
    }
    ourSize = new Dimension(longest+6, h+6);
    list.setSize(ourSize);      // ????
    if (debug)
        System.out.println("list size=" + list.getSize() + " rSize=" + ourSize);

    pC.add(list);
    add(pC, BorderLayout.CENTER);

    // Build the Button panel
    Panel pS = new Panel();
    if (readOnly) {
        doneB.addActionListener(this);
        pS.add(doneB);
    }else {
        pS.add(okB);
        okB.addActionListener(this);
        okB.addKeyListener(new MakeEnterDoAction());
        okB.setEnabled(false);                // Not until something selected
        cancelB.addActionListener(this);
        pS.add(cancelB);
    }
    add(pS, BorderLayout.SOUTH);

    // Trap resizing
    addComponentListener(new ComponentAdapter() {
        public void componentResized(ComponentEvent ce) {
            if (debug) {
                System.out.println("Resized " + ce);
                System.out.println("New size= " + getSize() 
                                        + " listSize= " + list.getSize());
            }
            // How large to make it???
            list.setSize(list.getSize().width+20, list.getSize().height+20);
            list.invalidate();
            validate();
        }
    });

    addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent we) {
            if (debug)
                System.out.println("windowClosing");
            setVisible(false);
            done = true;                // tell thread  
            ShowListBox.this.dispose();
        }
        // Keep our window on top if still going and not ReadOnly
        public void windowDeactivated(WindowEvent we) {
            if (debug)
                System.out.println("windowDeactivated");
            if (!done && !readOnly)
                toFront();
        }
    });
    pack();
    if (debug)
        System.out.println("size after pack " + getSize());

    // Center frame
    Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
    setLocation((ss.width-getBounds().width)/2, 
                (ss.height-getBounds().height)/2);  

//    Thread t = new Thread(this);
//    t.setDaemon(true);
//    t.start();     // start toFront() calls on thread
    show();
  }  // end constructor

  //---------------------------------------------
  // Trap selection of a list item
  public void itemStateChanged(ItemEvent ie) {
    // Get selected item
    List l = (List)ie.getSource();
    selectedItem = l.getSelectedItem();     // Save for caller to retrieve
    okB.setEnabled(true);
    okB.requestFocus();     // will this trap Enter???
  }

  //----------------------------------------------------------
  // OK button pressed
  public void actionPerformed(ActionEvent ae) {
    Object src = ae.getSource();
    if (src == okB || src == cancelB || src == doneB) {
        if (debug)
            System.out.println("Btn pressed " + src);
        setVisible(false);
        done = true;                // tell thread  
        dispose();
        if (src == cancelB)
            selectedItem = "";      // clear

    }else {
        System.err.println("ShowListBox() unknown obj:" + src);
    }
  } // end actionPerformed()

  //----------------------------------------------------------
  // Here caller can get selected item
  public String getSelection() {
    return selectedItem;
  }

  //----------------------------------------------------------
  /** Keep the dialog window on top!
  */
/*  public void run() {
    while (true) {  // forever loop
        try {
            if (done)  return;          // exit if done
            toFront();
            Thread.sleep(300);
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }  // end forever loop
  }  // end run() */

  //----------------------------------------------------------
  // Following for testing only - Comment out when done
/*  public static void main(String[] args) {
    TestFrame f = new TestFrame();
    f.show();
    Vector v = new Vector();
    v.addElement("THird on is a long one that should cause ??? to happen");
    v.addElement("SECOND");
    v.addElement("AaTh");
    v.addElement("ZZth");
    v.addElement("FIRST");
    //Blocks waiting for user
    ShowListBox slb = new ShowListBox("Select a number", v.elements(), 5, f);
//                                    new Frame());
    System.out.println("Selected >" + slb.getSelection() + "<");

    // Second slb closes by itself because of System.exit(0)!
    // Now with String[] and ReadOnly -> nothing returned/Doesn't block on user!
    String[] aList = new String[v.size()];
    v.copyInto((Object[])aList);
    slb = new  ShowListBox("Read only list", aList, 10, f, true);
  } // end main() */
}  // end class ShowListBox

