//ShowClassInfo.java - Use Reflection to display class information

import java.lang.reflect.*;

public final class ShowClassInfo {

   private final static String JAVA_LANG = "java.lang.";  // for stripping path

   static boolean getAll = false; //true;

   // Show some details for the object passed as an arg
	public static void showClassInfo(Object obj) {
      Class c = null;
      // Were we passed a Class object?
      if (obj instanceof Class)
         c = (Class)obj;               // Ok use it
      else 
         c = obj.getClass();           //Get it if not

      String nm = c.getName();

      int m = c.getModifiers();
      String mods = Modifier.toString(m);
      // class java.util.Vector$1 implements java.util.Enumeration

      String type = " class ";
      if (c.isInterface())
         type = " interface ";

      // Extends ??
      Class sc = c.getSuperclass();
      String supNm = sc.getName();

      // Implements??
      Class[] imps = c.getInterfaces();
      String impsNm = (imps.length > 0 ? " implements " : "");
      for (int i=0; i < imps.length; i++) {
         impsNm += stripJavaLang(imps[i].getName()) 
                     + (i+1 < imps.length ? ", " : "");
      }

      // Show what we have found for the class 
		System.out.println(mods + type + nm 
            + (supNm.endsWith(".Object") ? "" : " extends " + supNm)
            + impsNm);

      // Now show all the constructors:
      Constructor[] cons = c.getDeclaredConstructors();
      for(int i=0; i < cons.length; i++) {
         System.out.println("  " + cons[i].toString());
      }
      if (cons.length > 0)
         System.out.println("");       // Blank line after Constructors

      // FinallyShow the methods; public first, then private
      // NB - Add code to sort by name
      Method[] theMethods = null;
      if (getAll) {
         theMethods = c.getMethods();  // Every accessible public method
      }else {
         theMethods = c.getDeclaredMethods();  // Only in this class
      }
      // Place to hold private methods
      String[] privs = new String[theMethods.length];
      int privCnt = 0;

      for(int i=0; i < theMethods.length; i++) {
         Class[] parms = theMethods[i].getParameterTypes();
         int modM = theMethods[i].getModifiers();
         String parmNms = "(";         //Start with leading paran

         for(int j=0; j < parms.length; j++) {
            String thisP = parms[j].getName();
//           [Ljava.lang.Object;
            // NB: Single dim only!!!
            if (thisP.startsWith("[")) {
               if(thisP.startsWith("[L") && thisP.endsWith(";"))
                  thisP = thisP.substring(2, thisP.length()-1) + "[]";
               else
                  thisP = thisP.substring(1) + "[]";
            }
            parmNms += stripJavaLang(thisP) + (j+1 < parms.length ? ", " : "");
         }
         parmNms += ")";               // Add on closing paran
         String outLine = "  " + Modifier.toString(modM) 
                        + " " + stripJavaLang(theMethods[i].getReturnType().getName().toString())
                        + " " + theMethods[i].getName()
                        + parmNms;
         if (outLine.indexOf(" private ") > 0)
            privs[privCnt++] = outLine;      // save
         else
            System.out.println(outLine);
      }  // end theMethods

      // Output private methods (if any)
      for(int i =0; i < privCnt; i++) {
         System.out.println(privs[i]);
      }
	} // end showClassInfo()
   // Strip java.lang. from front of name
   private static String stripJavaLang(String s) {
      if (s.startsWith(JAVA_LANG)) {
         s = s.substring(JAVA_LANG.length());
      }
      return s;
   }

   //--------------------------------------------------------
	// For testing. Comment out when done
	public static void main(String[] args) {
      Object obj = null;
      if (args.length > 0 ) {
         try {
            // Only works for default Constructor!!! ie. no args
            obj = Class.forName(args[0]); //.newInstance(); 
         }catch(Exception ex) {
            System.err.println(ex);
            System.exit(1);
         }
      }else {
         java.util.Vector v = new java.util.Vector();
         obj = v.elements();
      }

      ShowClassInfo.showClassInfo(obj);
      System.exit(0);
	} // end main() */

} // end class ShowClassInfo
