// RenameFiles.java
// Rename files that IE5/Win95 named with [1]

import java.io.*;
import java.util.*;

/** Rename files with [1] in filename by removing the [1].<BR>
* Those files are created by IE5 Saving a Favorite for Offline viewing.<BR>
*  Usage: java RenameFiles directory
*/
public class RenameFiles {
    final static int MAX_DEPTH = 2;
    int   depth = 0;

    public RenameFiles(String[] args) {
        File dir = new File(args[0]);
        if (!dir.isDirectory()) usage(args[0] + " not directory");

        String endS = (args[0].endsWith("\\") ? "" : "\\");
        doDirectory(args[0] + endS);
    }

    //------------------------------------
    // Process files in this directory
    void doDirectory(String dirNM) {
//        System.out.println("doDir: " + dirNM);
        if (depth > MAX_DEPTH) {
            System.out.println("Depth exceeded: Skipping " + dirNM + " " + depth);
            return;           // exit if at max
        }

        File dir = new File(dirNM);
        String[] files = dir.list();
        if (files == null) {
            System.out.println("No files in " + dirNM + " " + dir.getAbsolutePath());
            return;
        }

        depth++;

        // Process files in this directory
        for (int i = 0; i < files.length; i++) {

            // Get next item this directory
            File f = new File(dirNM + files[i]);
            if (f.isDirectory()) {
                doDirectory(dirNM +files[i] + "\\");

            }else if(f.exists()) {
//                System.out.println("Got file " + f + "   " + f.exists() + " " 
//                                    + f.canRead() + " " + f.length());
                int idxLB = files[i].indexOf('[');
                int idxRB = files[i].indexOf(']');
                if (idxLB > 0 && idxRB > idxLB) {
                    String newNM = files[i].substring(0, idxLB) 
                                        + files[i].substring(idxRB+1);
                    File newF = new File(dirNM + newNM);
                    if (newF.exists()) {
                        System.err.println("File exists: " + newF);
                    }else {
                        System.out.println("Renaming " + files[i] + " to " + newNM
                            + " " + f.renameTo(newF));
//                       System.exit(0);
                    }
                     

                }else if (files[i].indexOf('[') > 0) {
                    System.out.println("Has left bracket: " + f);
                }

            } else {
                System.out.println(">*>*>*>* Error with file: " + f);
            }
        } // end for(i)

        depth--;
    }  // end doDirectory()
  

    //----------------------------------------------------------
	public static void main(String[] args) {
        if (args.length < 1) usage("Missing directory name");
        new RenameFiles(args);

	} // end main()

    static void usage(String msg) {
        System.out.println("Usage: java RenameFiles directory");
        if (!msg.equals(""))
            System.out.println(" Error: " + msg);
        System.exit(1);
    }
}