// PropsUtil.java
// Defines class for getting and setting Properties file.
// User program will define an Object[] containing pairs: 
//    propname, propvalue
// where  propname is the property name  
//        propvalue is the name of the variable(a String) to get/hold value

// Following 2 code sections must be copied and pasted into user's program:
/*
    //Beginning PropsUtil code part1------------------------------------                      
    // Define PropsUtilUser interface callback methods.
    // NB. Class must implement PropsUtilUser interface
    // These are here to prevent IllegalAccessExceptions!
	public String getString(java.lang.reflect.Field f) 
                                        throws IllegalAccessException {
        return (String)f.get(this);}
	public void   setString(java.lang.reflect.Field f, String val) 
                                        throws IllegalAccessException{
        f.set(this, val);}
    //Ending of PropsUtil code part1------------------------------------                      

  //        ****  Following goes in Constructor ****
    // Beginning of PropsUtil code part2--------------
    NormsTools.PropsUtil pu = null;            // Define the object reference
    try {
        pu = new NormsTools.PropsUtil("PropsUtilTest.ini"); // Replace Filename !!!
        pu.loadProps(this, props);
    }catch(Exception ex) {
        System.err.println("Test got ex " + ex);
        return;                 // EXIT DONE
    } // end of PropsUtil code part2------------------ 
*/

package NormsTools;

import java.lang.reflect.Field;
import java.util.Properties;
import java.io.*;

public class PropsUtil {

    String      propFN;
    Properties  propsF = new Properties();
    boolean     isNewFile = false;      // true if Props file didn't exist

    // Constructor
    public PropsUtil(String fn) throws Exception{
        propFN = fn;                    // Save
        // Read from the Props file
        try{
            FileInputStream fis = new FileInputStream(fn);
            propsF.load(fis);
        }catch(FileNotFoundException fnf) {
            isNewFile = true;           // File didn't exist
            return;
        }catch(Exception ex) {
            System.err.println("loadProps got " + ex);
            throw ex;
        }
    } // end Constructor

    // Tell caller if file existed
    public boolean isNewFile() {
        return isNewFile;
    }

    //--------------------------------------------------------------
    // Method to load the properties from a file into a program
    public boolean loadProps(PropsUtilUser caller, Object[] props) {

        // Work thru the props array 2 items at a time
        // [i] = name
        // [i+1] = name of value field
        for(int i = 0; i < props.length; i+=2) {
            try {
                // Get the current value to used as default
                Field fp = caller.getClass().getDeclaredField((String)props[i+1]);
                String val = caller.getString(fp);     //(String)fp.get(caller);
                // Not get the value from the Properties file
                val = propsF.getProperty((String)props[i], val); 
                // Put the new value into the val field
                caller.setString(fp, val);
//                fp.set(caller, val);

            }catch(Exception ex) {
                System.err.println("loadProps got ex " + ex);
                return false;
            }
        } // end loop processing all Props
        return true;
    } // end getProps() 
   
    //--------------------------------------------------------------
    // Method to save properties
    public boolean saveProps(PropsUtilUser caller, Object[] props, String title) {
        // Work thru the props array 2 items at a time
        // [i] = name
        // [i+1] = name of value field
        for(int i = 0; i < props.length; i+=2) {
            try {
                // Get the current value from the caller
                Field fp = caller.getClass().getDeclaredField((String)props[i+1]);
                String val = caller.getString(fp);    // (String)fp.get(caller);
                propsF.put((String)props[i], val);
//                System.out.println("Changed " + (String)props[i] + " to " + val);
            }catch(Exception ex) {
                System.err.println("saveProps got ex " + ex);
                return false;
            }
        } // end loop processing all Props

        //Now write the file
        try {
            FileOutputStream fos = new FileOutputStream(propFN);
            propsF.save(fos, title);
            isNewFile = false;          // It exists now
        }catch(Exception ex) {
            System.err.println("saveProps: Error saving props file " + propFN);
            return false;
        }
        return true;
    } // end saveProps()
} // end class PropsUtil  
