// NormsClassLoader.java - Load a class from a directory/jar file

// Here's my class loader -
// Needs code to search thru loc[] !!! NOW Hardcoded to use first only

// Changes:
//   11/27/01 - Changed loc to loc[] in loadClassBytes; Added NoClassDefFoundError

package NormsTools;

import java.util.*;
import java.io.*;
import java.util.zip.*;


public class NormsClassLoader extends ClassLoader {

    final static String JarExt = ".jar";

    private String[]    loc;            // Currently only using [0]!!!
    private Hashtable   classes = new Hashtable();  // Save loaded classes here

    private boolean     readFirst = true;   // Onetime switch to read first class
    private boolean     readAll = false;    // Only read, don't get system class

    private boolean     debug = false;      // controls debug output

    // Constructor ----------------------------
    public NormsClassLoader(String[] loc) { 
      this.loc = loc;             // Save location of class file
      if (debug)
         System.out.println("NormsClassLoader loc=" + loc);
      // Check if a jar file and ???
    }

 public void setLocation(String[] loc) {
    this.loc = loc;                     // Set new location
    classes = new Hashtable();          // Replace record of loaded classes
    readFirst = true;                   // reset flag
 }
 public void setReadAll(boolean b) {
    readAll = b;
 }
 public void setDebug(boolean b) {
    debug = b;
 }

 //  Here's the main entry point for loading a class. Resolve is set to false!
 public synchronized Class loadClass(String name)
               throws ClassNotFoundException, NoClassDefFoundError  {
    return loadClass(name, false);
 }

 protected synchronized Class loadClass(String name, boolean resolve)
               throws ClassNotFoundException, NoClassDefFoundError  {
    try {                       
        // check if class already loaded
        Class cl = (Class)classes.get(name);
        if (debug)
            System.out.println("ldCls() for " + name + ", cl = " + cl 
                                        + ", " + resolve);
    
        if (cl == null) { // new class
            if (!readFirst && !readAll) {
                try {
                    // check if system class ??? This won't look in my location?
                    Class sc = findSystemClass(name);
                    if (debug)
                        System.out.println("ldCls()     found sysClass>> " 
                                                                + sc.toString());
                    return sc;
                 }
                 catch (ClassNotFoundException e) {}
                 catch (NoClassDefFoundError e) {}    

             }else {
                readFirst = false;      // reset for next time
             }
           // load class bytes--details depend on class loader
           
           byte[] classBytes = loadClassBytes(name);
           if (classBytes == null) 
              throw new ClassNotFoundException(name);
    
           // Keep going into defineClass, BUT NEVER RETURN??->error thrown
           if (debug)
               System.out.println("ldCls() entering defineClass for " + name);
           cl = defineClass(name, classBytes, 0, classBytes.length);
           if (cl == null) { 
              if (debug)
                 System.err.println("ldCls() didn't define class " + name);
              throw new ClassNotFoundException(name);
           }
    
            if (debug)
               System.out.println("ldCls()     defined class>> " + cl.toString());
           classes.put(name, cl);           // remember class
        } // end new class to read and define
    
        if (resolve) resolveClass(cl);
    
        if (debug)
            System.out.println("ldCls() returning class:  " + cl.toString());
        return cl;

    }catch(Exception ex) {
        ex.printStackTrace();
        throw new ClassNotFoundException(name);
    }
 } // end loadClass()

 //------------------------------------------------------------------
 // Read and return bytes of a class file
 private byte[] loadClassBytes(String name) {
    String cname; // = name.replace('.', '/') + ".class";
    InputStream in = null;
    
    try {  
        // Determine where the class bytes are: jar entry or disk file
        if(loc[0].endsWith(JarExt)) {
            ZipFile zf =new ZipFile(loc[0]);
            cname = name.replace('.', '/') + ".class";
            if (debug)
                System.out.println("loadCB() reading zipEntry: " + cname 
                                                + "  from " + loc[0]);
            ZipEntry ze = zf.getEntry(cname);
            if (ze == null)
                return null;
            in = zf.getInputStream(ze);
        }else {  
            cname = name.replace('.', File.separatorChar) + ".class";
            if (debug)
                System.out.println("loadCB() reading file: " + loc[0] + cname);
            in = new FileInputStream(loc[0] + cname); 
        }

        ByteArrayOutputStream buffer  = new ByteArrayOutputStream();
        int ch;
        while ((ch = in.read()) != -1)
            buffer.write(ch);
        in.close();   
        if (debug)
            System.out.println("loadCB() returning " + buffer.size() + " bytes");
        return buffer.toByteArray();

    }catch (IOException e) {
        if (in != null)  {
            try { in.close(); } catch (IOException e2) {}
        }
        System.err.println("loadCB() IO ex " + e);
    }catch (Exception ex) {
        System.err.println("loadCB() ex: " + ex);
    }
    return null;
 }  // end loadClassBytes()


}  // end class MyClassLoader **********************************************
