// MyLabel.java

package NormsTools;

import java.awt.*;

//////////////////////////////////////////////////////////////////
// Define a class to make Label contents more compact

public class MyLabel extends Label {
    Dimension dm = null;

    public MyLabel(String txt, int algn) {
        super(txt, algn);
        Graphics g = getGraphics();
        if (g == null) return;
        FontMetrics fm = g.getFontMetrics();
        int h = fm.getHeight() + 2;
        int w = fm.stringWidth(txt);
        dm = new Dimension(w, h);
    }

    public   Dimension getPreferredSize() {
        if (dm == null) {
            Graphics g = getGraphics();
            FontMetrics fm = g.getFontMetrics();
            int h = fm.getHeight() + 2;
            int w = fm.stringWidth(getText());
            dm = new Dimension(w, h);
        }
        return dm;
    }
}