// MessageArea.java
/** Define a ccomponent to display a message in<BR>
*  The text will be folded to fit and newlines are honored
*/

package NormsTools;  // = name of subdirectory containing this file

import java.util.*;
import java.awt.*;
import java.awt.event.*;        // for testing code in main()


public class MessageArea extends Component {
    private boolean     testing = false;           // for debug output

    private final static int    MIN_WIDTH = 200;
    private final int           ExtraLines = 100;       // buffer

    String      msg;
    Font        font;
    FontMetrics fm;
    int         strLen;                 // in pixels
    int         maxWordLen = 0;         // in pixels
    int         hFM;                    // height of font
    int         YPAD = 3;               // spacing between lines
    Dimension   pSize;

    // Following array holds the text to be displayed. 
    private String[]    lines;          // msg broken up into lines
    private int         idx = 0;        // global index into above array
    private int         nbrLines = 0;   // Nbr of valid lines to display


    // Constructor -------------------------
    public MessageArea(String msg) {
        super();        // ???? set page 315 Volume 2
        this.msg = msg;
    } // end Constructor

    public void setTesting(boolean b) {
        testing = b;
    }

    //------------------------------------------------------------------
    // Override paint() to display the message:
    public void paint(Graphics g) {
        if (testing) System.out.println("MA: paint");
        if (pSize == null) {
            getSpecs();
        }

        // Show lines:
        int i = 0;
        try {
        int x = 0, y = fm.getAscent();
        for (i = 0; i < nbrLines; i++) {
            g.drawString(lines[i], x, y);
            y += hFM;
        }
        }catch(Exception ex) {
            System.out.println("paint ex " + ex + "\n i=" + i 
                        + ", nbrLines =" + nbrLines);
        }
    } // end paint

    //------------------------------------------------------------------
    //  Utility method to set pSize and fill lines array
    private synchronized void getSpecs() {
        if (testing) System.out.println("MA: getSpecs " + getFont() 
                    + "\n   superSize=" + super.getSize());

        fm = getFontMetrics(getFont());
        hFM = fm.getHeight();
        strLen = fm.stringWidth(msg);
        // Get width of ???
        int lineLen = super.getSize().width;
        if (lineLen == 0) {
            lineLen = MIN_WIDTH;        // Default???
            if (testing) 
                System.out.println("MA.getSpecs() width=0, set to " + lineLen);
        }
        // Compute approximate number of lines needed
        // Actual number will have to be computed by checking wrap etc
        nbrLines = (strLen + lineLen-1)/lineLen;

        // Fill array with data for each line. Find longest word
        lines = new String[nbrLines + ExtraLines];// +Xtra to allow for weird wraps
        idx = 0;                        // reset index

        // Check if there are newlines to worry about
        if (msg.indexOf("\n") > 0) {
            StringTokenizer tok = new StringTokenizer(msg, "\n");

            while (tok.hasMoreTokens()) {
                String nxt = tok.nextToken();
                if (fm.stringWidth(nxt) < lineLen) {
                    lines[idx++] = nxt; // save as it if short enuff    
                }else {
                    // need to break it up to fit
                    foldString(nxt, lineLen);
                    idx++;              // Adv to next position
                }
            } // end scanning strings ending with nl
            idx--;                      // backup to last

        }else {
            foldString(msg, lineLen);
        }

        nbrLines = idx + 1;      // remember actual number of lines saved
        // Set required size
        pSize = new Dimension(Math.max(lineLen, maxWordLen), 
                                nbrLines*(hFM+YPAD)-YPAD);
        if (testing)  
            System.out.println("MA.getSpecs(): new size " + pSize 
                    + "\n   maxWL=" + maxWordLen + ", lL=" + lineLen 
                    + ", nbrL=" + nbrLines + ", hFM=" + hFM);
    }  // end getSpecs()

    //--------------------------------------------------------------
    // Utility to fold a string to fit in lineLen
    // Leaves idx pointing to last line added
    private void foldString(String msg, int lineLen) {
        // Note: this will compress spaces to a single space!!!
        StringTokenizer tok = new StringTokenizer(msg);
        lines[idx] = tok.nextToken();   // save first word
        maxWordLen = fm.stringWidth(lines[idx]);  // ???

        while (tok.hasMoreTokens()) {
            String work = tok.nextToken();
            int lw = fm.stringWidth(work);
            // Save maximum word length - is min line length
            maxWordLen = (lw > maxWordLen ? lw : maxWordLen);
            if (fm.stringWidth(lines[idx] + " " + work) > lineLen) {
                idx++;              // Advance to next line
                lines[idx] = work;  // start next line    
            }else {
                lines[idx] += " " + work;  // Concat word to line
            }
                
        } // end while() picking tokens
    }  // end foldString()

    //------------------------------------------------------------------
    public void invalidate() {
        pSize = null;
        if (testing)   System.out.println("MA: invalidate");
        super.invalidate();
    }

    public void setSize(Dimension s) {
        if (testing)   System.out.println("MA: setSize: " + s);
        pSize = s;
    }

    public Dimension getSize() {
        if (testing)  System.out.println("MA: getSize: " + pSize + " " 
                                                       + super.getSize());
        if (pSize == null)
            return super.getSize();
        return pSize;
    } // end getSize()

    public Dimension getMinimumSize() {
        if (pSize == null) {
            if (testing)  System.out.println("MA: getMinimumSize " 
                                + super.getSize());
            getSpecs();
        }
        if (testing)  System.out.println("MA: getMinimumSize " + pSize);
        return pSize;        
    }
    // - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
    public Dimension getPreferredSize() {
        if (pSize == null) {
            getSpecs();
        }
        if (testing)  System.out.println("MA: getPreferredSize " + pSize);
        return pSize;
    } // end getPreferredSize()

    public boolean isFocusTraversable() {
        return false;                   // ??? WHY
    }

    //------------------------------------------------------------------
    // for testing only Comment out next line with /* when done:
/*    public static void main(String[] args) {
        Frame f = new Frame("MessageArea test");
        MessageArea ma = new MessageArea("This is a long message that is to "
        + "extend for more than one line.\n With a longer-than-normal-word."
        + "\nTwo short nls\nAgain.\n \n \n \n \n \n \n \n \n\nEnd.");
                                                
        ma.setBackground(Color.lightGray);
        f.add(ma, BorderLayout.NORTH);
        Label lbl = new Label("This is a red label");
        lbl.setBackground(Color.red);
        f.add(lbl, BorderLayout.CENTER);

        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        f.setSize(200, 100);
        f.setLocation(300, 300);
        f.pack();
        f.show();
    } // end main()   */
} // end class MessageAreatrue; 