// MakeFocusLostDoAction.java
// Class to turn Focus loss into an ActionEvent for a component
// A new instance of this class should be added as a FocusListener for
// the component to receive the ActionEvent

package NormsTools;

import java.awt.event.*;
import java.awt.*;

public class MakeFocusLostDoAction  extends FocusAdapter {

   public void focusLost(FocusEvent fe) {
     Object src = fe.getSource();
     Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(
                     new ActionEvent(src, 
                     ActionEvent.ACTION_PERFORMED, 
                     "Focus lost"));
   }  // end focusLost()
}  // end class