// MakeEnterDoAction.java
// Class to turn key press into an ActionEvent for a component
// A new instance of this class should be added as a KeyListener to the component
// that is to receive the ActionEvent:      button.addKeyListener(new MakeEnterDoAction());


package NormsTools;

import java.awt.event.*;
import java.awt.*;

public class MakeEnterDoAction  extends KeyAdapter {

   public void keyPressed(KeyEvent ke) {
     if (ke.getKeyCode() == KeyEvent.VK_ENTER) {
         Object src = ke.getSource();
         Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(
                         new ActionEvent(src, 
                         ActionEvent.ACTION_PERFORMED, 
                         "Enter"));
     }
   }  // end keyPressed()
}  // end class