//MSDosFilename.java 
// Program to convert MS DOS 8.3 filename to extended filename
// Add:   code to also convert 8.3 path to Extended

package NormsTools;

import java.io.*;
import java.util.*;     // FOR TESTING


public class MSDosFilename {

    /** Convert DOS 8.3 filename to the extended filename
    *  @param   String - 8.3 filename
    *  @return  String - the extended filename
    */
    public static String getExtendedName(String FN8dot3) {

        // Split name up into parts for checking with below
        int lenNm = FN8dot3.indexOf('.');
        // Get length of substring to compare:
        // Up to ~ or else up to .
        int tlda = FN8dot3.indexOf('~');
        if (tlda < 0)
            tlda = lenNm;
        String fnPfx = FN8dot3.substring(0, tlda);
        String fnExt = FN8dot3.substring(lenNm+1);  // get extension
//        System.out.println("pfx=" + fnPfx + "  ext=" + fnExt);

        File aF83 = new File(FN8dot3);
/*        // Note: Absolute path has good folder names but FN is unchanged! 
        System.out.println("given FN is: " + aF83.getName() 
                            +" exists:" + aF83.exists() 
                            + "  " + aF83.getParent()
                            + "\n   Apath: " + aF83.getAbsolutePath()); // */
        // Test that file exists before continuing
        if (!aF83.exists())
            return FN8dot3;             // Can't lookup if doesn't exist!

        // Get extended filenames for all files in this files folder:
        File pF = null;                 // Parent File
        if (aF83.getParent() != null)
            pF = new File(aF83.getParent());
        else {
            // Use current directory if above fails?
            Properties props = System.getProperties();
            pF = new File(props.getProperty("user.dir"));
        }

        // Get a list of the files in this directory
        String[] lFiles = pF.list();
        // Search for the match:
        // First 6 letters match(uppercase) and same size and lastmodified
        for(int j=0; j < lFiles.length; j++) {
//            System.out.println("File " + j + " " +lFiles[j]);
            if ((lFiles[j].length() > tlda)
                && lFiles[j].substring(0, tlda).toUpperCase().equals(fnPfx)) {
                // Name matches, check rest of it
                File testF = new File(lFiles[j]);
                if (!testF.isFile())
                    continue;           // Skip if not a file
                // Names match, check date and length
                if (testF.lastModified() == aF83.lastModified() &&
                    testF.length() == aF83.length())
                    return lFiles[j];   // OK, this is it 
            } // end matching filenames
        } // end searching all filenames

        // Not found, return original
        return FN8dot3;
    } // end getExtendedName()

    // Following for testing
    public static void main(String[] args) {
        String f83 = "ASKMUL~1.CLA";
        System.out.println(f83 + " to " + getExtendedName(f83));
        System.exit(0);
    } // end main()
}