// IntInputField.java - Int input field with Label

package NormsTools;

import java.awt.*;
import java.awt.event.*;

//////////////////////////////////////////////////////////////////
// Define class with input field for int
public class IntInputField extends Panel implements /*TextListener,*/
                                                FocusListener {
    MyLabel       lbl;
    TextField   tf;
    int         value;
    int         lastPos;
    Frame       errF = null;

    // Range checking values:
    int         maxValue = 100000;
    int         minValue = 0;

    FlowLayout  fl = new FlowLayout(FlowLayout.LEFT);

    // Constructor ------------------------------------------
    public IntInputField(String label, int size, int defval) {
        fl.setHgap(0);
        setLayout(fl);
        lbl = new MyLabel(label, Label.LEFT);
        add(lbl);
        tf = new TextField("" + defval, size);
        add(tf);
//        tf.addTextListener(this);
        tf.addFocusListener(this);
        tf.addKeyListener(new KeyAdapter() {
            public void keyTyped(KeyEvent ke) {
                char ch = ke.getKeyChar();
                // Only allow valid characters??? How about negative values?
                if (!(('0' <= ch && ch <= '9')
                        || Character.isISOControl(ch)))
                    ke.consume();       // eat invalid chars
                else
                   lastPos = tf.getCaretPosition();  // save location
            }
        });
        value = defval;
    } // end Constructor


    //--------------------------------------
    // Property handlers
    public int getValue() {
        checkValue();
        return value;
    }

    public void setValue(int v) {
        value = v;
        tf.setText("" + v);
    }

    public void setMinMax(int min, int max) {
        if (min < max) {
            minValue = min;
            maxValue = max;
        } else {
            System.err.println("Invalid min:max values");
        }
    }
   
    public void setErrFrame(Frame f) {
        errF = f;
    }
    public void ckValid() {
        checkValue();
    }

    public String toString() {
        return Integer.toString(value);
    }

    // Trap text input
/*    public void textValueChanged(TextEvent te) {
        checkValue();
    }
*/    
    // Get/check integer value from Text field
    private void checkValue() {
        // Skip checking if empty field
        if (tf.getText().trim().equals(""))
            return;

        try {
            int tempValue = Integer.parseInt(tf.getText().trim());
            if (tempValue > maxValue || tempValue < minValue) {
                if (errF != null) {
                    new ErrDialog(errF, lbl.getText() + " out of range: " 
                                    + minValue + ":" + maxValue);
                }else    
                    System.err.println(lbl.getText() + "out of range: " 
                                    + minValue + ":" + maxValue);
                tf.requestFocus();      // position cursor in textfield
//                throw new NumberRangeException("" + tempValue);
            } else
                value = tempValue;      // save if valid

/*        }catch(NumberRangeException nre) {
            nre.printStackTrace();
*/
        }catch(NumberFormatException ne) {
            tf.setText("" + value);
            tf.setCaretPosition(lastPos);
        }
    } // end checkValue()

    public void focusGained(FocusEvent fe) {}
    public void focusLost(FocusEvent fe) {
        if (fe.getComponent() == tf)
            if (tf.getText().trim().equals("")) {
                if (errF != null) {
                    new ErrDialog(errF, lbl.getText() + " missing value "); 
                }else    
                    System.err.println(lbl.getText() + " missing value ");
                tf.requestFocus();      // position cursor in textfield
            }else
                checkValue();
         else {
            System.out.println("unkn focusLost: " + fe);
        }
    }

    //--------------------------------------------------
    // Following for debugging.  Comment out when done
/*    public static void main(String[] args) {
        TestFrame f = new TestFrame();
        f.add(new IntInputField("Testing", 4, 100));
        f.show();
    } // end main()  */
}  // end class IntInputField

/* Class for debugging
class NumberRangeException extends Exception {
    public NumberRangeException(String s) {
        super(s);
        // ?
    }
} // end class NumberRangeException
*/
