// Histogram.java

package NormsTools;

import java.awt.*;
import java.awt.event.*;
import java.util.*;


public class Histogram extends Container {
   // 
    int TBHeight = 15;
    int SBWidth = 15;
    int CBHeight = 15;

   // Define the components that will make up the Histogram display
   TitleBar    tb;      // Title will go on top
   ScaleBar    sb;      // Scale bar will go down left side
   ColumnBar   cb;      // Column bar will go on bottom
   DataGram    dg;      // Data gram will show the histogram bars

   // Drawing controls:

   int   units = 1,           // 1 | 10 | 100 | 1000 ...
         nbrCols,
         displayHt,           // = height of DataGram area
         unitHeight,          // = display height / 10
         maxValue = 0;        // max value in data[]
   
 

   // Constructors
   public Histogram(String title, int[] data) {
      this(title, data, data.length, 400, 400);
   }

   public Histogram(String title, int[] data, int nbrCols) {
      this(title, data, nbrCols, 400, 400);
   }

   public Histogram(String title, int[] data, int nbrCols, int width, int height) {
      for(int i=0; i<data.length; i++) {
         if (data[i] > maxValue)
            maxValue = data[i];        // Save largest value
      }
      setLayout(null);                 // We'll do it

      tb = new TitleBar(title);
//      tb.setSize(width, TBHeight);
      Insets ins = getInsets();  // = 0???
      tb.setBounds(ins.left, ins.top, width-ins.left-ins.right, TBHeight);
      tb.setBackground(Color.yellow);
      add(tb);

      sb = new ScaleBar();
//      sb.setSize(SBWidth, height - TBHeight);
      sb.setBounds(ins.left, ins.top+TBHeight, SBWidth, height - TBHeight - CBHeight);
      sb.setBackground(Color.cyan);
      add(sb);

      cb = new ColumnBar();
//      cb.setSize(width - SBWidth, CBHeight);
      cb.setBounds(SBWidth, ins.top+height-CBHeight-15, width-ins.left-ins.right-SBWidth, CBHeight);
      cb.setBackground(Color.green);
      add(cb);

      dg = new DataGram();
      add(dg);

      System.out.println("End constr " + tb.getSize() + " " + ins);
   }
   // End Constructors

   public void paint(Graphics g) {
      super.paint(g);
      System.out.println("Cntnr.paint() " + getParent().getInsets());
   }
   public void paintComponentsXX(Graphics g) {
      super.paintComponents(g);
      System.out.println("Cntnr.paintComponents() ");
   }


    //*************************************************************************
   // Define inner classes that will be what's displayed in the container

   class TitleBar extends Component {
      String      title;
      Dimension   size;
      FontMetrics fm;

      public TitleBar(String title) {
         this.title = title;
      }
      public void setSize(int w, int h) {
         super.setSize(w, h);
         size = new Dimension(w, h);
      }
      public Dimension getPreferredSize() {
         System.out.println("TB.gPS: " + size);
         return size;
      }

      public void paint(Graphics g) {
         System.out.println("TB.paint() " + getBounds() + getInsets());
         fm = g.getFontMetrics();
         int wdx = fm.stringWidth(title);
         g.setColor(getBackground());
         Rectangle bnds = getBounds();
         g.fillRect(bnds.x, bnds.y, bnds.width, bnds.height);
         g.setColor(Color.black);
         // Center the title -> NB also check if too long????
         wdx = (bnds.width - wdx)/2;
         g.drawString(title, bnds.x+wdx, bnds.y+fm.getAscent());
      }
   } // end class TitleBar-----------------------------------------------------

   class ScaleBar extends Component {
      Dimension   size;
      FontMetrics fm;

      public ScaleBar() {
      }
      public void setSize(int w, int h) {
         super.setSize(w, h);
         size = new Dimension(w, h);
      }
      public Dimension getPreferredSize() {
         System.out.println("SB.gPS: " + size);
         return size;
      }

      public void paint(Graphics g) {
         System.out.println("SB.paint() " + getBounds() + getInsets());
         Rectangle bnds = getBounds();
         g.setColor(getBackground());
         g.fillRect(0, 0, bnds.width, bnds.height);
      }
   } // end class ScaleBar ---------------------------------------------------

   class ColumnBar extends Component {
      Dimension   size;
      FontMetrics fm;

      public ColumnBar() {
      }
      public void setSize(int w, int h) {
         super.setSize(w, h);
         size = new Dimension(w, h);
      }
      public Dimension getPreferredSize() {
         System.out.println("CB.gPS: " + size);
         return size;
      }

      public void paint(Graphics g) {
         System.out.println("CB.paint() " + getBounds() + getInsets() + getBackground());
         fm = g.getFontMetrics();
         g.setColor(getBackground());
         Rectangle bnds = getBounds();
         g.fillRect(0, 0, bnds.width, bnds.height);
//         g.setColor(Color.black);
      }
   }  // end class ColumnBar--------------------------------------------------

   class DataGram extends Component {
   }  // end class DataGram---------------------------------------------------

   //--------------------------------------------------------------------------
	// For testing:
	public static void main(String[] args) {
	
		Frame f = new Frame("Test Histogram");
		f.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we){
				System.exit(0);
			}
		});

      int[] samp = {4, 6, 2, 0, 2};

		Histogram h = new Histogram("Test histogram of 5 integers", samp);
		f.add(h);
      f.setSize(410, 410);
		f.show();
	}  // end main()
}  // end class Histogram