// Use a Scrollbar and TextField to get an int value

package NormsTools;

import java.applet.*;
import java.awt.*;
import java.awt.event.*;

final public class GetIntInput extends Dialog implements AdjustmentListener,
                                            ActionListener, TextListener {
    final boolean debug = false;          // Control debug output
    int         toFrontCnt = 3;
    boolean     done = false;

    Scrollbar theSB;
    TextField theTF = new TextField(" ");
    Button    button = new Button("Done");

    private int   theValue = -1;
    private int   minValue;
    private int   maxValue;

    //-------------------------------------------------------------------------
    public GetIntInput(Frame parent, String title, String label, int min, int max, int init) {

        super(parent, title, true);
        theValue = init;
        minValue = min;
        maxValue = max;
        theSB = new Scrollbar(Scrollbar.HORIZONTAL, init, 1, minValue, maxValue+1);

        setLayout(new BorderLayout());
        // Set traps for Scrollbar changes:
        theSB.addAdjustmentListener(this);

        // Set traps for TextField
        theTF.addActionListener(this);
        theTF.addTextListener(this);

        double[] rowWeights = {0.0, 1.0};
        double[] colWeights = {0.0, 1.0};
        GridBagLayout gbl = new GridBagLayout();
//        gbl.rowWeights = rowWeights;
        gbl.columnWeights = colWeights;
        Panel p = new Panel(gbl);
        p.setLayout(gbl);

        add(makeScrollbars(label, theSB, theTF), BorderLayout.NORTH); 

        button.addActionListener(this);
        Panel bPanel = new Panel();
        bPanel.add(button);
        add(bPanel, BorderLayout.SOUTH);

        // Trap window closing and get rid of our stuff
        addWindowListener(new WindowAdapter() {
           public void windowClosing(WindowEvent we) {
               setDone();
           }
           // Keep our window on top
           public void windowDeactivated(WindowEvent we) {
               if (!done) {
                   if(toFrontCnt-- > 0) {
                     toFront();           // No effect when run from main() below???
                   }
               }
           }
        });

        theTF.setText(""+theValue);
        theSB.setValue(theValue);
        // Problem here: If in Applet, get "Warning" status bar and 80 is not enough
        addNotify();
        Insets ins = getInsets();
//        System.out.println(ins);
        setSize(300, ins.top + ins.bottom + 53);

        // Center frame
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        setLocation((ss.width-getBounds().width)/2, 
                   (ss.height-getBounds().height)/2);  
        show();
    } // end constructor

    // Return selected value to the caller
    public int getValue() {
      return theValue;
    }

    Panel makeScrollbars(String l1, Scrollbar sb1, TextField tf1) {
        double[] rowWeights = {0.0, 1.0};
        double[] colWeights = {0.0, 1.0};
        GridBagLayout gbl = new GridBagLayout();
//        gbl.rowWeights = rowWeights;
        gbl.columnWeights = colWeights;
        Panel p = new Panel(gbl);
        p.setLayout(gbl);

        add(p, gbl, new Label(l1, Label.CENTER), 
                         0, 0, GridBagConstraints.NONE);
        add(p, gbl, sb1, 1, 0, GridBagConstraints.HORIZONTAL);

        add(p, gbl, tf1, 2, 0, GridBagConstraints.NONE);

        return p;
    } // end makeScrollbars()

    void add(Panel p, GridBagLayout gbl, Component comp, int x, int y, int fill) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.fill = fill;
        gbl.setConstraints(comp, gbc);
        p.add(comp);
    }

    // Process TextField changes
    public void textValueChanged(TextEvent te) {
      if (debug) System.out.println("TF changed: " + theTF.getText());
      // How to allow intermediate results that are out of range???
      theValue = getInt(theTF);
      theSB.setValue(theValue);
    }  // end textValueChanged()

    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if (src == theTF) {
            theValue = getInt(theTF);
            theSB.setValue(theValue);

        }else if(src == button) {
            // Ok we're done
            setDone();
        }else {
            System.err.println("Unknown ae " + ae);
        }
    } // end actionPerformed()

    private void setDone() {
            done = true;
            setVisible(false);
            dispose();
    }

    // Get the int value from a TextField
    private int getInt(TextField tf) {
        String s = tf.getText();
        int xx = -9999;
        try {
            xx = Integer.parseInt(s);
            //Make sure in range
            if (xx <= maxValue && xx >= minValue)
               return xx;
            // Out of range
            System.err.println("int value out of range: " + xx);
        }catch(Exception ex) {
            System.err.println("Invalid int value: " + s);
        }
        tf.setText(""+theValue);       // Restore
        return theValue;               // Leave unchanged
    } // end getInt()

    //---------------------------------------------------------
    // Process Scrollbar changes
    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (debug)
            System.out.println("aVC " + evt);
        Object src = evt.getSource();

        if (src == theSB) {
            theValue = (theSB.getValue());
        }else {
            System.err.println("Unknown AdjE " + evt);
            return;
        }
        theTF.setText(""+theValue);    // Show changed value in TF
    } // end adjustmentValueChanged

    // Pad String with leading 0 if single digit
    private String padZero(String s) {
        if (s.length() > 1)
            return s;
        return "0" + s;
    } // end padZero


    //------------------------------------------------------------------------
    // Following for testing. Comment out when done
/*    public static void main(String[] args) {
        Frame f = new Frame("Test Get Int Input");
        f.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                System.exit(0);
            }
        });
        GetIntInput ca = new GetIntInput(f,"Select value from 3 to 100", 
                           "Set delay", 3, 100, 20);
        System.out.println("got " + ca.getValue());
        System.exit(0);
    } // end main() */
} // end class ColorApplet

