// GetInput.java

// Changes- 09/25/01 - Preload TextArea with a String

package NormsTools;  // = name of subdirectory containing this file

import java.util.*;
import java.awt.*;
import java.awt.event.*;


//*************************************************************************
//-----------------------------------------------------------------------
/** This class is a modal Dialog to get user input
*/
public class GetInput extends Dialog implements ActionListener, TextListener,
                                                Runnable {

  final static int DEF_SIZE = 20;
  
  String      response = "";            // Only changed if user hits Enter
  Panel       p1 = new Panel();
  TextComponent   tf;
  Button      ok;  
  boolean     done = false;             // controls thread  

  //-- Constructors ---------------------------------
  public GetInput(String prompt, Frame parent) {
    super(parent, prompt, true);
    getInput(prompt, parent, DEF_SIZE, "Ok");  // Set default response size
  }  
  public GetInput(Frame parent, String prompt) {
    super(parent, prompt, true);
    getInput(prompt, parent, DEF_SIZE, "Ok");  // Set default response size
  }
  public GetInput(String prompt, Frame parent, int respSize) {
    super(parent, prompt, true);
    getInput(prompt, parent, respSize, "Ok");
  }
  public GetInput(String prompt, Frame parent, int respSize, boolean mdl) {
    super(parent, prompt, mdl);
    getInput(prompt, parent, respSize, "Ok");
  }
  public GetInput(Frame parent, String prompt, int respSize) {
    super(parent, prompt, true);
    getInput(prompt, parent, respSize, "Ok");
  }
  public GetInput(Frame parent, String prompt, int respSize, boolean mdl) {
    super(parent, prompt, mdl);
    getInput(prompt, parent, respSize, "Ok");
  }
  public GetInput(String prompt,Frame parent, String btnLbl) {
    super(parent, prompt, true);
    getInput(prompt, parent, DEF_SIZE, btnLbl);    
  }
  public GetInput(Frame parent, String prompt, String btnLbl) {
    super(parent, prompt, true);
    getInput(prompt, parent, DEF_SIZE, btnLbl);    
  }
  public GetInput(String prompt,Frame parent, int respSize, String btnLbl) {
    super(parent, prompt, true);
    getInput(prompt, parent, respSize, btnLbl);    
  }
  public GetInput(Frame parent, String prompt, int respSize, String btnLbl) {
    super(parent, prompt, true);
    getInput(prompt, parent, respSize, btnLbl);    
  }

  // Define a constructor that will putup a TextArea
  public GetInput(String prompt, Frame parent, int rows, int cols, 
                              String btnLbl, String init) {
     super(parent, prompt, true);
     getInputFromTA(prompt, parent, rows, cols, btnLbl, init);
 }
  public GetInput(String prompt, Frame parent, int rows, int cols, String btnLbl) {
    super(parent, prompt, true);
    getInputFromTA(prompt, parent, rows, cols, btnLbl, null);
  }
  private void getInputFromTA(String prompt, Frame parent,
                           int rows, int cols, String btnLbl, String init) {
    setLayout(new BorderLayout());

    tf = new TextArea(rows, cols);
    tf.addTextListener(this);
    if (init != null) {
      tf.setText(init);
      response = init;                 // In case doesn't hit enter!
    }
    add(tf, BorderLayout.CENTER);
    ok = new Button(btnLbl);
    ok.addActionListener(this);
    ok.setEnabled(false);
    p1.add(ok);
    add(p1, BorderLayout.SOUTH);
    setSize(600, 400);

    addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent we) {
            setVisible(false);
            done = true;                // tell thread
            dispose();
        }
    });

    (new Thread(this)).start();     // start toFront() calls on thread

    // compute location ???
    try {
      setLocation(100, 100);
    }catch (Exception e) {}  // ignore
    if (isModal())
        setVisible(true);
  }  // end constructor

  // ---- Common routine ------------------------------------
  private void getInput(String prompt, Frame parent, int respSize, String btnLbl) {  
    setLayout(new FlowLayout());   // for Internet Explorer???

    p1.setLayout(new FlowLayout());
    tf = new TextField(" ", respSize);
    tf.addTextListener(this);
    ((TextField)tf).addActionListener(this);         // Allow Enter to finish
    p1.add(tf);
    ok = new Button(btnLbl);
    ok.addActionListener(this);
    ok.addKeyListener(new MakeEnterDoAction());
    ok.setEnabled(false);
    p1.add(ok);
    add(p1);
    setSize(400, 80);
    pack();

    addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent we) {
            setVisible(false);
            done = true;                // tell thread
            dispose();
        }
    });

    (new Thread(this)).start();     // start toFront() calls on thread

    // compute location ???
    try {
      setLocation( 100, 100);
    }catch (Exception e) {}  

    if (isModal())
        setVisible(true);
  } // end constructor -----


  //-----------------------------------------------------------------------------
  /** Preload text field NO is after the fact with modal=true!!!
  *   @param String - value to be set
  */
  public void setField(String s) {
    tf.setText(s);
  } // end setField()

  public void showIt() {
    setModal(true);
    setVisible(true);
  } 

 //----------------------------------------------------------
 public void textValueChanged(TextEvent te) {
    ok.setEnabled(!tf.getText().trim().equals(""));
  }

  // Trap button press or Enter
  public void actionPerformed(ActionEvent ae) {
    response = tf.getText().trim();   // NOTE: save user's input
//    System.out.println("Resp: " + response);
    if (response != null && !response.equals("")) {
      setVisible(false);
      done = true;                    // tell thread
      dispose();                      // ?????????? have data?
    }
  } // end actionPerformed()

  // Keep the dialog window on top!
  public void run() {
    while (true) {  // forever loop
        try {
            if (done)  return;          // exit if done
            toFront();
            Thread.sleep(500);
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }  // end forever loop
  }  // end run()
 
  public String getResponse() {return response;}
  
  //*********************************************************************
/*  // Following for testing
  public static void main(String[] args) {
    GetInput gi = new GetInput("Enter something", new Frame());
    gi.setField("THis is the msg");
    System.out.println("Got >" + gi.getResponse() + "<");
    gi = new GetInput("Enter a lot", new Frame(), 10, 70, "Import");
    System.out.println("Got >" + gi.getResponse() + "<");
    System.exit(0);                     // Need this, java doesn't exit???
  } // end main() */ 
}  // end class GetInput          

