// Get folder that a class was loaded from

package NormsTools;

import java.net.URL;
import java.io.File;
import java.util.zip.*;
import java.util.Date;


public final class FindOurHome {

   final static boolean    debug = false;     // For debug output

   private static boolean  setHomeLoc = false;
   private static boolean  homeLocInJar = false;  // true if class file from jar

   private static String  URLStr = "";


    // Here are the possible headers and id strings (see below):
    private final static String JAVA_HDR1 = "file:/";
    private final static String JAVA_HDR2 = "jar:";
    private final static String JAVA_SEP = "!";
    private final static String JVIEW_HDR1 = "systemresource:/FILE";
    private final static String JVIEW_HDR2 = "systemresource:/ZIP";
    private final static String JVIEW_SEP1 = "/+/";
    private final static String JAR_EXT = ".jar";
    private final static String   MetaFILE = "META-INF/MANIFEST.MF";   

   //-------------------------------------------------------------------
   public final static String getHomeLoc(Object obj, String className) {
       if(debug) {
         System.out.println("getHomeLoc(): class is " + obj.getClass());
       }
       URL ourLoc = obj.getClass().getResource(className);
       if (ourLoc == null) {
         System.err.println("getHomeLoc(): getResource returned null for " 
                                 + className + " with " + obj);
         return "";
       }
       if (debug)
         System.out.println("Loaded from=" + ourLoc 
                       + ",\n    getFile=" + ourLoc.getFile());

   //   Output when from a class file:
   //JAVA >Loaded from  file:/D:/JavaDevelopment/SlideShow/ImgIdxEditor.class,
   //               getFile=/D:/JavaDevelopment/SlideShow/ImgIdxEditor.class
   //JVIEW>Loaded from  systemresource:/FILED:\JavaDevelopment\SlideShow\/+/ImgIdxEditor.class,
   //               getFile=/FILED:\JavaDevelopment\SlideShow\/+/ImgIdxEditor.class

   //   Output when load from a jar:
   //JAVA >Loaded from  jar:file:/C:/My_Photos/SlideShowApp.jar!/ImgIdxEditor.class,
   //               getFile=file:/C:/My_Photos/SlideShowApp.jar!/ImgIdxEditor.class
   //JVIEW>Loaded from  systemresource:/ZIPC:\My_Photos\SlideShowApp.jar/+/ImgIdxEditor.class,
   //               getFile=/ZIPC:\My_Photos\SlideShowApp.jar/+/ImgIdxEditor.class
   //JDK118>Loaded from=systemresource:/ZIP1/+/NormsTools/FindOurHome.class,
   //               getFile=/ZIP1/+/NormsTools/FindOurHome.class

       URLStr = ourLoc.toString();
       String propFolder = "";

       int ix, iy;

       homeLocInJar = false;           // Reset
       setHomeLoc = true;

       //  Parse depending on Java or JVIEW
       if (URLStr.startsWith(JVIEW_HDR1)) {
         // From a class file
         ix = URLStr.indexOf(JVIEW_SEP1); // Get end of filename
         propFolder = URLStr.substring(JVIEW_HDR1.length(), ix);

       }else if (URLStr.startsWith(JVIEW_HDR2)) {
         // From a jar file - get drive thru last /
         ix = URLStr.lastIndexOf(File.separator);
         if (ix > JVIEW_HDR2.length()) {
            propFolder = URLStr.substring(JVIEW_HDR2.length(), ix+1);
            homeLocInJar = true;
         } else {
            System.err.println("getHomeLoc(): Unknown format: " + URLStr);
         }
   
       }else if ((iy = URLStr.indexOf(JAVA_HDR1)) >= 0) {
         // Its Java program
         if (URLStr.startsWith(JAVA_HDR2)) {
            // Its in a jar file
            ix = URLStr.indexOf(JAVA_SEP);
            homeLocInJar = true;

         }else {
            ix = URLStr.length();
         }
         ix = URLStr.lastIndexOf("/", ix); // Get sep that's before the jar fn
         if (ix > JAVA_HDR1.length()) {
            propFolder = URLStr.substring(iy 
               + JAVA_HDR1.length(), ix+1).replace('/', File.separatorChar);
         }else {
            System.err.println("getHomeLoc(): Unknown format: " + URLStr);
         }
   
       }else {
         // Unknown program???
         System.err.println("getHomeLoc(): Unknown format: " + URLStr);
       }
       if (debug)
          System.out.println("getHomeLoc(): FilePath=" + propFolder);

       return propFolder;
	 } // end getHomeLoc()

    //---------------------------------------------------------
    // Was class file in a jar?
    public static boolean fromJar() {
      if (!setHomeLoc)
         throw new RuntimeException("Must call getHomeLoc() first");
      return homeLocInJar;
    }

    final static long NO_DATE = 0L;    // When no valid date found
    //---------------------------------------------------------
    // Get build date of a Jar file. Use the manifest's date!
    // Args: object that was loaded from the jar. Currently NOT USED??? 
    public static long getBuildDate(Object obj) {
      if (!fromJar() || URLStr.indexOf(JAR_EXT) < 0) {
         System.err.println("getBuildDate(): Class was not loaded from a jar");
         return NO_DATE;
      }
      //Parse out the path to the jar file
      int ixJar = URLStr.indexOf(JAR_EXT);
      int lenHdr = JAVA_HDR1.length() + JAVA_HDR2.length(); // Assume java
      if (URLStr.startsWith(JVIEW_HDR2)) {
         lenHdr = JVIEW_HDR2.length();
      }
      if (ixJar < lenHdr) {
         return NO_DATE;
      }
      String jarFN = URLStr.substring(lenHdr, ixJar+JAR_EXT.length());
      try {
         ZipFile zipF = new ZipFile(jarFN);
         ZipEntry ze = zipF.getEntry(MetaFILE);
         if (ze == null) {
            System.err.println("getBuildDate(): Manifest file not found in jar.");
            return NO_DATE;
         }
         long time = ze.getTime();
         zipF.close();
         return time;                  // Return the entry's time

      }catch(Exception ex) {
         ex.printStackTrace();
      }
      return NO_DATE;                  // if problem
    } // end getBuildDate()

    //----------------------------------------------------------------
    // Following for testing. Comment out when done
/*    public static void main(String[] args) {
      if (args.length == 0) {
         // Default
         args = new String[]{"FindOurHome.class"};
      }
//      FindOurHome.debug = true;
      FindOurHome foh = new FindOurHome();
      System.out.println(args[0] + " loaded from " 
                        + FindOurHome.getHomeLoc(foh, args[0]) 
                        + " " + FindOurHome.fromJar());
      System.out.println("Build date: " + new Date(FindOurHome.getBuildDate(foh)));
    } // end main */
} // end class

