// ErrDialog.java

package NormsTools;

import java.awt.*;
import java.awt.event.*;


///////////////////////////////////////////////////////////////////////
// Define class to display error messages
public class ErrDialog extends Dialog implements Runnable {

    final static int EDWidth = 200;
    final static int EDHeight = 150;

    boolean     WasCancelled = false;

    boolean     done = false;           // controls thread

    // Constructors ---------------------------
    public ErrDialog(Frame f, String msg, boolean modal) {
        super(f, "Error", modal);
        restOfConst(f, msg);
    }

    public ErrDialog(Frame f, String msg) {
        super(f, "Error", true);
        restOfConst(f, msg);
    }

    private void restOfConst(Frame f, String msg) {
        setBackground(Color.red);
        MessageArea ma = new MessageArea(msg);
        add(ma, BorderLayout.CENTER);

        Panel p2 = new Panel();
        Button ok = new Button("  Ok  ");
        ok.setBackground(Color.green);
        ok.addKeyListener(new MakeEnterDoAction());
        p2.add(ok);
        Button cancel = new Button("Cancel");
        cancel.setBackground(Color.yellow);
 //       p2.add(cancel);
        add(p2, BorderLayout.SOUTH);

        // Create button action processors
        ok.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                setVisible(false);
                done = true;            // tell thread
                dispose();
            }
        });
        cancel.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent ae) {
                setVisible(false);
                done = true;            // tell thread
                WasCancelled = true;     // remember
                dispose();
            }
        });

        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                setVisible(false);
                done = true;            // tell thread
                dispose();
            }
        });

        setSize(EDWidth, EDHeight);
        pack();

        // Center on Frame ???
        Dimension pD = f.getSize();
        Dimension oD = getSize();
        Point p = f.getLocation();
//        System.out.println("Size= " + pD + " " + p + " " + oD);
        if (oD.width < pD.width) {
            // Our size is smaller than the Frame we were given
            // Put inside other frame
            setLocation(p.x + (pD.width-oD.width)/2, p.y + (pD.height-oD.height)/2);
        }else {
            // Our frame is larger than the Frame
            // Put our frame over top
            setLocation((800-oD.width)/2, (600-oD.height)/2);   // HARDCODED???
        }
       (new Thread(this)).start();     // start toFront() calls on thread
        setVisible(true);
    }  // end Constructor

    public boolean wasCancelled() {
        return WasCancelled;
    }

    // Keep the dialog window on top!
    public void run() {
      while (true) {  // forever loop
        try {
            if (done)  return;          // exit if done 
            toFront();
            Thread.sleep(1000);
        }catch(Exception ex){
            ex.printStackTrace();
        }
      }  // end forever loop
    }  // end run()

    //------------------------------------------------------------------------
/*    // Following for testing
    public static void main(String[] args) {
        new ErrDialog(new Frame(), "Short message");
        new ErrDialog(new Frame(), "Long message that extends for more"
 + " than-one-line-and-we'll-see-how-it-looks-when-its-really-too-long-for-the-screen.");
        System.exit(0);
    } // end main() */
}  // end class ErrDialog
