// CmprLists.java - compare two lists and show items in/not in second list

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

import NormsTools.ErrDialog;


public class CmprLists extends Frame implements ActionListener, TextListener {

    private final String  VERSION = " 14 Nov 2001";

    private static final String PropFN = "CmprLists.ini";
    private static final String ShortListNM = "ShortList";
    private static final String LongListNM = "LongList";

    TextField   sFileTF,
                lFileTF;

    Button      getSFile,
                getLFile,
                compareBtn,
                clearTA;

    CheckboxGroup CBgrp;
    Checkbox    InList, NotInList;
    TextArea    outArea;    

    Hashtable   shortList;
    boolean     inList = false;
    String      inLine;
    String      sFileDir = "",
                lFileDir = "";
    String      sFileNM = "", lFileNM = "";
    File        sFile, lFile;

    Properties  ourProps;

    boolean     usePrintln = false;


    // Constructor ->check for valid args and files and then do it
	public CmprLists(String[] args) {
        // Process args (if any)
        if (args.length == 3) {
            if (args[0].equals("-in"))
                inList = true;
            else if (!args[0].equals("-out"))
                usage("Invalid parm: " + args[0]);
    
            sFile = new File(args[1]);
            if (!sFile.exists()) {
                usage("File not found " + args[1]);
            }
            if (!sFile.isFile()) {
                usage("Invalid File " + args[1]);
            }
            sFileNM = args[1];          // save

            lFile = new File(args[2]);
            if (!lFile.exists()) {
                usage("File not found " + args[2]);
            }
            if (!lFile.isFile()) {
                usage("Invalid File " + args[2]);

            }
            lFileNM = args[2];          // save

        }else if (args.length != 0) {
            usage("Invalid args " + args[0]);
        }

        //Process the properties file
        ourProps = new Properties();
        try {
            FileInputStream sf = new FileInputStream(PropFN);
            ourProps.load(sf);
        }catch(FileNotFoundException fnf) {
            System.err.println("Property file NOT found " + PropFN);
        }catch(Exception ex) {
            System.err.println("Error getting properties " + ex);
        }
        sFileNM = ourProps.getProperty(ShortListNM, sFileNM);
        lFileNM = ourProps.getProperty(LongListNM, lFileNM);

        //Build the gui
        setTitle("Compare lists: short vs long " + VERSION);

        Panel p1 = new Panel();
            Label l1 = new Label("Short list:");
            p1.add(l1);
            sFileTF = new TextField(50);
            sFileTF.addTextListener(this);
            sFileTF.setText(sFileNM);
            p1.add(sFileTF);
            getSFile = new Button("Choose");
            getSFile.addActionListener(this);
            p1.add(getSFile);

        Panel p2 = new Panel();
            Label l2 = new Label("Long list: ");
            p2.add(l2);
            lFileTF = new TextField(50);
            lFileTF.addTextListener(this);
            lFileTF.setText(lFileNM);
            p2.add(lFileTF);
            getLFile = new Button("Choose");
            getLFile.addActionListener(this);
            p2.add(getLFile);

        Panel p3 = new Panel();
            CBgrp = new CheckboxGroup();   
            InList = new Checkbox("In List", CBgrp, true);
            NotInList  = new Checkbox("Not in List ", CBgrp, false);
            p3.add(InList);
            p3.add(NotInList);
            compareBtn = new Button("Compare lists");
            compareBtn.addActionListener(this);
            enableCompareBtn();
            p3.add(compareBtn);
            clearTA = new Button("Clear");
            clearTA.addActionListener(this);
            p3.add(clearTA);

        Panel p4 = new Panel();
        p4.setLayout(new BorderLayout());
            p4.add(p1, BorderLayout.NORTH);
            p4.add(p2, BorderLayout.CENTER);
            p4.add(p3, BorderLayout.SOUTH);
        add(p4, BorderLayout.NORTH);

        outArea = new TextArea(18, 40);
        add(outArea,BorderLayout.CENTER);

        setSize(600, 400);
        setLocation(100, 100);
        setBackground(new Color(180, 230, 255));
        pack();
        setVisible(true);

        // Trap window closing
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent we) {
                // Save properties file
                ourProps.put(ShortListNM, sFileNM);
                ourProps.put(LongListNM, lFileNM);
                try {
                    FileOutputStream sf = new FileOutputStream(PropFN);
                    ourProps.save(sf, "Compare lists");
                }catch(Exception ex) {
                    System.err.println("Error saving props " + ex);
                }
                dispose();
                System.exit(0);
            }
        });



	}  // end Constructor

    //--------------------------------------------------------------------------
    // Process button pushes
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();

        if (src == getSFile) {
            FileDialog fds = new FileDialog(this, "Select short list file");
            fds.setDirectory(sFileDir);
            fds.setFile(sFileNM);
            fds.show();
            sFileDir = fds.getDirectory();
            sFileNM = sFileDir + fds.getFile();
            sFileTF.setText(sFileNM);
            enableCompareBtn();

        }else if (src == getLFile) {
            FileDialog fds = new FileDialog(this, "Select long list file");
            fds.setDirectory(lFileDir);
            fds.setFile(lFileNM);
            fds.show();
            lFileDir = fds.getDirectory();
            lFileNM = lFileDir + fds.getFile();
            lFileTF.setText(lFileNM);
            enableCompareBtn();

        }else if (src == compareBtn) {
            // Check that we have both files
            boolean fndError = false;  // Remember if error
            sFile = new File(sFileNM);
            if (!sFile.exists()) {
                new ErrDialog(this, "File not found: " + sFileNM);
                fndError = true;
            }
            lFile = new File(lFileNM);
            if (!lFile.exists()) {
                new ErrDialog(this, "File not found: " + lFileNM);
                fndError = true;
            }
            if (fndError)
               return;                 // Exit if had error

            inList = InList.getState();
            // Ok go compare them
            doCompare();

        }else if (src == clearTA) {
            outArea.setText("");

        }else {
            System.err.println("Unknown action " + ae);
        }
    }

    public void textValueChanged(TextEvent te) {
       Object src = te.getSource();
       if (src == sFileTF) {
         sFileNM = sFileTF.getText();
       }else if(src == lFileTF) {
         lFileNM = lFileTF.getText();
       }else {
         System.err.println("unknown te " + te);
       }
       enableCompareBtn();
    }

    void enableCompareBtn() {
        compareBtn.setEnabled(!sFileNM.equals("") && !lFileNM.equals(""));
    }

    //--------------------------------------------------------------------------
    // Compare the two files
    void doCompare() {
        // OK, got two good files.  Read and compare them
        if (usePrintln)
            System.out.println("Comparing for: "  + (inList ? "In list" : "Not in list") 
                + "\nShort list:" + sFileNM + " >" + sFile.length() + " bytes\n" 
                + "Long list: " + lFileNM + " >" + lFile.length() + " bytes\n"); 
               

        shortList = new Hashtable();
        try {
            BufferedReader br = new BufferedReader(new FileReader(sFileNM));
            // Read and save the short list in a hashtable
            while ((inLine = br.readLine()) != null) {  
                shortList.put(inLine, "X");
            }
            br.close();

            // Now read the longer list and see if its records are in short list
            br = new BufferedReader(new FileReader(lFileNM));
            int recNbr = 0;         // Record index in long file
            int recCnt = 0;         // Count number of records displayed

            while ((inLine = br.readLine()) != null) {  
                recNbr++;               // assign record number 
                if(shortList.containsKey(inLine)) {
                    if (inList) {
                        recCnt++;       //count
                        if (usePrintln)
                            System.out.println(RAdj(recNbr, 3) + " " + inLine);
                        outArea.append(RAdj(recNbr, 3) + " " + inLine + "\n");
                    }
                }else {
                    if (!inList) {
                        recCnt++;       //count
                        if (usePrintln)
                            System.out.println(RAdj(recNbr, 3) + " " + inLine);
                        outArea.append(RAdj(recNbr, 3) + " " + inLine + "\n");
                    }
                }
            } // end while()

            br.close();
            
            if (usePrintln)
                System.out.println("\n  " + recCnt + " records found of " + recNbr);
            outArea.append("\n  " + recCnt + " records found of " + recNbr);

        }catch(FileNotFoundException fnf) {
            new ErrDialog(this, "File not found " + fnf.getMessage());
        }catch(Exception ex) {
            System.err.println(ex);
        }    
    }  // end doCompare()

    // Right adjust v in l spaces
    String RAdj(int v, int l) {
        String s = Integer.toString(v);
        if(s.length() < l)
            return "      ".substring(0, l-s.length()) + s;
        else
            return s;
    }

    //----------------------------------------
	public static void main(String[] args) {
//        if (args.length != 3)  usage("Invalid args");
        new CmprLists(args);
	}  // end main()

    static void usage(String msg) {
        System.out.println("Usage: java CmprLists [-opt shortList longList]" 
                        + "\n  " + msg);
        try{Thread.sleep(5000);}catch(Exception ex){}   // allow user to see
        System.exit(0);
    }
} // end class CmprLists
