// hacked out of org.cyberiantiger's lovely class object model
//package com.generationjava.lang;

// Modified by NCR to scan Class file byte codes and return a list of classes
// referenced by a class file. Other info available is package name and super

package NormsTools;

import java.util.*;
import java.io.*;

public class ClassFileScanner {

    static final public int MAGIC = 0xCAFEBABE;

    // Define Constant Pool ids:
	static final public byte CLASS = 7;
	static final public byte FIELD_REF = 9;
	static final public byte METHOD_REF = 10;
	static final public byte INTERFACE_METHOD_REF = 11;
	static final public byte STRING = 8;
	static final public byte INTEGER = 3;
	static final public byte FLOAT = 4;
	static final public byte LONG = 5;
	static final public byte DOUBLE = 6;
	static final public byte NAME_AND_TYPE = 12;
	static final public byte UTF8 = 1;


    private String name = null;     //Name of this class (from filename??)

    // Accessor methods:
    public String getName() {
        if (thisClass == null) {
            System.err.println("CFS: thisClass = null");
            return "";
        }
        // Display a message if names don't match
        if (!name.equals(thisClass.toString()))  {
//            System.err.println("CFS: mismatch: name= " + name + " vs " + thisClass
//                                + ", super=" + superClass);
            return thisClass.toString();        // This is correct!
        }
        return this.name;
    }
    public String getSuper() {
        return superClass.toString();
    }

    // Main method: -------------------------------------------------
    /** getReferencedClasses - returns list of referenced classes
    */
    public Vector getReferencedClasses(String classFname) {
        // Save classname stripped of ".class"
        this.name = classFname.substring(0, classFname.length()-6);
        // Convert to dotted notation from path/file format
        this.name = this.name.replace('/','.'); 

        try {
            DataInputStream in = new DataInputStream(new FileInputStream(classFname));
            readFrom(in);               // Read/parse the constant Pool
            resolve();                  // Get names of classes, this and super
            return getClasses();        // Get list of only classes
        } catch(IOException ioe) {
            System.err.println("CFS: Error reading " + classFname);
            ioe.printStackTrace();
        }
        return new Vector();
	}  // end getReferencedClasses()

    public Vector getReferencedClasses(DataInputStream in) {
        try {
            readFrom(in);               // Read/parse the constant Pool
            resolve();                  // Get names of classes, this and super
            name = thisClass.toString();  // Set our classname
            return getClasses();        // Get list of only classes
        } catch(IOException ioe) {
            System.err.println("CFS: Error reading class bytes " + in);
            ioe.printStackTrace();
        }
        return new Vector();
    }  // end getReferencedClasses()


    // Return a list of classes referenced in this class
    private Vector getClasses() {
        Vector list = new Vector();
        Enumeration iterator = constantPool.elements();
        // Find Class (C7) items and return in list
        while(iterator.hasMoreElements()) {
            Object obj = iterator.nextElement();
            if(obj instanceof C7) {
                list.addElement(obj.toString());
            }
        }
        return list;
    } // end getClasses()


    //-------------------------------------------------------------------------
	// Class data
	int        minorVersion;
	int        majorVersion;
	Vector     constantPool;
	int        accessFlags;
	int        this_class;
	Object     thisClass;
	int        super_class;
	Object     superClass;


    //-------------------------------------------------------------------------
    // Read the byte codes and parse/decode into constantPool
	public void readFrom(DataInputStream in) throws IOException {
		if(in.readInt() != MAGIC) throw new IOException("Bad Magic Number");
		minorVersion = in.readUnsignedShort();
		majorVersion = in.readUnsignedShort();
		// check version number
		if(!(majorVersion == 45 || (majorVersion == 46 && minorVersion == 0))){
			throw new IOException("Unsupported version number");
		}
		int length = in.readUnsignedShort();
		constantPool = new Vector(length);
		// Hack
		constantPool.addElement(null);

		for(int i=1; i<length; i++) {
            int rdB = in.readByte();
			switch(rdB) {
			  case CLASS:
			    C7 c7 = new C7();
			    c7.readFrom(in);
			    constantPool.addElement(c7);
			    break;
			  case UTF8:
                C1 c1 = new C1();
			    c1.readFrom(in);
			    constantPool.addElement(c1);
			    break;

                // we ignore all the other possible constants.
                // though we do read the necessary bytes
			  case FIELD_REF:
                in.readUnsignedShort();
                in.readUnsignedShort();
			    constantPool.addElement(null);
			    break;
			  case METHOD_REF:
                in.readUnsignedShort();
                in.readUnsignedShort();
			    constantPool.addElement(null);
			    break;
			  case INTERFACE_METHOD_REF:
                in.readUnsignedShort();
                in.readUnsignedShort();
			    constantPool.addElement(null);
			    break;
			  case STRING:
                in.readUnsignedShort();
			    constantPool.addElement(null);
			    break;
			  case INTEGER:
                in.readInt();
			    constantPool.addElement(null);
			    break;
			  case FLOAT:
                in.readFloat();
			    constantPool.addElement(null);
			    break;
			  case LONG:
                i++;                    // NCR added: LONG takes 2 entries!
                in.readLong();
			    constantPool.addElement(null);
			    constantPool.addElement(null); // NCR added: LONG takes 2 entries!
			    break;
			  case DOUBLE:
                i++;                    // NCR added: DOUBLE takes 2 entries!
                in.readDouble();
			    constantPool.addElement(null);
			    constantPool.addElement(null); // NCR added: DOUBLE takes 2 entries!
			    break;
			  case NAME_AND_TYPE:
                in.readUnsignedShort();
                in.readUnsignedShort();
			    constantPool.addElement(null);
			    break;
			  default:
				throw new IOException("Invalid Constant Found " + rdB 
                        + " at " + i + " of " + length);
			}
		}
        // various bits of class info
        accessFlags = in.readUnsignedShort();
        this_class = in.readUnsignedShort();
        super_class = in.readUnsignedShort(); 

        // STOP HERE. Class has more data, we don't care.
        in.close();                     // Finished with Input
	}

    //-------------------------------------------------------------------------
    // Set names for classes(C7) and for this and super
	public void resolve() {
		Enumeration i = constantPool.elements();
		// skip first value coz it's null
		i.nextElement();
		while(i.hasMoreElements()) {
			Object obj = i.nextElement();
            if(obj instanceof C7) {
                // Process Class item - Set its name
                ((C7)obj).resolve();
            }
		}

        // Now get names for this class and its super
		if(this_class == 0 || this_class >= constantPool.size() ||
		   super_class == 0 || super_class >= constantPool.size() ) {
			throw new RuntimeException("Invalid Constant Pool Reference");
		}
        // Get this class's object
		Object ob = constantPool.elementAt(this_class);
		if(!(ob instanceof C7) ) {
			throw new RuntimeException("Wrong type of object at reference in constant pool");
		}
		thisClass = (C7) ob;
        // Get super class's object
		ob = constantPool.elementAt(super_class);
		if(!(ob instanceof C7) ) {
			throw new RuntimeException("Wrong type of object at reference in constant pool");
		}
		superClass = (C7) ob;
	} // end resolve()


    //-------------------------------------------------------------------------
    // Parse UTF8 - Strings
	class C1 {
		String value;
		C1() {}
		C1(String value) {
			this.value = value;
		}
		public byte getType() { return UTF8; }
		public String getValue() { return value; }

		public void readFrom(DataInputStream in) throws IOException {
			value = in.readUTF();
		}
		public boolean equals(Object obj) {
			return (obj instanceof C1) && ((C1)obj).value.equals(value);
		}
		public int hashCode() { return value.hashCode(); }
		public String toString() { return value; }
	} // end class C1

    //-------------------------------------------------------------------------
    // Parse Class items
	class C7 {
		int index;
		C1 name;
		public byte getType() { return CLASS; }
		public C1 getClassName() { return name; }

		public void readFrom(DataInputStream in) throws IOException {
			index = in.readUnsignedShort();
		}
		public void resolve() {
			if(index == 0) {
				throw new RuntimeException("Invalid Constant Pool Reference: "
                                                    +index);
			}
            if(index >= constantPool.size()) {
				throw new RuntimeException("Invalid Constant Pool Reference: "
                                                +index + "/" + constantPool.size());
			}
			Object ob = constantPool.elementAt(index);
			if( !(ob instanceof C1) ) {
				throw new RuntimeException(
                            "Wrong type of object at reference in constant pool");
			}
			name = (C1) ob;              // Set the name
		}

		public boolean equals(Object obj) {
			return (obj instanceof C7) && ((C7)obj).name.equals(name);
		}
		public int hashCode() { return name.hashCode(); }
		public String toString() { return name.toString().replace('/','.');}
	} // end class C7

    //----------------------------------------------------------------------
    // Following for Testing ???
	static public void main(String[] args) throws Throwable {
		ClassFileScanner c = new ClassFileScanner();
        System.err.println(c.getReferencedClasses(args[0]));
        System.out.println("CFS: Name=" + c.getName() + ", super=" + c.getSuper());
    } // end main()

} // end class ClassFileScanner
