// ChoiceOfYesOrNo.java
// Present dialog with message and get a response

//  Changes:
// 5/29/01 - Changed toFront() to WindowListener
// 1/11/01 - Added Color to Constructor
// 11/14/01 - Center on screen if won't center over ...

package NormsTools;  // = name of subdirectory containing this file

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class ChoiceOfYesOrNo extends Dialog implements ActionListener {
   Button   yes,
            no;
   Panel    p1, ques;
   int      lng = 0,
            nLines = 1,
            ht = 80;                     // Default/minimum
   String   LStr = "";
   Label    msgLbl;

   boolean  yesAnswer = false;
   boolean  done = false;               // control thread

   //--- Constructors ---------------------
   public ChoiceOfYesOrNo(Frame parent, String text) {
      this(parent, text, null);
   }
   public ChoiceOfYesOrNo(Frame parent, String text, Color textC) {
      super(parent, "Please reply", true);

      ques = new Panel();
      ques.setFont(new Font("Monospaced", Font.PLAIN, 12));
      if(text.indexOf("\n") > 0) {
        StringTokenizer tok = new StringTokenizer(text, "\n");
        ques.setLayout(new GridLayout(tok.countTokens(), 1));
        nLines = tok.countTokens();
        // Multiple labels, one for each line
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.length() > lng) { 
                lng = str.length();     // Save longest
                LStr = str;
            }
            msgLbl = new Label(str){
                // Add some space around the text   
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    System.out.println("getP..Size: " + d);
                    return new Dimension(d.width+20, d.height+8);
                }
            };
            if (textC != null)
               msgLbl.setForeground(textC);
            ques.add(msgLbl);
        } // end while()
      
      }else {
          // Define the components of our display:
          msgLbl = new Label(text, Label.CENTER) {
             // this adds some space around the text
             public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width+20, d.height+8);
             }
          };
          if (textC != null)
             msgLbl.setForeground(textC);
          ques.add(msgLbl);
          LStr = text;
      }

      // Compute size needed
      FontMetrics fm = getFontMetrics(ques.getFont());
      lng = fm.stringWidth(LStr) + 40;
      ht += fm.getHeight()*nLines;

      p1 = new Panel();
      yes  = new Button("Yes");
      yes.addKeyListener(new MakeEnterDoAction());
      yes.addActionListener(this);
      p1.add(yes);
      no = new Button("No");
      no.addActionListener(this);
      no.addKeyListener(new MakeEnterDoAction());
      p1.add(no);

      setLayout(new BorderLayout()); 
      add(ques, BorderLayout.CENTER);
      add(p1, BorderLayout.SOUTH);
//      pack();

      addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent we) {
            // NB. Listener IGNORED when code placed below after setVisible() ???
//            System.out.println("Window closing");
            setVisible(false);          // done
            done = true;                // tell thread
            dispose();
         }
        // Keep our window on top
        public void windowDeactivated(WindowEvent we) {
            if (!done)
                toFront();
        }
      });

      setSize(lng, ht);

      // compute location ???
      try {
         Point p = parent.getLocation();
         Dimension d = parent.getSize();
//         System.out.println(p + " " + d);
         if (d.height > ht && d.width > lng) {
             setLocation(p.x +(d.width-lng)/2, p.y+(d.height-ht)/2);
         }else {
             // Otherwise center on screen
             Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
             setLocation((ss.width-getBounds().width)/2, 
                         (ss.height-getBounds().height)/2);  
         }
      }catch (Exception e) {} 
 
//      (new Thread(this)).start();     // start toFront() calls on thread

      setVisible(true);       // show the box

   } // end constructors -----------------------------------------

    // Trap button pushed
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if(src == yes) {
            yesAnswer = true;            
        }else if (src == no) {
            yesAnswer = false;
        }

        setVisible(false);          // done
        done = true;                // tell thread
        dispose();
   } // end actionPerformed()     

   public boolean isYes() {
      return yesAnswer;
   }


   //----------------------------------------------------------------
   //  Following for testing: ----------------
/*   public static void main(String args[]) {
     Frame aFrame = new Frame();
     aFrame.setFont(new Font("Monospaced", Font.PLAIN, 12));
     aFrame.setLocation(400, 300);
     ChoiceOfYesOrNo cyn = new ChoiceOfYesOrNo(aFrame, "Continue with this problem?", Color.red);
     System.out.println("Answer: " + (cyn.isYes() ? "Yes" : "NO"));

     cyn = new ChoiceOfYesOrNo(aFrame, "Save the output file?\n or copy it?\n"
                   + "  or just don't do anything until you're sure\n"
                   + " in which case these extra lines will be\n"
                   + " ok or maybe not", Color.blue);
     System.out.println("Answer: " + (cyn.isYes() ? "Yes" : "NO"));

     aFrame.dispose();     // get rid of Frames peer stuff
     System.exit(0);
   } // */
}
