// ChangeDate.java = Change a file's date

package NormsTools;

import java.awt.*;
import java.awt.event.*;
import java.text.*;
import java.util.*;
import java.io.*;

public class ChangeDate extends Frame implements ActionListener, TextListener {

   final String   DateFMT = "MM/dd/yyyy hh:mm:ss a";

   MenuBar     mBar = new MenuBar();
   Menu        fM = new Menu("File");
   MenuItem    openMI = new MenuItem("Open...");
   MenuItem    exitMI = new MenuItem("Exit");

   TextField   fnTF = new TextField(60);
   TextField   dateTF = new TextField(40);
   TextField   newDateTF = new TextField(40);
   Button      changeBtn = new Button("Change the Date");

   File        theFile;
   String      lastDir = "";

   SimpleDateFormat  sdf = new SimpleDateFormat(DateFMT);

   //  Constructor --------------------------------
   public ChangeDate(String[] args) {
      super("Change a file's last modified date");

      addWindowListener(new WindowAdapter() {
         public void windowClosing(WindowEvent we) {
            System.exit(0);
         }
      });

      // Build GUI
      setBackground(new Color(255, 0, 80));
      openMI.addActionListener(this);
      fM.add(openMI);
      exitMI.addActionListener(this);
      fM.add(exitMI);
      mBar.add(fM);
      setMenuBar(mBar);

      setLayout(new BorderLayout());
      Panel topPnl = new Panel();
      topPnl.setLayout(new BorderLayout());
      Panel topPnlA = new Panel();
         topPnlA.setLayout(new FlowLayout(FlowLayout.LEFT));
         topPnlA.add(new Label("Filename:"));
         topPnlA.add(fnTF);
      topPnl.add(topPnlA, BorderLayout.NORTH);
      Panel topPnlB = new Panel();
         topPnlB.setLayout(new FlowLayout(FlowLayout.LEFT));
         topPnlB.add(new Label("Current Date:"));
         dateTF.setEditable(false);    // Show only
         topPnlB.add(dateTF);
      topPnl.add(topPnlB, BorderLayout.CENTER);
      add(topPnl, BorderLayout.NORTH);
     
      Panel cntrPnl = new Panel();
      cntrPnl.setLayout(new FlowLayout(FlowLayout.LEFT));
      cntrPnl.add(new Label("New date:"));
      cntrPnl.add(newDateTF);
      newDateTF.addTextListener(this);
      newDateTF.setEditable(false);
      add(cntrPnl, BorderLayout.CENTER);

      Panel btmPnl = new Panel();
      btmPnl.add(changeBtn);
      changeBtn.setEnabled(false);     // Not until a file
      changeBtn.addActionListener(this);
      add(btmPnl, BorderLayout.SOUTH);
      pack();

      // Center frame
      Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
      setLocation((ss.width-getBounds().width)/2, 
                   (ss.height-getBounds().height)/2);  

      show();
   } // end Constructor

   // Trap menuitems and button pushes 
   public void actionPerformed(ActionEvent ae) {
      Object src = ae.getSource();

      if (src == openMI) {
         FileDialog fd = new FileDialog(this, "Chose file", FileDialog.LOAD);
         fd.setDirectory(lastDir);
         fd.show();                    // Block waiting for user's response
         fd.dispose();
         String fn = fd.getFile();
         lastDir = fd.getDirectory();
         if (fn == null || fn.equals(""))
             return;                 // Cancelled

         theFile = new File(lastDir+fn);
         Date fDate = new Date(theFile.lastModified());
         dateTF.setText(sdf.format(fDate));

         // Make some tests
         if (!theFile.exists()) {
            new ErrDialog(this, "File not found");
            return;
         }

         fnTF.setText(lastDir+fn);
         newDateTF.setEditable(true);
         changeBtn.setEnabled(!newDateTF.getText().trim().equals(""));      // Ok

      }else if(src == changeBtn) {
         // Change the date
         ParsePosition  pos = new ParsePosition(0);
         Date newDate = sdf.parse(newDateTF.getText().trim(), pos);
         if(newDate == null) {
            new ErrDialog(this, "Invalid date. Format must be: " + DateFMT);
            return;
         }
         try {
            if(!theFile.setLastModified(newDate.getTime())) {
               new ErrDialog(this, "Error changing date of " + theFile);
            }else {
               new ShowMsgBox(this, "Successful date change", "File: " + theFile 
                        + "\n  date was changed to \n" + sdf.format(newDate));
            }
         }catch(NoSuchMethodError nsme) {
            nsme.printStackTrace();
            new ErrDialog(this, "Error changing date of " + theFile 
                           + "\n Need newer version of Java");
         }catch(Exception ex) {
            ex.printStackTrace();
            new ErrDialog(this, "Error changing date of " + theFile);
         }
         changeBtn.setEnabled(false);

      }else if(src == exitMI) {
         System.exit(0);               // Exit program

      }else{
         System.out.println("a..P.. unknown ae " + ae);
      }
   }  // end actionPerformed()

   //--------------------------------------------
   // Trap text changes in TextFields
   public void textValueChanged(TextEvent te) {
      Object src = te.getSource();
      if (src == newDateTF) {
/*   Problem here - Need to wait until user is done changing!
         System.out.println("New date: >" + newDateTF.getText().trim() + "<");
         ParsePosition  pos = new ParsePosition(0);
         Date newDate = sdf.parse(newDateTF.getText().trim(), pos);
         if(newDate == null) {
            new ErrDialog(this, "Invalid date. Format must be: " + DateFMT);
            return;
         } */
         changeBtn.setEnabled(!newDateTF.getText().trim().equals(""));      // Ok

      } else {
         System.err.println("t..V..C.. unknown te " + te);
      }
   }  // end textValueChanged()

   //-------------------------------------------
	public static void main(String[] args) {
      new ChangeDate(args);
	}
} // end class ChangeDate