// AskMultipleChoices.java
// Present dialog with message and get a response

package NormsTools;  // = name of subdirectory containing this file

import java.awt.*;
import java.awt.event.*;
import java.util.*;

public class AskMultipleChoices extends Dialog implements ActionListener, Runnable {
   Button   cancelB = new Button("Cancel");
   Button[] choices; 
   Panel    p1, 
            ques;
   int  lng = 0,
        nLines = 1,
        ht = 80;
        // Default/minimum
   String LStr = "";

   public static final int    Cancelled = -1;   // User cancelled request
   private int          answer = Cancelled;     // index to selected button
   boolean              done = false;           // controls thread (toFront)

   /** Ask a question with multiple answers:
   *  @param - parent Frame for Dialog
   *  @param - title  the Title
   *  @param - text   The question to ask
   *  @param - butNms An array of button labels
   */
   //--- Constructor ---------------------
   public AskMultipleChoices(Frame parent, String title, String text,
                                    String[] butNms) {
      super(parent, title, true);

      ques = new Panel();
      ques.setFont(new Font("Monospaced", Font.PLAIN, 12));
      if(text.indexOf("\n") > 0) {
        StringTokenizer tok = new StringTokenizer(text, "\n");
        ques.setLayout(new GridLayout(tok.countTokens(), 1));
        nLines = tok.countTokens();
        while (tok.hasMoreTokens()) {
            String str = tok.nextToken();
            if (str.length() > lng) { 
                lng = str.length();     // Save longest
                LStr = str;
                }
            ques.add(new Label(str){
                // Add some space around the text   
                public Dimension getPreferredSize() {
                    Dimension d = super.getPreferredSize();
                    System.out.println("getP..Size: " + d);
                    return new Dimension(d.width+20, d.height+8);
                }
            });
        } // end while()
      
      }else {
          // Define the components of our display:
          Label lab = new Label(text, Label.CENTER) {
             // this adds some space around the text
             public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                return new Dimension(d.width+20, d.height+8);
             }
          };
          ques.add(lab);
          LStr = text;
      }

      // Compute size needed
      FontMetrics fm = getFontMetrics(ques.getFont());
      lng = fm.stringWidth(LStr) + 40;
      ht += fm.getHeight()*nLines;

      // Build buttons panel
      p1 = new Panel();
      choices = new Button[butNms.length];
      for(int i=0; i < butNms.length; i++) {
        choices[i]  = new Button(butNms[i]);
        choices[i].addKeyListener(new MakeEnterDoAction());
        choices[i].addActionListener(this);
        p1.add(choices[i]);
      }
      cancelB.addActionListener(this);
      cancelB.addKeyListener(new MakeEnterDoAction());
      p1.add(cancelB);

      setLayout(new BorderLayout()); 
      add(ques, BorderLayout.CENTER);
      add(p1, BorderLayout.SOUTH);
//      pack();

      setSize(lng, ht);

      // compute location ???
      try {
         Point p = parent.getLocation();
         Dimension d = parent.getSize();
//         System.out.println(p + " " + d);
         if (d.height > ht && d.width > lng) {
             setLocation(p.x +(d.width-lng)/2, p.y+(d.height-ht)/2);
         }else {
             setLocation(100, 100);
         }
      }catch (Exception e) {} 
 
      (new Thread(this)).start();     // start toFront() calls on thread

      setVisible(true);       // show the box

      // Trap and react to some Window events
      addWindowListener(new WindowAdapter() {
         public void windowClosing(WindowEvent we) {
            System.out.println("Window closing");       // ??? IGNORED
            setVisible(false);          // done
            done = true;                // tell thread
            dispose();
         }
         public void windowDeactivated(WindowEvent we) {
            if (!done)
                toFront();
         }
      });
   } // end constructor

    // Trap button pushed
    public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
        if(src == cancelB) { 
            answer = Cancelled;

        } else {
            for(int i = 0; i < choices.length; i++) {
                if (src == choices[i]) {
                    answer = i;         // Save index to button as answer
                    break;
                }
            }
        }

        setVisible(false);          // done
        done = true;                // tell thread
        dispose();
   } // end actionPerformed()     

   /**  Returns index of selected button, or -1 if cancelled
   */
   public int getAnswer() {
      return answer;
   }

  // Keep the dialog window on top!
  public void run() {
    while (true) {  // forever loop
        try {
            if (done)  return;          // exit if done
            toFront();
            Thread.sleep(300);
        }catch(Exception ex){
            ex.printStackTrace();
        }
    }  // end forever loop
  }  // end run()


   //----------------------------------------------------------------
   //  Following for testing: Comment out when done  ----------------
/*   public static void main(String args[]) {
     Frame aFrame = new Frame();
     aFrame.setFont(new Font("Monospaced", Font.PLAIN, 12));
     aFrame.setLocation(400, 300);
     AskMultipleChoices amc = new AskMultipleChoices(aFrame, "Chose an answer",
            "Continue with this problem?", new String[]{"Yes", "No", "Maybe"});
     System.out.println("Answer: " + (amc.getAnswer() == 0 ? "Yes" : "NO"));

     amc = new AskMultipleChoices(aFrame, "Another choice", 
                    "Save the output file?\n or copy it?\n"
                   + "  or just don't do anything until you're sure\n"
                   + " in which case these extra lines will be\n"
                   + " ok or maybe not", new String[]{"Yes", "?"});
     System.out.println("Answer: " + (amc.getAnswer() == 0 ? "Yes" : "NO"));

     aFrame.dispose();     // get rid of Frames peer stuff
     System.exit(0);
   } // */
}
