//  ArrayUtil.java
// Miscellaneous utilitly methods for arrays

package NormsTools;  // = name of subdirectory containing this file
 
public class ArrayUtil {
  final static boolean     Testing = true;   // Debugging output control

  //-----------------------------------------------------------------
  // Move thisitem in front of before
  public static void moveBefore(Object[] a, int thisitem, int before) {
    // Two cases:  thisitem is above before (thisitem < before) ==> move up 
    // and thisitem below before (thisitem > before) ==> move down
    
    if (Testing) System.out.println("Moving: " + thisitem 
                                     + " before " + before);
    
    if (thisitem < before - 1) {       // move elements up over thisitem   
      Object temp = a[thisitem];       // save
      if (Testing) System.out.println("Saving: " + temp);
      for (int i = thisitem; i < (before - 1); i++) {
        try {
          a[i] = a[i + 1];              // move elements up
        } catch(Exception e) {
          System.out.println("OutofBnds i: " + i);
          return;
        }
      }  
      a[before - 1] = temp;           // now insert thisitem in its place
    } 
    else if (thisitem > before) {    // move elements down over thisitem
      Object temp = a[thisitem];     // save
      if (Testing) System.out.println("Saving: " + temp);
      for (int i = (thisitem - 1); i >= before; i--) {
        try {    
          a[i + 1] = a[i];             // move elements down
        } catch(Exception e) {
          System.out.println("OutOfBnds i: " + i); 
          return;
        }
      }  
      a[before] = temp;
    }    
    else {  // error condition ??/
      System.err.println("Invalid move " + thisitem + " " + before);
   }  
  }  // end moveBefore
  
} // end class ArrayUtil 
