// Define an applet that will load another applet



/*  AppletLoader.java
  <APPLET CODE="AppletLoader.class" NAME="QLoader" HEIGHT=200 WIDTH=200>
  <PARAM NAME="appletToLoad" VALUE="SecondApplet">
  <PARAM NAME="SecondAppletParm" VALUE="Hello World">
  </APPLET>
*/
import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.*;

/** Define an applet to load another applet<BR>
*  It displays a message while the other applet is loading
*/

public class AppletLoader extends Applet implements Runnable, AppletStub {
    String  appletToLoad;
    Thread  appletThread;
    Applet  realApplet;
    Dimension ourSize;
    boolean done = false;

    // Define where to paint our message
    int xPos = -1, 
        yPos = -1,
        yIncr = -1,
        yStart = 30,
        yMax = 0;

    Font pFont = new Font("TimesRoman", Font.ITALIC, 20);


    String msg = "Loading ...";

    public void init() {
      appletToLoad = getParameter("appletToLoad");
      msg = "Loading " + appletToLoad;
      setBackground(Color.white);
      System.out.println("Size:" + getSize());
      new MoveLetters();
    }

    // Put up a message while the applet is being loaded
    public void paint(Graphics g) {
        ourSize = getSize();
        g.setFont(pFont);
        if (yIncr < 0) {
            // Get starting pos and center text
            FontMetrics fm = g.getFontMetrics();
            int w = fm.stringWidth(msg);
            xPos = (ourSize.width - w)/2;
            yStart = yPos = fm.getHeight() + 30;
            yIncr = fm.getHeight();
            yMax = ourSize.height - yIncr;
        }else {
            yPos += yIncr;
            if (yPos > yMax)
                yPos = yStart;
        }
        g.setColor(Color.blue);       // of text  
        g.drawString(msg, xPos, yPos);
    } 

    //  Do some things and then start a thread to load the real applet 
    public void start() {
      repaint();
      try {
//          resize(400, 400);
          repaint();
      }catch(Exception e){
        System.err.println("AppletLoader got ex " + e);
      }
      // Create a thread to load the next applet
      appletThread = new Thread(this);
      appletThread.start();
    } // end start()

    // Try to load the applet and get it started
    public void run() {
      try {
        Class appletClass = Class.forName(appletToLoad);
        realApplet = (Applet)appletClass.newInstance();
        realApplet.setStub(this);
        done = true;

        // Place new applet right on top of us
        setLayout(new GridLayout(1,0));
        add(realApplet);
        // Start the new applet
        realApplet.init();
        realApplet.start();

      }catch (ClassNotFoundException cnf) {
        msg = appletToLoad + " not Found";
        setBackground(Color.red);
        repaint();
        done = true;

      }catch (Exception e) {
        System.out.println("run() got ex: " + e);
        setBackground(Color.red);
        msg = e.toString();
        repaint();
        done = true;
      }

      // Make sure GUI is ok
      validate();
    } // end run()

    public void stop() {
        if (realApplet != null)
            realApplet.stop();
        if (appletThread != null)
            appletThread.stop();   
        appletThread = null;
    }

    public void appletResize( int width, int height ){
        System.out.println("resize to: " + width +","+height);
//        resize(width, height);
    }

    // Define an inner class to call repaint() to move text
    class MoveLetters implements Runnable {
        // Constructor to start the thread
        MoveLetters() {
            new Thread(this).start();
        }

        public void run() {
            while(true) {
                if (done) 
                    return;
                repaint();
                try {Thread.sleep(500);}catch(Exception e){}
            }
        }
    }  // end class MoveLetters
} // end class