/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;

public final class GetURLText
extends Frame
implements ActionListener,
ItemListener {
    private static final String Title = "GetURLText Application - 28 Feb 2002";
    MenuBar mb = new MenuBar();
    Menu fileM = new Menu("File");
    MenuItem getFilesFM = new MenuItem("Get files...");
    Menu editM = new Menu("Edit");
    Menu helpM = new Menu("Help");
    MenuItem aboutHM = new MenuItem("About");
    MenuItem topicsHM = new MenuItem("Topics");
    TextArea textArea;
    TextField urlTF = new TextField("http://localhost:8080", 60);
    TextField postTF = new TextField("", 60);
    TextField cookieTF = new TextField("", 60);
    Button getBtn;
    Button stopBtn;
    private Button clearTA = new Button("Clear");
    Checkbox useCookie = new Checkbox("Send cookie");
    private CheckboxGroup cbg = new CheckboxGroup();
    private Checkbox useURLConn = new Checkbox("URLConnection", this.cbg, true);
    Checkbox useSocket = new Checkbox("Socket", this.cbg, false);
    Checkbox doPost = new Checkbox("do Post");
    Thread getThread;
    String cookieValue = "User=Norm";
    String lastDir = System.getProperty("user.dir");
    boolean debug = false;

    public GetURLText(String[] stringArray) {
        super(Title);
        if (stringArray.length > 0) {
            this.useSocket.setState("Socket".equalsIgnoreCase(stringArray[0]));
        }
        this.fileM.add(this.getFilesFM);
        this.getFilesFM.addActionListener(this);
        this.mb.add(this.fileM);
        this.setMenuBar(this.mb);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        panel2.add(new Label("URL:"));
        panel2.add(this.urlTF);
        this.urlTF.addActionListener(this);
        panel.add((Component)panel2, "North");
        Panel panel3 = new Panel();
        panel3.setLayout(new BorderLayout());
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(0));
        this.doPost.addItemListener(this);
        panel4.add(this.doPost);
        this.postTF.setEditable(false);
        panel4.add(this.postTF);
        panel3.add((Component)panel4, "North");
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout(0));
        this.useCookie.addItemListener(this);
        panel5.add(this.useCookie);
        panel5.add(this.cookieTF);
        panel3.add((Component)panel5, "Center");
        panel.add((Component)panel3, "Center");
        Panel panel6 = new Panel();
        this.getBtn = new Button("Read from URL");
        this.getBtn.addActionListener(this);
        panel6.add(this.getBtn);
        this.stopBtn = new Button("Stop");
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        panel6.add(this.stopBtn);
        this.clearTA.addActionListener(new ActionListener(){
            {
                GetURLText.this.getClass();
            }

            public void actionPerformed(ActionEvent actionEvent) {
                GetURLText.this.textArea.setText("");
            }
        });
        panel6.add(this.clearTA);
        this.useURLConn.addItemListener(this);
        panel6.add(this.useURLConn);
        this.useSocket.addItemListener(this);
        panel6.add(this.useSocket);
        panel.add((Component)panel6, "South");
        this.add((Component)panel, "North");
        ((Component)this).setBackground(new Color(29, 141, 143));
        this.textArea = new TextArea(20, 80);
        this.textArea.setEditable(false);
        this.add((Component)this.textArea, "Center");
        this.addWindowListener(new WindowAdapter(){
            {
                GetURLText.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((dimension.width - this.getBounds().width) / 2, (dimension.height - this.getBounds().height) / 2);
        this.show();
        this.showSetting();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.doPost) {
            this.postTF.setEditable(this.doPost.getState());
        } else if (object == this.useCookie) {
            this.cookieTF.setEditable(this.useCookie.getState());
        } else {
            this.showSetting();
        }
    }

    private void getSaveFile(String string, String string2) {
        if (string2.indexOf("?") >= 0 || string2.indexOf(58) > 0 || string2.indexOf(46) < 0) {
            System.out.println("Skipping " + string2);
            return;
        }
        URL uRL = null;
        try {
            Object object;
            Object object2;
            int n;
            uRL = new URL(this.urlTF.getText() + "/" + string2);
            if (!string2.equals(uRL.getFile())) {
                // empty if block
            }
            string2 = string2.replace('/', File.separatorChar);
            File file = new File(string + string2);
            if (file.exists()) {
                FileDialog fileDialog = new FileDialog((Frame)this, "File exists. Change name or overwrite?", 1);
                fileDialog.setFile(string2);
                fileDialog.setDirectory(string);
                fileDialog.show();
                string2 = fileDialog.getFile();
                file = new File(fileDialog.getDirectory() + fileDialog.getFile());
            }
            if ((n = string2.lastIndexOf(File.separator)) > 0) {
                object2 = string2.substring(0, n);
                object = new File(string + (String)object2);
                ((File)object).mkdirs();
            }
            object2 = new FileOutputStream(file);
            object = uRL.openConnection();
            InputStream inputStream = ((URLConnection)object).getInputStream();
            byte[] byArray = new byte[4096];
            this.textArea.append("Copying " + string2 + " ... ");
            int n2 = inputStream.read();
            if (n2 == 10) {
                System.out.println("Lost first char =" + n2);
            } else {
                ((FileOutputStream)object2).write(n2);
            }
            while ((n2 = inputStream.read(byArray)) > -1) {
                ((FileOutputStream)object2).write(byArray, 0, n2);
            }
            ((FileOutputStream)object2).close();
            inputStream.close();
            this.textArea.append(" done\n");
        }
        catch (Exception exception) {
            System.out.println("Exception trying to download " + string2 + " from " + this.urlTF.getText());
            this.textArea.append("getSaveFile: " + exception + "\n");
        }
    }

    public static void main(String[] stringArray) {
        new GetURLText(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.getBtn || object == this.urlTF) {
            if (this.doPost.getState() && this.postTF.getText().trim().equals("")) {
                this.textArea.append("Post requires data. Please enter.\n");
                this.doPost.requestFocus();
                return;
            }
            if (this.useCookie.getState() && this.cookieTF.getText().trim().equals("")) {
                this.textArea.append("Use cookies requires data. Please enter.\n");
                this.cookieTF.requestFocus();
                return;
            }
            this.cookieValue = this.cookieTF.getText();
            this.getThread = new Thread(new Runnable(){
                {
                    GetURLText.this.getClass();
                }

                public void run() {
                    GetURLText.this.getBtn.setEnabled(false);
                    try {
                        ConnectionReader connectionReader = null;
                        connectionReader = GetURLText.this.useSocket.getState() ? new SocketConnectionReader(GetURLText.this.urlTF.getText()) : new URLConnectionReader(GetURLText.this.urlTF.getText());
                        GetURLText.this.textArea.append(connectionReader.getReply());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("URL FNFex: " + fileNotFoundException);
                        GetURLText.this.textArea.append("FileNotFound Exception: " + fileNotFoundException.getMessage() + "\n");
                        fileNotFoundException.printStackTrace();
                    }
                    catch (IOException iOException) {
                        System.err.println("URL IOex: " + iOException);
                        GetURLText.this.textArea.append("IO Exception: " + iOException.getMessage() + "\n");
                        iOException.printStackTrace();
                    }
                    catch (Exception exception) {
                        System.err.println("Error: " + exception);
                        GetURLText.this.textArea.append(exception.getMessage() + "\n");
                        exception.printStackTrace();
                    }
                    GetURLText.this.getBtn.setEnabled(true);
                    GetURLText.this.stopBtn.setEnabled(false);
                    GetURLText.this.getThread = null;
                }
            });
            this.stopBtn.setEnabled(true);
            this.getThread.start();
        } else if (object == this.stopBtn) {
            if (this.getThread != null) {
                this.getThread.interrupt();
            }
        } else if (object == this.getFilesFM) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Select target folder", 1);
            fileDialog.setFile("Press 'SAVE' when in target folder");
            fileDialog.setDirectory(this.lastDir);
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            this.getFilesFM.setEnabled(false);
            this.getBtn.setEnabled(false);
            this.lastDir = fileDialog.getDirectory();
            if (!this.lastDir.endsWith(File.separator)) {
                this.lastDir = this.lastDir + File.separator;
            }
            this.getThread = new Thread(new Runnable(){
                {
                    GetURLText.this.getClass();
                }

                public void run() {
                    GetURLText.this.getFiles(GetURLText.this.lastDir);
                    GetURLText.this.getBtn.setEnabled(true);
                    GetURLText.this.getFilesFM.setEnabled(true);
                    GetURLText.this.stopBtn.setEnabled(false);
                    GetURLText.this.getThread = null;
                }
            });
            this.stopBtn.setEnabled(true);
            this.getThread.start();
        } else {
            System.out.println("unknown ae " + actionEvent);
        }
    }

    private void showSetting() {
        this.textArea.append("   >>>>>> Using " + (this.useSocket.getState() ? "Socket" : "URLConnection") + " <<<<<<\n");
    }

    void getFiles(String string) {
        String string2 = this.textArea.getText();
        if (string2.length() < 20) {
            return;
        }
        int n = 0;
        int n2 = string2.indexOf("<A", n) + 1;
        if (n2 < 1 && (n2 = string2.indexOf("<a", n) + 1) < 1) {
            return;
        }
        try {
            CharArrayReader charArrayReader = new CharArrayReader(string2.toCharArray());
            StreamTokenizer streamTokenizer = new StreamTokenizer(charArrayReader);
            streamTokenizer.quoteChar(34);
            streamTokenizer.wordChars(95, 95);
            streamTokenizer.wordChars(36, 36);
            charArrayReader.skip(n2);
            charArrayReader.mark(string2.length());
            n = n2 + 2;
            block8: while (true) {
                int n3 = streamTokenizer.nextToken();
                switch (n3) {
                    case -1: {
                        continue block8;
                    }
                    case -3: {
                        if (streamTokenizer.sval.equalsIgnoreCase("A")) {
                            n3 = streamTokenizer.nextToken();
                            if (n3 == -3 && streamTokenizer.sval.equalsIgnoreCase("HREF") && (n3 = streamTokenizer.nextToken()) == 61) {
                                n3 = streamTokenizer.nextToken();
                                if (n3 == 34) {
                                    this.getSaveFile(string, streamTokenizer.sval);
                                } else if (n3 == -3) {
                                    this.getSaveFile(string, streamTokenizer.sval);
                                }
                            }
                        } else {
                            System.err.println("We're lost expected 'A' and got '" + streamTokenizer.sval + "'");
                        }
                        n2 = string2.indexOf("<A", n) + 1;
                        if (n2 < 1 && (n2 = string2.indexOf("<a", n) + 1) < 1) {
                            return;
                        }
                        charArrayReader.reset();
                        charArrayReader.skip(n2 - n + 2);
                        charArrayReader.mark(string2.length());
                        n = n2 + 2;
                        continue block8;
                    }
                    case 34: {
                        System.out.println("quoted string: " + streamTokenizer.sval);
                        continue block8;
                    }
                    case 61: {
                        System.out.println(" equal sign");
                        continue block8;
                    }
                }
                System.out.println("Unprocessed token " + (char)n3 + "   ");
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    abstract class ConnectionReader {
        StringBuffer resp;
        protected final String CRLF = "\r\n";

        ConnectionReader() {
            GetURLText.this.getClass();
            this.resp = new StringBuffer(20000);
            this.CRLF = "\r\n";
        }

        public String getReply() {
            return this.resp.toString();
        }
    }

    class URLConnectionReader
    extends ConnectionReader {
        public URLConnectionReader(String string) throws Exception {
            String string2;
            Object object;
            Closeable closeable;
            GetURLText.this.getClass();
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.resp.append(exception + "\n");
                return;
            }
            if (GetURLText.this.debug) {
                System.out.println("Using URL: " + uRL);
            }
            URLConnection uRLConnection = uRL.openConnection();
            if (GetURLText.this.useCookie.getState()) {
                uRLConnection.setRequestProperty("Cookie", GetURLText.this.cookieValue);
            }
            if (GetURLText.this.doPost.getState()) {
                uRLConnection.setDoOutput(true);
                closeable = new DataOutputStream(uRLConnection.getOutputStream());
                ((DataOutputStream)closeable).writeBytes(GetURLText.this.postTF.getText());
                ((FilterOutputStream)closeable).close();
            }
            closeable = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            int n = 0;
            while ((object = uRLConnection.getHeaderField(n)) != null) {
                String string3 = uRLConnection.getHeaderFieldKey(n);
                if (string3 != null && !string3.equals("")) {
                    this.resp.append("hdr> " + string3 + ": " + (String)object + "\n");
                }
                ++n;
            }
            object = Thread.currentThread();
            while ((string2 = ((BufferedReader)closeable).readLine()) != null) {
                this.resp.append(string2);
                this.resp.append("\n");
                if (((Thread)object).isInterrupted()) break;
            }
            ((BufferedReader)closeable).close();
        }
    }

    class SocketConnectionReader
    extends ConnectionReader {
        private String hostName;
        private int hostPort;
        private String reqFile;

        public SocketConnectionReader(String string) {
            Object object;
            Object object2;
            GetURLText.this.getClass();
            this.hostName = "";
            this.reqFile = "";
            try {
                object2 = new URL(string);
                this.hostName = ((URL)object2).getHost();
                this.hostPort = ((URL)object2).getPort();
                if (this.hostPort == -1) {
                    this.hostPort = string.startsWith("http://") ? 80 : (string.startsWith("ftp://") ? 21 : 80);
                }
                this.reqFile = ((URL)object2).getFile();
                if (this.reqFile.equals("")) {
                    this.reqFile = "/";
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.resp.append(exception.getMessage() + "\n");
                return;
            }
            object2 = "";
            if (GetURLText.this.doPost.getState()) {
                object = GetURLText.this.postTF.getText();
                object2 = "POST " + this.reqFile + " HTTP/1.0" + "\r\n" + "Content-Length: " + ((String)object).length() + "\r\n" + "Content-Type: text/html" + "\r\n" + "User-Agent: NormsTools" + "\r\n" + (GetURLText.this.useCookie.getState() ? "Cookie: " + GetURLText.this.cookieTF.getText() + "\r\n" : "") + "\r\n" + (String)object;
            } else {
                object2 = "GET " + this.reqFile + " HTTP/1.0" + "\r\n" + (GetURLText.this.useCookie.getState() ? "Cookie: " + GetURLText.this.cookieTF.getText() + "\r\n" : "") + "\r\n";
            }
            this.resp.append("\n >>> Sending: >" + (String)object2 + "<    to " + this.hostName + ", port=" + this.hostPort + ";  Response follows >>>\n");
            try {
                int n;
                object = new Socket(this.hostName, this.hostPort);
                if (GetURLText.this.debug) {
                    System.out.println("Socket: " + object);
                }
                DataOutputStream dataOutputStream = new DataOutputStream(((Socket)object).getOutputStream());
                dataOutputStream.writeBytes((String)object2);
                dataOutputStream.flush();
                DataInputStream dataInputStream = new DataInputStream(((Socket)object).getInputStream());
                int n2 = dataInputStream.available();
                if (GetURLText.this.debug) {
                    System.out.println("" + n2 + " bytes available.");
                }
                int n3 = 0;
                Thread thread = Thread.currentThread();
                while ((n = dataInputStream.read()) != -1) {
                    if (thread.isInterrupted()) break;
                    this.resp.append((char)n);
                    ++n3;
                }
                if (GetURLText.this.debug) {
                    System.out.println("\n Loop count: " + n3);
                }
                if (n3 == 0) {
                    this.resp.append("No data read from server.");
                }
                this.resp.append("\n");
                dataInputStream.close();
                ((Socket)object).close();
            }
            catch (Exception exception) {
                System.out.println("Error: " + exception);
                exception.printStackTrace();
                this.resp.append(exception + "\n");
            }
        }
    }
}

