/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NormsClassLoader
extends ClassLoader {
    static final String JarExt = ".jar";
    private String[] loc;
    private Hashtable classes = new Hashtable();
    private boolean readFirst = true;
    private boolean readAll = false;
    private boolean debug = false;

    public void setReadAll(boolean bl) {
        this.readAll = bl;
    }

    public NormsClassLoader(String[] stringArray) {
        this.loc = stringArray;
        if (this.debug) {
            System.out.println("NormsClassLoader loc=" + stringArray);
        }
    }

    private byte[] loadClassBytes(String string) {
        InputStream inputStream = null;
        try {
            int n;
            String string2;
            Closeable closeable;
            if (this.loc[0].endsWith(JarExt)) {
                ZipEntry zipEntry;
                closeable = new ZipFile(this.loc[0]);
                string2 = string.replace('.', '/') + ".class";
                if (this.debug) {
                    System.out.println("loadCB() reading zipEntry: " + string2 + "  from " + this.loc[0]);
                }
                if ((zipEntry = ((ZipFile)closeable).getEntry(string2)) == null) {
                    return null;
                }
                inputStream = ((ZipFile)closeable).getInputStream(zipEntry);
            } else {
                string2 = string.replace('.', File.separatorChar) + ".class";
                if (this.debug) {
                    System.out.println("loadCB() reading file: " + this.loc[0] + string2);
                }
                inputStream = new FileInputStream(this.loc[0] + string2);
            }
            closeable = new ByteArrayOutputStream();
            while ((n = inputStream.read()) != -1) {
                ((ByteArrayOutputStream)closeable).write(n);
            }
            inputStream.close();
            if (this.debug) {
                System.out.println("loadCB() returning " + ((ByteArrayOutputStream)closeable).size() + " bytes");
            }
            return ((ByteArrayOutputStream)closeable).toByteArray();
        }
        catch (IOException iOException) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException2) {}
            }
            System.err.println("loadCB() IO ex " + iOException);
        }
        catch (Exception exception) {
            System.err.println("loadCB() ex: " + exception);
        }
        return null;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public synchronized Class loadClass(String string) throws ClassNotFoundException, NoClassDefFoundError {
        return this.loadClass(string, false);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException, NoClassDefFoundError {
        try {
            Class<?> clazz = (Class<?>)this.classes.get(string);
            if (this.debug) {
                System.out.println("ldCls() for " + string + ", cl = " + clazz + ", " + bl);
            }
            if (clazz == null) {
                if (!this.readFirst && !this.readAll) {
                    try {
                        Class<?> clazz2 = this.findSystemClass(string);
                        if (this.debug) {
                            System.out.println("ldCls()     found sysClass>> " + clazz2.toString());
                        }
                        return clazz2;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                } else {
                    this.readFirst = false;
                }
                byte[] byArray = this.loadClassBytes(string);
                if (byArray == null) {
                    throw new ClassNotFoundException(string);
                }
                if (this.debug) {
                    System.out.println("ldCls() entering defineClass for " + string);
                }
                if ((clazz = this.defineClass(string, byArray, 0, byArray.length)) == null) {
                    if (this.debug) {
                        System.err.println("ldCls() didn't define class " + string);
                    }
                    throw new ClassNotFoundException(string);
                }
                if (this.debug) {
                    System.out.println("ldCls()     defined class>> " + clazz.toString());
                }
                this.classes.put(string, clazz);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            if (this.debug) {
                System.out.println("ldCls() returning class:  " + clazz.toString());
            }
            return clazz;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ClassNotFoundException(string);
        }
    }

    public void setLocation(String[] stringArray) {
        this.loc = stringArray;
        this.classes = new Hashtable();
        this.readFirst = true;
    }
}

