/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class ClassFileScanner {
    public static final int MAGIC = -889275714;
    public static final byte CLASS = 7;
    public static final byte FIELD_REF = 9;
    public static final byte METHOD_REF = 10;
    public static final byte INTERFACE_METHOD_REF = 11;
    public static final byte STRING = 8;
    public static final byte INTEGER = 3;
    public static final byte FLOAT = 4;
    public static final byte LONG = 5;
    public static final byte DOUBLE = 6;
    public static final byte NAME_AND_TYPE = 12;
    public static final byte UTF8 = 1;
    private String name = null;
    int minorVersion;
    int majorVersion;
    Vector constantPool;
    int accessFlags;
    int this_class;
    Object thisClass;
    int super_class;
    Object superClass;

    public String getName() {
        if (this.thisClass == null) {
            System.err.println("CFS: thisClass = null");
            return "";
        }
        if (!this.name.equals(this.thisClass.toString())) {
            return this.thisClass.toString();
        }
        return this.name;
    }

    public String getSuper() {
        return this.superClass.toString();
    }

    public Vector getReferencedClasses(String classFname) {
        this.name = classFname.substring(0, classFname.length() - 6);
        this.name = this.name.replace('/', '.');
        try {
            DataInputStream in = new DataInputStream(new FileInputStream(classFname));
            this.readFrom(in);
            this.resolve();
            return this.getClasses();
        }
        catch (IOException ioe) {
            System.err.println("CFS: Error reading " + classFname);
            ioe.printStackTrace();
            return new Vector();
        }
    }

    public Vector getReferencedClasses(DataInputStream in) {
        try {
            this.readFrom(in);
            this.resolve();
            this.name = this.thisClass.toString();
            return this.getClasses();
        }
        catch (IOException ioe) {
            System.err.println("CFS: Error reading class bytes " + in);
            ioe.printStackTrace();
            return new Vector();
        }
    }

    private Vector getClasses() {
        Vector<String> list = new Vector<String>();
        Enumeration iterator = this.constantPool.elements();
        while (iterator.hasMoreElements()) {
            Object obj = iterator.nextElement();
            if (!(obj instanceof C7)) continue;
            list.addElement(obj.toString());
        }
        return list;
    }

    public void readFrom(DataInputStream in) throws IOException {
        if (in.readInt() != -889275714) {
            throw new IOException("Bad Magic Number");
        }
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        if (this.majorVersion != 45 && (this.majorVersion != 46 || this.minorVersion != 0)) {
            throw new IOException("Unsupported version number");
        }
        int length = in.readUnsignedShort();
        this.constantPool = new Vector(length);
        this.constantPool.addElement(null);
        int i = 1;
        while (i < length) {
            byte rdB = in.readByte();
            switch (rdB) {
                case 7: {
                    C7 c7 = new C7();
                    c7.readFrom(in);
                    this.constantPool.addElement(c7);
                    break;
                }
                case 1: {
                    C1 c1 = new C1();
                    c1.readFrom(in);
                    this.constantPool.addElement(c1);
                    break;
                }
                case 9: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.addElement(null);
                    break;
                }
                case 10: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.addElement(null);
                    break;
                }
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.addElement(null);
                    break;
                }
                case 8: {
                    in.readUnsignedShort();
                    this.constantPool.addElement(null);
                    break;
                }
                case 3: {
                    in.readInt();
                    this.constantPool.addElement(null);
                    break;
                }
                case 4: {
                    in.readFloat();
                    this.constantPool.addElement(null);
                    break;
                }
                case 5: {
                    ++i;
                    in.readLong();
                    this.constantPool.addElement(null);
                    this.constantPool.addElement(null);
                    break;
                }
                case 6: {
                    ++i;
                    in.readDouble();
                    this.constantPool.addElement(null);
                    this.constantPool.addElement(null);
                    break;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    this.constantPool.addElement(null);
                    break;
                }
                default: {
                    throw new IOException("Invalid Constant Found " + rdB + " at " + i + " of " + length);
                }
            }
            ++i;
        }
        this.accessFlags = in.readUnsignedShort();
        this.this_class = in.readUnsignedShort();
        this.super_class = in.readUnsignedShort();
        in.close();
    }

    public void resolve() {
        Enumeration i = this.constantPool.elements();
        i.nextElement();
        while (i.hasMoreElements()) {
            Object obj = i.nextElement();
            if (!(obj instanceof C7)) continue;
            ((C7)obj).resolve();
        }
        if (this.this_class == 0 || this.this_class >= this.constantPool.size() || this.super_class == 0 || this.super_class >= this.constantPool.size()) {
            throw new RuntimeException("Invalid Constant Pool Reference");
        }
        Object ob = this.constantPool.elementAt(this.this_class);
        if (!(ob instanceof C7)) {
            throw new RuntimeException("Wrong type of object at reference in constant pool");
        }
        this.thisClass = (C7)ob;
        ob = this.constantPool.elementAt(this.super_class);
        if (!(ob instanceof C7)) {
            throw new RuntimeException("Wrong type of object at reference in constant pool");
        }
        this.superClass = (C7)ob;
    }

    public static void main(String[] args) throws Throwable {
        ClassFileScanner c = new ClassFileScanner();
        System.err.println(c.getReferencedClasses(args[0]));
        System.out.println("CFS: Name=" + c.getName() + ", super=" + c.getSuper());
    }

    class C7 {
        int index;
        C1 name;

        C7() {
        }

        public byte getType() {
            return 7;
        }

        public C1 getClassName() {
            return this.name;
        }

        public void readFrom(DataInputStream in) throws IOException {
            this.index = in.readUnsignedShort();
        }

        public void resolve() {
            if (this.index == 0) {
                throw new RuntimeException("Invalid Constant Pool Reference: " + this.index);
            }
            if (this.index >= ClassFileScanner.this.constantPool.size()) {
                throw new RuntimeException("Invalid Constant Pool Reference: " + this.index + "/" + ClassFileScanner.this.constantPool.size());
            }
            Object ob = ClassFileScanner.this.constantPool.elementAt(this.index);
            if (!(ob instanceof C1)) {
                throw new RuntimeException("Wrong type of object at reference in constant pool");
            }
            this.name = (C1)ob;
        }

        public boolean equals(Object obj) {
            return obj instanceof C7 && ((C7)obj).name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return this.name.toString().replace('/', '.');
        }
    }

    class C1 {
        String value;

        C1() {
        }

        C1(String value) {
            this.value = value;
        }

        public byte getType() {
            return 1;
        }

        public String getValue() {
            return this.value;
        }

        public void readFrom(DataInputStream in) throws IOException {
            this.value = in.readUTF();
        }

        public boolean equals(Object obj) {
            return obj instanceof C1 && ((C1)obj).value.equals(this.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return this.value;
        }
    }
}

