/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.CheckClassPath;

import NormsTools.ClassFileScanner;
import NormsTools.ErrDialog;
import NormsTools.MSDosFilename;
import NormsTools.MakeEnterDoAction;
import NormsTools.NormsClassLoader;
import NormsTools.ShowListBox;
import NormsTools.ShowMsgBox;
import NormsTools.Sorter;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FindClass
extends Frame
implements ActionListener,
TextListener,
ItemListener {
    static final String Title = "Find Class  -  27 Nov 2001";
    final MenuBar mb = new MenuBar();
    final Menu mF = new Menu("File");
    final MenuItem fExit = new MenuItem("Exit");
    final Menu mV = new Menu("View");
    final MenuItem vListCP = new MenuItem("List Classpath(s)");
    final MenuItem vListMethods = new MenuItem("List Methods");
    final MenuItem vListConstructors = new MenuItem("List Constructors");
    final Menu mO = new Menu("Options");
    final CheckboxMenuItem oAllClassesCB = new CheckboxMenuItem("List all classes in package", true);
    final CheckboxMenuItem oShowAllPkgsCB = new CheckboxMenuItem("List all packages with class", true);
    final CheckboxMenuItem oShowAllSubPkgsCB = new CheckboxMenuItem("List all sub packages", false);
    final CheckboxMenuItem oListOnlyDefMethods = new CheckboxMenuItem("List only methods defined", false);
    final CheckboxMenuItem oUseJVMRTLib = new CheckboxMenuItem("Search JVM Runtime library", false);
    final CheckboxMenuItem oShowObjectMs = new CheckboxMenuItem("Show Object class methods", false);
    final MenuItem oSetCP = new MenuItem("Set Classpath ...");
    final MenuItem oAddCP = new MenuItem("Add to Classpath ...");
    final CheckboxMenuItem oDebug = new CheckboxMenuItem("Debug", false);
    Menu mH = new Menu("Help");
    MenuItem hAbout = new MenuItem("About");
    MenuItem hTopics = new MenuItem("Topics");
    TextField srchTF = new TextField(40);
    List dispTA = new List();
    final Font dispFont = new Font("monospaced", 0, 12);
    final String padClsNmBlanks = "                                          ";
    final Button srchB = new Button("Search");
    final Button stopB = new Button("Stop");
    final Button clearB = new Button("Clear");
    final Color BGColor = new Color(180, 230, 255);
    static final String JVMRunTimeLib = File.separator + "lib" + File.separator + "rt.jar";
    static final String JAVA_LANG = "java.lang.";
    static final String JarExt = ".jar";
    static final String ZipExt = ".zip";
    static final String ClassExt = ".class";
    static final String PkgNmEnd = ".*";
    static final String ZipEntrySep = "/";
    static final char ZipEntrySepChar = '/';
    static final String FoundIn = " found in  ";
    static final int MinFolderLen = 10;
    String sysCP;
    String givenCP;
    String userDir;
    String javaHome;
    String[] clsPaths;
    int fndCnt = 0;
    boolean stopSrch = false;
    boolean debug = false;
    boolean getMethods = false;
    NormsClassLoader mcl = null;

    private String[] getClassesFmJar(String string) {
        try {
            Object object;
            ZipFile zipFile = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (((ZipEntry)object).isDirectory()) continue;
                String string2 = ((ZipEntry)object).getName();
                if (string2.endsWith(ClassExt)) {
                    string2 = string2.substring(0, string2.length() - 6);
                }
                vector.addElement(string2);
            }
            object = new String[vector.size()];
            vector.copyInto((Object[])object);
            if (this.debug) {
                System.out.println("getClassesFmJar() Found " + ((Object)object).length + " in " + string);
            }
            return object;
        }
        catch (IOException iOException) {
            System.err.println("Error reading from " + string);
            return new String[0];
        }
    }

    Class getClass(String string, String string2) {
        block6: {
            try {
                Class<?> clazz = Class.forName(string2);
                System.out.println("getClass() Class.forName() found " + string2);
                return clazz;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("getClass() Class.forName() error: " + noClassDefFoundError);
            }
            catch (Exception exception) {
                if (!this.debug) break block6;
                System.err.println("getClass() Class.forName() error: " + exception);
            }
        }
        if (this.mcl == null) {
            this.mcl = new NormsClassLoader(new String[]{string});
        }
        this.mcl.setDebug(this.debug);
        try {
            Class clazz = this.mcl.loadClass(string2);
            System.out.println("getClass() NormsClassLoader found " + string2);
            return clazz;
        }
        catch (Exception exception) {
            System.err.println("getClass() NormsClassLoader ex: " + exception);
            return null;
        }
    }

    private String[] getClassesFmDir(String string) {
        File file;
        if (this.debug) {
            System.out.println("getClassesFmDir() Looking in directory: " + string);
        }
        if (!(file = new File(string)).isDirectory()) {
            if (this.debug) {
                System.err.println("ERROR >>> " + string + " is NOT a directory.");
            }
            return new String[0];
        }
        String[] stringArray = file.list(new FilenameFilter(){
            {
                FindClass.this.getClass();
            }

            public boolean accept(File file, String string) {
                return string.endsWith(FindClass.ClassExt);
            }
        });
        if (this.debug) {
            System.out.println("getClassesFmDir() Found " + stringArray.length + " files in " + string);
        }
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].substring(0, stringArray[n].length() - 6);
            ++n;
        }
        Sorter.sort(stringArray);
        return stringArray;
    }

    private void usage() {
        System.out.println("Usage: java FindClass [-d] [-cp classpath] <classfilename>");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {}
        System.exit(0);
    }

    public FindClass(String[] stringArray) {
        super(Title);
        Object object;
        Properties properties = System.getProperties();
        this.sysCP = properties.getProperty("java.class.path");
        this.userDir = properties.getProperty("user.dir", ".");
        this.javaHome = properties.getProperty("java.home");
        this.setClasspaths(this.sysCP);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (stringArray[n].equalsIgnoreCase("-CP")) {
                    if (++n < stringArray.length) {
                        this.givenCP = stringArray[n];
                        this.setClasspaths(this.givenCP);
                    } else {
                        System.err.println("Classpath missing after " + stringArray[n - 1]);
                        this.usage();
                    }
                } else if (stringArray[n].equalsIgnoreCase("-D")) {
                    this.debug = true;
                } else {
                    System.err.println("Unknown arg: " + stringArray[n]);
                    this.usage();
                }
            } else {
                if (n != stringArray.length - 1) {
                    System.err.println("args problem: >" + stringArray[n + 1] + "< at " + n);
                    this.usage();
                }
                if (!((String)(object = stringArray[n])).endsWith(ClassExt)) {
                    System.err.println("Invalid extension: " + stringArray[n]);
                    if (((String)object).indexOf(126) > 0) {
                        int n2 = ((String)object).lastIndexOf(File.separator);
                        object = n2 < 0 ? object : ((String)object).substring(n2 + 1);
                        object = MSDosFilename.getExtendedName((String)object);
                        if (this.debug) {
                            System.out.println("Change fn " + stringArray[n] + " to " + (String)object);
                        }
                    }
                }
            }
            ++n;
        }
        if (this.debug) {
            System.out.println("Classpath = " + this.sysCP);
        }
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(this.BGColor);
        this.fExit.addActionListener(this);
        this.mF.add(this.fExit);
        this.mb.add(this.mF);
        this.vListCP.addActionListener(this);
        this.mV.add(this.vListCP);
        this.vListMethods.addActionListener(this);
        this.vListMethods.setEnabled(false);
        this.mV.add(this.vListMethods);
        this.mV.add(this.vListConstructors);
        this.vListConstructors.addActionListener(this);
        this.vListConstructors.setEnabled(false);
        this.mb.add(this.mV);
        this.mO.add(this.oAllClassesCB);
        this.mO.add(this.oShowAllPkgsCB);
        this.mO.add(this.oShowAllSubPkgsCB);
        this.mO.add(this.oListOnlyDefMethods);
        this.mO.add(this.oUseJVMRTLib);
        this.mO.add(this.oShowObjectMs);
        this.mO.addSeparator();
        this.oSetCP.addActionListener(this);
        this.mO.add(this.oSetCP);
        this.oAddCP.addActionListener(this);
        this.mO.add(this.oAddCP);
        this.mO.addSeparator();
        this.oDebug.addItemListener(this);
        this.oDebug.setState(this.debug);
        this.mO.add(this.oDebug);
        this.mb.add(this.mO);
        this.hTopics.addActionListener(this);
        this.mH.add(this.hTopics);
        this.hAbout.addActionListener(this);
        this.mH.add(this.hAbout);
        this.mb.add(this.mH);
        this.setMenuBar(this.mb);
        Panel panel = new Panel();
        panel.add(new Label("Class/package:"));
        this.srchTF.addTextListener(this);
        panel.add(this.srchTF);
        this.srchB.setEnabled(false);
        this.srchB.addActionListener(this);
        this.srchB.addKeyListener(new MakeEnterDoAction());
        panel.add(this.srchB);
        this.stopB.setEnabled(false);
        this.stopB.addActionListener(this);
        panel.add(this.stopB);
        this.add((Component)panel, "North");
        this.dispTA.setFont(this.dispFont);
        this.dispTA.addItemListener(this);
        this.add((Component)this.dispTA, "Center");
        this.addWindowListener(new WindowAdapter(){
            {
                FindClass.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        object = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setSize(Math.max(700, ((Dimension)object).width - 100), Math.max(((Dimension)object).height - 100, 500));
        ((Component)this).setLocation((((Dimension)object).width - this.getBounds().width) / 2, (((Dimension)object).height - this.getBounds().height) / 2);
        this.show();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.oDebug) {
            this.debug = this.oDebug.getState();
        } else if (object == this.dispTA) {
            this.vListMethods.setEnabled(this.checkClsSelected());
            this.vListConstructors.setEnabled(this.checkClsSelected());
        } else {
            System.err.println("Unknown ie " + itemEvent);
        }
    }

    private boolean checkClsSelected() {
        String string = this.dispTA.getSelectedItems()[0];
        return string.length() > FoundIn.length() + "                                          ".length() + 10 && string.indexOf(FoundIn) > 0;
    }

    String padString(String string, int n) {
        if (string.length() > n || string.length() > "                                          ".length()) {
            return string;
        }
        return string + "                                          ".substring(0, n - string.length());
    }

    public static void main(String[] stringArray) {
        new FindClass(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.srchB) {
            String string = this.srchTF.getText().trim();
            if (string.length() < 3 || string.indexOf(File.separator) >= 0) {
                new ErrDialog((Frame)this, "Invalid packagename/class. Use dotted notation");
                this.srchTF.requestFocus();
                return;
            }
            new Thread(new Runnable(){
                {
                    FindClass.this.getClass();
                }

                public void run() {
                    FindClass.this.srchB.setEnabled(false);
                    FindClass.this.stopB.setEnabled(true);
                    FindClass.this.stopSrch = false;
                    FindClass.this.searchPaths();
                    FindClass.this.srchB.setEnabled(true);
                    FindClass.this.stopB.setEnabled(false);
                }
            }).start();
        } else if (object == this.stopB) {
            this.stopSrch = true;
        } else if (object == this.oSetCP) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose new classpath", 0);
            fileDialog.setFile("Select jar or zip, or any file to get its directory.");
            fileDialog.show();
            fileDialog.dispose();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            if (string.endsWith(JarExt) || string.endsWith(ZipExt)) {
                this.setClasspaths(fileDialog.getDirectory() + string);
            } else {
                this.setClasspaths(fileDialog.getDirectory());
            }
        } else if (object == this.oAddCP) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Add a new classpath", 0);
            fileDialog.setFile("Select jar or zip, or any file to get its directory.");
            fileDialog.show();
            fileDialog.dispose();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            if (string.endsWith(JarExt) || string.endsWith(ZipExt)) {
                this.addClasspath(fileDialog.getDirectory() + string);
            } else {
                this.addClasspath(fileDialog.getDirectory());
            }
        } else if (object == this.fExit) {
            System.exit(0);
        } else if (object == this.vListCP) {
            new ShowListBox("Current classpaths", this.clsPaths, Math.min(20, this.clsPaths.length), this, true);
        } else {
            this.getMethods = object == this.vListMethods;
            if (this.getMethods || object == this.vListConstructors) {
                if (!this.checkClsSelected()) {
                    new ErrDialog((Frame)this, "Invalid class item Selected.");
                    return;
                }
                this.stopSrch = false;
                this.stopB.setEnabled(true);
                new Thread(new Runnable(){
                    {
                        FindClass.this.getClass();
                    }

                    public void run() {
                        Executable[] executableArray;
                        String string = FindClass.this.dispTA.getSelectedItems()[0];
                        int n = string.indexOf(FindClass.FoundIn);
                        if (n < 1) {
                            return;
                        }
                        String string2 = string.substring(0, n).trim();
                        String string3 = string.substring(n + FindClass.FoundIn.length()).trim();
                        String string4 = string2.replace(File.separatorChar, '.');
                        string4 = string4.replace('/', '.');
                        if (FindClass.this.debug) {
                            System.out.println("Selected >" + string2 + "<, in loc >" + string3 + "<" + ", classname:" + string4);
                        }
                        Class clazz = null;
                        try {
                            clazz = FindClass.this.getClass(string3, string4);
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            new ErrDialog((Frame)FindClass.this, noClassDefFoundError.toString());
                        }
                        catch (Exception exception) {
                            System.err.println("getClass ex" + exception);
                        }
                        if (clazz == null) {
                            FindClass.this.dispTextNL("No class found for " + string2);
                            return;
                        }
                        if (FindClass.this.getMethods) {
                            executableArray = clazz.getMethods();
                            if (FindClass.this.oListOnlyDefMethods.getState()) {
                                executableArray = clazz.getDeclaredMethods();
                            }
                            new ShowMethods((Method[])executableArray, string2, string4);
                        } else {
                            executableArray = clazz.getConstructors();
                            new ShowMethods((Constructor[])executableArray, string2, string4);
                        }
                        FindClass.this.stopB.setEnabled(false);
                    }
                }).start();
            } else if (object == this.hAbout) {
                new ShowMsgBox("About FindClass", "Written by Norm Radder\n Email: radder@hotmail.com", this, true);
            } else if (object == this.hTopics) {
                new ShowMsgBox("Find Class topics", "Enter class or package name(ends with .*) and press Search.\nChoose an option to control report listing.\n Other Options:\n  Set classpath - change classpath value \n  Add to classpath - will add a path", this, false, 300);
            } else {
                System.err.println("Unknown ae " + actionEvent);
            }
        }
    }

    public String removeString(String string, String string2) {
        int n = string.indexOf(string2);
        if (n < 0) {
            return string;
        }
        int n2 = string2.length();
        while (n >= 0) {
            string = n == 0 ? string.substring(n2) : (n == string.length() - n2 ? string.substring(0, n) : string.substring(0, n) + string.substring(n + n2));
            n = string.indexOf(string2);
        }
        return string;
    }

    private String padClsNm(String string) {
        if (string.length() > "                                          ".length()) {
            return string;
        }
        return string + "                                          ".substring(0, "                                          ".length() - string.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void searchPaths() {
        String string;
        String string2 = this.srchTF.getText().trim();
        String string3 = File.separator;
        char c = File.separatorChar;
        boolean bl = false;
        boolean bl2 = false;
        if (string2.endsWith(PkgNmEnd)) {
            string = this.oShowAllSubPkgsCB.getState() ? "packages starting with" : "package";
            bl = true;
        } else {
            string = "class";
            bl2 = true;
        }
        this.dispTA.removeAll();
        this.dispTA.add("Searching for " + string + " " + string2);
        this.fndCnt = 0;
        int n = 0;
        block2: while (n <= this.clsPaths.length) {
            block27: {
                int n2;
                String string4;
                boolean bl3;
                boolean bl4;
                String string5;
                String string6;
                String[] stringArray;
                String string7;
                block29: {
                    block30: {
                        block28: {
                            if (this.stopSrch) break;
                            string7 = null;
                            if (n < this.clsPaths.length) {
                                string7 = this.clsPaths[n];
                            } else {
                                if (n != this.clsPaths.length) break;
                                if (this.fndCnt == 0 && this.oUseJVMRTLib.getState()) {
                                    string7 = this.javaHome + JVMRunTimeLib;
                                }
                            }
                            if (this.debug) {
                                System.out.println(" Next ClassPath >" + string7 + "<");
                            }
                            if (string7 == null) break block27;
                            stringArray = null;
                            string6 = "";
                            string5 = "";
                            bl4 = false;
                            bl3 = false;
                            if (!string7.toLowerCase().endsWith(JarExt) && !string7.toLowerCase().endsWith(ZipExt)) break block28;
                            bl4 = true;
                            if (this.debug) {
                                System.out.println("Looking in jar: " + string7);
                            }
                            string3 = ZipEntrySep;
                            c = '/';
                            stringArray = this.getClassesFmJar(string7);
                            string4 = (bl ? string2.substring(0, string2.length() - 1) : string2).replace('.', c);
                            break block29;
                        }
                        if (string7.equals("." + File.separator)) break block27;
                        if (string7.indexOf(46) <= 2000) break block30;
                        System.err.println("Skipping Path with a . > " + string7);
                        break block27;
                    }
                    bl3 = true;
                    string3 = File.separator;
                    c = File.separatorChar;
                    string4 = (bl ? string2.substring(0, string2.length() - 1) : string2).replace('.', c);
                    n2 = 0;
                    n2 = string4.indexOf(c);
                    if (n2 > 0 && n2 < string4.length()) {
                        string6 = string4.substring(0, n2 + 1);
                        string5 = string4.substring(n2 + 1);
                        if (this.debug) {
                            System.out.println(" subpath " + string6 + " with file: " + string5);
                        }
                    } else {
                        string5 = "";
                        string6 = "";
                    }
                    stringArray = this.getClassesFmDir(string7 + (bl ? string4 : (n2 > 0 ? string6 : "")));
                }
                if (this.debug) {
                    System.out.println("  Searching for " + string4 + " as " + (bl ? "package" : "class"));
                }
                n2 = 1;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    block32: {
                        block33: {
                            String string8;
                            block34: {
                                block31: {
                                    if (this.stopSrch) break block2;
                                    string8 = stringArray[n3];
                                    if (this.debug) {
                                        System.out.println("       next classfile: " + string8);
                                    }
                                    if (!bl2) break block31;
                                    if (string8.equals(string4) || string8.endsWith(string3 + string2) || string8.equals(string5)) {
                                        this.dispTextNL((n2 != 0 ? "\n" : "") + this.padClsNm(bl4 ? string8 : string2) + FoundIn + string7 + string6);
                                        n2 = 0;
                                        ++this.fndCnt;
                                        if (!this.oShowAllPkgsCB.getState()) {
                                            break block2;
                                        }
                                    }
                                    break block32;
                                }
                                if (!bl) break block33;
                                if (!string8.startsWith(string4)) break block34;
                                if (string8.substring(string4.length()).indexOf(string3) < 0 || this.oShowAllSubPkgsCB.getState()) {
                                    this.dispTextNL((n2 != 0 ? "\n" : "") + this.padClsNm(string8) + FoundIn + string7);
                                    n2 = 0;
                                    ++this.fndCnt;
                                    if (!this.oAllClassesCB.getState()) {
                                        break block2;
                                    }
                                    break block32;
                                } else if (this.debug) {
                                    System.out.println(string4 + " is prefix of " + string8);
                                }
                                break block32;
                            }
                            if (bl3) {
                                Object object;
                                if (this.debug) {
                                    System.out.println("Need to read " + string8 + ClassExt);
                                }
                                ClassFileScanner classFileScanner = new ClassFileScanner();
                                try {
                                    object = new DataInputStream(new FileInputStream(string7 + string4 + string8 + ClassExt));
                                    classFileScanner.getReferencedClasses((DataInputStream)object);
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    fileNotFoundException.printStackTrace();
                                    this.dispTextNL("File not found error: " + string8 + ClassExt);
                                    return;
                                }
                                object = classFileScanner.getName().replace('.', c);
                                if (this.debug) {
                                    System.out.println(" CFS read pkgName = " + (String)object + " vs " + string4);
                                }
                                if (((String)object).startsWith(string4)) {
                                    this.dispTextNL((n2 != 0 ? "\n" : "") + this.padClsNm((String)object) + FoundIn + string7 + string4 + "\n");
                                    n2 = 0;
                                    ++this.fndCnt;
                                    if (!this.oAllClassesCB.getState()) {
                                        break block2;
                                    }
                                }
                            }
                            break block32;
                        }
                        System.err.println("Invalid flag settings!");
                    }
                    ++n3;
                }
            }
            ++n;
        }
        this.dispTextNL((this.stopSrch ? "Search cancelled" : "") + "  " + this.fndCnt + " matches found");
    }

    void dispTextNL(String string) {
        int n = string.indexOf("\n");
        if (n >= 0) {
            this.dispTA.add(string.substring(0, n));
            if (n < string.length()) {
                this.dispTA.add(string.substring(n + 1));
            } else {
                this.dispTA.add("");
            }
        } else {
            this.dispTA.add(string);
        }
    }

    void dispTextNL(TextArea textArea, String string) {
        textArea.append(string + "\n");
    }

    public void textValueChanged(TextEvent textEvent) {
        this.srchB.setEnabled(!this.srchTF.getText().equals(""));
    }

    private void addClasspath(String string) {
        String[] stringArray = new String[this.clsPaths.length + 1];
        System.arraycopy(this.clsPaths, 0, stringArray, 0, this.clsPaths.length);
        stringArray[stringArray.length - 1] = string;
        this.clsPaths = stringArray;
    }

    private void setClasspaths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (!(string2.endsWith(File.separator) || string2.toLowerCase().endsWith(JarExt) || string2.toLowerCase().endsWith(ZipExt))) {
                string2 = string2 + File.separator;
            }
            File file = new File(string2);
            if (string2.toLowerCase().endsWith(JarExt) || string2.toLowerCase().endsWith(ZipExt)) {
                if (!file.exists()) {
                    this.dispTextNL("Classpath File NOT found: " + string2);
                    continue;
                }
            } else if (!file.isDirectory()) {
                this.dispTextNL("Classpath Directory NOT found: " + string2);
                continue;
            }
            vector.addElement(string2);
        }
        this.clsPaths = new String[vector.size()];
        vector.copyInto(this.clsPaths);
    }

    class ShowMethods {
        final int FirstColWidth = 35;
        final String SEPCHAR = ";";
        Frame dispMethodsF;

        ShowMethods(Constructor[] constructorArray, String string, String string2) {
            FindClass.this.getClass();
            this.FirstColWidth = 35;
            this.SEPCHAR = ";";
            this.dispMethodsF = new Frame("Constructors for " + string);
            this.common(constructorArray, null, string, string2);
        }

        ShowMethods(Method[] methodArray, String string, String string2) {
            FindClass.this.getClass();
            this.FirstColWidth = 35;
            this.SEPCHAR = ";";
            this.dispMethodsF = new Frame("Methods for " + string);
            this.common(null, methodArray, string, string2);
        }

        private void common(Constructor[] constructorArray, Method[] methodArray, String string, String string2) {
            int n;
            int n2;
            String string3;
            int n3 = constructorArray != null ? constructorArray.length : methodArray.length;
            TextArea textArea = new TextArea(Math.min(20, n3 + 3), 80);
            textArea.setFont(FindClass.this.dispFont);
            this.dispMethodsF.add(textArea);
            this.dispMethodsF.addWindowListener(new WindowAdapter(){
                {
                    ShowMethods.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ShowMethods.this.dispMethodsF.dispose();
                    ShowMethods.this.dispMethodsF = null;
                }
            });
            ((Component)this.dispMethodsF).setLocation(FindClass.this.getLocation().x + 10, FindClass.this.getLocation().y + 10);
            ((Component)this.dispMethodsF).setSize(FindClass.this.getSize().width - 20, FindClass.this.getSize().height - 20);
            this.dispMethodsF.pack();
            this.dispMethodsF.show();
            int n4 = 0;
            int n5 = 0;
            String[] stringArray = null;
            if (constructorArray != null) {
                stringArray = new String[constructorArray.length];
            } else if (methodArray != null) {
                stringArray = new String[methodArray.length];
            } else {
                System.err.println("ShowMethods - both inputs null?");
            }
            int n6 = 0;
            while (n6 < stringArray.length) {
                string3 = null;
                string3 = constructorArray != null ? FindClass.this.removeString(constructorArray[n6].toString(), FindClass.JAVA_LANG) : FindClass.this.removeString(methodArray[n6].toString(), FindClass.JAVA_LANG);
                n = string3.lastIndexOf(46, n2 = string3.indexOf("("));
                if (n < 0) {
                    n = string3.lastIndexOf(32, n2);
                }
                String string4 = string3.substring(n + 1, n2);
                stringArray[n6] = string4 + ";" + string3;
                ++n6;
            }
            Sorter.sort(stringArray);
            n6 = 0;
            while (n6 < stringArray.length) {
                if (FindClass.this.stopSrch) break;
                string3 = stringArray[n6];
                if (string3.indexOf(" Object.") > 0 && !FindClass.this.oShowObjectMs.getState()) {
                    ++n5;
                } else {
                    n2 = string3.indexOf(";");
                    if (n2 > 0) {
                        string3 = string3.substring(n2 + 1);
                    }
                    if (methodArray != null && (n = string3.indexOf(string2)) > 0) {
                        string3 = FindClass.this.padString(string3.substring(0, n), 35) + string3.substring(1 + n + string.length());
                    }
                    FindClass.this.dispTextNL(textArea, "  " + string3);
                    ++n4;
                }
                ++n6;
            }
            FindClass.this.dispTextNL(textArea, string + " had " + n4 + " methods. " + (n5 > 0 ? n5 + " Object class methods not shown." : ""));
        }
    }
}

