/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.DocumentViewer;

import NormsTools.DocumentViewer.DocElemBGColor;
import NormsTools.DocumentViewer.DocElemCenter;
import NormsTools.DocumentViewer.DocElemColor;
import NormsTools.DocumentViewer.DocElemDebug;
import NormsTools.DocumentViewer.DocElemEndCenter;
import NormsTools.DocumentViewer.DocElemFont;
import NormsTools.DocumentViewer.DocElemHLString;
import NormsTools.DocumentViewer.DocElemHorizLine;
import NormsTools.DocumentViewer.DocElemNOBR;
import NormsTools.DocumentViewer.DocElemNewLine;
import NormsTools.DocumentViewer.DocElemRegisterLoc;
import NormsTools.DocumentViewer.DocElemSetInset;
import NormsTools.DocumentViewer.DocElemString;
import NormsTools.DocumentViewer.Document;
import NormsTools.DocumentViewer.DocumentElement;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.ShowMsgBox;
import NormsTools.StackX;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.Stack;
import java.util.Vector;

public final class HTMLParser {
    private boolean debug = false;
    private final String DebugON = "DEBUGON";
    private final String DebugOFF = "DEBUGOFF";
    StreamTokenizer st;
    Vector de = new Vector();
    Document doc;
    private String pushedTkn = null;
    final String leftBkt = "<";
    final String rightBkt = ">";
    final String startEnd = "/";
    final String EOF = "<EOF>";
    final String CMTStart = "!";
    final String CMTEnd = "-->";
    final int CMTStartC = 33;
    final String DblDash = "--";
    final String Amper = "&";
    final String AmpVarEnd = ";";
    final String StartHEX = "#";
    final String SkipTag = "X-";
    Color currBGColor = Color.white;
    Color currColor = Color.black;
    Color linkColor = new Color(0, 0, 255);
    Font currFont = new Font("TimesRoman", 0, 14);
    private final int H1Size = 13;
    private final int H2Size = 9;
    private final int H3Size = 5;
    private final int H4Size = 2;
    private final int H5Size = -1;
    private final int H6Size = -2;
    static final int NoList = 0;
    static final int OLtype = 1;
    static final int ULtype = 2;
    static final String ULIdx = "\u00b0 ";
    static final String ULIdx2 = "\u00b7 ";
    static final String OLSfx = "). ";
    private int currOLIdx = 0;
    private int currListType = 0;
    StackX saveFont = new StackX();
    StackX saveColor = new StackX();
    StackX saveListType = new StackX();
    StackX saveOLIdx = new StackX();
    private boolean returnSpaces = false;
    final int elemIdxCCT = 0;
    final int parserIdxCCT = 1;
    final int cctIdxCCT = 2;
    final int entrySizeCCT = 3;
    final String LinkToCCT = "<LINKTOCCT>";
    final String ExitCCT = "<EXITCCT";
    Object[] currCCT = null;
    Stack saveCCT = new Stack();
    ParseA parseA = new ParseA();
    ParseB parseB = new ParseB();
    ParseI parseI = new ParseI();
    ParseFONT parseFONT = new ParseFONT();
    ParseCENTER parseCENTER = new ParseCENTER();
    ParseHEAD parseHEAD = new ParseHEAD();
    ParseBODY parseBODY = new ParseBODY();
    ParseTITLE parseTITLE = new ParseTITLE();
    ParseMETA parseMETA = new ParseMETA();
    ParseBR parseBR = new ParseBR();
    ParseP parseP = new ParseP();
    ParseHR parseHR = new ParseHR();
    ParseOL parseOL = new ParseOL();
    ParseUL parseUL = new ParseUL();
    ParseLI parseLI = new ParseLI();
    ParseLI parseLIX = new ParseLI("X");
    ParseHTML parseHTML = new ParseHTML();
    ParsePRE parsePRE = new ParsePRE();
    ParseDIV parseDIV = new ParseDIV();
    ParseTT parseTT = new ParseTT();
    ParseNOBR parseNOBR = new ParseNOBR();
    ParseEATTAG parseEatTag = new ParseEATTAG();
    Object[] CharsHiLite_CCT = new Object[]{"B", this.parseB, null, "I", this.parseI, null, "TT", this.parseTT, null, "FONT", this.parseFONT, null};
    Object[] UL_CCT = new Object[]{"LI", this.parseLI, null, "/UL", this.parseUL, "<EXITCCT"};
    Object[] OL_CCT = new Object[]{"LI", this.parseLI, null, "/OL", this.parseOL, "<EXITCCT"};
    Object[] LI_CCT = new Object[]{"B", this.parseB, null, "I", this.parseI, null, "TT", this.parseTT, null, "A", this.parseA, null, "P", this.parseP, null, "BR", this.parseBR, null, "H1", new ParseH1(), null, "H2", new ParseH2(), null, "H3", new ParseH3(), null, "H4", new ParseH4(), null, "H5", new ParseH5(), null, "H6", new ParseH6(), null, "FONT", this.parseFONT, null, "NOBR", this.parseNOBR, null, "OL", this.parseOL, this.OL_CCT, "UL", this.parseUL, this.UL_CCT, "/LI", this.parseLI, "<EXITCCT", "LI", this.parseLIX, null};
    Object[] A_CCT = new Object[]{"B", this.parseB, null, "I", this.parseI, null, "TT", this.parseTT, null, "FONT", this.parseFONT, null, "/A", this.parseA, "<EXITCCT"};
    Object[] HEAD_CCT = new Object[]{"TITLE", this.parseTITLE, null, "META", this.parseMETA, null, "SCRIPT", this.parseEatTag, null, "/HEAD", this.parseHEAD, "<EXITCCT"};
    Object[] BODY_CCT = new Object[]{"B", this.parseB, null, "I", this.parseI, null, "BR", this.parseBR, null, "P", this.parseP, null, "HR", this.parseHR, null, "TT", this.parseTT, null, "OL", this.parseOL, this.OL_CCT, "UL", this.parseUL, this.UL_CCT, "FONT", this.parseFONT, null, "NOBR", this.parseNOBR, null, "CENTER", this.parseCENTER, null, "H1", new ParseH1(), null, "H2", new ParseH2(), null, "H3", new ParseH3(), null, "H4", new ParseH4(), null, "H5", new ParseH5(), null, "H6", new ParseH6(), null, "A", this.parseA, this.A_CCT, "APPLET", this.parseEatTag, null, "DL", this.parseEatTag, null, "SCRIPT", this.parseEatTag, null, "TABLE", this.parseEatTag, null, "FORM", this.parseEatTag, null, "OBJECT", this.parseEatTag, null, "/BODY", this.parseBODY, "<EXITCCT"};
    Object[] HTML_CCT = new Object[]{"HEAD", this.parseHEAD, this.HEAD_CCT, "BODY", this.parseBODY, this.BODY_CCT, "/HTML", this.parseHTML, null};
    final int B_TAG = 1;
    final String[] amperNms = new String[]{";lt;gt;", ";amp;", ";copy;nbsp;quot;"};
    final String[][] amperVals = new String[][]{{"<", ">"}, {"&"}, {"\u00a9", " ", "\""}};
    private boolean isAmpVarGT = false;
    private String lastCharGNT = "";
    private String thisCharGNT = "";
    private String HEX_CHARS = "0123456789ABCDEF";
    static /* synthetic */ Class class$NormsTools$DocumentViewer$HTMLParser;

    public HTMLParser() {
        this.UL_CCT[2] = this.LI_CCT;
        this.OL_CCT[2] = this.LI_CCT;
    }

    private void showLocation(String msg) {
        System.out.println("showLocation() " + msg + " At line: " + this.st.lineno() + "  currCCT= " + this.currCCT + ", 1stEnt=" + (String)this.currCCT[0]);
    }

    private boolean parseEngine(String tok, Object[] cct) throws InvalidHTMLException {
        boolean peDebug = false;
        if (this.debug || peDebug) {
            System.out.println("parseEng: tok=" + tok);
        }
        int i = 0;
        while (i < cct.length) {
            if (((String)cct[i]).equalsIgnoreCase(tok) || tok.equalsIgnoreCase("/" + (String)cct[i])) {
                if (this.debug || peDebug) {
                    System.out.println("parseEng found " + tok + " in " + cct + "  i=" + i);
                }
                ((ParseTAG)cct[i + 1]).parseTag(tok);
                if (cct[i + 2] != null) {
                    if (cct[i + 2] instanceof String && ((String)cct[i + 2]).equals("<EXITCCT")) {
                        this.currCCT = (Object[])this.saveCCT.pop();
                        if (this.debug || peDebug) {
                            System.out.println("parsEng ExitCCT: " + this.currCCT);
                        }
                    } else if (!tok.startsWith("/") && !((String)cct[i]).equalsIgnoreCase("/" + tok)) {
                        this.saveCCT.push(this.currCCT);
                        this.currCCT = (Object[])cct[i + 2];
                        if (this.debug || peDebug) {
                            System.out.println("parsEng set new CCT: " + this.currCCT);
                        }
                    } else {
                        this.currCCT = (Object[])this.saveCCT.pop();
                        if (this.debug || peDebug) {
                            System.out.println("parsEng restored CCT: " + this.currCCT);
                        }
                    }
                }
                return true;
            }
            i += 3;
        }
        if (this.debug || peDebug) {
            System.out.println("parseEngine didn't find " + tok + " in " + cct);
        }
        return false;
    }

    public Document parseHTMLFile(String fn) throws InvalidHTMLException, Exception {
        block18: {
            String tkn;
            block19: {
                if (this.debug) {
                    System.out.println("parseHTMLFile() trying to read " + fn);
                }
                try {
                    this.st = new StreamTokenizer(new FileReader(fn));
                }
                catch (Exception ex) {
                    System.err.println("parseHTMLFile() ex trying to read " + fn + "\n" + ex);
                }
                if (this.st == null) {
                    try {
                        URL url = (class$NormsTools$DocumentViewer$HTMLParser == null ? (class$NormsTools$DocumentViewer$HTMLParser = HTMLParser.class$("NormsTools.DocumentViewer.HTMLParser")) : class$NormsTools$DocumentViewer$HTMLParser).getResource("/" + fn);
                        if (this.debug) {
                            System.out.println("Reading " + fn + " from " + url);
                        }
                        if (url != null) {
                            this.st = new StreamTokenizer(new InputStreamReader(url.openStream()));
                        }
                    }
                    catch (Exception ex) {
                        System.err.println("error trying to get " + fn);
                    }
                    if (this.st == null) {
                        new ShowMsgBox("Error reading file", "Unable to read file: " + fn, new Frame(), true);
                        throw new Exception("parseHTMLFile() unable to read file: " + fn);
                    }
                }
                this.doc = new Document();
                this.doc.setFileName(fn);
                this.de = new Vector();
                this.de.addElement(new DocElemFont(this.currFont));
                this.st.resetSyntax();
                this.st.whitespaceChars(0, 32);
                this.st.wordChars(97, 122);
                this.st.wordChars(65, 90);
                this.st.wordChars(47, 47);
                this.st.wordChars(39, 39);
                this.st.wordChars(48, 57);
                this.st.wordChars(46, 46);
                this.st.wordChars(45, 45);
                this.st.wordChars(35, 35);
                this.st.quoteChar(34);
                this.st.ordinaryChar(32);
                this.st.eolIsSignificant(true);
                block4: while (true) {
                    tkn = this.getToken();
                    if (this.debug) {
                        System.out.println("Mainlp: Got token: " + tkn);
                    }
                    if (tkn.equals("<EOF>")) break block18;
                    if (!tkn.equals("<")) break block19;
                    tkn = this.getToken();
                    if (!tkn.equalsIgnoreCase("HTML")) break;
                    this.getCkForRBkt();
                    this.currCCT = this.HTML_CCT;
                    while (true) {
                        if ((tkn = this.getToken()).equals("<")) {
                            tkn = this.getToken();
                            if (tkn.startsWith("X-")) {
                                this.eatTag(tkn);
                                continue;
                            }
                            if (tkn.equals("DEBUGON")) {
                                this.debug = true;
                                this.de.addElement(new DocElemDebug(true));
                                this.eatTag(tkn);
                                continue;
                            }
                            if (tkn.equals("DEBUGOFF")) {
                                this.debug = false;
                                this.de.addElement(new DocElemDebug(false));
                                this.eatTag(tkn);
                                continue;
                            }
                            if (this.parseEngine(tkn, this.currCCT)) continue;
                            System.out.println("Mainlp: false from parseEng at " + this.st.lineno() + ", tkn=" + tkn + ", cct=" + this.currCCT + " 1stEnt=" + (String)this.currCCT[0]);
                            if (tkn.equals("/HTML")) {
                                this.getCkForRBkt();
                                break block18;
                            }
                            System.err.println("mainlp(): ignoring '" + tkn + "' at line " + this.st.lineno());
                            this.eatThruEndTag(tkn);
                            continue;
                        }
                        if (tkn.equals("<EOF>")) continue block4;
                        String str = this.getAString(tkn, "<");
                        if (this.debug) {
                            System.out.println("mainlp adding str '" + str + "' at " + this.st.lineno());
                        }
                        this.de.addElement(new DocElemString(str));
                    }
                    break;
                }
                throw new InvalidHTMLException("Mainlp: expected 'HTML', got '" + tkn + "'");
            }
            throw new InvalidHTMLException("Mainlp: expected '<', got '" + tkn + "'");
        }
        this.de.addElement(new DocElemNewLine());
        this.doc.des = new DocumentElement[this.de.size()];
        this.de.copyInto(this.doc.des);
        return this.doc;
    }

    private String getToken() {
        String tok;
        this.isAmpVarGT = false;
        if (this.pushedTkn != null) {
            tok = this.pushedTkn;
            this.pushedTkn = null;
            if (!tok.equals("&")) {
                return tok;
            }
        } else {
            tok = this.getNextT();
        }
        while (tok.equals("<")) {
            tok = this.getNextT();
            if (tok.equals("!")) {
                this.eatComment();
                tok = this.getNextT();
                continue;
            }
            this.st.pushBack();
            return "<";
        }
        if (tok.equals("&") && this.returnSpaces) {
            String tok2 = this.getNextT();
            String tok3 = this.getNextT();
            if (!tok3.equals(";")) {
                if (this.debug) {
                    System.out.println("getToken pushing1 '" + tok2 + "' " + tok3);
                }
                this.st.pushBack();
                this.pushToken(tok2);
                return tok;
            }
            int ix = 0;
            int il = tok2.length() - 2;
            if (il < this.amperNms.length && (ix = this.amperNms[il].indexOf(";" + tok2.toLowerCase())) >= 0) {
                this.isAmpVarGT = true;
                return this.amperVals[il][ix / (il + 2)];
            }
            if (tok2.startsWith("#") && tok2.length() < 5) {
                long val = this.HexStringToDec(tok2.substring(1));
                String hxS = new String(new byte[]{(byte)val});
                return hxS;
            }
            if (tok2.equals("DEBUGON")) {
                this.debug = true;
                this.de.addElement(new DocElemDebug(true));
                return "";
            }
            if (tok2.equals("DEBUGOFF")) {
                this.debug = false;
                this.de.addElement(new DocElemDebug(false));
                return "";
            }
            System.out.println("getToken pushing2 '" + tok2 + "'");
            this.st.pushBack();
            this.pushToken(tok2);
            return tok;
        }
        if (this.debug) {
            System.out.println("getToken() returning '" + tok + "' at " + this.st.lineno());
        }
        return tok;
    }

    private void pushToken(String tok) {
        if (this.pushedTkn != null) {
            System.err.println("pushToken() overlayed " + this.pushedTkn + " with " + tok + " at " + this.st.lineno());
        }
        this.pushedTkn = tok;
    }

    private String getNextT() {
        this.lastCharGNT = this.thisCharGNT;
        block9: while (true) {
            try {
                this.st.nextToken();
            }
            catch (IOException ex) {
                System.err.println(">*>*>*>StreamTokenizer error " + ex);
                this.thisCharGNT = "";
                return "";
            }
            switch (this.st.ttype) {
                case -2: {
                    System.out.println("TT_NUMBER " + this.st.nval);
                    Double d = new Double(this.st.nval);
                    this.thisCharGNT = "" + d.intValue();
                    return this.thisCharGNT;
                }
                case -3: {
                    this.thisCharGNT = this.st.sval;
                    return this.thisCharGNT;
                }
                case -1: {
                    this.thisCharGNT = "<EOF>";
                    return "<EOF>";
                }
                case 34: {
                    this.thisCharGNT = this.st.sval;
                    return this.thisCharGNT;
                }
                case 10: 
                case 32: {
                    this.thisCharGNT = " ";
                    if (this.returnSpaces && !this.lastCharGNT.equals(" ")) {
                        return " ";
                    }
                    this.lastCharGNT = " ";
                    continue block9;
                }
            }
            break;
        }
        this.thisCharGNT = new String(new byte[]{(byte)this.st.ttype});
        return this.thisCharGNT;
    }

    private String getAString(String tkn, String terminators) {
        String str;
        StringBuffer sb;
        block4: {
            this.returnSpaces = true;
            if (tkn.equals("&")) {
                this.pushToken("&");
                tkn = this.getToken();
            }
            sb = new StringBuffer();
            if (this.lastCharGNT.equals(" ")) {
                sb.append(" ");
            }
            str = "";
            while (true) {
                sb.append(tkn);
                tkn = this.getToken();
                if (tkn.length() < 1) continue;
                if (tkn.equals("<EOF>")) break block4;
                int ix = terminators.indexOf(tkn.substring(0, 1));
                if (ix >= 0 & !this.isAmpVarGT) break;
            }
            this.pushToken(tkn);
        }
        str = sb.toString();
        if (this.debug) {
            System.out.println("getAString() terminates '" + str + "' with " + tkn + " at " + this.st.lineno());
        }
        this.returnSpaces = false;
        return str;
    }

    private Color getColor(String tkn) {
        if (tkn.length() == 7 & tkn.startsWith("#")) {
            int r = (int)this.HexStringToDec(tkn.substring(1, 3));
            int g = (int)this.HexStringToDec(tkn.substring(3, 5));
            int b = (int)this.HexStringToDec(tkn.substring(5));
            return new Color(r, g, b);
        }
        System.err.println("getColor() invalid color value: " + tkn);
        return Color.white;
    }

    private void eatComment() {
        String tkn;
        if (this.debug) {
            System.out.println("Eating a comment at " + this.st.lineno());
        }
        if (!(tkn = this.getNextT()).startsWith("--")) {
            System.out.println("EatCmt  pushback '" + tkn + "'");
            this.st.pushBack();
            return;
        }
        do {
            if (!(tkn = this.getNextT()).equals("<EOF>")) continue;
            return;
        } while (!(tkn.equals("--") || tkn.endsWith("--") ? (tkn = this.getNextT()).equals(">") : tkn.endsWith("-->")));
    }

    private void getCkForRBkt() throws InvalidHTMLException {
        String tok = this.getNextT();
        if (tok.equals(">")) {
            return;
        }
        throw new InvalidHTMLException("Missing >");
    }

    private String getCkValue(String kw) throws InvalidHTMLException {
        String tag = this.getToken();
        if (!tag.equals("=")) {
            throw new InvalidHTMLException("Invalid keyword " + kw + ", fnd:" + tag);
        }
        String str = this.getAString("", ">");
        this.getToken();
        return str;
    }

    private String getAttributeValue(String kw) throws InvalidHTMLException {
        String tok = this.getToken();
        if (!tok.equals("=")) {
            throw new InvalidHTMLException("Invalid keyword " + kw + ", fnd:" + tok);
        }
        String str = this.getAString("", " >");
        return str;
    }

    private void eatTag(String tkn) {
        while (!tkn.equals(">")) {
            tkn = this.getNextT();
            if (tkn.equals("<EOF>")) break;
        }
    }

    private void eatThruEndTag(String tag) {
        if (this.debug) {
            System.out.println("Eating tag " + tag);
        }
        String tok = this.getToken();
        String endTag = "/" + tag;
        while (!tok.equals(">")) {
            tok = this.getToken();
            if (!tok.equals("<EOF>")) continue;
            return;
        }
        while (true) {
            if (tok.equals("<") && (tok = this.getToken()).equalsIgnoreCase(endTag)) {
                tok = this.getToken();
                return;
            }
            if (tok.equals("<EOF>")) {
                return;
            }
            tok = this.getToken();
        }
    }

    private long HexStringToDec(String xs) {
        long val = 0L;
        int i = 0;
        while (i < xs.length()) {
            int xv = this.HEX_CHARS.indexOf(xs.substring(i, i + 1).toUpperCase());
            if (xv >= 0) {
                val = val * 16L + (long)xv;
            } else {
                System.err.println("Invalid hex string '" + xs + "' at " + this.st.lineno());
            }
            ++i;
        }
        return val;
    }

    public static void main(String[] args) {
        String htmlFN = "TestParser.html";
        if (args.length > 0) {
            htmlFN = args[0];
        }
        HTMLParser hp = new HTMLParser();
        try {
            Document dd = hp.parseHTMLFile(htmlFN);
            ShowDocument sd = new ShowDocument(dd);
            sd.setExitOnClose(true);
        }
        catch (Exception ex) {
            System.err.println("main() got " + ex + " at " + hp.st.lineno());
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InvalidHTMLException
    extends Exception {
        public InvalidHTMLException(String msg) {
            super("\n  " + msg + " at line:" + HTMLParser.this.st.lineno());
        }
    }

    class ParseNOBR
    extends ParseTAG {
        ParseNOBR() {
            this.type = 25;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.de.addElement(new DocElemNOBR(true));
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemNOBR(false));
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseEATTAG
    extends ParseTAG {
        ParseEATTAG() {
            this.type = -1;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            System.out.println("Eating tag: " + tag + " at line " + HTMLParser.this.st.lineno());
            if (!tag.startsWith("/")) {
                HTMLParser.this.eatThruEndTag(tag);
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParsePRE
    extends ParseTAG {
        ParsePRE() {
            this.type = 22;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.eatThruEndTag(tag);
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseDIV
    extends ParseTAG {
        ParseDIV() {
            this.type = 21;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.eatThruEndTag(tag);
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseHTML
    extends ParseTAG {
        ParseHTML() {
            this.type = 20;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseLI
    extends ParseTAG {
        boolean doEndTag = false;

        ParseLI() {
            this.type = 19;
        }

        ParseLI(String x) {
            this.type = 19;
            this.doEndTag = true;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                if (this.doEndTag) {
                    HTMLParser.this.de.addElement(new DocElemNewLine());
                    HTMLParser.this.showLocation("<LI> ends <LI>");
                }
                String pfx = HTMLParser.ULIdx;
                if (HTMLParser.this.currListType == 1) {
                    pfx = HTMLParser.this.currOLIdx++ + HTMLParser.OLSfx;
                }
                HTMLParser.this.de.addElement(new DocElemString(pfx));
                HTMLParser.this.de.addElement(new DocElemSetInset(4));
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemSetInset(-4));
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.getCkForRBkt();
                if (this.doEndTag) {
                    System.err.println("Got /LI for parseLIX??");
                }
            }
        }
    }

    class ParseUL
    extends ParseTAG {
        ParseUL() {
            this.type = 18;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.de.addElement(new DocElemSetInset(2));
                HTMLParser.this.de.addElement(new DocElemNewLine());
                if (HTMLParser.this.currListType != 0) {
                    HTMLParser.this.saveListType.push(HTMLParser.this.currListType);
                    HTMLParser.this.saveOLIdx.push(HTMLParser.this.currOLIdx);
                }
                HTMLParser.this.currListType = 2;
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemSetInset(-2));
                if (!HTMLParser.this.saveListType.isEmpty()) {
                    HTMLParser.this.currListType = HTMLParser.this.saveListType.popInt();
                    HTMLParser.this.currOLIdx = HTMLParser.this.saveOLIdx.popInt();
                }
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseOL
    extends ParseTAG {
        ParseOL() {
            this.type = 17;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.de.addElement(new DocElemSetInset(2));
                HTMLParser.this.de.addElement(new DocElemNewLine());
                if (HTMLParser.this.currListType != 0) {
                    HTMLParser.this.saveListType.push(HTMLParser.this.currListType);
                    HTMLParser.this.saveOLIdx.push(HTMLParser.this.currOLIdx);
                }
                HTMLParser.this.currOLIdx = 1;
                HTMLParser.this.currListType = 1;
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.de.addElement(new DocElemSetInset(-2));
                if (!HTMLParser.this.saveListType.isEmpty()) {
                    HTMLParser.this.currListType = HTMLParser.this.saveListType.popInt();
                    HTMLParser.this.currOLIdx = HTMLParser.this.saveOLIdx.popInt();
                }
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseHR
    extends ParseTAG {
        ParseHR() {
            this.type = 16;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                String keyWd = HTMLParser.this.getToken();
                int hrSz = 1;
                if (keyWd.equalsIgnoreCase("SIZE")) {
                    String sz = HTMLParser.this.getCkValue(keyWd);
                    hrSz = Integer.parseInt(sz);
                } else {
                    HTMLParser.this.eatTag(keyWd);
                }
                HTMLParser.this.de.addElement(new DocElemColor(Color.gray));
                HTMLParser.this.de.addElement(new DocElemHorizLine(hrSz));
                HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseP
    extends ParseTAG {
        ParseP() {
            this.type = 15;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseBR
    extends ParseTAG {
        ParseBR() {
            this.type = 14;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseMETA
    extends ParseTAG {
        ParseMETA() {
            this.type = 13;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.eatTag("");
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseHEAD
    extends ParseTAG {
        ParseHEAD() {
            this.type = 12;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseBODY
    extends ParseTAG {
        ParseBODY() {
            this.type = 11;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                String tkn = HTMLParser.this.getToken();
                while (!tkn.equals(">")) {
                    if (tkn.equalsIgnoreCase("BGCOLOR") && (tkn = HTMLParser.this.getToken()).equals("=")) {
                        tkn = HTMLParser.this.getToken();
                        HTMLParser.this.currBGColor = HTMLParser.this.getColor(tkn);
                        HTMLParser.this.de.addElement(new DocElemBGColor(HTMLParser.this.currBGColor));
                    }
                    tkn = HTMLParser.this.getToken();
                }
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseTITLE
    extends ParseTAG {
        ParseTITLE() {
            this.type = 10;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                String title;
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.doc.title = title = HTMLParser.this.getAString("", "<");
            } else {
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseA
    extends ParseTAG {
        ParseA() {
            this.type = 9;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.saveColor.push(HTMLParser.this.currColor);
                HTMLParser.this.currColor = HTMLParser.this.linkColor;
                HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.linkColor));
                String keyWd = HTMLParser.this.getToken();
                if (keyWd.equalsIgnoreCase("HREF")) {
                    String loc = HTMLParser.this.getCkValue(keyWd);
                    String str = HTMLParser.this.getAString("", "<").trim();
                    HTMLParser.this.de.addElement(new DocElemHLString(str, loc));
                } else if (keyWd.equalsIgnoreCase("NAME")) {
                    String loc = HTMLParser.this.getCkValue(keyWd);
                    HTMLParser.this.de.addElement(new DocElemRegisterLoc(loc));
                } else {
                    HTMLParser.this.eatTag(tag);
                }
            } else {
                HTMLParser.this.currColor = HTMLParser.this.saveColor.popColor();
                HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
                HTMLParser.this.getCkForRBkt();
            }
        }
    }

    class ParseTT
    extends ParseTAG {
        ParseTT() {
            this.type = 23;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font("Monospaced", HTMLParser.this.currFont.getStyle(), HTMLParser.this.currFont.getSize());
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }
    }

    class ParseH6
    extends ParseTAG {
        ParseH6() {
            this.type = 8;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font("Monospaced", 2, HTMLParser.this.currFont.getSize() + -2);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }
    }

    class ParseH5
    extends ParseTAG {
        ParseH5() {
            this.type = 25;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font("Monospaced", 1, HTMLParser.this.currFont.getSize() + -1);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }
    }

    class ParseH4
    extends ParseTAG {
        ParseH4() {
            this.type = 8;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + 2);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }
    }

    class ParseH3
    extends ParseTAG {
        ParseH3() {
            this.type = 7;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + 5);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }
    }

    class ParseH2
    extends ParseTAG {
        ParseH2() {
            this.type = 6;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + 9);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }
    }

    class ParseH1
    extends ParseTAG {
        ParseH1() {
            this.type = 5;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemNewLine());
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize() + 13);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = (Font)HTMLParser.this.saveFont.pop();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
                HTMLParser.this.de.addElement(new DocElemNewLine());
            }
        }
    }

    class ParseCENTER
    extends ParseTAG {
        ParseCENTER() {
            this.type = 4;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemCenter());
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.de.addElement(new DocElemEndCenter());
            }
        }
    }

    class ParseFONT
    extends ParseTAG {
        boolean popColor = false;

        ParseFONT() {
            this.type = 3;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                String keyWd;
                Color newColor = HTMLParser.this.currColor;
                int newSize = HTMLParser.this.currFont.getSize();
                int newStyle = HTMLParser.this.currFont.getStyle();
                String newName = HTMLParser.this.currFont.getName();
                while (true) {
                    if ((keyWd = HTMLParser.this.getToken()).equalsIgnoreCase("COLOR")) {
                        String color = HTMLParser.this.getAttributeValue(keyWd);
                        newColor = HTMLParser.this.getColor(color);
                        continue;
                    }
                    if (keyWd.equalsIgnoreCase("SIZE")) {
                        String size = HTMLParser.this.getAttributeValue(keyWd);
                        int sz = 0;
                        if (size.startsWith("+")) {
                            sz = Integer.parseInt(size.substring(1));
                        } else if (size.startsWith("-")) {
                            sz = Integer.parseInt(size);
                        } else {
                            newSize = Integer.parseInt(size);
                        }
                        newSize += sz;
                        continue;
                    }
                    if (keyWd.equalsIgnoreCase("FACE")) {
                        String face;
                        newName = face = HTMLParser.this.getAttributeValue(keyWd);
                        continue;
                    }
                    if (keyWd.equalsIgnoreCase("STYLE")) {
                        String style = HTMLParser.this.getAttributeValue(keyWd);
                        System.out.println("Font style=" + style + " NOT IMPLIMENTED");
                        continue;
                    }
                    if (!keyWd.equals(" ")) break;
                }
                HTMLParser.this.eatTag(keyWd);
                if (newColor != HTMLParser.this.currColor) {
                    this.popColor = true;
                    HTMLParser.this.saveColor.push(HTMLParser.this.currColor);
                    HTMLParser.this.currColor = newColor;
                    HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
                }
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(newName, newStyle, newSize);
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                if (this.popColor) {
                    this.popColor = false;
                    HTMLParser.this.currColor = HTMLParser.this.saveColor.popColor();
                    HTMLParser.this.de.addElement(new DocElemColor(HTMLParser.this.currColor));
                }
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = HTMLParser.this.saveFont.popFont();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }
    }

    class ParseI
    extends ParseTAG {
        ParseI() {
            this.type = 2;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 2, HTMLParser.this.currFont.getSize());
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                HTMLParser.this.currFont = HTMLParser.this.saveFont.popFont();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }
    }

    class ParseB
    extends ParseTAG {
        int nest = 0;

        ParseB() {
            this.type = 1;
        }

        void parseTag(String tag) throws InvalidHTMLException {
            if (!tag.startsWith("/")) {
                HTMLParser.this.getCkForRBkt();
                ++this.nest;
                HTMLParser.this.saveFont.push(HTMLParser.this.currFont);
                HTMLParser.this.currFont = new Font(HTMLParser.this.currFont.getName(), 1, HTMLParser.this.currFont.getSize());
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            } else {
                HTMLParser.this.getCkForRBkt();
                --this.nest;
                if (this.nest < 0) {
                    throw new InvalidHTMLException("</B> nest error");
                }
                HTMLParser.this.currFont = HTMLParser.this.saveFont.popFont();
                HTMLParser.this.de.addElement(new DocElemFont(HTMLParser.this.currFont));
            }
        }
    }

    class ParseTAG {
        int type;

        ParseTAG() {
        }

        int getType() {
            return this.type;
        }

        void parseTag(String tag) throws InvalidHTMLException {
        }
    }
}

