/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.DocumentViewer;

import NormsTools.DocumentViewer.Document;
import NormsTools.DocumentViewer.DocumentWindow;
import NormsTools.DocumentViewer.DummyGraphics;
import NormsTools.DocumentViewer.HyperLinkMntr;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.ShowMsgBox;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.Serializable;
import java.util.Stack;

public final class DocumentWindowImpl
extends DocumentWindow {
    ShowDocument sd;
    Stack prevLoc = new Stack();
    Stack prevDoc = new Stack();
    Stack prevPrevLoc = new Stack();
    Cursor handCsr = Cursor.getPredefinedCursor(12);
    Cursor defaultCsr;
    private Cursor currCsr = this.defaultCsr = Cursor.getPredefinedCursor(0);
    Point mePressPt = null;

    public void invalidate() {
        this.pSize = null;
        this.currX = this.currInset;
        this.currY = 3;
        if (this.testing) {
            System.out.println("DW: invalidate() currX=" + this.currX);
        }
        super.invalidate();
    }

    public boolean isValid() {
        if (this.testing) {
            System.out.println("DW: isValid " + super.isValid());
        }
        return super.isValid();
    }

    public DocumentWindowImpl(Document document, ShowDocument showDocument) {
        super(document);
        this.sd = showDocument;
        this.InstanceID = "<Derived Impl>";
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = 0;
                while (n < DocumentWindowImpl.this.hlMonitors.size()) {
                    HyperLinkMntr hyperLinkMntr = (HyperLinkMntr)DocumentWindowImpl.this.hlMonitors.elementAt(n);
                    if (hyperLinkMntr.contains(mouseEvent.getPoint())) {
                        Serializable serializable;
                        String string = hyperLinkMntr.getHyperLink();
                        if (DocumentWindowImpl.this.testing) {
                            System.out.println("HyperLink: " + string);
                        }
                        if (string.startsWith(DocumentWindowImpl.this.LclAnchorPfx)) {
                            serializable = DocumentWindowImpl.this.doc.getAnchorLoc(string.substring(1));
                            if (serializable != null) {
                                DocumentWindowImpl.this.goToLocation((Point)serializable);
                            }
                        } else if (string.indexOf("://") < 0) {
                            serializable = null;
                            try {
                                serializable = Document.getDocument(string);
                                if (DocumentWindowImpl.this.testing) {
                                    System.out.println("Got doc for " + string + " at " + serializable);
                                }
                            }
                            catch (Exception exception) {
                                System.err.println("DW: mouseClicked() got " + exception);
                                if (DocumentWindowImpl.this.testing) {
                                    exception.printStackTrace();
                                }
                                return;
                            }
                            if (serializable == null) {
                                return;
                            }
                            DocumentWindowImpl.this.prevDoc.push(DocumentWindowImpl.this.doc);
                            DocumentWindowImpl.this.prevLoc.push(DocumentWindowImpl.this.sd.getDocLocation());
                            DocumentWindowImpl.this.prevPrevLoc.push(DocumentWindowImpl.this.prevLoc);
                            DocumentWindowImpl.this.prevLoc = new Stack();
                            DocumentWindowImpl.this.doc = serializable;
                            DocumentWindowImpl.this.des = DocumentWindowImpl.this.doc.getDocumentElements();
                            DocumentWindowImpl.this.currVPsize = 0;
                            DocumentWindowImpl.this.sd.loadChoices(DocumentWindowImpl.this.doc);
                            DocumentWindowImpl.this.sd.setGoBack(true);
                            DocumentWindowImpl.this.repaint();
                        } else {
                            new ShowMsgBox("Internet reference.", "Unable to connect to internet for " + string, DocumentWindowImpl.this.sd, true);
                            if (DocumentWindowImpl.this.testing) {
                                System.out.println("External anchor: " + string);
                            }
                        }
                    }
                    ++n;
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                DocumentWindowImpl.this.mePressPt = mouseEvent.getPoint();
            }
            {
                DocumentWindowImpl.this.getClass();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (DocumentWindowImpl.this.mePressPt != null) {
                    Point point = mouseEvent.getPoint();
                    if (Math.abs(DocumentWindowImpl.this.mePressPt.x - point.x) + Math.abs(DocumentWindowImpl.this.mePressPt.y - point.y) < 5 && !DocumentWindowImpl.this.mePressPt.equals(point)) {
                        this.mouseClicked(mouseEvent);
                    }
                    DocumentWindowImpl.this.mePressPt = null;
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }

            public void mouseExited(MouseEvent mouseEvent) {
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            {
                DocumentWindowImpl.this.getClass();
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = 0;
                while (n < DocumentWindowImpl.this.hlMonitors.size()) {
                    String string;
                    Point point;
                    HyperLinkMntr hyperLinkMntr = (HyperLinkMntr)DocumentWindowImpl.this.hlMonitors.elementAt(n);
                    if (hyperLinkMntr.contains(mouseEvent.getPoint()) && (point = (string = hyperLinkMntr.getHyperLink()).startsWith(DocumentWindowImpl.this.LclAnchorPfx) ? DocumentWindowImpl.this.doc.getAnchorLoc(string.substring(1)) : DocumentWindowImpl.this.doc.getAnchorLoc(string)) != null) {
                        DocumentWindowImpl.this.setCursor(DocumentWindowImpl.this.handCsr);
                        return;
                    }
                    ++n;
                }
                DocumentWindowImpl.this.setCursor(DocumentWindowImpl.this.defaultCsr);
            }
        });
    }

    public void paint(Graphics graphics) {
        if (this.testing) {
            System.out.println("DW: paint() graphics:" + graphics + ", font=" + graphics.getFont());
        }
        if (this.testing) {
            System.out.println("DW: paint  pSize=" + this.pSize + "\n     parentSize=" + this.getParent().getSize() + "\n        sp.size=" + this.sd.sp.getSize() + "\n  ClipBnds=" + graphics.getClipBounds());
        }
        this.currGraphics = graphics;
        if (this.pSize == null) {
            this.pSize = this.getSpecs();
        }
        if (this.sd.sp.getViewportSize().width != this.currVPsize) {
            if (this.testing) {
                System.out.println("DW: paint() -> size changed from " + this.currVPsize + " to " + this.sd.sp.getViewportSize().width);
            }
            this.pSize = this.getSpecs();
            this.getParent().setSize(this.pSize);
            super.invalidate();
            this.sd.sp.validate();
        }
        this.currX = this.currInset;
        this.currY = 3;
        this.currFM = graphics.getFontMetrics();
        this.currVPsize = this.sd.sp.getViewportSize().width;
        this.hlMonitors.removeAllElements();
        this.nextLineQ.removeAllElements();
        if (this.currBGColor != Color.white & this.pSize != null) {
            graphics.setColor(this.currBGColor);
            graphics.fillRect(0, 0, this.pSize.width + 10, this.pSize.height);
            graphics.setColor(this.currColor);
        }
        this.displayDoc(graphics);
        if (this.testing) {
            System.out.println("paint() end at " + System.currentTimeMillis());
        }
    }

    private synchronized Dimension getSpecs() {
        FontMetrics fontMetrics;
        if (this.testing) {
            System.out.println("DW: getSpecs " + this.getFont() + "\n superSize=" + super.getSize() + "\n   sp.size=" + this.sd.sp.getSize() + "\n sp.VPSize=" + this.sd.sp.getViewportSize() + " inset=" + this.sd.sp.getInsets());
        }
        if ((fontMetrics = this.getFontMetrics(this.getFont())) != this.currFM && this.currFM != null) {
            System.err.println("getSpecs(): different fonts? \n  nfm=" + fontMetrics + "\n     vs currFM=" + this.currFM);
        }
        int n = fontMetrics.getHeight();
        if (this.currFM != null && n != this.currFM.getHeight()) {
            System.err.println("getSpecs(): different fonts? \n  hFM=" + n + "\n     vs currHFM=" + this.currHFM);
        }
        int n2 = super.getSize().width;
        int n3 = this.sd.sp.getInsets().left + this.sd.sp.getInsets().right;
        n3 = 24;
        n2 = this.sd.sp.getSize().width - n3;
        if (n2 == 0) {
            n2 = 300;
            if (this.testing) {
                System.out.println("DW.getSpecs() width=0, set to " + n2);
            }
        }
        DocumentWindow documentWindow = new DocumentWindow();
        documentWindow.currFM = fontMetrics;
        documentWindow.currVPsize = Math.max(n2, 300);
        documentWindow.maxLineLen = 0;
        documentWindow.des = this.des;
        documentWindow.InstanceID = "<Dummy for getSpecs>";
        DummyGraphics dummyGraphics = new DummyGraphics();
        documentWindow.displayDoc(dummyGraphics);
        Dimension dimension = new Dimension(documentWindow.maxLineLen, documentWindow.currX <= documentWindow.currInset ? documentWindow.currY : documentWindow.currY + documentWindow.currHFM);
        if (this.testing) {
            System.out.println("DW.getSpecs(): new size " + dimension + "\n  lL=" + n2 + ", hFM=" + n + " vs " + documentWindow.currHFM + ", currX=" + this.currX + "  " + System.currentTimeMillis());
        }
        return dimension;
    }

    public void goBack() {
        if (!this.prevLoc.isEmpty()) {
            Point point = (Point)this.prevLoc.pop();
            this.sd.setGoBack(!this.prevLoc.isEmpty() || !this.prevDoc.isEmpty());
            this.sd.showLocation(point);
            if (this.testing) {
                System.out.println("goBack to " + point);
            }
        } else if (!this.prevDoc.isEmpty()) {
            this.doc = (Document)this.prevDoc.pop();
            this.des = this.doc.getDocumentElements();
            this.currVPsize = 0;
            this.prevLoc = (Stack)this.prevPrevLoc.pop();
            Point point = (Point)this.prevLoc.pop();
            this.sd.setGoBack(!this.prevLoc.isEmpty() || !this.prevDoc.isEmpty());
            this.sd.loadChoices(this.doc);
            this.sd.showLocation(point);
            this.repaint();
        } else {
            System.err.println("goBack() with empty stacks");
        }
    }

    public void update(Graphics graphics) {
        System.out.println("update()");
        this.paint(graphics);
    }

    protected void goToLocation(Point point) {
        if (this.testing) {
            System.out.println("goToLocation " + point);
        }
        this.prevLoc.push(this.sd.getDocLocation());
        this.sd.setGoBack(true);
        this.sd.showLocation(point);
    }

    public Dimension getPreferredSize() {
        if (this.pSize == null) {
            this.pSize = this.getSpecs();
        }
        if (this.testing) {
            System.out.println("DW: getPreferredSize    " + this.pSize + "  " + System.currentTimeMillis());
        }
        return this.pSize;
    }

    public void setSize(Dimension dimension) {
        if (this.testing) {
            System.out.println("DW: setSize: " + dimension);
        }
        this.pSize = dimension;
    }

    public Dimension getSize() {
        if (this.testing) {
            System.out.println("DW.getSize: pSize=" + this.pSize + "\n      super.Size=" + super.getSize() + "\n         sp.size=" + this.sd.sp.getSize());
        }
        if (this.pSize == null) {
            return super.getSize();
        }
        return this.pSize;
    }

    public Dimension getMinimumSize() {
        if (this.pSize == null) {
            if (this.testing) {
                System.out.println("DW: getMinimumSize " + super.getSize());
            }
            this.pSize = this.getSpecs();
        }
        if (this.testing) {
            System.out.println("DW: getMinimumSize " + this.pSize);
        }
        return this.pSize;
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

