/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import NormsTools.BigTextAreaListener;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class BigTextArea
extends TextArea
implements ActionListener {
    private final boolean debug = false;
    private Vector savedSections = new Vector();
    private final int NONE_SAVED = -1;
    private int szCurrSection = 0;
    private int currSection = 0;
    private int maxSectionSz = 30000;
    private int lastSectionSaved = -1;
    private StringBuffer svText;
    private boolean doingSuperAppend = false;
    private MenuItem upMI;
    private MenuItem downMI;
    private Button upB;
    private Button downB;
    private BigTextAreaListener btaL = null;
    private String svUpLbl = "";
    private String svDownLbl = "";
    private final char nlChar = (char)10;

    public void addBigTextAreaListener(BigTextAreaListener bigTextAreaListener) {
        this.btaL = bigTextAreaListener;
    }

    public Dimension getPreferredSizeXXX() {
        System.out.println("getPreferredSize: " + super.getPreferredSize() + " parent= " + this.getParent());
        return super.getPreferredSize();
    }

    public synchronized void goToTop() {
        this.saveBottom();
        this.currSection = 0;
        super.setText((String)this.savedSections.elementAt(this.currSection));
        this.enableControls();
    }

    private Vector breakUpStr(String string, int n) {
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < string.length() - 1) {
            int n3 = this.findMaxNL(string, n2, n);
            if (n3 < 0) {
                if (n2 >= string.length()) break;
                vector.addElement(string.substring(n2));
                break;
            }
            vector.addElement(string.substring(n2, ++n3));
            n2 = n3;
            n = this.maxSectionSz;
        }
        return vector;
    }

    public synchronized void goDown() {
        if (this.currSection > this.lastSectionSaved) {
            return;
        }
        ++this.currSection;
        this.enableControls();
        if (this.currSection > this.lastSectionSaved) {
            super.setText(this.svText.toString());
            this.szCurrSection = this.svText.length();
            this.svText.setLength(0);
        } else {
            super.setText((String)this.savedSections.elementAt(this.currSection));
        }
    }

    public synchronized void select(int n, int n2) {
        if (this.lastSectionSaved == -1) {
            super.select(n, n2);
        } else {
            int n3 = 0;
            boolean bl = false;
            int n4 = 0;
            while (n4 < this.savedSections.size()) {
                int n5 = ((String)this.savedSections.elementAt(n4)).length();
                if (n >= n3 && n < n3 + n5) {
                    this.goToSection(n4);
                    bl = true;
                    break;
                }
                n3 += n5;
                ++n4;
            }
            if (!bl) {
                this.goToBottom();
            }
            super.select(n - n3, n2 - n3);
        }
    }

    private void finishInit() {
        this.svText = new StringBuffer(2 * this.maxSectionSz);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = ((Button)object).getLabel();
        if (string.startsWith(this.svUpLbl)) {
            this.goUp();
        } else if (string.startsWith(this.svDownLbl)) {
            this.goDown();
        } else {
            System.err.println("Unknown ae " + actionEvent + " src=" + actionEvent.getSource());
        }
    }

    private void tellListener() {
        if (this.btaL != null) {
            this.btaL.addedSection(this.lastSectionSaved);
        }
    }

    public synchronized void goToBottom() {
        if (this.currSection == this.lastSectionSaved + 1) {
            return;
        }
        this.currSection = this.lastSectionSaved + 1;
        super.setText(this.svText.toString());
        this.szCurrSection = this.svText.length();
        this.svText.setLength(0);
        this.enableControls();
    }

    public synchronized void flush() {
        if (this.svText.length() > 0) {
            this.savedSections.addElement(this.svText.toString());
            this.svText.setLength(0);
            this.szCurrSection = 0;
            ++this.lastSectionSaved;
            this.tellListener();
            this.enableControls();
            System.out.println("Flushed section " + this.lastSectionSaved);
        } else if (this.szCurrSection > 0) {
            this.savedSections.addElement(super.getText());
            ++this.lastSectionSaved;
            this.tellListener();
            this.enableControls();
        }
    }

    public String getSelectedText() {
        if (this.lastSectionSaved == -1 || this.currSection == 0) {
            return super.getSelectedText();
        }
        String string = "";
        string = this.currSection <= this.lastSectionSaved ? ((String)this.savedSections.elementAt(this.currSection)).substring(this.getSelectionStart(), this.getSelectionEnd()) : super.getText().substring(this.getSelectionStart(), this.getSelectionEnd());
        return string;
    }

    public boolean findStr(String string) {
        return true;
    }

    private void saveBottom() {
        if (this.currSection > this.lastSectionSaved) {
            String string = super.getText();
            this.svText.setLength(0);
            this.svText.append(string);
            this.szCurrSection = string.length();
        }
    }

    private int findMaxNL(String string, int n, int n2) {
        int n3 = -1;
        int n4 = n;
        int n5;
        while ((n5 = string.indexOf(10, n)) >= 0 && n5 - n4 <= n2) {
            n3 = n5;
            n = n5 + 1;
        }
        return n3;
    }

    private void enableControls() {
        if (this.upMI != null) {
            this.upMI.setEnabled(this.currSection > 0);
        }
        if (this.upB != null) {
            this.upB.setEnabled(this.currSection > 0);
        }
        if (this.downMI != null) {
            this.downMI.setEnabled(this.currSection <= this.lastSectionSaved);
        }
        if (this.downB != null) {
            this.downB.setEnabled(this.currSection <= this.lastSectionSaved);
        }
        this.changeButtons();
    }

    public BigTextArea() {
        this.finishInit();
    }

    public BigTextArea(String string) {
        super(string);
        this.finishInit();
    }

    public BigTextArea(int n) {
        this.maxSectionSz = n;
        this.finishInit();
    }

    public BigTextArea(String string, int n) {
        super(string);
        this.maxSectionSz = n;
        this.finishInit();
    }

    public BigTextArea(int n, int n2, int n3) {
        super(n, n2);
        this.maxSectionSz = n3;
        this.finishInit();
    }

    public BigTextArea(String string, int n, int n2, int n3) {
        super(string, n, n2);
        this.maxSectionSz = n3;
        this.finishInit();
    }

    public void setMenuItems(MenuItem menuItem, MenuItem menuItem2) {
        this.upMI = menuItem;
        this.downMI = menuItem2;
    }

    public void setButtons(Button button, Button button2, boolean bl) {
        this.upB = button;
        this.svUpLbl = button.getLabel();
        this.downB = button2;
        this.svDownLbl = button2.getLabel();
        if (bl) {
            this.upB.addActionListener(this);
            this.downB.addActionListener(this);
            this.upB.setBackground(Color.yellow);
            this.downB.setBackground(Color.yellow);
        }
    }

    public void setMaxSectionSize(int n) {
        this.maxSectionSz = n;
        this.svText.ensureCapacity(n);
    }

    public int getMaxSectionSize() {
        return this.maxSectionSz;
    }

    private void changeButtons() {
        if (this.btaL != null && this.upB != null) {
            this.upB.setLabel(this.svUpLbl + " " + (this.currSection + 1) + (this.lastSectionSaved >= 0 ? "/" + (this.lastSectionSaved + 2) : ""));
            this.upB.invalidate();
            if (this.upB.getParent() != null) {
                this.upB.getParent().validate();
            }
            this.downB.setLabel(this.svDownLbl + " " + (this.currSection + 1) + (this.lastSectionSaved >= 0 ? "/" + (this.lastSectionSaved + 2) : ""));
            this.downB.invalidate();
            if (this.downB.getParent() != null) {
                if (this.downB.getParent().getParent() != null) {
                    this.downB.getParent().getParent().validate();
                }
                this.downB.getParent().validate();
            }
        }
    }

    public synchronized void goToSection(int n) {
        if (n < 0 || n > this.lastSectionSaved + 1 || this.currSection == n) {
            return;
        }
        this.saveBottom();
        this.currSection = n;
        super.setText((String)this.savedSections.elementAt(this.currSection));
        this.enableControls();
    }

    public boolean findNextStr() {
        return true;
    }

    public synchronized void append(String string) {
        if (this.currSection > this.lastSectionSaved) {
            this.doingSuperAppend = true;
            super.append(string);
            this.doingSuperAppend = false;
            this.szCurrSection += string.length();
            if (this.szCurrSection > this.maxSectionSz) {
                this.savedSections.addElement(super.getText());
                super.setText("");
                this.szCurrSection = 0;
                ++this.currSection;
                ++this.lastSectionSaved;
                this.tellListener();
                this.enableControls();
            }
        } else {
            this.svText.append(string);
            this.szCurrSection += string.length();
            if (this.szCurrSection > this.maxSectionSz) {
                this.savedSections.addElement(this.svText.toString());
                this.svText.setLength(0);
                this.szCurrSection = 0;
                ++this.lastSectionSaved;
                this.tellListener();
                this.enableControls();
            }
        }
    }

    public synchronized void goUp() {
        if (this.currSection == 0) {
            return;
        }
        this.saveBottom();
        this.currSection += -1;
        super.setText((String)this.savedSections.elementAt(this.currSection));
        this.enableControls();
    }

    public synchronized String getText() {
        if (this.lastSectionSaved == -1 || this.doingSuperAppend) {
            return super.getText();
        }
        StringBuffer stringBuffer = new StringBuffer((this.lastSectionSaved + 2) * this.maxSectionSz);
        int n = 0;
        while (n <= this.lastSectionSaved) {
            stringBuffer.append((String)this.savedSections.elementAt(n));
            ++n;
        }
        if (this.currSection > this.lastSectionSaved) {
            stringBuffer.append(super.getText());
        } else {
            stringBuffer.append(this.svText.toString());
        }
        return stringBuffer.toString();
    }

    public synchronized void setText(String string) {
        if (string.length() < this.maxSectionSz) {
            super.setText(string);
            this.svText.setLength(0);
            this.currSection = 0;
            this.szCurrSection = string.length();
            this.savedSections.removeAllElements();
            this.lastSectionSaved = -1;
            this.enableControls();
            return;
        }
        Vector vector = this.breakUpStr(string, this.maxSectionSz);
        this.savedSections.removeAllElements();
        int n = 0;
        while (n < vector.size() - 1) {
            this.savedSections.addElement(vector.elementAt(n));
            ++n;
        }
        super.setText((String)vector.lastElement());
        this.szCurrSection = ((String)vector.lastElement()).length();
        this.lastSectionSaved = vector.size() - 2;
        this.currSection = this.lastSectionSaved + 1;
        this.svText.setLength(0);
        this.tellListener();
        this.enableControls();
    }
}

