/*
 * Decompiled with CFR 0.152.
 */
import NormsTools.AskMultipleChoices;
import NormsTools.BigTextArea;
import NormsTools.BigTextAreaListener;
import NormsTools.ChoiceOfYesOrNo;
import NormsTools.DocumentViewer.ShowDocument;
import NormsTools.ErrDialog;
import NormsTools.GetInput;
import NormsTools.MakeEnterDoAction;
import NormsTools.SaveStdOutput;
import NormsTools.ShowMsgBox;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class CmprFolders
extends Frame
implements ActionListener,
FilenameFilter,
BigTextAreaListener,
ItemListener,
TextListener {
    private final String title = "Compare Directory contents: Source vs target - 21 Nov 2001";
    private final String helpFN = "CmprFolders.html";
    private String propFN = "CmprFolders.ini";
    public static final String CMPRFoldersListExt = ".cfl";
    public static final String JARext = ".jar";
    private static final String LogFN = "CmprFolders.log";
    private static final String SourceDirNM = "SourceDir";
    private static final String TargetDirNM = "TargetDir";
    private static final String FiltersNM = "Filters";
    private static final String CopyToNM = "CopyToDir";
    private static final String AfterDateNM = "AfterDate";
    private static final String UseAfterDateNM = "useAfterDate";
    private static final String DisplayWhichNM = "Display";
    private static final String CopyCommandNM = "CopyCmd";
    private static final String FNOnlyNM = "FileNameOnly";
    private static final String FullPathNM = "FullPath";
    private static final String SubPathNM = "SubPath";
    private static final String InclSubDirNM = "InclSubDir";
    private static final String ShowNestingNM = "ShowNesting";
    private static final String ShowDiffDatesNM = "ShowDiffDates";
    private static final String CopyToMatchingNM = "CopyToMatching";
    private static final String AutoNoNM = "AutoNo";
    static final String blanks = "                                                                                              ";
    static final int LEN_PFX = 8;
    int FN_WIDTH = 70;
    static final int LEN_DATE = 17;
    static final String TAB_C = "\u00a0";
    static final char TAB_C_REPLACE = '*';
    static final int MIN_FULLPATH = 10;
    SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yy hh:mm a");
    MenuBar mBar = new MenuBar();
    Menu fMenu = new Menu("File");
    Menu sMenu = new Menu("Edit");
    Menu hMenu = new Menu("Help");
    MenuItem fmCopy = new MenuItem("Copy...", new MenuShortcut(67));
    MenuItem fmOpenP = new MenuItem("Open props...");
    MenuItem fmExit = new MenuItem("Exit", new MenuShortcut(88));
    MenuItem smFind = new MenuItem("Find...", new MenuShortcut(70));
    MenuItem smFindNext = new MenuItem("Find Next", new MenuShortcut(71));
    MenuItem smSelAll = new MenuItem("Select All", new MenuShortcut(65));
    MenuItem smOptions = new MenuItem("Options...", new MenuShortcut(79));
    MenuItem hmAbout = new MenuItem("About Compare folders");
    MenuItem hmHelp = new MenuItem("Help Topics");
    Checkbox omFNOnly = new Checkbox("Show Filename Only", false);
    Checkbox omFullPath = new Checkbox("Show FullPath", true);
    Checkbox omSubPath = new Checkbox("SubPath", false);
    Checkbox omSubDir = new Checkbox("Include SubDirectory", true);
    Checkbox omShowNesting = new Checkbox("Show subdirectories searched", false);
    Checkbox omDiffDates = new Checkbox("Show different Dates only");
    Checkbox omCopyMatching = new Checkbox("Copy to matching subdirectories", true);
    Checkbox omAutoNo = new Checkbox("Automatic No for overwrite", true);
    Checkbox omTesting = new Checkbox("Testing mode", false);
    Checkbox omAfterDate = new Checkbox("Show only files modified after:", false);
    Checkbox omCompareList = new Checkbox("Compare Files List(.cfl) to directory", false);
    TextField sFileTF = new TextField(50);
    TextField tFileTF = new TextField(50);
    TextField filterTF = new TextField(50);
    final String cmprBtnCompare = "Compare";
    final String cmprBtnCrtList = "Crt List";
    Button getSFile = new Button("Choose");
    Button getTFile = new Button("Choose");
    Button compareBtn = new Button("Compare");
    Button clearTA = new Button("Clear");
    Button stopBtn = new Button("Stop");
    CheckboxGroup CBgrp = new CheckboxGroup();
    Checkbox SourceOnly = new Checkbox("Source only", this.CBgrp, false);
    Checkbox TargetOnly = new Checkbox("Target only ", this.CBgrp, false);
    Checkbox Both = new Checkbox("Both", this.CBgrp, true);
    final int dspCBIdx = 0;
    final int dspStrIdx = 1;
    final int dspEntryLen = 2;
    Object[] displayCBs = new Object[]{this.Both, "Both", this.TargetOnly, "Target", this.SourceOnly, "Source"};
    BigTextArea outArea;
    Panel p4R = new Panel();
    Button goUpB = new Button("Up");
    Button goDownB = new Button("Down");
    PopupMenu helpPUM = new PopupMenu("Compare Folders Help");
    MouseListener ml = new MouseEventHandler();
    Hashtable helps = new Hashtable();
    String[] filterExts;
    String sFileInDir = "";
    String tFileInDir = "";
    String filters = "*.*";
    String copyToDir = "";
    String displayWhich = "Both";
    String afterDate = "";
    String copyCommand = "XCopy";
    File sFileIn;
    File tFileIn;
    ShowOptions shwOpts = null;
    Calendar selDate = null;
    Calendar workCal = Calendar.getInstance();
    Frame showRes;
    Frame errMsgFrm = new Frame();
    Properties ourProps;
    boolean bothDir = true;
    boolean stopCompare = false;
    boolean comparingFiles = false;
    boolean stopCopying = false;
    boolean copyingFiles = false;
    static boolean Testing = false;
    boolean usingStdOutput = false;
    boolean propsChanged = false;
    static int totalDiffs = 0;
    static int totalMatches = 0;
    static int diffDates = 0;
    static int extraSource = 0;
    static int extraTarget = 0;
    static int totalSource = 0;
    static int totalTarget = 0;
    String findWhat = "";
    int findWhere = 0;
    TextField monTF = new TextField(2);
    TextField dayTF = new TextField(2);
    TextField yearTF = new TextField("2000", 4);
    TextField[] inputTF = new TextField[]{this.yearTF, this.monTF, this.dayTF};
    BufferedWriter theList = null;

    String RAdj(int n, int n2) {
        String string = Integer.toString(n);
        if (string.length() < n2) {
            return blanks.substring(0, n2 - string.length()) + string;
        }
        return string.substring(0, n2);
    }

    String LAdj(String string, int n) {
        if (string.indexOf(TAB_C) >= 0) {
            string.replace(TAB_C.charAt(0), '*');
            System.err.println("Record contains TAB_C. Replacing with " + '*' + "\n" + string);
        }
        if (string.length() < n) {
            return TAB_C + string + blanks.substring(0, n - string.length()) + TAB_C;
        }
        return TAB_C + string + TAB_C;
    }

    public void addedSection(int n) {
        if (n == 0) {
            this.p4R.removeAll();
            this.p4R.add(this.goUpB);
            this.p4R.add(this.goDownB);
            this.goUpB.invalidate();
            this.goDownB.invalidate();
            this.goUpB.getParent().validate();
        }
    }

    void sortList(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length - 1) {
            int n2 = n + 1;
            while (n2 < stringArray.length) {
                if (stringArray[n].compareTo(stringArray[n2]) > 0) {
                    String string = stringArray[n];
                    stringArray[n] = stringArray[n2];
                    stringArray[n2] = string;
                }
                ++n2;
            }
            ++n;
        }
    }

    static void usage(String string) {
        System.out.println("Usage: java CmprFolders [-source Dir1 Dir2] [-debug | -LOG]\n  " + string);
        System.exit(0);
    }

    private void setSelDate() {
        if (this.omAfterDate.getState()) {
            this.selDate = Calendar.getInstance();
            this.selDate.setLenient(false);
            this.selDate.clear();
            int n = 0;
            boolean bl = false;
            try {
                this.selDate.set(1, Integer.parseInt(this.yearTF.getText()));
                this.selDate.get(1);
                n = 1;
                this.selDate.set(2, Integer.parseInt(this.monTF.getText()) - 1);
                this.selDate.get(2);
                n = 2;
                this.selDate.set(5, Integer.parseInt(this.dayTF.getText()));
                this.selDate.getTime();
                bl = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (bl) {
                if (Testing) {
                    System.out.println(new SimpleDateFormat("MM/dd/yyyy").format(this.selDate.getTime()));
                }
            } else {
                this.omAfterDate.setState(false);
                if (Testing) {
                    System.out.println("Invalid date field " + n + " " + this.inputTF[n].getText());
                }
            }
        } else {
            System.out.println("setSelDate called with AfterDate off");
        }
    }

    boolean dateWanted(Date date) {
        if (!this.omAfterDate.getState()) {
            return true;
        }
        if (this.selDate == null) {
            System.err.println("dateWanted() with selDate = null?");
            return true;
        }
        this.workCal.setTime(date);
        return this.selDate.before(this.workCal);
    }

    public CmprFolders(String[] stringArray) {
        int n = 0;
        try {
            n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase("-both")) {
                    this.bothDir = true;
                } else if (stringArray[n].equalsIgnoreCase("-source")) {
                    if (n + 3 > stringArray.length) {
                        CmprFolders.usage("Invalid args. -source needs 2 directories");
                    }
                    this.sFileIn = new File(stringArray[n + 1]);
                    if (!this.sFileIn.exists()) {
                        CmprFolders.usage("File not found " + stringArray[n + 1]);
                    }
                    if (!this.sFileIn.isDirectory()) {
                        CmprFolders.usage("Invalid Directory " + stringArray[n + 1]);
                    }
                    this.sFileInDir = stringArray[n + 1];
                    this.tFileIn = new File(stringArray[n + 2]);
                    if (!this.tFileIn.exists()) {
                        CmprFolders.usage("File not found " + stringArray[n + 2]);
                    }
                    if (!this.tFileIn.isDirectory()) {
                        CmprFolders.usage("Invalid Directory " + stringArray[n + 2]);
                    }
                    this.tFileInDir = stringArray[n + 2];
                    n += 2;
                } else if (stringArray[n].equalsIgnoreCase("-LOG")) {
                    try {
                        SaveStdOutput.start(LogFN);
                        this.usingStdOutput = true;
                        System.out.println("Log file started");
                    }
                    catch (Exception exception) {
                        System.err.println("Error starting log file " + exception);
                    }
                } else if (stringArray[n].equalsIgnoreCase("-DEBUG") || stringArray[n].equals("-t")) {
                    Testing = true;
                } else if (stringArray[n].equals("?")) {
                    CmprFolders.usage("");
                } else {
                    CmprFolders.usage("Invalid args: " + stringArray[n]);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            System.err.println("Ex in init() " + n + " " + stringArray.length + " " + exception);
        }
        this.ourProps = new Properties();
        this.openProps(true);
        this.setTitle("Compare Directory contents: Source vs target - 21 Nov 2001");
        this.fMenu.add(this.fmOpenP);
        this.fmOpenP.addActionListener(this);
        this.fMenu.addSeparator();
        this.fmCopy.addActionListener(this);
        this.fmCopy.setActionCommand("Copy");
        this.fmCopy.setEnabled(false);
        this.fMenu.add(this.fmCopy);
        this.fmExit.addActionListener(this);
        this.fMenu.addSeparator();
        this.fMenu.add(this.fmExit);
        this.mBar.add(this.fMenu);
        this.smFind.addActionListener(this);
        this.smFind.setActionCommand("Find");
        this.sMenu.add(this.smFind);
        this.smFindNext.addActionListener(this);
        this.smFindNext.setActionCommand("Find Next");
        this.smFindNext.setEnabled(false);
        this.sMenu.add(this.smFindNext);
        this.smSelAll.addActionListener(this);
        this.smSelAll.setActionCommand("Select All");
        this.smSelAll.setEnabled(false);
        this.sMenu.add(this.smSelAll);
        this.sMenu.addSeparator();
        this.smOptions.addActionListener(this);
        this.sMenu.add(this.smOptions);
        this.mBar.add(this.sMenu);
        this.omFNOnly.addItemListener(this);
        this.hMenu.add(this.hmAbout);
        this.hmAbout.addActionListener(this);
        this.hMenu.add(this.hmHelp);
        this.hmHelp.addActionListener(this);
        this.mBar.add(this.hMenu);
        this.setMenuBar(this.mBar);
        Panel panel = new Panel();
        Label label = new Label("Source:");
        panel.add(label);
        ((TextComponent)this.sFileTF).setText(this.sFileInDir);
        this.sFileTF.addTextListener(this);
        this.sFileTF.addMouseListener(this.ml);
        panel.add(this.sFileTF);
        this.getSFile.addActionListener(this);
        panel.add(this.getSFile);
        Panel panel2 = new Panel();
        Label label2 = new Label("Target: ");
        panel2.add(label2);
        ((TextComponent)this.tFileTF).setText(this.tFileInDir);
        this.tFileTF.addTextListener(this);
        this.tFileTF.addMouseListener(this.ml);
        panel2.add(this.tFileTF);
        this.getTFile.addActionListener(this);
        panel2.add(this.getTFile);
        Panel panel3 = new Panel();
        Label label3 = new Label("Filter: ");
        panel3.add(label3);
        ((TextComponent)this.filterTF).setText(this.filters);
        this.filterTF.addTextListener(this);
        this.filterTF.addMouseListener(this.ml);
        panel3.add(this.filterTF);
        Panel panel4 = new Panel();
        panel4.setLayout(new FlowLayout(0));
        Panel panel5 = new Panel();
        panel5.setLayout(new FlowLayout(0));
        this.SourceOnly.addMouseListener(this.ml);
        this.TargetOnly.addMouseListener(this.ml);
        this.Both.addMouseListener(this.ml);
        panel5.add(this.Both);
        panel5.add(this.SourceOnly);
        panel5.add(this.TargetOnly);
        this.compareBtn.addActionListener(this);
        this.compareBtn.addKeyListener(new MakeEnterDoAction());
        this.enableCompareBtn();
        panel5.add(this.compareBtn);
        this.clearTA.addActionListener(this);
        panel5.add(this.clearTA);
        this.stopBtn.setEnabled(false);
        this.stopBtn.addActionListener(this);
        panel5.add(this.stopBtn);
        panel4.add(panel5);
        this.p4R.setLayout(new GridLayout(1, 2));
        this.p4R.add(new Label("           "));
        this.p4R.add(new Label("           "));
        panel4.add(this.p4R);
        Panel panel6 = new Panel();
        panel6.setLayout(new GridLayout(4, 1));
        panel6.add(panel);
        panel6.add(panel2);
        panel6.add(panel3);
        panel6.add(panel4);
        this.add((Component)panel6, "North");
        this.outArea = new BigTextArea(19, 70, 24000);
        this.outArea.addTextListener(this);
        this.outArea.setFont(new Font("Monospaced", 0, 12));
        this.outArea.addBigTextAreaListener(this);
        this.outArea.setButtons(this.goUpB, this.goDownB, true);
        this.add((Component)this.outArea, "Center");
        this.outArea.addMouseListener(new MouseAdapter(){
            {
                CmprFolders.this.getClass();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    CmprFolders.this.showHelps(CmprFolders.this.outArea);
                    return;
                }
                CmprFolders.this.enableCopyMI();
                if (!CmprFolders.this.fmCopy.isEnabled() && !CmprFolders.this.outArea.getSelectedText().equals("")) {
                    new ShowMsgBox("Copy Warning", "Must have FullPath and not Both to be able to Copy", CmprFolders.this, true);
                }
            }
        });
        this.loadHelps(this.sFileTF, "Source directory. Directory with younger files or source to build files list (target filename ext=.cfl).");
        this.loadHelps(this.tFileTF, "Target directory. Directory with older files, jar or the filename (ext=.cfl) of a files list to be built or to compare to. Set Option: Compare Files List ...  Note: Compare button label changes to Crt List.");
        this.loadHelps(this.filterTF, "Filename filters used to chose the files to compare. For example: *.java;*.hmtl Separated by ;");
        this.loadHelps(this.Both, "Files from both Source and Target directories are displayed in output area below.");
        this.loadHelps(this.SourceOnly, "Only files from the Source directory are displayed in output area below.");
        this.loadHelps(this.TargetOnly, "Only files from the Target directory are displayed in output area below.");
        this.loadHelps(this.outArea, "Compare results are displayed here. Select files to be copied and Select File|Copy menuitem to copy them. The output area is editable.");
        ((Component)this).setSize(700, 500);
        ((Component)this).setLocation(50, 50);
        ((Component)this).setBackground(new Color(180, 230, 255));
        ((Component)this).setVisible(true);
        this.addWindowListener(new WindowAdapter(){
            {
                CmprFolders.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                CmprFolders.this.saveProps();
                CmprFolders.this.dispose();
                if (CmprFolders.this.usingStdOutput) {
                    SaveStdOutput.stop();
                }
                System.exit(0);
            }
        });
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.omFullPath) {
            this.omFNOnly.setState(false);
            this.omSubPath.setState(false);
        } else if (object == this.omFNOnly) {
            this.omSubPath.setState(false);
            this.omFullPath.setState(false);
        } else if (object == this.omSubPath) {
            this.omFNOnly.setState(false);
            this.omFullPath.setState(false);
        } else if (object != this.omSubDir && object != this.omShowNesting && object != this.omDiffDates) {
            if (object == this.omCompareList) {
                if (this.omCompareList.getState()) {
                    this.compareBtn.setLabel("Compare");
                } else {
                    this.compareBtn.setLabel("Crt List");
                }
            } else {
                System.err.println("Unknown ItemEvent " + itemEvent);
            }
        }
    }

    void enableCompareBtn() {
        this.compareBtn.setEnabled(!this.sFileTF.getText().equals("") && !this.tFileTF.getText().equals("") && !this.copyingFiles && !this.comparingFiles);
        if (this.tFileTF.getText().toLowerCase().endsWith(CMPRFoldersListExt) && !this.omCompareList.getState()) {
            this.setCompareBtn("Crt List");
            this.omCompareList.setEnabled(true);
        } else {
            this.setCompareBtn("Compare");
        }
    }

    void setCompareBtn(String string) {
        if (!this.compareBtn.getLabel().equals(string)) {
            this.compareBtn.setLabel(string);
            this.compareBtn.invalidate();
            if (this.compareBtn.getParent() != null) {
                this.compareBtn.getParent().validate();
            }
        }
    }

    private void loadHelps(Component component, String string) {
        this.helps.put(component, string);
    }

    String getFN(File file) {
        if (this.omFullPath.getState()) {
            return file.toString();
        }
        if (this.omSubPath.getState()) {
            String string = file.toString();
            string.lastIndexOf(File.pathSeparatorChar);
            return string.substring(10);
        }
        return file.getName();
    }

    void enableCopyMI() {
        this.fmCopy.setEnabled(!this.outArea.getSelectedText().equals("") && this.omFullPath.getState() && !this.Both.getState() && !this.copyingFiles && !this.comparingFiles);
        this.smSelAll.setEnabled(!this.outArea.getText().equals(""));
    }

    public boolean accept(File file, String string) {
        if (this.filterExts.length == 0) {
            File file2 = null;
            file2 = file == null ? new File(string) : new File(file, string);
            return file2.isFile();
        }
        int n = 0;
        while (n < this.filterExts.length) {
            if (this.filterExts[n].equals("*.*")) {
                File file3 = null;
                file3 = file == null ? new File(string) : new File(file, string);
                return file3.isFile();
            }
            int n2 = this.filterExts[n].indexOf(".");
            if (n2 > 0 ? string.endsWith(this.filterExts[n].substring(n2)) : string.endsWith(this.filterExts[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    void showList(String string, String[] stringArray) {
        System.out.println("  >>> Showing list <<< for " + string);
        int n = 0;
        while (n < stringArray.length) {
            System.out.println(stringArray[n]);
            ++n;
        }
        System.out.println(" <<<< end list >>>>");
    }

    void createList(File file, File file2) {
        try {
            this.theList = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
            String string = file.getAbsolutePath();
            if (!string.endsWith(File.separator)) {
                string = file.getAbsolutePath() + File.separator;
            }
            this.theList.write("#" + " Source=" + string + "\n");
            this.theList.write("#" + " Filter=" + this.filterTF.getText() + "\n");
            this.listFiles(file);
            this.theList.close();
        }
        catch (Exception exception) {
            System.err.println("createList ex: " + exception);
        }
        this.outArea.append("  Output written to " + this.tFileIn + "\n" + "  Total files found: " + totalSource + "\n");
        totalSource = 0;
        this.compareBtn.setEnabled(true);
        this.clearTA.setEnabled(true);
        this.stopBtn.setEnabled(false);
        this.comparingFiles = false;
    }

    String Y2KDate(Date date) {
        int n = 0;
        String string = this.sdf.format(date);
        n = string.indexOf("/69 ");
        if (n < 0) {
            return string;
        }
        return string.substring(0, n) + "/00 " + string.substring(n + 4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.getSFile) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Select source directory (by selecting a file in it)");
            fileDialog.setDirectory(this.sFileInDir);
            this.filters = this.filterTF.getText();
            fileDialog.setFile(this.filters);
            fileDialog.show();
            if (fileDialog.getFile() == null) {
                return;
            }
            this.sFileInDir = fileDialog.getDirectory();
            ((TextComponent)this.sFileTF).setText(this.sFileInDir);
            this.propsChanged = true;
            this.enableCompareBtn();
        } else if (object == this.getTFile) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Select target directory (by selecting a file in it)");
            fileDialog.setDirectory(this.tFileInDir);
            this.filters = this.filterTF.getText();
            fileDialog.setFile(this.filters);
            fileDialog.show();
            if (fileDialog.getFile() == null) {
                return;
            }
            this.tFileInDir = fileDialog.getDirectory();
            this.propsChanged = true;
            String string = fileDialog.getFile();
            if (string.endsWith(CMPRFoldersListExt) || string.endsWith(JARext)) {
                ((TextComponent)this.tFileTF).setText(this.tFileInDir + string);
            } else {
                ((TextComponent)this.tFileTF).setText(this.tFileInDir);
            }
            this.enableCompareBtn();
        } else if (object == this.compareBtn) {
            Object object2;
            this.sFileInDir = this.sFileTF.getText();
            this.sFileIn = new File(this.sFileInDir);
            if (!this.sFileIn.exists() || !this.sFileIn.isDirectory()) {
                new ErrDialog(this.errMsgFrm, "Source Directory not found " + this.sFileInDir);
                return;
            }
            this.tFileInDir = this.tFileTF.getText();
            this.tFileIn = new File(this.tFileInDir);
            if (!this.tFileInDir.endsWith(CMPRFoldersListExt)) {
                if (this.tFileInDir.endsWith(JARext)) {
                    if (!this.tFileIn.exists()) {
                        new ErrDialog(this.errMsgFrm, "Target jar file not found " + this.tFileInDir);
                        return;
                    }
                } else if (!this.tFileIn.exists() || !this.tFileIn.isDirectory()) {
                    new ErrDialog(this.errMsgFrm, "Target Directory not found " + this.tFileInDir);
                    return;
                }
            }
            if (this.sFileInDir.equals(this.tFileInDir)) {
                new ErrDialog(this.errMsgFrm, "Source and Target Directories the same");
                return;
            }
            this.filters = this.filterTF.getText();
            StringTokenizer stringTokenizer = new StringTokenizer(this.filters, ";");
            this.filterExts = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                object2 = stringTokenizer.nextToken();
                if (((String)object2).startsWith(".") || ((String)object2).endsWith(".") || !((String)object2).equals("*") && ((String)object2).length() < 3) {
                    new ErrDialog(this.errMsgFrm, "Invalid Filefilter: " + (String)object2);
                    return;
                }
                this.filterExts[n++] = object2;
            }
            this.stopCompare = false;
            this.comparingFiles = true;
            this.stopBtn.setEnabled(true);
            this.compareBtn.setEnabled(false);
            this.clearTA.setEnabled(false);
            if (this.tFileInDir.endsWith(CMPRFoldersListExt) && !this.omCompareList.getState()) {
                this.createList(this.sFileIn, this.tFileIn);
            } else {
                if (this.tFileInDir.endsWith(CMPRFoldersListExt) || this.tFileInDir.endsWith(JARext)) {
                    try {
                        if (this.tFileInDir.endsWith(JARext)) {
                            ListFiles.setRoot(this.sFileInDir);
                        }
                        ListFiles.createListFiles(this.tFileInDir);
                        this.tFileIn = new ListFiles(ListFiles.getRoot());
                    }
                    catch (Exception exception) {
                        System.err.println("createListFiles ex: " + exception);
                    }
                }
                object2 = new DoCompare(this.sFileIn, this.tFileIn);
                ((Thread)object2).setPriority(1);
                ((Thread)object2).start();
            }
        } else if (object == this.fmOpenP) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose new Properties file", 0);
            File file = new File(this.propFN);
            fileDialog.setDirectory(file.getParent());
            fileDialog.setFile(file.getName());
            fileDialog.show();
            fileDialog.dispose();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            this.saveProps();
            this.propFN = fileDialog.getDirectory() + string;
            this.saveProps();
            this.openProps(true);
        } else if (object == this.clearTA) {
            this.outArea.setText("");
            this.p4R.removeAll();
            totalTarget = 0;
            totalSource = 0;
            extraTarget = 0;
            extraSource = 0;
            diffDates = 0;
            totalMatches = 0;
            totalDiffs = 0;
        } else if (object == this.stopBtn) {
            this.stopCompare = true;
            this.stopCopying = true;
        } else if (object == this.fmCopy) {
            this.fmCopy.setEnabled(false);
            this.compareBtn.setEnabled(false);
            this.clearTA.setEnabled(false);
            this.stopBtn.setEnabled(true);
            this.stopCopying = false;
            new CopyFiles();
        } else if (object == this.fmExit) {
            this.saveProps();
            while (this.copyingFiles) {
                this.stopCopying = true;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            System.exit(0);
        } else if (object == this.smFind) {
            GetInput getInput = new GetInput("Find what:", (Frame)this, "Find");
            this.findWhat = getInput.getResponse();
            if (this.findWhat.equals("")) {
                return;
            }
            String string = this.outArea.getText();
            this.findWhere = string.indexOf(this.findWhat);
            if (this.findWhere > 0) {
                this.outArea.select(this.findWhere, this.findWhere + this.findWhat.length());
                this.smFindNext.setEnabled(true);
            } else {
                new ErrDialog(this.errMsgFrm, this.findWhat + " not found");
                this.smFindNext.setEnabled(false);
            }
        } else if (object == this.smFindNext) {
            String string = this.outArea.getText();
            this.findWhere = string.indexOf(this.findWhat, this.findWhere + this.findWhat.length());
            if (this.findWhere > 0) {
                this.outArea.select(this.findWhere, this.findWhere + this.findWhat.length());
            } else {
                new ErrDialog(this.errMsgFrm, this.findWhat + " not found");
            }
        } else if (object == this.smSelAll) {
            this.outArea.selectAll();
            String string = this.outArea.getSelectedText();
            System.out.println("Selected " + string.length());
            this.outArea.requestFocus();
            this.enableCopyMI();
        } else if (object == this.smOptions) {
            if (this.shwOpts == null) {
                this.shwOpts = new ShowOptions(new NotifyChanges());
            } else {
                this.shwOpts.show();
            }
        } else if (object == this.hmAbout) {
            new ShowMsgBox("About Compare Folders", "Written by Norm Radder\n Email: radder@hotmail.com", this, true);
        } else if (object == this.hmHelp) {
            try {
                new ShowDocument("CmprFolders.html");
            }
            catch (Exception exception) {
                new ErrDialog(this.errMsgFrm, "Error reading help file: " + "CmprFolders.html");
            }
        } else {
            System.err.println("Unknown action " + actionEvent);
        }
    }

    public static void main(String[] stringArray) {
        new CmprFolders(stringArray);
    }

    void showHelps(Component component) {
        new ShowMsgBox("Compare Folders Help", (String)this.helps.get(component), this, false);
    }

    void doCompare(File file, File file2) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        String string = "";
        String string2 = "";
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Dimension dimension = this.outArea.getSize();
        FontMetrics fontMetrics = this.outArea.getFontMetrics(this.outArea.getFont());
        int n4 = fontMetrics.stringWidth("ABCDEFWXYZ") / 10;
        int n5 = dimension.width / n4;
        this.FN_WIDTH = n5 - 17 - 8 - 4;
        try {
            if (file != null) {
                string = file.getAbsolutePath();
                if (!string.endsWith(File.separator)) {
                    string = file.getAbsolutePath() + File.separator;
                }
                stringArray = file.list(this);
                totalSource += stringArray.length;
                this.sortList(stringArray);
                if (Testing) {
                    this.showList(string, stringArray);
                }
            }
            if (file2 != null) {
                string2 = file2.getAbsolutePath();
                if (!string2.endsWith(File.separator)) {
                    string2 = file2.getAbsolutePath() + File.separator;
                }
                stringArray2 = file2.list(this);
                totalTarget += stringArray2.length;
                this.sortList(stringArray2);
                if (Testing) {
                    this.showList(string2, stringArray2);
                }
            }
            if (Testing) {
                System.out.println("Comparing: Source dir:" + string + "  Target dir: " + string2);
            }
            while (true) {
                Date date;
                ListFiles listFiles;
                Date date2;
                File file3;
                int n6;
                if (this.stopCompare) {
                    return;
                }
                if (stringArray2 == null || n2 >= stringArray2.length) {
                    if (file != null && !this.TargetOnly.getState() && !this.omDiffDates.getState()) {
                        n6 = n;
                        while (n6 < stringArray.length) {
                            if (this.stopCompare) {
                                return;
                            }
                            file3 = new File(string + stringArray[n6]);
                            date2 = new Date(file3.lastModified());
                            if (this.dateWanted(date2)) {
                                this.outArea.append("S-Only>" + this.LAdj(this.getFN(file3), this.FN_WIDTH) + this.Y2KDate(date2) + "\n");
                            }
                            ++totalDiffs;
                            ++extraSource;
                            ++n6;
                        }
                    }
                    break;
                }
                if (stringArray == null || n >= stringArray.length) {
                    if (file2 != null && !this.SourceOnly.getState() && !this.omDiffDates.getState()) {
                        n6 = n2;
                        while (n6 < stringArray2.length) {
                            if (this.stopCompare) {
                                return;
                            }
                            listFiles = new ListFiles(string2 + stringArray2[n6]);
                            date = new Date(((File)listFiles).lastModified());
                            if (this.dateWanted(date)) {
                                this.outArea.append("T-Only>" + this.LAdj(this.getFN(listFiles), this.FN_WIDTH) + this.Y2KDate(date) + "\n");
                            }
                            ++totalDiffs;
                            ++extraTarget;
                            ++n6;
                        }
                    }
                    break;
                }
                n3 = stringArray[n].compareTo(stringArray2[n2]);
                if (n3 == 0) {
                    file3 = new File(string + stringArray[n]);
                    listFiles = new ListFiles(string2 + stringArray2[n2]);
                    if (file3.lastModified() != ((File)listFiles).lastModified()) {
                        if (Testing) {
                            System.out.println("Date mismatch for: " + stringArray[n] + " " + file3.lastModified() + " " + ((File)listFiles).lastModified());
                        }
                        date2 = new Date(file3.lastModified());
                        date = new Date(((File)listFiles).lastModified());
                        if ((this.Both.getState() || this.SourceOnly.getState()) && this.dateWanted(date2)) {
                            this.outArea.append("S-mod >" + this.LAdj(this.getFN(file3), this.FN_WIDTH) + this.Y2KDate(date2) + "\n");
                        }
                        if ((this.Both.getState() || this.TargetOnly.getState()) && this.dateWanted(date)) {
                            this.outArea.append("T-mod >" + this.LAdj(this.getFN(listFiles), this.FN_WIDTH) + this.Y2KDate(date) + "\n");
                        }
                        ++totalDiffs;
                        ++diffDates;
                    } else {
                        ++totalMatches;
                        if (Testing) {
                            System.out.println("Files match: " + stringArray[n] + " " + file3.lastModified());
                        }
                    }
                    ++n;
                    ++n2;
                    continue;
                }
                if (n3 < 0) {
                    if (Testing) {
                        System.out.println("S= " + stringArray[n] + " <  T= " + stringArray2[n2]);
                    }
                    file3 = new File(string + stringArray[n]);
                    date2 = new Date(file3.lastModified());
                    if ((this.Both.getState() || this.SourceOnly.getState()) && !this.omDiffDates.getState() && this.dateWanted(date2)) {
                        this.outArea.append("S-only>" + this.LAdj(this.getFN(file3), this.FN_WIDTH) + this.Y2KDate(date2) + "\n");
                    }
                    ++totalDiffs;
                    ++extraSource;
                    ++n;
                    continue;
                }
                if (Testing) {
                    System.out.println("S= " + stringArray[n] + " >  T= " + stringArray2[n2]);
                }
                listFiles = new ListFiles(string2 + stringArray2[n2]);
                date = new Date(((File)listFiles).lastModified());
                if ((this.Both.getState() || this.TargetOnly.getState()) && !this.omDiffDates.getState() && this.dateWanted(date)) {
                    this.outArea.append("T-only>" + this.LAdj(this.getFN(listFiles), this.FN_WIDTH) + this.Y2KDate(date) + "\n");
                }
                ++totalDiffs;
                ++extraTarget;
                ++n2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception + "\n  s=" + n + " of " + (stringArray != null ? stringArray.length : 0) + " t=" + n2 + " of " + (stringArray2 != null ? stringArray2.length : 0));
        }
        if (file2 == null || file == null) {
            if (Testing) {
                System.out.println("Exiting - only one dir. Src: " + string + "  Trgt: " + string2);
            }
            if (this.omSubDir.getState()) {
                if (file != null) {
                    GetDirOnly getDirOnly = new GetDirOnly();
                    stringArray = file.list(getDirOnly);
                    this.sortList(stringArray);
                    int n7 = 0;
                    while (n7 < stringArray.length) {
                        if (this.stopCompare) {
                            return;
                        }
                        this.doCompare(new File(string + stringArray[n7]), null);
                        ++n7;
                    }
                } else {
                    GetDirOnly getDirOnly = new GetDirOnly();
                    stringArray2 = file2.list(getDirOnly);
                    this.sortList(stringArray2);
                    int n8 = 0;
                    while (n8 < stringArray2.length) {
                        if (this.stopCompare) {
                            return;
                        }
                        this.doCompare(null, new ListFiles(string2 + stringArray2[n8]));
                        ++n8;
                    }
                }
            }
            return;
        }
        if (this.omSubDir.getState()) {
            GetDirOnly getDirOnly = new GetDirOnly();
            if (file != null) {
                stringArray = file.list(getDirOnly);
                this.sortList(stringArray);
            }
            if (file2 != null) {
                stringArray2 = file2.list(getDirOnly);
                this.sortList(stringArray2);
            }
            if (Testing) {
                System.out.println("got directories: " + file + " " + stringArray.length + " " + file2 + " " + stringArray2.length);
                this.showList(string, stringArray);
                this.showList(string2, stringArray2);
            }
            n2 = 0;
            n = 0;
            while (true) {
                if (this.stopCompare) {
                    return;
                }
                if (n >= stringArray.length || n2 >= stringArray2.length) {
                    if (n < stringArray.length) {
                        if (this.omShowNesting.getState()) {
                            this.outArea.append(" >>> Going to subdirectory: " + string + stringArray[n] + " <<<\n");
                        }
                        this.doCompare(new File(string + stringArray[n]), null);
                        ++n;
                        continue;
                    }
                    if (n2 >= stringArray2.length) break;
                    if (this.omShowNesting.getState()) {
                        this.outArea.append(" >>> Going to subdirectory: " + string2 + stringArray2[n2] + " <<<\n");
                    }
                    this.doCompare(null, new ListFiles(string2 + stringArray2[n2]));
                    ++n2;
                    continue;
                }
                n3 = stringArray[n].compareTo(stringArray2[n2]);
                if (n3 == 0) {
                    if (Testing) {
                        System.out.println("SubDir call for: " + stringArray[n]);
                    }
                    if (this.omShowNesting.getState()) {
                        this.outArea.append(" >>> Going to subdirectory: " + string + stringArray[n] + " <<<\n");
                    }
                    this.doCompare(new File(string + stringArray[n]), new ListFiles(string2 + stringArray2[n2]));
                    ++n;
                    ++n2;
                    continue;
                }
                if (n3 < 0) {
                    if (Testing) {
                        System.out.println("Source directory only: " + string + " " + stringArray[n] + " vs " + string2 + " " + stringArray2[n2]);
                    }
                    this.doCompare(new File(string + stringArray[n]), null);
                    ++n;
                    continue;
                }
                if (n3 > 0) {
                    if (Testing) {
                        System.out.println("Target directory only: " + string2 + stringArray2[n2] + " vs " + string + stringArray[n]);
                    }
                    this.doCompare(null, new ListFiles(string2 + stringArray2[n2]));
                    ++n2;
                    continue;
                }
                System.err.println("Unknown compare results: " + n3);
            }
        }
    }

    void listFiles(File file) throws IOException {
        String[] stringArray = null;
        String string = "";
        if (this.stopCompare) {
            return;
        }
        string = file.getAbsolutePath();
        if (!string.endsWith(File.separator)) {
            string = file.getAbsolutePath() + File.separator;
        }
        stringArray = file.list(this);
        totalSource += stringArray.length;
        this.sortList(stringArray);
        if (Testing) {
            this.showList(string, stringArray);
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = new File(string + stringArray[n]);
            Date date = new Date(file2.lastModified());
            this.theList.write(this.LAdj(this.getFN(file2), this.FN_WIDTH) + this.Y2KDate(date) + TAB_C + file2.lastModified() + "\n");
            ++n;
        }
        if (this.omSubDir.getState()) {
            GetDirOnly getDirOnly = new GetDirOnly();
            stringArray = file.list(getDirOnly);
            this.sortList(stringArray);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (this.stopCompare) {
                    return;
                }
                this.listFiles(new File(string + stringArray[n2]));
                ++n2;
            }
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        Object object = textEvent.getSource();
        if (object == this.filterTF || object == this.sFileTF || object == this.tFileTF) {
            this.propsChanged = true;
        }
        if (object == this.filterTF) {
            this.filters = this.filterTF.getText();
        }
        this.enableCopyMI();
        this.enableCompareBtn();
    }

    private void openProps(boolean bl) {
        Object object;
        try {
            object = new FileInputStream(this.propFN);
            this.ourProps.load((InputStream)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Property file NOT found: " + this.propFN + " It will be created on Exit.");
            this.propsChanged = true;
        }
        catch (Exception exception) {
            System.err.println("Error getting properties " + exception);
        }
        this.sFileInDir = this.ourProps.getProperty(SourceDirNM, this.sFileInDir);
        this.tFileInDir = this.ourProps.getProperty(TargetDirNM, this.tFileInDir);
        this.filters = this.ourProps.getProperty(FiltersNM, this.filters);
        this.copyToDir = this.ourProps.getProperty(CopyToNM, this.copyToDir);
        this.afterDate = this.ourProps.getProperty(AfterDateNM, this.afterDate);
        this.displayWhich = this.ourProps.getProperty(DisplayWhichNM, this.displayWhich);
        this.omAfterDate.setState("true".equals(this.ourProps.getProperty(UseAfterDateNM)));
        if (this.afterDate.length() >= 8) {
            object = new StringTokenizer(this.afterDate, "/");
            ((TextComponent)this.monTF).setText(((StringTokenizer)object).nextToken());
            ((TextComponent)this.dayTF).setText(((StringTokenizer)object).nextToken());
            ((TextComponent)this.yearTF).setText(((StringTokenizer)object).nextToken());
        }
        this.setSelDate();
        if (bl) {
            ((TextComponent)this.sFileTF).setText(this.sFileInDir);
            ((TextComponent)this.tFileTF).setText(this.tFileInDir);
            ((TextComponent)this.filterTF).setText(this.filters);
            boolean bl2 = false;
            int n = 0;
            while (n < this.displayCBs.length) {
                if (((String)this.displayCBs[n + 1]).equals(this.displayWhich)) {
                    ((Checkbox)this.displayCBs[n]).setState(true);
                    bl2 = true;
                    break;
                }
                n += 2;
            }
            if (!bl2) {
                System.out.println("Unknown Display value: " + this.displayWhich);
            }
        }
        if (Testing) {
            this.ourProps.list(System.out);
        }
    }

    void saveProps() {
        if (!this.propsChanged) {
            return;
        }
        this.propsChanged = false;
        ((Hashtable)this.ourProps).put(SourceDirNM, this.sFileInDir);
        ((Hashtable)this.ourProps).put(TargetDirNM, this.tFileInDir);
        ((Hashtable)this.ourProps).put(FiltersNM, this.filters);
        ((Hashtable)this.ourProps).put(CopyToNM, this.copyToDir);
        ((Hashtable)this.ourProps).put(UseAfterDateNM, "" + this.omAfterDate.getState());
        int n = 0;
        while (n < this.displayCBs.length) {
            if (((Checkbox)this.displayCBs[n]).getState()) {
                ((Hashtable)this.ourProps).put(DisplayWhichNM, (String)this.displayCBs[n + 1]);
                break;
            }
            n += 2;
        }
        if (!this.monTF.getText().equals("")) {
            ((Hashtable)this.ourProps).put(AfterDateNM, this.monTF.getText() + "/" + this.dayTF.getText() + "/" + this.yearTF.getText());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propFN);
            this.ourProps.save(fileOutputStream, "Compare Folder contents");
        }
        catch (Exception exception) {
            System.err.println("Error saving props " + exception);
        }
        if (Testing) {
            this.ourProps.list(System.out);
        }
    }

    class MouseEventHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Component component = (Component)mouseEvent.getSource();
                int n = this.findComponent(component);
                if (n > 0) {
                    CmprFolders.this.helpPUM.show(component, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    System.out.println("no popup for " + component);
                }
            }
        }

        MouseEventHandler() {
            CmprFolders.this.getClass();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                Component component = (Component)mouseEvent.getSource();
                int n = this.findComponent(component);
                if (n > 0) {
                    CmprFolders.this.helpPUM.show(component, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    if (n == 0) {
                        return;
                    }
                    System.out.println("no popup for " + component);
                }
            }
        }

        int findComponent(Component component) {
            if (CmprFolders.this.helps.containsKey(component)) {
                CmprFolders.this.showHelps(component);
                return 0;
            }
            return -1;
        }
    }

    class ShowOptions
    extends Dialog
    implements TextListener,
    ItemListener,
    Runnable {
        boolean showingError;
        boolean doneFlg;
        NotifyChanges nc;

        private void setSelDate() {
            if (CmprFolders.this.omAfterDate.getState()) {
                CmprFolders.this.selDate = Calendar.getInstance();
                CmprFolders.this.selDate.setLenient(false);
                CmprFolders.this.selDate.clear();
                int n = 0;
                boolean bl = false;
                try {
                    CmprFolders.this.selDate.set(1, Integer.parseInt(CmprFolders.this.yearTF.getText()));
                    CmprFolders.this.selDate.get(1);
                    n = 1;
                    CmprFolders.this.selDate.set(2, Integer.parseInt(CmprFolders.this.monTF.getText()) - 1);
                    CmprFolders.this.selDate.get(2);
                    n = 2;
                    CmprFolders.this.selDate.set(5, Integer.parseInt(CmprFolders.this.dayTF.getText()));
                    CmprFolders.this.selDate.getTime();
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bl) {
                    if (Testing) {
                        System.out.println(new SimpleDateFormat("MM/dd/yyyy").format(CmprFolders.this.selDate.getTime()));
                    }
                } else {
                    CmprFolders.this.omAfterDate.setState(false);
                    if (Testing) {
                        System.out.println("Invalid date field " + n + " " + CmprFolders.this.inputTF[n].getText());
                    }
                    this.showingError = true;
                    new ErrDialog((Frame)CmprFolders.this, "Invalid date field " + CmprFolders.this.inputTF[n].getText());
                    this.showingError = false;
                    CmprFolders.this.inputTF[n].requestFocus();
                }
            } else {
                CmprFolders.this.selDate = null;
                System.out.println("setSelDate called with AfterDate off");
            }
        }

        ShowOptions(NotifyChanges notifyChanges) {
            super(CmprFolders.this, "Compare Folders Options", false);
            CmprFolders.this.getClass();
            this.showingError = false;
            this.doneFlg = false;
            this.nc = notifyChanges;
            ((Component)this).setBackground(new Color(180, 180, 200));
            this.setLayout(new GridLayout(11, 1));
            this.add(CmprFolders.this.omFNOnly);
            CmprFolders.this.omFullPath.addItemListener(CmprFolders.this);
            this.add(CmprFolders.this.omFullPath);
            CmprFolders.this.omSubPath.addItemListener(CmprFolders.this);
            this.add(CmprFolders.this.omSubDir);
            this.add(CmprFolders.this.omShowNesting);
            this.add(CmprFolders.this.omDiffDates);
            this.add(CmprFolders.this.omCopyMatching);
            this.add(CmprFolders.this.omCompareList);
            CmprFolders.this.omCompareList.setEnabled(CmprFolders.this.tFileTF.getText().toLowerCase().endsWith(CmprFolders.CMPRFoldersListExt) || CmprFolders.this.tFileTF.getText().toLowerCase().endsWith(CmprFolders.JARext));
            CmprFolders.this.omCompareList.addItemListener(CmprFolders.this);
            this.add(CmprFolders.this.omTesting);
            CmprFolders.this.omTesting.setState(Testing);
            CmprFolders.this.omTesting.addItemListener(this);
            this.add(CmprFolders.this.omAfterDate);
            this.enableAfterDate();
            CmprFolders.this.omAfterDate.addItemListener(this);
            Panel panel = new Panel();
            panel.add(new Label("Mon"));
            panel.add(CmprFolders.this.monTF);
            CmprFolders.this.monTF.addTextListener(this);
            panel.add(new Label("Day"));
            panel.add(CmprFolders.this.dayTF);
            CmprFolders.this.dayTF.addTextListener(this);
            panel.add(new Label("Year"));
            panel.add(CmprFolders.this.yearTF);
            CmprFolders.this.yearTF.addTextListener(this);
            this.add(panel);
            Panel panel2 = new Panel();
            Button button = new Button("Done");
            panel2.add(button);
            button.addActionListener(new ActionListener(){
                {
                    ShowOptions.this.getClass();
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ShowOptions.this.exitPgm();
                }
            });
            this.add(panel2);
            this.addWindowListener(new WindowAdapter(){
                {
                    ShowOptions.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ShowOptions.this.exitPgm();
                }
            });
            this.setSelDate();
            ((Component)this).setLocation(300, 150);
            ((Component)this).setSize(300, 100);
            this.pack();
            this.show();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Object object = itemEvent.getSource();
            if (object == CmprFolders.this.omAfterDate) {
                this.nc.optChanged();
            } else if (object == CmprFolders.this.omTesting) {
                Testing = CmprFolders.this.omTesting.getState();
            } else {
                System.err.println("unknown ie " + itemEvent);
            }
            this.setSelDate();
        }

        void enableAfterDate() {
            CmprFolders.this.omAfterDate.setEnabled(!CmprFolders.this.monTF.getText().equals("") && !CmprFolders.this.dayTF.getText().equals("") && !CmprFolders.this.yearTF.getText().equals(""));
        }

        void exitPgm() {
            ((Component)this).setVisible(false);
            this.doneFlg = true;
            this.dispose();
        }

        public void run() {
            int n = 0;
            while (true) {
                System.out.println(this.showingError + " done=" + this.doneFlg);
                if (this.doneFlg) {
                    return;
                }
                if (!this.showingError) {
                    System.out.println("" + n++ + " toFront()");
                    this.toFront();
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public void textValueChanged(TextEvent textEvent) {
            this.enableAfterDate();
            this.setSelDate();
            this.nc.optChanged();
        }
    }

    class DoCompare
    extends Thread {
        File sFile;
        File tFile;

        DoCompare(File file, File file2) {
            CmprFolders.this.getClass();
            this.sFile = file;
            this.tFile = file2;
        }

        public void run() {
            CmprFolders.this.doCompare(this.sFile, this.tFile);
            CmprFolders.this.outArea.append(" >>> " + (totalMatches > 0 ? totalMatches + " matched, " : " ") + (diffDates > 0 ? diffDates + " had different dates, " : " ") + (extraSource > 0 ? extraSource + " in Source only, " : " ") + (extraTarget > 0 ? extraTarget + " in Target only, " : " ") + "  " + totalDiffs + " differences <<<\n");
            CmprFolders.this.outArea.append("   Total files: " + CmprFolders.this.RAdj(totalSource, 6) + " source; " + CmprFolders.this.RAdj(totalTarget, 6) + " target\n");
            diffDates = 0;
            totalMatches = 0;
            totalDiffs = 0;
            totalTarget = 0;
            totalSource = 0;
            extraTarget = 0;
            extraSource = 0;
            CmprFolders.this.smSelAll.setEnabled(true);
            CmprFolders.this.comparingFiles = false;
            CmprFolders.this.compareBtn.setEnabled(true);
            CmprFolders.this.clearTA.setEnabled(true);
            CmprFolders.this.stopBtn.setEnabled(false);
            ListFiles.clear();
        }
    }

    class CopyFiles
    implements Runnable {
        TextArea resOut;
        int copyCnt;
        boolean okToOverWrite;
        final int MaxAskIfOk = 3;
        int askIfOkCnt;
        Vector filesToCopy;

        public CopyFiles() {
            CmprFolders.this.getClass();
            this.resOut = new TextArea(12, 80);
            this.copyCnt = 0;
            this.okToOverWrite = false;
            this.MaxAskIfOk = 3;
            this.askIfOkCnt = 0;
            this.filesToCopy = new Vector();
            if (CmprFolders.this.copyingFiles) {
                System.err.println("System error - already copying files");
                return;
            }
            Thread thread = new Thread(this);
            thread.setPriority(Thread.currentThread().getPriority() - 2);
            thread.start();
        }

        Vector parsePath(String string) {
            Vector<String> vector = new Vector<String>();
            int n = 0;
            int n2 = 0;
            while ((n = string.indexOf(File.separatorChar, n2)) > 0) {
                vector.addElement(string.substring(n2, ++n));
                n2 = n++;
            }
            return vector;
        }

        String bldTargetPath(Vector vector, Vector vector2, int n) {
            String string = "";
            int n2 = 0;
            while (n2 < vector.size()) {
                string = string + vector.elementAt(n2);
                ++n2;
            }
            n2 = n;
            while (n2 < vector2.size()) {
                string = string + vector2.elementAt(n2);
                ++n2;
            }
            return string;
        }

        void copyFiles() {
            Dialog dialog;
            Object object;
            String[] stringArray = new String[4];
            this.filesToCopy = new Vector();
            Process process = null;
            int n = 0;
            int n2 = 0;
            String string = CmprFolders.this.outArea.getSelectedText();
            StringTokenizer stringTokenizer = new StringTokenizer(string, CmprFolders.TAB_C);
            while (stringTokenizer.hasMoreTokens()) {
                if (CmprFolders.this.stopCopying) {
                    return;
                }
                object = stringTokenizer.nextToken().trim();
                if (((String)object).length() <= 10 || ((String)object).charAt(1) != ':' || !CmprFolders.this.accept(null, (String)object)) continue;
                File file = new File((String)object);
                if (file.isFile()) {
                    n = (int)((long)n + file.length());
                    this.filesToCopy.addElement(object);
                    continue;
                }
                System.out.println("Rejected non file: " + (String)object);
            }
            if (this.filesToCopy.isEmpty()) {
                new ErrDialog((Frame)CmprFolders.this, "No valid files found to copy.");
                return;
            }
            object = new FileDialog((Frame)CmprFolders.this, "Position to folder to copy " + this.filesToCopy.size() + " files to");
            ((FileDialog)object).setMode(1);
            ((FileDialog)object).setDirectory(CmprFolders.this.copyToDir);
            ((FileDialog)object).setFile("No name needed. Press Save when in folder.");
            ((Dialog)object).show();
            if (((FileDialog)object).getFile() == null) {
                return;
            }
            CmprFolders.this.copyToDir = ((FileDialog)object).getDirectory();
            String string2 = (String)this.filesToCopy.firstElement();
            int n3 = string2.lastIndexOf(File.separatorChar);
            if (n3 < 0) {
                new ErrDialog((Frame)CmprFolders.this, "Invalid filename: " + string2);
                System.err.println("Invalid filename: " + string2 + " >" + File.separatorChar + "<");
                return;
            }
            if ((string2 = string2.substring(0, n3 + 1)).equals(CmprFolders.this.copyToDir)) {
                System.out.println("File: " + string2 + "\ndir: " + CmprFolders.this.copyToDir);
                dialog = new ChoiceOfYesOrNo((Frame)CmprFolders.this, "Source and Target directory the same.\n Is it Ok to continue?");
                if (!((ChoiceOfYesOrNo)dialog).isYes()) {
                    return;
                }
            }
            if (((AskMultipleChoices)(dialog = new AskMultipleChoices((Frame)CmprFolders.this, "Ready to copy the files?", "Copy " + this.filesToCopy.size() + " files to: " + CmprFolders.this.copyToDir + (CmprFolders.this.omCopyMatching.getState() ? " and sub-Directories" : "") + "?\n              (" + n + " bytes)", new String[]{"Copy", "Copy. Ok to Overwrite"}))).getAnswer() == -1) {
                return;
            }
            if (((AskMultipleChoices)dialog).getAnswer() == 1) {
                this.okToOverWrite = true;
            }
            Vector vector = this.parsePath(CmprFolders.this.copyToDir);
            stringArray[0] = "XCopy";
            stringArray[3] = "/Y";
            CmprFolders.this.showRes = new Frame();
            CmprFolders.this.showRes.add(this.resOut);
            ((Component)CmprFolders.this.showRes).setSize(700, 300);
            ((Component)CmprFolders.this.showRes).setFont(new Font("Monospaced", 0, 12));
            CmprFolders.this.showRes.setTitle("File copy results for " + this.filesToCopy.size() + " files");
            CmprFolders.this.showRes.addWindowListener(new WindowAdapter(){
                {
                    CopyFiles.this.getClass();
                }

                public void windowClosing(WindowEvent windowEvent) {
                    if (CopyFiles.this.filesToCopy.isEmpty()) {
                        CmprFolders.this.showRes.dispose();
                        CmprFolders.this.showRes = null;
                    }
                }
            });
            CmprFolders.this.showRes.show();
            while (!this.filesToCopy.isEmpty()) {
                Object object2;
                Object object3;
                Serializable serializable;
                String string3;
                if (CmprFolders.this.stopCopying) {
                    return;
                }
                stringArray[1] = (String)this.filesToCopy.elementAt(0);
                this.filesToCopy.removeElementAt(0);
                int n4 = stringArray[1].lastIndexOf(File.separatorChar);
                if (n4 < 0) {
                    string3 = stringArray[1];
                    System.out.println("Invalid filename: " + string3 + " >" + File.separatorChar + "<");
                    new ErrDialog((Frame)CmprFolders.this, "Invalid filename: " + string3);
                    return;
                }
                string3 = stringArray[1].substring(n4 + 1);
                if (CmprFolders.this.omCopyMatching.getState()) {
                    serializable = this.parsePath(stringArray[1]);
                    if (vector.size() == 1) {
                        n2 = 1;
                    } else {
                        int n5 = ((Vector)serializable).size() - 1;
                        while (n5 > 0) {
                            if (((String)((Vector)serializable).elementAt(n5)).equals((String)vector.elementAt(vector.size() - 1))) {
                                n2 = n5 + 1;
                                break;
                            }
                            --n5;
                        }
                        if (n2 == 0) {
                            System.err.println("No matching path found");
                            ChoiceOfYesOrNo choiceOfYesOrNo = new ChoiceOfYesOrNo((Frame)CmprFolders.this, "No matching subdirectory found.\nFiles will be copied with subdirectories to " + CmprFolders.this.copyToDir + "\n    Ok to continue?");
                            if (!choiceOfYesOrNo.isYes()) {
                                return;
                            }
                            n2 = 1;
                        }
                    }
                    stringArray[2] = this.bldTargetPath(vector, (Vector)serializable, n2);
                } else {
                    stringArray[2] = CmprFolders.this.copyToDir;
                }
                serializable = new File(stringArray[2] + string3);
                if (((File)serializable).isFile() && ((File)serializable).exists() && !this.okToOverWrite) {
                    Date date = new Date(((File)serializable).lastModified());
                    object3 = new File(stringArray[1]);
                    if (((File)object3).lastModified() == ((File)serializable).lastModified() && CmprFolders.this.omAutoNo.getState()) continue;
                    Date date2 = new Date(((File)object3).lastModified());
                    Color color = null;
                    if (((File)object3).lastModified() < ((File)serializable).lastModified()) {
                        color = Color.red;
                    }
                    if (!((ChoiceOfYesOrNo)(object2 = new ChoiceOfYesOrNo(CmprFolders.this.errMsgFrm, "Ok to overwrite: " + stringArray[2] + string3 + "  " + CmprFolders.this.sdf.format(date) + "\n           with: " + stringArray[1] + "  " + CmprFolders.this.sdf.format(date2), color))).isYes()) continue;
                    ++this.askIfOkCnt;
                }
                if (this.askIfOkCnt == 3 && !this.okToOverWrite) {
                    ++this.askIfOkCnt;
                    ChoiceOfYesOrNo choiceOfYesOrNo = new ChoiceOfYesOrNo(CmprFolders.this.errMsgFrm, "Do you want to Overwrite ALL in future?");
                    if (choiceOfYesOrNo.isYes()) {
                        this.okToOverWrite = true;
                    }
                }
                if (Testing) {
                    System.out.println(CmprFolders.this.RAdj(this.copyCnt + 1, 3) + " Copying:  " + stringArray[1] + "\n     to:  " + stringArray[2]);
                }
                if (CmprFolders.this.showRes != null) {
                    this.resOut.append(CmprFolders.this.RAdj(this.copyCnt + 1, 3) + " Copying:  " + stringArray[1] + "\n         to:  " + stringArray[2]);
                }
                try {
                    process = Runtime.getRuntime().exec(stringArray);
                    if (CmprFolders.this.showRes != null || Testing) {
                        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(process.getInputStream()));
                        object3 = new byte[400];
                        int n6 = 0;
                        int n7 = 0;
                        while (n6 < ((Object)object3).length) {
                            if (n7++ > ((Object)object3).length) break;
                            try {
                                byte by = dataInputStream.readByte();
                                object3[n6++] = by;
                            }
                            catch (EOFException eOFException) {
                                break;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                break;
                            }
                        }
                        dataInputStream.close();
                        if (Testing) {
                            System.out.println("Read " + n6 + " bytes and looped " + n7);
                        }
                        if (CmprFolders.this.showRes != null) {
                            this.resOut.append(new String((byte[])object3, 0, n6));
                        }
                        object2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                        while ((string2 = ((BufferedReader)object2).readLine()) != null) {
                            if (Testing) {
                                System.out.println(string2);
                            }
                            if (CmprFolders.this.showRes == null) continue;
                            this.resOut.append(string2 + "\n");
                        }
                        ((BufferedReader)object2).close();
                    }
                    ++this.copyCnt;
                }
                catch (IOException iOException) {
                    System.err.println("IOEx >" + iOException + "\n" + iOException.getMessage() + "\n " + (process != null ? "" + process.exitValue() : "null"));
                }
            }
        }

        public void run() {
            CmprFolders.this.copyingFiles = true;
            CmprFolders.this.stopBtn.setEnabled(true);
            this.copyFiles();
            this.resOut.append(" >>> Total of " + this.copyCnt + " file" + (this.copyCnt > 1 ? "s" : "") + " copied <<<");
            CmprFolders.this.copyingFiles = false;
            CmprFolders.this.stopBtn.setEnabled(false);
            CmprFolders.this.fmCopy.setEnabled(true);
            CmprFolders.this.compareBtn.setEnabled(true);
            CmprFolders.this.clearTA.setEnabled(true);
        }
    }

    private class NotifyChanges {
        void optChanged() {
            CmprFolders.this.propsChanged = true;
        }

        NotifyChanges() {
            CmprFolders.this.getClass();
        }
    }

    class GetDirOnly
    implements FilenameFilter {
        GetDirOnly() {
            CmprFolders.this.getClass();
        }

        public boolean accept(File file, String string) {
            File file2 = new File(file + File.separator + string);
            return file2.isDirectory();
        }
    }
}

