/*
 * Decompiled with CFR 0.152.
 */
package NormsTools;

import NormsTools.TextPaneData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class TextPane
extends Component
implements MouseMotionListener {
    static final Color DfltBGColor = Color.white;
    static final Color DfltFGColor = Color.black;
    Vector theText = new Vector();
    Point currPos = new Point(0, 0);
    Dimension ourSize;
    Insets ins = new Insets(1, 1, 1, 1);
    Frame parent;
    PopUpWindow puw;
    static final boolean debug = false;

    public void setInsets(Insets insets) {
        this.ins = insets;
    }

    public Insets getInsets() {
        return this.ins;
    }

    public void invalidate() {
        this.ourSize = null;
        super.invalidate();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public TextPane(Frame frame) {
        this.addMouseMotionListener(this);
        this.parent = frame;
        this.addMouseListener(new MouseAdapter(){
            {
                TextPane.this.getClass();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                block0: {
                    if (TextPane.this.puw == null || TextPane.this.puw.tpd.rect.contains(mouseEvent.getX(), mouseEvent.getY())) break block0;
                    TextPane.this.clearPUW();
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
            }
        });
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n = 0;
        while (n < this.theText.size()) {
            TextPaneData textPaneData = (TextPaneData)this.theText.elementAt(n);
            if (textPaneData.rect != null && textPaneData.MOText != null && textPaneData.rect.contains(mouseEvent.getPoint())) {
                if (!textPaneData.showingMOText) {
                    if (this.puw != null && this.puw.tpd != textPaneData) {
                        this.clearPUW();
                    }
                    Rectangle rectangle = this.getBounds();
                    Point point = this.parent.getLocation();
                    this.puw = new PopUpWindow(this.parent, textPaneData.MOText, textPaneData);
                    ((Component)this.puw).setBounds(point.x + rectangle.x + mouseEvent.getX(), point.y + rectangle.y + mouseEvent.getY() + 20, textPaneData.MOSize.width, textPaneData.MOSize.height);
                    this.puw.show();
                    textPaneData.showingMOText = true;
                    return;
                }
                return;
            }
            ++n;
        }
        this.clearPUW();
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics;
        TextPaneData textPaneData;
        int n = graphics.getFontMetrics().getAscent();
        int n2 = graphics.getFontMetrics().getHeight();
        if (this.ourSize != null && this.getBackground() != Color.white) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.ourSize.width, this.ourSize.height);
        }
        this.currPos.setLocation(this.ins.top, this.ins.left);
        int n3 = 0;
        while (n3 < this.theText.size()) {
            textPaneData = (TextPaneData)this.theText.elementAt(n3);
            if (textPaneData.theFont == null) {
                textPaneData.theFont = this.getFont();
            }
            if ((fontMetrics = graphics.getFontMetrics(textPaneData.theFont)).getAscent() > n) {
                n = fontMetrics.getAscent();
                n2 = fontMetrics.getHeight();
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < this.theText.size()) {
            textPaneData = (TextPaneData)this.theText.elementAt(n3);
            graphics.setFont(textPaneData.theFont);
            fontMetrics = graphics.getFontMetrics();
            int n4 = n2 - fontMetrics.getHeight();
            if (textPaneData.MOText != null) {
                textPaneData.MOSize = new Dimension(fontMetrics.stringWidth(textPaneData.MOText) + 6, fontMetrics.getAscent() + 6);
            }
            if (textPaneData.rect == null) {
                textPaneData.rect = new Rectangle(this.currPos.x, this.currPos.y, fontMetrics.stringWidth(textPaneData.text), fontMetrics.getHeight());
            }
            if (textPaneData.recType == 2) {
                this.currPos.x = textPaneData.rect.x;
                this.currPos.y = textPaneData.rect.y;
            } else {
                if (textPaneData.bgColor != null) {
                    graphics.setColor(textPaneData.bgColor);
                    graphics.fillRect(this.currPos.x, this.currPos.y + n4, textPaneData.rect.width, textPaneData.rect.height);
                }
                if (textPaneData.fgColor != null) {
                    graphics.setColor(textPaneData.fgColor);
                }
                graphics.drawString(textPaneData.text, textPaneData.rect.x, textPaneData.rect.y + n);
                this.currPos.x += fontMetrics.stringWidth(textPaneData.text);
            }
            ++n3;
        }
        if (this.ourSize == null) {
            this.ourSize = new Dimension(this.currPos.x + this.ins.left + this.ins.right, n2 + this.ins.top + this.ins.bottom);
        }
    }

    public TextPaneData addText(String string) {
        return this.addText(string, DfltBGColor, DfltFGColor, null);
    }

    public TextPaneData addText(String string, Color color, Color color2) {
        return this.addText(string, color, color2, null);
    }

    public TextPaneData addText(String string, Color color, Color color2, String string2) {
        TextPaneData textPaneData = new TextPaneData(string, color, color2, string2);
        this.theText.addElement(textPaneData);
        return textPaneData;
    }

    public TextPaneData addText(TextPaneData textPaneData) {
        this.theText.addElement(textPaneData);
        return textPaneData;
    }

    public boolean contains(Point point) {
        System.out.println("Contains Point=" + point);
        return super.contains(point);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public boolean containsXXXX(int n, int n2) {
        System.out.println("Contains x=" + n + ", y=" + n2 + "? " + super.contains(n, n2));
        return super.contains(n, n2);
    }

    public void clearText() {
        this.theText.removeAllElements();
    }

    private boolean containsIt(Rectangle rectangle, Point point) {
        return point.x > rectangle.x && point.x < rectangle.x + rectangle.width && point.y > rectangle.y && point.y < rectangle.y + rectangle.height;
    }

    public Dimension getMinimumSize() {
        if (this.ourSize == null) {
            this.addNotify();
            Graphics graphics = this.getGraphics();
            this.paint(graphics);
        }
        return this.ourSize;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    void clearPUW() {
        if (this.puw != null) {
            this.puw.tpd.showingMOText = false;
            this.puw.dispose();
            this.puw = null;
        }
    }

    public TextPaneData setText(String string) {
        return this.setText(string, DfltBGColor, DfltFGColor, null);
    }

    public TextPaneData setText(String string, Color color, Color color2, String string2) {
        this.clearPUW();
        this.theText.removeAllElements();
        return this.addText(string, color, color2, string2);
    }

    private class PopUpWindow
    extends Window {
        String msg;
        TextPaneData tpd;

        PopUpWindow(Frame frame, String string, TextPaneData textPaneData) {
            super(frame);
            TextPane.this.getClass();
            ((Component)this).setBackground(Color.yellow);
            this.msg = string;
            this.tpd = textPaneData;
            this.addMouseMotionListener(new MouseMotionAdapter(){
                {
                    PopUpWindow.this.getClass();
                }

                public void mouseMoved() {
                }
            });
            this.addMouseListener(new MouseAdapter(){
                {
                    PopUpWindow.this.getClass();
                }

                public void mouseExited() {
                }
            });
        }

        public void paint(Graphics graphics) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.msg, (this.getSize().width - fontMetrics.stringWidth(this.msg)) / 2, (this.getSize().height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        }
    }
}

