/*
 * Decompiled with CFR 0.152.
 */
package NormsTools.CheckClassPath;

import NormsTools.ClassFileScanner;
import NormsTools.DroppedFileHandler;
import NormsTools.MSDosFilename;
import NormsTools.NormsDropTarget;
import NormsTools.ShowListBox;
import NormsTools.ShowMsgBox;
import NormsTools.TextPane;
import NormsTools.TextPaneData;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Properties;
import java.util.StringTokenizer;

public class CheckClasspath
extends Frame
implements ActionListener {
    final String VERSION = "Norm's Classpath Checker - 14 Dec 2001";
    final MenuBar mb = new MenuBar();
    final Menu fM = new Menu("File");
    final MenuItem fOpen = new MenuItem("Open...");
    final Menu vM = new Menu("View");
    final MenuItem vListCP = new MenuItem("List CP");
    final Menu hM = new Menu("Help");
    final MenuItem hAbout = new MenuItem("About");
    final MenuItem hTopics = new MenuItem("Topics");
    Color bgColor = Color.cyan;
    Color CPColor = new Color(180, 230, 255);
    Color PkgColor = new Color(130, 230, 50);
    Color GapColor = Color.red;
    Color OvlpColor = Color.magenta;
    final Font pathFont = new Font("Monospaced", 0, 14);
    final String FullPathPfx = "Path to class file:  ";
    Label fPathLbl = new Label("Path to class file:  ");
    final String PackNamePfx = "Package.classname: ";
    final String ClassOnlyPfx = "Classname: ";
    Label packNameLbl = new Label("Package.classname: ");
    final String clsPathPfx = "Classpath: ";
    TextPane clsPathLbl = new TextPane(this);
    String fileName;
    String absPath;
    String packName;
    String givenCP;
    String neededCP;
    String sysCP;
    String userDir;
    String lastDir;
    String[] clsPaths;
    static final String ClassExt = ".class";
    static boolean debug = false;

    private void usage() {
        System.out.println("Usage: [-d] [-cp classpath] classfilename");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {}
        System.exit(0);
    }

    public CheckClasspath(String[] stringArray) {
        Properties properties = System.getProperties();
        this.sysCP = properties.getProperty("java.class.path");
        this.userDir = properties.getProperty("user.dir", ".");
        this.setClasspaths(this.sysCP);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("-")) {
                if (stringArray[n].equalsIgnoreCase("-CP")) {
                    if (++n < stringArray.length) {
                        this.givenCP = stringArray[n];
                        this.setClasspaths(this.givenCP);
                    } else {
                        System.err.println("Classpath missing after " + stringArray[n - 1]);
                        this.usage();
                    }
                } else if (stringArray[n].equalsIgnoreCase("-D")) {
                    debug = true;
                } else {
                    System.err.println("Unknown arg: " + stringArray[n]);
                    this.usage();
                }
            } else {
                String string;
                if (n != stringArray.length - 1) {
                    System.err.println("args problem: >" + stringArray[n + 1] + "< at " + n);
                    this.usage();
                }
                if (!(string = stringArray[n]).endsWith(ClassExt)) {
                    System.err.println("Invalid extension: " + stringArray[n]);
                    if (string.indexOf(126) > 0) {
                        int n2 = string.lastIndexOf(File.separator);
                        string = n2 < 0 ? string : string.substring(n2 + 1);
                        string = MSDosFilename.getExtendedName(string);
                        if (debug) {
                            System.out.println("Change fn " + stringArray[n] + " to " + string);
                        }
                    }
                }
                this.processNewFile(string);
            }
            ++n;
        }
        if (debug) {
            System.out.println("Classpath= " + this.sysCP + "\n  -CP=" + this.givenCP + "\n   User.dir=" + this.userDir);
        }
        this.setTitle("Norm's Classpath Checker - 14 Dec 2001");
        this.setLayout(new GridLayout(3, 1));
        this.add(this.fPathLbl);
        this.add(this.packNameLbl);
        this.add(this.clsPathLbl);
        this.fM.add(this.fOpen);
        this.fOpen.addActionListener(this);
        this.mb.add(this.fM);
        this.vM.add(this.vListCP);
        this.vListCP.addActionListener(this);
        this.mb.add(this.vM);
        this.hM.add(this.hTopics);
        this.hTopics.addActionListener(this);
        this.mb.add(this.hM);
        this.hM.add(this.hAbout);
        this.hAbout.addActionListener(this);
        this.setMenuBar(this.mb);
        this.addWindowListener(new WindowAdapter(){
            {
                CheckClasspath.this.getClass();
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        if ("1.2".compareTo(System.getProperty("java.version")) < 0) {
            new DropClassFile(this.fPathLbl);
        }
        ((Component)this).setLocation(100, 100);
        ((Component)this).setBackground(this.bgColor);
        this.pack();
        this.show();
    }

    void processNewFile(String string) {
        this.fileName = string;
        File file = new File(this.fileName);
        if (!file.exists()) {
            System.err.println("File not found: " + this.fileName);
            this.fPathLbl.setText("File not found: " + this.fileName);
            this.packNameLbl.setText("Package.classname: ");
            this.clsPathLbl.setText("Classpath: ");
        } else {
            this.absPath = file.getAbsolutePath();
            this.fPathLbl.setText("Path to class file:  " + this.absPath);
            ClassFileScanner classFileScanner = new ClassFileScanner();
            try {
                DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
                classFileScanner.getReferencedClasses(dataInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            this.packName = classFileScanner.getName();
            int n = this.packName.indexOf(46);
            this.packNameLbl.setText((n > 0 ? "Package.classname: " : "Classname: ") + this.packName);
            this.clsPathLbl.setText("Classpath: ");
            String string2 = this.absPath.substring(0, this.absPath.length() - 6);
            string2 = string2.replace(File.separatorChar, '.');
            this.neededCP = "";
            if (string2.endsWith(this.packName)) {
                Object object;
                Object object2;
                this.neededCP = string2.substring(0, string2.length() - this.packName.length());
                if (debug) {
                    System.out.println("neededCP=" + this.neededCP);
                }
                boolean bl = false;
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this.clsPaths.length) {
                    if (debug) {
                        System.out.println("clspth= " + this.clsPaths[n2]);
                    }
                    if (this.clsPaths[n2].equals(this.neededCP)) {
                        object2 = this.clsPathLbl.setText("Classpath: ");
                        ((TextPaneData)object2).setBGColor(this.bgColor);
                        object2 = this.clsPathLbl.addText(this.neededCP.replace('.', File.separatorChar), this.CPColor, Color.black, "Classpath");
                        ((TextPaneData)object2).setFont(this.pathFont);
                        object = this.packName.indexOf(46) > 0 ? "Package.classname: " : "Classname: ";
                        object2 = this.clsPathLbl.addText(this.packName.replace('.', File.separatorChar), this.PkgColor, Color.black, (String)object);
                        ((TextPaneData)object2).setFont(this.pathFont);
                        bl2 = true;
                        break;
                    }
                    if (this.clsPaths[n2].equals(".")) {
                        bl = true;
                    }
                    ++n2;
                }
                if (!bl2) {
                    Object object3;
                    n2 = 0;
                    while (n2 < this.clsPaths.length) {
                        if (this.neededCP.startsWith(this.clsPaths[n2])) {
                            object2 = this.neededCP.substring(this.clsPaths[n2].length());
                            object = this.clsPathLbl.setText("Classpath: ");
                            ((TextPaneData)object).setBGColor(this.bgColor);
                            object = this.clsPathLbl.addText(this.clsPaths[n2].replace('.', File.separatorChar), this.CPColor, Color.black, "Classpath");
                            ((TextPaneData)object).setFont(this.pathFont);
                            object = this.clsPathLbl.addText(((String)object2).replace('.', File.separatorChar), this.GapColor, Color.black, "Gap in Classpath");
                            ((TextPaneData)object).setFont(this.pathFont);
                            object3 = this.packName.indexOf(46) > 0 ? "Package.classname: " : "Classname: ";
                            object = this.clsPathLbl.addText(this.packName.replace('.', File.separatorChar), this.PkgColor, Color.black, (String)object3);
                            ((TextPaneData)object).setFont(this.pathFont);
                            bl2 = true;
                            break;
                        }
                        ++n2;
                    }
                    if (!bl2) {
                        n2 = 0;
                        while (n2 < this.clsPaths.length) {
                            if (string2.startsWith(this.clsPaths[n2])) {
                                if (this.clsPaths[n2].startsWith(this.neededCP)) {
                                    object2 = this.clsPaths[n2].substring(this.neededCP.length());
                                    object = this.clsPaths[n2].substring(0, this.clsPaths[n2].length() - ((String)object2).length());
                                    object3 = this.clsPathLbl.setText("Classpath: ");
                                    ((TextPaneData)object3).setBGColor(this.bgColor);
                                    object3 = this.clsPathLbl.addText(((String)object).replace('.', File.separatorChar), this.CPColor, Color.black, "Classpath");
                                    ((TextPaneData)object3).setFont(this.pathFont);
                                    object3 = this.clsPathLbl.addText(((String)object2).replace('.', File.separatorChar), this.OvlpColor, Color.black, "Overlap of Classpath & package.class");
                                    ((TextPaneData)object3).setFont(this.pathFont);
                                    String string3 = this.packName.substring(((String)object2).length());
                                    String string4 = string3.indexOf(46) > 0 ? "Package.classname: " : "Classname: ";
                                    object3 = this.clsPathLbl.addText(string3.replace('.', File.separatorChar), this.PkgColor, Color.black, string4);
                                    ((TextPaneData)object3).setFont(this.pathFont);
                                    bl2 = true;
                                    break;
                                }
                            } else if (this.clsPaths[n2].startsWith(this.neededCP)) {
                                System.err.println("??? CP=" + this.clsPaths[n2] + " startsWith " + this.neededCP);
                            }
                            ++n2;
                        }
                    }
                    if (!bl2) {
                        this.neededCP = bl ? "Must be in curr.dir " + File.separator : "?????" + File.separator;
                        TextPaneData textPaneData = this.clsPathLbl.setText("Classpath: ");
                        textPaneData.setBGColor(this.bgColor);
                        textPaneData = this.clsPathLbl.addText(this.neededCP, this.CPColor, Color.black, "Classpath");
                        textPaneData.setFont(this.pathFont);
                        object2 = this.packName.indexOf(46) > 0 ? "Package.classname: " : "Classname: ";
                        textPaneData = this.clsPathLbl.addText(this.packName.replace('.', File.separatorChar), this.PkgColor, Color.black, (String)object2);
                        textPaneData.setFont(this.pathFont);
                    }
                }
            } else {
                System.err.println("FullPath= " + string2 + " pkgNm= " + this.packName);
                new ShowMsgBox("Invalid path for package.class", "Path to class file does NOT end with package.classname.\nProbably need to move class file to different directory.", this, true, 300);
                TextPaneData textPaneData = this.clsPathLbl.setText("Invalid class file location");
                textPaneData.setFont(this.pathFont);
                textPaneData.setBGColor(Color.yellow);
            }
        }
        this.fPathLbl.invalidate();
        this.packNameLbl.invalidate();
        this.clsPathLbl.invalidate();
        this.validate();
        ((Component)this).setBackground(this.bgColor);
        this.pack();
    }

    public static void main(String[] stringArray) {
        new CheckClasspath(stringArray);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fOpen) {
            FileDialog fileDialog = new FileDialog((Frame)this, "Choose class file:", 0);
            fileDialog.setFile("*" + ClassExt);
            if (this.lastDir != null) {
                fileDialog.setDirectory(this.lastDir);
            }
            fileDialog.show();
            String string = fileDialog.getFile();
            if (string == null || string.equals("")) {
                return;
            }
            if (!string.endsWith(ClassExt)) {
                System.err.println("Invalid file extension: " + string);
                return;
            }
            this.lastDir = fileDialog.getDirectory();
            this.processNewFile(this.lastDir + string);
        } else if (object == this.vListCP) {
            String[] stringArray = new String[this.clsPaths.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray[n] = this.clsPaths[n].equals(".") ? this.clsPaths[n] : this.clsPaths[n].replace('.', File.separatorChar);
                ++n;
            }
            new ShowListBox("Current classpaths", stringArray, Math.min(20, stringArray.length), this, true);
        } else if (object == this.hAbout) {
            new ShowMsgBox("About Check Classpath", "Written by Norm Radder\n Email: radder@hotmail.com", this, true);
        } else if (object == this.hTopics) {
            new ShowMsgBox("Check Classpath topics", "Position mouse over colored text\nin Classpath for description.", this, false);
        } else {
            System.err.println("Unknown ae " + actionEvent);
        }
    }

    private String findPath() {
        return "";
    }

    private void setClasspaths(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        this.clsPaths = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (!string2.endsWith(File.separator) && string2.indexOf(46) < 0) {
                string2 = string2 + File.separator;
            }
            this.clsPaths[n++] = string2.replace(File.separatorChar, '.');
        }
    }

    class DropClassFile
    implements DroppedFileHandler {
        DropClassFile(Component component) {
            CheckClasspath.this.getClass();
            new NormsDropTarget(component, this);
        }

        public void handleDroppedFile(File file) {
            if (file.isFile() && file.getName().endsWith(CheckClasspath.ClassExt)) {
                CheckClasspath.this.processNewFile(file.getAbsolutePath());
                CheckClasspath.this.toFront();
            } else {
                System.err.println("Rejected dropped file: " + file.getName());
            }
        }
    }
}

